/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import com.sun.gjc.spi.ConnectionManager;
import com.sun.gjc.spi.ConnectionRequestInfo;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;

public abstract class DataSource
implements javax.sql.DataSource,
Serializable,
com.sun.appserv.jdbc.DataSource,
Referenceable {
    protected ManagedConnectionFactory mcf;
    private javax.resource.spi.ConnectionManager cm;
    private int loginTimeout;
    private PrintWriter logWriter;
    private String description;
    private Reference reference;
    private ConnectionHolder.ConnectionType conType_;
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    public DataSource(ManagedConnectionFactory mcf, javax.resource.spi.ConnectionManager cm) {
        this.mcf = mcf;
        if (cm == null) {
            this.cm = new ConnectionManager();
        } else {
            this.cm = cm;
            this.conType_ = this.findConnectionType();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            ConnectionHolder con = (ConnectionHolder)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, null);
            this.setConnectionType(con);
            return con;
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    @Override
    public Connection getConnection(String user, String pwd) throws SQLException {
        try {
            ConnectionRequestInfo info = new ConnectionRequestInfo(user, pwd);
            ConnectionHolder con = (ConnectionHolder)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)info);
            this.setConnectionType(con);
            return con;
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    public Connection getConnection(Connection con) throws SQLException {
        Connection driverCon = con;
        if (con instanceof ConnectionHolder) {
            driverCon = ((ConnectionHolder)con).getConnection();
        }
        return driverCon;
    }

    public Connection getNonTxConnection() throws SQLException {
        try {
            ConnectionHolder con = (ConnectionHolder)((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.cm).allocateNonTxConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, null);
            this.setConnectionType(con, true);
            return con;
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    public Connection getNonTxConnection(String user, String password) throws SQLException {
        try {
            ConnectionRequestInfo cxReqInfo = new ConnectionRequestInfo(user, password);
            ConnectionHolder con = (ConnectionHolder)((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.cm).allocateNonTxConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)cxReqInfo);
            this.setConnectionType(con, true);
            return con;
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    private ConnectionHolder.ConnectionType findConnectionType() {
        ConnectionHolder.ConnectionType cmType = ConnectionHolder.ConnectionType.STANDARD;
        if (this.cm instanceof LazyAssociatableConnectionManager) {
            if (!((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.cm).getJndiName().endsWith("__pm")) {
                cmType = ConnectionHolder.ConnectionType.LAZY_ASSOCIATABLE;
            }
        } else if (this.cm instanceof LazyEnlistableConnectionManager && !((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.cm).getJndiName().endsWith("__pm") && !((com.sun.appserv.connectors.internal.spi.ConnectionManager)this.cm).getJndiName().endsWith("__nontx")) {
            cmType = ConnectionHolder.ConnectionType.LAZY_ENLISTABLE;
        }
        return cmType;
    }

    private void setConnectionType(ConnectionHolder con) {
        this.setConnectionType(con, false);
    }

    private void setConnectionType(ConnectionHolder con, boolean isNonTx) {
        con.setConnectionType(this.conType_);
        if (this.conType_ == ConnectionHolder.ConnectionType.LAZY_ASSOCIATABLE) {
            con.setLazyAssociatableConnectionManager((LazyAssociatableConnectionManager)this.cm);
        } else if (this.conType_ == ConnectionHolder.ConnectionType.LAZY_ENLISTABLE) {
            if (isNonTx) {
                con.setConnectionType(ConnectionHolder.ConnectionType.STANDARD);
            } else {
                con.setLazyEnlistableConnectionManager((LazyEnlistableConnectionManager)this.cm);
            }
        }
    }

    public void markConnectionAsBad(Connection conn) {
        if (conn instanceof ConnectionHolder) {
            ConnectionHolder userConn = (ConnectionHolder)conn;
            userConn.getManagedConnection().markForRemoval(true);
        }
    }
}

