// $Id: testCxxFile.cc,v 1.18 2002/03/01 21:50:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CxxFile.hh"
#include <iostream>

#define DEBUG(x)

int main()
{  // CxxFile f(std::cout,"std::cout"); doesn't work since std::cout is not an std::ofstream!
   // CxxFile f(1,"std::cout");
   CxxFile f("/dev/fd/1");
   
   // this is impossible with libstdc++ 3.0, so pretend if compiler is newer ...
#if defined __GNUC__ && __GNUC__ == 2 && defined __GNUC_MINOR__ && __GNUC_MINOR__ == 95
   std::cout.tie(&(std::ostream&)f);
   ((std::ostream&)f).tie(&std::cout);
#elif defined __GNUC__ && defined __GNUC_MINOR__
   std::cout << __GNUC__ << '.' << __GNUC_MINOR__ << '\n';
#endif
   
   f.Include("name");
   f.Include("name",true);
   f.Include("name"); // unnecessary, doesn't appear
   DEBUG(f.dump_context_stack());
   f.Declaration("int i");

   f.Declaration().
   	Funct_ReturnType("void").FunctionName("hello").FunctionArg("int i");
   DEBUG(f.dump_context_stack());
//   f.EndLine();
//   DEBUG(f.dump_context_stack());

   f.Definition().
   	Funct_ReturnType("int").FunctionName("verdoppeln").FunctionArg("int i");
   f.StartBlock();
   f.Statement("return i*2");
   f.EndBlock();
   DEBUG(f.dump_context_stack());

   {  Remember<CxxFile> r(f,1);
      r.Declaration("int x0");
      r.Declaration("int y0");
   }
   
   f.Declaration().Class("some_class");
   
   f.Definition().
   	Funct_ReturnType("void").FunctionName("another_function");
   f.StartBlock();
   f.CppIf("TEST");
   f.Statement("i").Assignment("2");
   f.EndIf("TEST");
   f.Declaration("int a").Assignment("13");
   f.Statement("a").Assignment().FunctionName("sqrt").FunctionArg("2");
   f.EndBlock();
   DEBUG(f.dump_context_stack());

   {  Remember<CxxFile> r(f,0);
      r.Declaration("int x");
      r.Declaration("int y");
   }
   
   f.Definition().Class("Unique");
   f.StartBlock();
   DEBUG(f.dump_context_stack());
   f.Private().Declaration("int i");
   f.Public().Definition().FunctionName("Unique").Construct("i","2");
   f.StartBlock().EndBlock(); // necessary?
   f.Public().Declaration("int help:1");
   f.Protected().Declaration().Funct_ReturnType("void")
   	.FunctionName("test");
   DEBUG(f.dump_context_stack());
   f.EndBlock();
   
   f.Definition().Class("Unique2");
   f.Derive("public Unique");
   f.StartBlock();
   f.Public().Declaration().Funct_Storage("static").Funct_ReturnType("void");
   f.FunctionName("test2").FunctionArg("int i");
   f.EndBlock();
   f.NewLine();
   
   f.Declaration("int testarrctx_RValue[]").Assignment().StartBlock();
   f << " 0, 1, 2 ";
   f.EndBlock();
   
   f.Statement("a").Assignment().FunctionName("b").FunctionArg()
   	.FunctionName("c").FunctionArg("1");
   
   f.write_remembered(0);
   f.write_remembered(1);
   f.write_remembered(2); // shouldn't bomb ...
   
   f.Statement("int a");
   f.Assignment() << "2";
   f.StartBlock().EndBlock();
   
   f.close();
   DEBUG(f.dump_context_stack());
}
