/*
 * G-ToDo Gkrellm Plugin
 * Copyright 2003 Dimitar Haralanov
 *
 */
/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CONFIG_H
#define __CONFIG_H

#include <main.h>

/* GtkListStore column definitions
 */
enum {
     ACTIVE_COLUMN,
     TITLE_COLUMN,
     COMPLETE_COLUMN,
     DEADLINE_COLUMN,
     REMINDER_COLUMN,
     TIME_COLUMN,
     COMMENT_COLUMN,
     N_COLUMNS
};

/* Global GtkListStore for all the tasks
 */
GtkListStore *task_list_store;


/* Global Control Block
 * it holds the configuration options, as well as,
 * some global runtime flags
 */
struct {
     gchar *file;                               /* task list filename */
     enum { REGULAR, MILITARY } time_format;    /* time display format */
     enum { AMERICAN, EUROPEAN } date_format;   /* date display format */
     gboolean auto_delete;                      /* delete expired tasks */
     gboolean if_acked;                         /* only if acked */
     gboolean remind_complete;                  /* remind of complete tasks */
     gboolean remind_old;                       /* remind of expired tasks */
     gboolean enable_reminders;                 /* enable reminders? */
     gint     start_interval;                   /* remind X min before event */
     gboolean repeat_reminders;                 /* repeat reminders? */
     gint     repeat_interval;                  /* repeat reminders every X min */
     gboolean flash;                            /* use flash reminder? */
     gboolean popup;                            /* use popup reminder? */
     gboolean exec;                             /* use commnad reminder? */
     gchar   *command;                          /* command to run as reminder */
     gchar   *text;                             /* text to put in the reminder */
     gboolean clean;                            /* is the list clean? */
     gboolean acked;                            /* have the tasks been acked */
     gboolean timer_on;                         /* timer on/off */
     gboolean timer_change;                     /* Reminder option change flag */
     gboolean window;                           /* quick view window is up */
     gboolean have_active;                      /* we have an active task */
     gint     ntasks;
} global_config;

/* Apply the current configuration to the plugin
 * This function is called by GKrellM when the "Apply"
 * button of the Configuration window is pressed.
 */
void gtodo_apply_plugin_config (void);

/* Save the current pluyin configuration */
void gtodo_save_plugin_config  (FILE *);

/* Load the plugin configuration from the user_config file */
void gtodo_load_plugin_config  (gchar *);

/* Sets the defaul values for all the relevant fields
 * for the plugin configuration and the control
 * variables
 */
void gtodo_set_default_config  (void);

/* Load the task list from the task file */
int  gtodo_load_task_list      (gchar *);

/* Save the task list to file */
int  gtodo_save_task_list      (gchar *);
#endif /* config.h */
