/* The following code was generated by JFlex 1.4.1 on 12/12/07 5:07 PM */

// _line_ 1 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
/* -*-Fundamental-*- */

/* Copyright (c) 2007, by Paul N. Hilfinger.  All Rights Reserved.
 * For licensing terms, see the file GJDB.LICENSES, Part 2, which must
 * accompany any redistribution of this file. */

package ucb.gjdb;

import java.util.*;
import java.io.StringReader;

import static ucb.gjdb.CommandParser.*;
import static ucb.gjdb.CommandException.ERROR;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 12/12/07 5:07 PM from the specification file
 * <tt>/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf</tt>
 */
class CommandLexer {
// _line_ 27 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;
// _line_ 34 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

  /** lexical states */
  public static final int PRINT = 6;
  public static final int COLLECT = 2;
  public static final int COMMAND = 3;
  public static final int YYINITIAL = 0;
  public static final int BREAK = 1;
  public static final int DEFAULTARGS = 4;
  public static final int RUNARGS = 5;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\6\0\1\23\2\0\1\1\1\3\1\0\1\1\1\20\22\0\1\1"+
    "\1\12\1\17\1\0\1\6\1\12\2\0\1\61\1\62\1\4\1\54"+
    "\1\60\1\10\1\55\1\2\1\13\7\11\2\11\1\54\1\12\1\22"+
    "\1\12\1\22\1\24\1\12\6\15\5\7\1\21\13\7\1\14\2\7"+
    "\1\56\1\16\1\57\1\0\1\5\1\0\1\25\1\27\1\33\1\42"+
    "\1\31\1\44\1\50\1\37\1\45\1\7\1\32\1\26\1\41\1\43"+
    "\1\40\1\35\1\7\1\30\1\34\1\36\1\51\1\52\1\53\1\46"+
    "\1\47\1\7\3\0\1\12\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\7\0\1\1\1\2\1\3\1\2\1\4\1\5\1\6"+
    "\6\5\2\4\1\7\1\10\1\11\1\12\2\13\1\2"+
    "\1\14\1\12\2\15\1\16\2\13\16\16\2\17\1\2"+
    "\1\20\1\21\1\22\1\23\1\0\5\5\1\24\1\25"+
    "\1\0\1\26\1\27\1\13\3\0\1\30\1\13\13\16"+
    "\1\31\6\16\1\17\2\0\1\32\1\0\1\33\4\5"+
    "\2\13\1\34\2\16\1\35\10\16\1\36\3\16\1\37"+
    "\1\16\1\17\1\23\1\0\3\5\1\40\17\16\1\23"+
    "\1\17\1\5\1\41\1\5\1\16\1\42\1\16\1\43"+
    "\1\16\1\44\1\45\1\16\1\46\5\16\1\47\1\50"+
    "\1\51\1\52\4\16\1\53\3\16\1\54\2\16\1\55"+
    "\3\16\1\56\2\16\1\57\1\16\1\60\5\16\1\61"+
    "\1\62\4\16\1\63\2\16\1\64\1\65\1\16\1\66";

  private static int [] zzUnpackAction() {
    int [] result = new int[206];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\377\0\u0132\0\0"+
    "\0\u0165\0\u0165\0\u0198\0\u0165\0\u01cb\0\u01fe\0\u0231\0\u0264"+
    "\0\u0297\0\u02ca\0\u02fd\0\u0330\0\u0363\0\u0396\0\u0165\0\u0165"+
    "\0\u0165\0\u03c9\0\u03fc\0\u042f\0\u0462\0\u0165\0\u0165\0\u0198"+
    "\0\u0165\0\u0495\0\u04c8\0\u04fb\0\u052e\0\u0561\0\u0594\0\u05c7"+
    "\0\u05fa\0\u062d\0\u0660\0\u0693\0\u06c6\0\u06f9\0\u072c\0\u075f"+
    "\0\u0792\0\u07c5\0\u07f8\0\u082b\0\u085e\0\u0165\0\u0165\0\u0198"+
    "\0\u0891\0\u08c4\0\u08f7\0\u092a\0\u095d\0\u0990\0\u09c3\0\u01cb"+
    "\0\u01cb\0\u0363\0\u0165\0\u0165\0\u0165\0\u09f6\0\u0462\0\u0a29"+
    "\0\u0165\0\u0495\0\u0a5c\0\u0a8f\0\u0ac2\0\u0af5\0\u0b28\0\u0b5b"+
    "\0\u0b8e\0\u0bc1\0\u0bf4\0\u0c27\0\u0c5a\0\u0495\0\u0c8d\0\u0cc0"+
    "\0\u0cf3\0\u0d26\0\u0d59\0\u0d8c\0\u0dbf\0\u085e\0\u0df2\0\u0165"+
    "\0\u0e25\0\u01cb\0\u0e58\0\u0e8b\0\u0ebe\0\u0ef1\0\u0f24\0\u0f57"+
    "\0\u0495\0\u0f8a\0\u0fbd\0\u0495\0\u0ff0\0\u1023\0\u1056\0\u1089"+
    "\0\u10bc\0\u10ef\0\u1122\0\u1155\0\u0495\0\u1188\0\u11bb\0\u11ee"+
    "\0\u1221\0\u1254\0\u1287\0\u0165\0\u12ba\0\u12ed\0\u1320\0\u1353"+
    "\0\u01cb\0\u1386\0\u13b9\0\u13ec\0\u141f\0\u1452\0\u1485\0\u14b8"+
    "\0\u14eb\0\u151e\0\u1551\0\u1584\0\u15b7\0\u15ea\0\u161d\0\u1650"+
    "\0\u07f8\0\u1683\0\u16b6\0\u01cb\0\u16e9\0\u171c\0\u0495\0\u174f"+
    "\0\u1782\0\u17b5\0\u0495\0\u0495\0\u17e8\0\u0495\0\u181b\0\u184e"+
    "\0\u1881\0\u18b4\0\u18e7\0\u0495\0\u01cb\0\u01cb\0\u0495\0\u191a"+
    "\0\u194d\0\u1980\0\u19b3\0\u0495\0\u19e6\0\u1a19\0\u1a4c\0\u0495"+
    "\0\u1a7f\0\u1ab2\0\u0495\0\u1ae5\0\u1b18\0\u1b4b\0\u0495\0\u1b7e"+
    "\0\u1bb1\0\u0495\0\u1be4\0\u0495\0\u1c17\0\u1c4a\0\u1c7d\0\u1cb0"+
    "\0\u1ce3\0\u0495\0\u0495\0\u1d16\0\u1d49\0\u1d7c\0\u1daf\0\u0495"+
    "\0\u1de2\0\u1e15\0\u0495\0\u0495\0\u1e48\0\u0495";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[206];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\63\10\1\11\1\12\1\13\1\12\1\14\1\15\1\11"+
    "\1\15\1\11\1\16\1\11\1\16\2\15\2\11\1\12"+
    "\1\15\3\11\1\17\2\15\1\20\5\15\1\21\4\15"+
    "\1\22\1\15\1\23\2\15\1\24\3\15\1\14\1\25"+
    "\1\26\4\14\3\27\1\0\55\27\1\30\1\31\1\11"+
    "\1\12\1\13\1\12\3\11\1\32\1\11\1\33\1\11"+
    "\1\34\2\32\1\11\1\35\1\12\1\32\1\11\1\36"+
    "\1\37\27\32\10\11\1\12\1\40\1\12\1\41\4\42"+
    "\1\43\1\42\1\44\2\42\1\11\1\35\1\12\1\42"+
    "\3\11\1\45\1\46\1\47\1\50\1\51\1\42\1\52"+
    "\1\53\1\54\1\55\1\42\1\56\1\57\2\42\1\60"+
    "\5\42\1\61\1\62\1\41\1\42\2\11\1\42\2\41"+
    "\1\63\1\12\1\64\1\12\13\63\1\65\1\12\1\63"+
    "\1\66\40\63\1\67\1\12\1\70\1\12\14\67\1\12"+
    "\42\67\65\0\1\71\1\0\1\72\63\0\3\15\1\0"+
    "\1\15\1\0\3\15\3\0\1\15\3\0\27\15\20\0"+
    "\1\16\1\0\1\16\54\0\3\15\1\0\1\15\1\0"+
    "\3\15\3\0\1\15\3\0\1\15\1\73\4\15\1\74"+
    "\20\15\14\0\3\15\1\0\1\15\1\0\3\15\3\0"+
    "\1\15\3\0\4\15\1\75\22\15\14\0\3\15\1\0"+
    "\1\15\1\0\3\15\3\0\1\15\3\0\12\15\1\76"+
    "\14\15\14\0\3\15\1\0\1\15\1\0\3\15\3\0"+
    "\1\15\3\0\13\15\1\77\13\15\14\0\3\15\1\0"+
    "\1\15\1\0\3\15\3\0\1\15\3\0\17\15\1\100"+
    "\7\15\14\0\3\15\1\0\1\15\1\0\3\15\3\0"+
    "\1\15\3\0\13\15\1\101\13\15\10\0\1\102\1\0"+
    "\1\102\7\0\1\103\4\0\1\102\121\0\1\104\12\0"+
    "\3\32\1\0\3\32\3\0\1\32\3\0\27\32\20\0"+
    "\1\33\1\0\1\33\5\0\1\105\4\0\1\105\45\0"+
    "\1\33\1\0\1\33\1\106\4\0\1\105\4\0\1\105"+
    "\17\0\1\106\14\0\3\107\1\0\12\107\1\110\1\111"+
    "\1\0\42\107\5\0\11\42\3\0\1\42\3\0\27\42"+
    "\1\0\1\42\2\0\1\42\7\0\4\42\1\43\1\42"+
    "\1\43\2\42\3\0\1\112\3\0\1\42\1\112\25\42"+
    "\1\0\1\42\2\0\1\42\7\0\4\42\1\43\1\42"+
    "\1\43\1\113\1\42\3\0\1\112\3\0\1\42\1\112"+
    "\17\42\1\113\5\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\1\42\1\114\25\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\13\42\1\115\13\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\3\42\1\116\23\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\24\42\1\117\2\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\1\42\1\120\25\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\1\42\1\121\11\42\1\122\13\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\11\42\1\123"+
    "\15\42\1\0\1\42\2\0\1\42\7\0\11\42\3\0"+
    "\1\42\3\0\3\42\1\124\23\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\12\42\1\125"+
    "\14\42\1\0\1\42\2\0\1\42\7\0\11\42\3\0"+
    "\1\42\3\0\16\42\1\126\1\127\7\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\1\130"+
    "\3\42\1\131\22\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\20\42\1\132\6\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\1\133\26\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\1\134\26\42\1\0\1\42\2\0"+
    "\1\42\2\0\1\63\1\0\1\63\1\0\13\63\2\0"+
    "\1\63\1\0\41\63\1\0\1\71\1\0\1\135\12\63"+
    "\2\0\1\63\1\0\40\63\3\136\1\0\12\136\1\137"+
    "\1\140\1\0\42\136\3\71\1\0\57\71\4\72\1\141"+
    "\56\72\5\0\3\15\1\0\1\15\1\0\3\15\3\0"+
    "\1\15\3\0\1\15\1\142\25\15\14\0\3\15\1\0"+
    "\1\15\1\0\3\15\3\0\1\15\3\0\6\15\1\143"+
    "\20\15\14\0\3\15\1\0\1\15\1\0\3\15\3\0"+
    "\1\15\3\0\7\15\1\144\17\15\14\0\3\15\1\0"+
    "\1\15\1\0\3\15\3\0\1\15\3\0\3\15\1\145"+
    "\23\15\14\0\3\15\1\0\1\15\1\0\3\15\3\0"+
    "\1\15\3\0\16\15\1\146\10\15\20\0\1\147\1\0"+
    "\1\147\1\0\1\147\7\0\1\147\1\0\1\147\1\0"+
    "\1\147\1\0\1\147\6\0\1\147\1\0\1\147\34\0"+
    "\2\107\50\0\4\42\1\150\1\42\1\150\1\42\1\150"+
    "\3\0\1\42\3\0\1\150\1\42\1\150\1\42\1\150"+
    "\1\42\1\150\6\42\1\150\1\42\1\150\7\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\1\42\1\151\25\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\6\42\1\152\20\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\4\42\1\153\22\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\16\42\1\154\10\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\4\42\1\155\22\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\1\156\26\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\14\42"+
    "\1\157\12\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\1\160\14\42\1\161\11\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\4\42\1\162\13\42\1\163\6\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\3\42\1\164"+
    "\23\42\1\0\1\42\2\0\1\42\7\0\11\42\3\0"+
    "\1\42\3\0\17\42\1\165\7\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\21\42\1\166"+
    "\5\42\1\0\1\42\2\0\1\42\7\0\11\42\3\0"+
    "\1\42\3\0\11\42\1\167\15\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\4\42\1\170"+
    "\22\42\1\0\1\42\2\0\1\42\7\0\11\42\3\0"+
    "\1\42\3\0\3\42\1\171\23\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\11\42\1\172"+
    "\15\42\1\0\1\42\2\0\1\42\2\0\1\135\1\72"+
    "\1\135\1\72\1\173\12\135\2\72\1\135\1\72\40\135"+
    "\16\0\2\136\43\0\2\72\1\174\1\72\1\175\56\72"+
    "\5\0\3\15\1\0\1\15\1\0\3\15\3\0\1\15"+
    "\3\0\4\15\1\176\22\15\14\0\3\15\1\0\1\15"+
    "\1\0\3\15\3\0\1\15\3\0\4\15\1\177\22\15"+
    "\14\0\3\15\1\0\1\15\1\0\3\15\3\0\1\15"+
    "\3\0\4\15\1\200\22\15\14\0\3\15\1\0\1\15"+
    "\1\0\3\15\3\0\1\15\3\0\4\15\1\201\22\15"+
    "\20\0\1\147\1\0\1\147\1\0\1\147\3\0\1\105"+
    "\3\0\1\147\1\105\1\147\1\0\1\147\1\0\1\147"+
    "\6\0\1\147\1\0\1\147\23\0\4\42\1\150\1\42"+
    "\1\150\1\42\1\150\3\0\1\112\3\0\1\150\1\112"+
    "\1\150\1\42\1\150\1\42\1\150\6\42\1\150\1\42"+
    "\1\150\7\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\1\202\26\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\1\203\26\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\14\42\1\204\12\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\7\42\1\205\17\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\10\42\1\206\16\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\6\42\1\207\20\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\20\42\1\210\6\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\11\42\1\211\15\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\16\42\1\212\10\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\4\42\1\213\22\42"+
    "\1\0\1\42\2\0\1\42\7\0\3\42\1\214\5\42"+
    "\3\0\1\42\3\0\27\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\12\42\1\215\14\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\1\42\1\216\25\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\20\42\1\217\6\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\6\42\1\220\20\42\1\0\1\42\2\0\1\42"+
    "\2\0\1\135\1\72\1\221\1\72\1\222\12\135\2\72"+
    "\1\135\1\72\40\135\2\72\1\0\1\72\1\175\56\72"+
    "\5\0\3\15\1\0\1\15\1\0\3\15\3\0\1\15"+
    "\3\0\7\15\1\223\17\15\14\0\3\15\1\0\1\15"+
    "\1\0\3\15\3\0\1\15\3\0\11\15\1\224\15\15"+
    "\14\0\3\15\1\0\1\15\1\0\3\15\3\0\1\15"+
    "\3\0\1\225\26\15\14\0\11\42\3\0\1\42\3\0"+
    "\1\42\1\226\25\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\5\42\1\227\21\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\4\42\1\230\22\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\7\42\1\231\17\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\3\42\1\232\23\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\5\42\1\233\21\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\16\42\1\234\10\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\11\42\1\235\15\42\1\0"+
    "\1\42\2\0\1\42\7\0\11\42\3\0\1\42\3\0"+
    "\11\42\1\236\15\42\1\0\1\42\2\0\1\42\7\0"+
    "\11\42\3\0\1\42\3\0\1\237\26\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\17\42"+
    "\1\240\7\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\13\42\1\241\13\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\15\42"+
    "\1\242\11\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\1\243\26\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\12\42\1\244"+
    "\14\42\1\0\1\42\2\0\1\42\2\0\1\135\1\72"+
    "\1\63\1\72\1\222\12\135\2\72\1\135\1\72\40\135"+
    "\5\0\3\15\1\0\1\15\1\0\3\15\3\0\1\15"+
    "\3\0\7\15\1\245\17\15\14\0\3\15\1\0\1\15"+
    "\1\0\3\15\3\0\1\15\3\0\15\15\1\246\11\15"+
    "\14\0\11\42\3\0\1\42\3\0\7\42\1\247\17\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\16\42\1\250\10\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\4\42\1\251\3\42"+
    "\1\252\16\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\4\42\1\253\22\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\22\42"+
    "\1\254\4\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\15\42\1\255\11\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\3\42"+
    "\1\256\23\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\15\42\1\257\11\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\7\42"+
    "\1\260\17\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\2\42\1\261\24\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\11\42"+
    "\1\262\15\42\1\0\1\42\2\0\1\42\7\0\11\42"+
    "\3\0\1\42\3\0\7\42\1\263\17\42\1\0\1\42"+
    "\2\0\1\42\7\0\11\42\3\0\1\42\3\0\1\264"+
    "\26\42\1\0\1\42\2\0\1\42\7\0\11\42\3\0"+
    "\1\42\3\0\7\42\1\265\17\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\1\42\1\266"+
    "\5\42\1\267\13\42\1\270\3\42\1\0\1\42\2\0"+
    "\1\42\7\0\11\42\3\0\1\42\3\0\1\271\26\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\7\42\1\272\17\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\1\42\1\273\25\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\7\42\1\274\17\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\11\42\1\275\15\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\7\42\1\276\17\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\13\42\1\277\13\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\3\42\1\300\23\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\14\42\1\301\12\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\4\42\1\302\22\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\12\42\1\303\14\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\4\42\1\304\22\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\6\42\1\305\20\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\13\42\1\306\13\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\4\42\1\307\22\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\15\42\1\310\11\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\5\42\1\311\21\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\24\42\1\312\2\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\7\42\1\313\17\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\7\42\1\314\17\42\1\0\1\42\2\0\1\42"+
    "\7\0\11\42\3\0\1\42\3\0\10\42\1\315\16\42"+
    "\1\0\1\42\2\0\1\42\7\0\11\42\3\0\1\42"+
    "\3\0\7\42\1\316\17\42\1\0\1\42\2\0\1\42"+
    "\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[7803];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

// _line_ 407 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\7\0\1\1\2\11\1\1\1\11\12\1\3\11\4\1"+
    "\2\11\1\1\1\11\24\1\2\11\2\1\1\0\7\1"+
    "\1\0\3\11\3\0\1\11\24\1\2\0\1\11\1\0"+
    "\32\1\1\11\1\0\121\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[206];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

// _line_ 451 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
// _line_ 20 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
    CommandLexer (String src) {
	this (new StringReader (src));
    }

    String lexeme;
    String lastCommand, lastRecognizedKeyword;
    CommandParser parser;

    private int parens;
    private boolean balanceParens;
    StringBuilder buffer = new StringBuilder ();

    int scan () throws java.io.IOException {
	int s0 = yystate ();        
	int tok = yylex ();
        if (parser != null && parser.yydebug > 0) {
	    System.err.printf ("scan: %d->%d => %d/'%s'%n", 
			       s0, yystate (), tok, lexeme);
        }
        return tok;
    }

    void toDefaultMode () {
	yybegin (DEFAULTARGS);
    }

    void toBreakMode () {
	yybegin (BREAK); 
    }

    void toBalancedCollectMode () {
	yybegin (COLLECT);
	buffer.setLength (0);
	balanceParens = true;
	parens = 0;
    }

    void toCollectMode () {
	yybegin (COLLECT);
	buffer.setLength (0);
	balanceParens = false;
	parens = 0;
    }

    void toRunArgsMode () {
	yybegin (RUNARGS); 
    }

    void toPrintMode () {
	yybegin (PRINT);
    }

    private void setVal (String val) {
	lexeme = val;
    }

    private int symbol (String val) {
        setVal (val);
	return CommandParser.findQuotedToken (val);
    }

    private int command () {
	int result = keyword (commandList, WORD);
	lastCommand = lastRecognizedKeyword;
	return result;
    }

    private int keyword (String[][] keywordList, int defaultVal) {
         int i, j;
	 int N = yylength ();
         i = j = 0;
	 while (i < keywordList.length && j < N) {
	     if (j >= keywordList[i][0].length ()
		 || yycharat (j) > keywordList[i][0].charAt (j))
		 i += 1;
	     else if (yycharat (j) == keywordList[i][0].charAt (j))
		 j += 1;
	     else 
		 break;
          }
	  if (j == N
	      && yymatch (keywordList[i][0])
	      && (N == keywordList[i][0].length ()
		  || i + 1 >= keywordList.length 
		  || !yymatch (keywordList[i+1][0]))) {
	       lastRecognizedKeyword = keywordList[i][keywordList[i].length-1];
	       return symbol (lastRecognizedKeyword);
	  }
          setVal (yytext ());
	  return defaultVal;
     }
	     
     /** True iff the first N characters of yytext () match S. */
     private boolean yymatch (String S) {
	if (S.length () < yylength ())
	    return false;
	for (int i = yylength () - 1; i >= 0; i -= 1)
	    if (S.charAt (i) != yycharat (i))
		return false;
	return true;
     }

    /* NOTE: These commands do not require a connected VM. 
       "?", 
       "attach",
       "break", 
       "catch", "classpath", "clear", "command", "condition", "connect",
       "delete", "exclude", 
       "exec-args", "exec-class", "exit",
       "help",
       "info",
       "listen",
       "pass",
       "quit", 
       "run", 
       "set", "source", "sourcepath",
       "unwatch", "use", 
       "version", 
       "watch"
    */

     private static final String[][] commandList =
	{ { "?", "help" },
	  { "attach" },
          { "b", "break" },
    	  { "backtrace" },
    	  { "break" },
	  { "bt", "backtrace" },
	  { "bytecodes" },
	  { "c", "continue"},
	  { "call" },
	  { "catch" },
	  { "classpath" },
	  { "clear" },
	  { "command" },
	  { "condition" },
	  { "connect" },
	  { "continue" },
	  { "d", "delete"},
	  { "da", "dumpall"},
	  { "delete" },
	  { "detach" },
	  { "disablegc" },
	  { "down" },
	  { "dump" },
	  { "dumpall" },
	  { "enablegc" },
	  { "eval", "print" },
	  { "exclude" },
	  { "exec-args" },
	  { "exec-class" },
	  { "exit", "quit"},
	  { "f", "finish"},
	  { "finish" },
	  { "frame" },
	  { "gc" },
	  { "help" },
	  { "ignore" },
	  { "info" },
	  { "interrupt" },
	  { "kill" },
	  { "l", "list"},
	  { "lines" },
	  { "list" },
	  { "listen" },
	  { "loadclass" },
	  { "lock" },
	  { "memory" },
	  { "monitor" },
	  { "next" },
	  { "p", "print"},
	  { "pass" },
	  { "print" },
	  { "ptype" },
	  { "quit" },
	  { "read" },
	  { "resume" },
	  { "run" },
	  { "s", "step"},
	  { "save" },
	  { "set" },
	  { "si", "stepi"},
	  { "source" },
	  { "sourcepath" },
	  { "step" },
	  { "stepi" },
	  { "suspend" },
	  { "thread" },
	  { "threadgroup" },
	  { "trace" },
	  { "unmonitor" },
	  { "untrace" },
	  { "unwatch" },
	  { "up" },
	  { "use", "sourcepath"},
	  { "version" },
	  { "watch" },
	  { "where", "backtrace"},
	  { "wherei" }
	};


// _line_ 705 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  CommandLexer(java.io.Reader in) {
      yybegin (COMMAND);
    lastCommand = lastRecognizedKeyword = null;
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  CommandLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 150) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }
// _line_ 746 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
// _line_ 892 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
// _line_ 902 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
// _line_ 915 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


// _line_ 923 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
// _line_ 932 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;
// _line_ 946 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

    while (true) {
      zzMarkedPosL = zzMarkedPos;

// _line_ 951 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;

// _line_ 958 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
// _line_ 993 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
// _line_ 997 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;
// _line_ 1005 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 47: 
          { 
// _line_ 283 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("methods"); 
          }
        case 55: break;
        case 40: 
          { 
// _line_ 303 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("access"); 
          }
        case 56: break;
        case 28: 
          { 
// _line_ 273 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("all"); 
          }
        case 57: break;
        case 6: 
          { 
// _line_ 313 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ()); return INTLIT; 
          }
        case 58: break;
        case 31: 
          { 
// _line_ 294 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("variable"); 
          }
        case 59: break;
        case 19: 
          { 
// _line_ 249 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 
          }
        case 60: break;
        case 29: 
          { 
// _line_ 293 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("run"); 
          }
        case 61: break;
        case 34: 
          { 
// _line_ 274 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("break"); 
          }
        case 62: break;
        case 8: 
          { 
// _line_ 324 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 buffer.append ("("); parens += 1; 
          }
        case 63: break;
        case 51: 
          { 
// _line_ 278 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("compressed"); 
          }
        case 64: break;
        case 41: 
          { 
// _line_ 309 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("thread"); 
          }
        case 65: break;
        case 36: 
          { 
// _line_ 288 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("stack"); 
          }
        case 66: break;
        case 44: 
          { 
// _line_ 280 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("fields"); 
          }
        case 67: break;
        case 39: 
          { 
// _line_ 296 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("watch"); 
          }
        case 68: break;
        case 9: 
          { 
// _line_ 325 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 if (parens <= 0 && balanceParens) {
	          yybegin (DEFAULTARGS);
		  yypushback (1);
		  setVal (buffer.toString ().trim ());
		  return TEXT;
	      } else {
		  buffer.append (")");
		  parens -= 1;
	      }
	    
          }
        case 69: break;
        case 13: 
          { 
// _line_ 299 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return yycharat (0); 
          }
        case 70: break;
        case 48: 
          { 
// _line_ 279 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("elements"); 
          }
        case 71: break;
        case 45: 
          { 
// _line_ 276 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("classes"); 
          }
        case 72: break;
        case 5: 
          { 
// _line_ 310 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ()); return IDENT; 
          }
        case 73: break;
        case 24: 
          { 
// _line_ 256 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ().substring (1, yylength () - 1)); 
			  return WORD; 
          }
        case 74: break;
        case 22: 
          { 
// _line_ 311 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol (".0"); 
          }
        case 75: break;
        case 20: 
          { 
// _line_ 306 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("if"); 
          }
        case 76: break;
        case 52: 
          { 
// _line_ 282 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("max-frames"); 
          }
        case 77: break;
        case 26: 
          { 
// _line_ 263 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ()); return WORD; 
          }
        case 78: break;
        case 15: 
          { 
// _line_ 261 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ()); return WORD; 
          }
        case 79: break;
        case 10: 
          { 
// _line_ 269 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 yybegin (DEFAULTARGS); return command (); 
          }
        case 80: break;
        case 46: 
          { 
// _line_ 292 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("threads"); 
          }
        case 81: break;
        case 38: 
          { 
// _line_ 287 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("print"); 
          }
        case 82: break;
        case 12: 
          { 
// _line_ 267 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 yybegin (DEFAULTARGS); return symbol ("^F"); 
          }
        case 83: break;
        case 14: 
          { 
// _line_ 297 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ()); return WORD; 
          }
        case 84: break;
        case 49: 
          { 
// _line_ 295 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("variable"); 
          }
        case 85: break;
        case 35: 
          { 
// _line_ 275 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("class"); 
          }
        case 86: break;
        case 54: 
          { 
// _line_ 290 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("threadgroups"); 
          }
        case 87: break;
        case 17: 
          { 
// _line_ 319 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 yypushback (1); yybegin (COLLECT); 
          }
        case 88: break;
        case 25: 
          { 
// _line_ 285 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("on"); 
          }
        case 89: break;
        case 21: 
          { 
// _line_ 305 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("go"); 
          }
        case 90: break;
        case 3: 
          { 
// _line_ 248 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 
          }
        case 91: break;
        case 18: 
          { 
// _line_ 318 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 yybegin (DEFAULTARGS); return '/'; 
          }
        case 92: break;
        case 1: 
          { 
// _line_ 350 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 throw ERROR ("Internal error: lexer in improper state."); 
          }
        case 93: break;
        case 23: 
          { 
// _line_ 312 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("[]"); 
          }
        case 94: break;
        case 53: 
          { 
// _line_ 291 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("threadlocks"); 
          }
        case 95: break;
        case 42: 
          { 
// _line_ 281 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("locals"); 
          }
        case 96: break;
        case 4: 
          { 
// _line_ 314 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return yycharat (0); 
          }
        case 97: break;
        case 16: 
          { 
// _line_ 262 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return yycharat (0); 
          }
        case 98: break;
        case 7: 
          { 
// _line_ 335 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 buffer.append (yycharat (0)); 
          }
        case 99: break;
        case 50: 
          { 
// _line_ 277 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("classpath"); 
          }
        case 100: break;
        case 32: 
          { 
// _line_ 307 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("none"); 
          }
        case 101: break;
        case 43: 
          { 
// _line_ 286 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("pretty"); 
          }
        case 102: break;
        case 33: 
          { 
// _line_ 308 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("reset"); 
          }
        case 103: break;
        case 30: 
          { 
// _line_ 284 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("off"); 
          }
        case 104: break;
        case 27: 
          { 
// _line_ 304 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("all"); 
          }
        case 105: break;
        case 11: 
          { 
// _line_ 255 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (yytext ()); return INTLIT; 
          }
        case 106: break;
        case 37: 
          { 
// _line_ 289 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 return symbol ("stdin"); 
          }
        case 107: break;
        case 2: 
          { 
// _line_ 347 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"

		  throw ERROR ("Unknown symbol: '%c'", yycharat (0)); 
          }
        case 108: break;
// _line_ 1343 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case PRINT: {
              
// _line_ 319 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 setVal (""); return TEXT; 
            }
            case 207: break;
            case COLLECT: {
              
// _line_ 335 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.jf"
 if (parens != 0) 
		  throw ERROR ("unbalanced parentheses");
	      String text = buffer.toString ().trim ();
	      yybegin (DEFAULTARGS); 
	      if (text.length () > 0) {
	          setVal (text);
	          return TEXT; 
	       }
	     
            }
            case 208: break;
            default:
            return YYEOF;
            }
// _line_ 1371 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
// _line_ 1375 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"
          }
      }
    }
  }

// _line_ 1381 "/home/cs/hilfingr/src/gjdb-5x/src/ucb/gjdb/CommandLexer.java"

}
