/*******************************<GINKGO LICENSE>******************************
Copyright (c) 2017-2023, the Ginkgo authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************<GINKGO LICENSE>*******************************/

#ifndef GKO_OMP_COMPONENTS_MATRIX_OPERATIONS_HPP_
#define GKO_OMP_COMPONENTS_MATRIX_OPERATIONS_HPP_


#include <omp.h>


#include <ginkgo/core/base/math.hpp>


namespace gko {
namespace kernels {
namespace omp {


/**
 * @internal
 *
 * Computes the infinity norm of a column-major matrix.
 */
template <typename ValueType>
remove_complex<ValueType> compute_inf_norm(size_type num_rows,
                                           size_type num_cols,
                                           const ValueType* matrix,
                                           size_type stride)
{
    auto result = zero<remove_complex<ValueType>>();
    for (size_type i = 0; i < num_rows; ++i) {
        auto tmp = zero<remove_complex<ValueType>>();
        for (size_type j = 0; j < num_cols; ++j) {
            tmp += abs(matrix[i + j * stride]);
        }
        result = max(result, tmp);
    }
    return result;
}


}  // namespace omp
}  // namespace kernels
}  // namespace gko


#endif  // GKO_OMP_COMPONENTS_MATRIX_OPERATIONS_HPP_
