/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppatternselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimppatternselect
 * @title: gimppatternselect
 * @short_description: Functions providing a pattern selection dialog.
 *
 * Functions providing a pattern selection dialog.
 **/


/**
 * gimp_patterns_popup:
 * @pattern_callback: The callback PDB proc to call when pattern selection is made.
 * @popup_title: Title of the pattern selection dialog.
 * @initial_pattern: The name of the pattern to set as the first selected.
 *
 * Invokes the Gimp pattern selection.
 *
 * This procedure opens the pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_popup (const gchar *pattern_callback,
                     const gchar *popup_title,
                     const gchar *initial_pattern)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), pattern_callback);
  g_value_set_string (gimp_value_array_index (args, 1), popup_title);
  g_value_set_string (gimp_value_array_index (args, 2), initial_pattern);

  return_vals = gimp_run_procedure_with_array ("gimp-patterns-popup",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_patterns_close_popup:
 * @pattern_callback: The name of the callback registered for this pop-up.
 *
 * Close the pattern selection dialog.
 *
 * This procedure closes an opened pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_close_popup (const gchar *pattern_callback)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), pattern_callback);

  return_vals = gimp_run_procedure_with_array ("gimp-patterns-close-popup",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_patterns_set_popup:
 * @pattern_callback: The name of the callback registered for this pop-up.
 * @pattern_name: The name of the pattern to set as selected.
 *
 * Sets the current pattern in a pattern selection dialog.
 *
 * Sets the current pattern in a pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_set_popup (const gchar *pattern_callback,
                         const gchar *pattern_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (G_TYPE_STRING,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  g_value_set_string (gimp_value_array_index (args, 0), pattern_callback);
  g_value_set_string (gimp_value_array_index (args, 1), pattern_name);

  return_vals = gimp_run_procedure_with_array ("gimp-patterns-set-popup",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
