/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagetransform_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimagetransform
 * @title: gimpimagetransform
 * @short_description: Transformations on images.
 *
 * Operations to scale, resize, crop, flip and rotate images.
 **/


/**
 * gimp_image_resize:
 * @image_ID: The image.
 * @new_width: New image width.
 * @new_height: New image height.
 * @offx: x offset between upper left corner of old and new images: (new - old).
 * @offy: y offset between upper left corner of old and new images: (new - old).
 *
 * Resize the image to the specified extents.
 *
 * This procedure resizes the image so that it's new width and height
 * are equal to the supplied parameters. Offsets are also provided
 * which describe the position of the previous image's content. All
 * channels within the image are resized according to the specified
 * parameters; this includes the image selection mask. All layers
 * within the image are repositioned according to the specified
 * offsets.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_resize (gint32 image_ID,
                   gint   new_width,
                   gint   new_height,
                   gint   offx,
                   gint   offy)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), new_width);
  g_value_set_int (gimp_value_array_index (args, 2), new_height);
  g_value_set_int (gimp_value_array_index (args, 3), offx);
  g_value_set_int (gimp_value_array_index (args, 4), offy);

  return_vals = gimp_run_procedure_with_array ("gimp-image-resize",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_resize_to_layers:
 * @image_ID: The image.
 *
 * Resize the image to fit all layers.
 *
 * This procedure resizes the image to the bounding box of all layers
 * of the image. All channels within the image are resized to the new
 * size; this includes the image selection mask. All layers within the
 * image are repositioned to the new image area.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_image_resize_to_layers (gint32 image_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-resize-to-layers",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_scale:
 * @image_ID: The image.
 * @new_width: New image width.
 * @new_height: New image height.
 *
 * Scale the image using the default interpolation method.
 *
 * This procedure scales the image so that its new width and height are
 * equal to the supplied parameters. All layers and channels within the
 * image are scaled according to the specified parameters; this
 * includes the image selection mask. The interpolation method used can
 * be set with gimp_context_set_interpolation().
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_scale (gint32 image_ID,
                  gint   new_width,
                  gint   new_height)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), new_width);
  g_value_set_int (gimp_value_array_index (args, 2), new_height);

  return_vals = gimp_run_procedure_with_array ("gimp-image-scale",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_crop:
 * @image_ID: The image.
 * @new_width: New image width: (0 < new_width <= width).
 * @new_height: New image height: (0 < new_height <= height).
 * @offx: X offset: (0 <= offx <= (width - new_width)).
 * @offy: Y offset: (0 <= offy <= (height - new_height)).
 *
 * Crop the image to the specified extents.
 *
 * This procedure crops the image so that it's new width and height are
 * equal to the supplied parameters. Offsets are also provided which
 * describe the position of the previous image's content. All channels
 * and layers within the image are cropped to the new image extents;
 * this includes the image selection mask. If any parameters are out of
 * range, an error is returned.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_crop (gint32 image_ID,
                 gint   new_width,
                 gint   new_height,
                 gint   offx,
                 gint   offy)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), new_width);
  g_value_set_int (gimp_value_array_index (args, 2), new_height);
  g_value_set_int (gimp_value_array_index (args, 3), offx);
  g_value_set_int (gimp_value_array_index (args, 4), offy);

  return_vals = gimp_run_procedure_with_array ("gimp-image-crop",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_flip:
 * @image_ID: The image.
 * @flip_type: Type of flip.
 *
 * Flips the image horizontally or vertically.
 *
 * This procedure flips (mirrors) the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_flip (gint32              image_ID,
                 GimpOrientationType flip_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ORIENTATION_TYPE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), flip_type);

  return_vals = gimp_run_procedure_with_array ("gimp-image-flip",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_rotate:
 * @image_ID: The image.
 * @rotate_type: Angle of rotation.
 *
 * Rotates the image by the specified degrees.
 *
 * This procedure rotates the image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_rotate (gint32           image_ID,
                   GimpRotationType rotate_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_ROTATION_TYPE,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), rotate_type);

  return_vals = gimp_run_procedure_with_array ("gimp-image-rotate",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
