/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimageguides_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpimageguides
 * @title: gimpimageguides
 * @short_description: Functions for manipulating an image's guides.
 *
 * Functions for manipulating an image's guides.
 **/


/**
 * gimp_image_add_hguide:
 * @image_ID: The image.
 * @yposition: The guide's y-offset from top of image.
 *
 * Add a horizontal guide to an image.
 *
 * This procedure adds a horizontal guide to an image. It takes the
 * input image and the y-position of the new guide as parameters. It
 * returns the guide ID of the new guide.
 *
 * Returns: The new guide.
 **/
gint32
gimp_image_add_hguide (gint32 image_ID,
                       gint   yposition)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 guide_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), yposition);

  return_vals = gimp_run_procedure_with_array ("gimp-image-add-hguide",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    guide_ID = g_value_get_uint (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return guide_ID;
}

/**
 * gimp_image_add_vguide:
 * @image_ID: The image.
 * @xposition: The guide's x-offset from left of image.
 *
 * Add a vertical guide to an image.
 *
 * This procedure adds a vertical guide to an image. It takes the input
 * image and the x-position of the new guide as parameters. It returns
 * the guide ID of the new guide.
 *
 * Returns: The new guide.
 **/
gint32
gimp_image_add_vguide (gint32 image_ID,
                       gint   xposition)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 guide_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), xposition);

  return_vals = gimp_run_procedure_with_array ("gimp-image-add-vguide",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    guide_ID = g_value_get_uint (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return guide_ID;
}

/**
 * gimp_image_delete_guide:
 * @image_ID: The image.
 * @guide_ID: The ID of the guide to be removed.
 *
 * Deletes a guide from an image.
 *
 * This procedure takes an image and a guide ID as input and removes
 * the specified guide from the specified image.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_image_delete_guide (gint32 image_ID,
                         gint32 guide_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), guide_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-delete-guide",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_find_next_guide:
 * @image_ID: The image.
 * @guide_ID: The ID of the current guide (0 if first invocation).
 *
 * Find next guide on an image.
 *
 * This procedure takes an image and a guide ID as input and finds the
 * guide ID of the successor of the given guide ID in the image's guide
 * list. If the supplied guide ID is 0, the procedure will return the
 * first Guide. The procedure will return 0 if given the final guide ID
 * as an argument or the image has no guides.
 *
 * Returns: The next guide's ID.
 **/
gint32
gimp_image_find_next_guide (gint32 image_ID,
                            gint32 guide_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 next_guide_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), guide_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-find-next-guide",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    next_guide_ID = g_value_get_uint (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return next_guide_ID;
}

/**
 * gimp_image_get_guide_orientation:
 * @image_ID: The image.
 * @guide_ID: The guide.
 *
 * Get orientation of a guide on an image.
 *
 * This procedure takes an image and a guide ID as input and returns
 * the orientations of the guide.
 *
 * Returns: The guide's orientation.
 **/
GimpOrientationType
gimp_image_get_guide_orientation (gint32 image_ID,
                                  gint32 guide_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpOrientationType orientation = GIMP_ORIENTATION_UNKNOWN;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), guide_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-guide-orientation",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    orientation = g_value_get_enum (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return orientation;
}

/**
 * gimp_image_get_guide_position:
 * @image_ID: The image.
 * @guide_ID: The guide.
 *
 * Get position of a guide on an image.
 *
 * This procedure takes an image and a guide ID as input and returns
 * the position of the guide relative to the top or left of the image.
 *
 * Returns: The guide's position relative to top or left of image.
 **/
gint
gimp_image_get_guide_position (gint32 image_ID,
                               gint32 guide_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint position = G_MININT /* GIMP_GUIDE_POSITION_UNDEFINED */;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_uint (gimp_value_array_index (args, 1), guide_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-image-get-guide-position",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    position = g_value_get_int (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return position;
}
