/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpchannel_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpchannel
 * @title: gimpchannel
 * @short_description: Functions for manipulating channels.
 *
 * Functions for manipulating channels.
 **/


/**
 * _gimp_channel_new:
 * @image_ID: The image to which to add the channel.
 * @width: The channel width.
 * @height: The channel height.
 * @name: The channel name.
 * @opacity: The channel opacity.
 * @color: The channel compositing color.
 *
 * Create a new channel.
 *
 * This procedure creates a new channel with the specified width,
 * height, name, opacity and color.
 * The new channel still needs to be added to the image, as this is not
 * automatic. Add the new channel with gimp_image_insert_channel().
 * Other attributes, such as channel visibility, should be set with
 * explicit procedure calls.
 * The channel's contents are undefined initially.
 *
 * Returns: The newly created channel.
 **/
gint32
_gimp_channel_new (gint32         image_ID,
                   gint           width,
                   gint           height,
                   const gchar   *name,
                   gdouble        opacity,
                   const GimpRGB *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 channel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_STRING,
                                          G_TYPE_DOUBLE,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_int (gimp_value_array_index (args, 1), width);
  g_value_set_int (gimp_value_array_index (args, 2), height);
  g_value_set_string (gimp_value_array_index (args, 3), name);
  g_value_set_double (gimp_value_array_index (args, 4), opacity);
  gimp_value_set_rgb (gimp_value_array_index (args, 5), color);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-new",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    channel_ID = gimp_value_get_channel_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return channel_ID;
}

/**
 * gimp_channel_new_from_component:
 * @image_ID: The image to which to add the channel.
 * @component: The image component.
 * @name: The channel name.
 *
 * Create a new channel from a color component
 *
 * This procedure creates a new channel from a color component.
 * The new channel still needs to be added to the image, as this is not
 * automatic. Add the new channel with gimp_image_insert_channel().
 * Other attributes, such as channel visibility, should be set with
 * explicit procedure calls.
 *
 * Returns: The newly created channel.
 *
 * Since: 2.4
 **/
gint32
gimp_channel_new_from_component (gint32           image_ID,
                                 GimpChannelType  component,
                                 const gchar     *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 channel_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_IMAGE_ID,
                                          GIMP_TYPE_CHANNEL_TYPE,
                                          G_TYPE_STRING,
                                          G_TYPE_NONE);
  gimp_value_set_image_id (gimp_value_array_index (args, 0), image_ID);
  g_value_set_enum (gimp_value_array_index (args, 1), component);
  g_value_set_string (gimp_value_array_index (args, 2), name);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-new-from-component",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    channel_ID = gimp_value_get_channel_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return channel_ID;
}

/**
 * gimp_channel_copy:
 * @channel_ID: The channel to copy.
 *
 * Copy a channel.
 *
 * This procedure copies the specified channel and returns the copy.
 * The new channel still needs to be added to the image, as this is not
 * automatic. Add the new channel with gimp_image_insert_channel().
 *
 * Returns: The newly copied channel.
 **/
gint32
gimp_channel_copy (gint32 channel_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint32 channel_copy_ID = -1;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-copy",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    channel_copy_ID = gimp_value_get_channel_id (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return channel_copy_ID;
}

/**
 * gimp_channel_combine_masks:
 * @channel1_ID: The channel1.
 * @channel2_ID: The channel2.
 * @operation: The selection operation.
 * @offx: x offset between upper left corner of channels: (second - first).
 * @offy: y offset between upper left corner of channels: (second - first).
 *
 * Combine two channel masks.
 *
 * This procedure combines two channel masks. The result is stored in
 * the first channel.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_combine_masks (gint32         channel1_ID,
                            gint32         channel2_ID,
                            GimpChannelOps operation,
                            gint           offx,
                            gint           offy)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          GIMP_TYPE_CHANNEL_ID,
                                          GIMP_TYPE_CHANNEL_OPS,
                                          GIMP_TYPE_INT32,
                                          GIMP_TYPE_INT32,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel1_ID);
  gimp_value_set_channel_id (gimp_value_array_index (args, 1), channel2_ID);
  g_value_set_enum (gimp_value_array_index (args, 2), operation);
  g_value_set_int (gimp_value_array_index (args, 3), offx);
  g_value_set_int (gimp_value_array_index (args, 4), offy);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-combine-masks",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_get_show_masked:
 * @channel_ID: The channel.
 *
 * Get the composite method of the specified channel.
 *
 * This procedure returns the specified channel's composite method. If
 * it is TRUE, then the channel is composited with the image so that
 * masked regions are shown. Otherwise, selected regions are shown.
 *
 * Returns: The channel composite method.
 **/
gboolean
gimp_channel_get_show_masked (gint32 channel_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean show_masked = FALSE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-get-show-masked",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    show_masked = g_value_get_boolean (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return show_masked;
}

/**
 * gimp_channel_set_show_masked:
 * @channel_ID: The channel.
 * @show_masked: The new channel composite method.
 *
 * Set the composite method of the specified channel.
 *
 * This procedure sets the specified channel's composite method. If it
 * is TRUE, then the channel is composited with the image so that
 * masked regions are shown. Otherwise, selected regions are shown.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_set_show_masked (gint32   channel_ID,
                              gboolean show_masked)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_BOOLEAN,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);
  g_value_set_boolean (gimp_value_array_index (args, 1), show_masked);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-set-show-masked",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_get_opacity:
 * @channel_ID: The channel.
 *
 * Get the opacity of the specified channel.
 *
 * This procedure returns the specified channel's opacity.
 *
 * Returns: The channel opacity.
 **/
gdouble
gimp_channel_get_opacity (gint32 channel_ID)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble opacity = 0.0;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-get-opacity",
                                               args);
  gimp_value_array_unref (args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS)
    opacity = g_value_get_double (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return opacity;
}

/**
 * gimp_channel_set_opacity:
 * @channel_ID: The channel.
 * @opacity: The new channel opacity.
 *
 * Set the opacity of the specified channel.
 *
 * This procedure sets the specified channel's opacity.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_set_opacity (gint32  channel_ID,
                          gdouble opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_DOUBLE,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);
  g_value_set_double (gimp_value_array_index (args, 1), opacity);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-set-opacity",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_get_color:
 * @channel_ID: The channel.
 * @color: (out caller-allocates): The channel compositing color.
 *
 * Get the compositing color of the specified channel.
 *
 * This procedure returns the specified channel's compositing color.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_get_color (gint32   channel_ID,
                        GimpRGB *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-get-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  if (success)
    gimp_value_get_rgb (gimp_value_array_index (return_vals, 1), &*color);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_set_color:
 * @channel_ID: The channel.
 * @color: The new channel compositing color.
 *
 * Set the compositing color of the specified channel.
 *
 * This procedure sets the specified channel's compositing color.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_set_color (gint32         channel_ID,
                        const GimpRGB *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (GIMP_TYPE_CHANNEL_ID,
                                          GIMP_TYPE_RGB,
                                          G_TYPE_NONE);
  gimp_value_set_channel_id (gimp_value_array_index (args, 0), channel_ID);
  gimp_value_set_rgb (gimp_value_array_index (args, 1), color);

  return_vals = gimp_run_procedure_with_array ("gimp-channel-set-color",
                                               args);
  gimp_value_array_unref (args);

  success = g_value_get_enum (gimp_value_array_index (return_vals, 0)) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
