/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpmath/gimpmath.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpchannel.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"
#include "core/gimppickable.h"
#include "core/gimpselection.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
selection_bounds_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean non_empty = FALSE;
  gint32 x1 = 0;
  gint32 y1 = 0;
  gint32 x2 = 0;
  gint32 y2 = 0;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      gint x, y, w, h;

      non_empty = gimp_item_bounds (GIMP_ITEM (gimp_image_get_mask (image)),
                                    &x, &y, &w, &h);

      x1 = x;
      y1 = y;
      x2 = x + w;
      y2 = y + h;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_boolean (gimp_value_array_index (return_vals, 1), non_empty);
      g_value_set_int (gimp_value_array_index (return_vals, 2), x1);
      g_value_set_int (gimp_value_array_index (return_vals, 3), y1);
      g_value_set_int (gimp_value_array_index (return_vals, 4), x2);
      g_value_set_int (gimp_value_array_index (return_vals, 5), y2);
    }

  return return_vals;
}

static GimpValueArray *
selection_value_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gint32 x;
  gint32 y;
  gint32 value = 0;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  x = g_value_get_int (gimp_value_array_index (args, 1));
  y = g_value_get_int (gimp_value_array_index (args, 2));

  if (success)
    {
      gdouble val;

      val= gimp_pickable_get_opacity_at (GIMP_PICKABLE (gimp_image_get_mask (image)),
                                         x, y);

      value = ROUND (CLAMP (val, 0.0, 1.0) * 255.0);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), value);

  return return_vals;
}

static GimpValueArray *
selection_is_empty_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gboolean is_empty = FALSE;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      is_empty = gimp_channel_is_empty (gimp_image_get_mask (image));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), is_empty);

  return return_vals;
}

static GimpValueArray *
selection_translate_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 offx;
  gint32 offy;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  offx = g_value_get_int (gimp_value_array_index (args, 1));
  offy = g_value_get_int (gimp_value_array_index (args, 2));

  if (success)
    {
      gimp_item_translate (GIMP_ITEM (gimp_image_get_mask (image)),
                           offx, offy, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_float_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawable *drawable;
  gint32 offx;
  gint32 offy;
  GimpLayer *layer = NULL;

  drawable = gimp_value_get_drawable (gimp_value_array_index (args, 0), gimp);
  offx = g_value_get_int (gimp_value_array_index (args, 1));
  offy = g_value_get_int (gimp_value_array_index (args, 2));

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (drawable));

          layer = gimp_selection_float (GIMP_SELECTION (gimp_image_get_mask (image)),
                                        drawable, context, TRUE, offx, offy,
                                        error);
          if (! layer)
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_layer (gimp_value_array_index (return_vals, 1), layer);

  return return_vals;
}

static GimpValueArray *
selection_invert_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      gimp_channel_invert (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_sharpen_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      gimp_channel_sharpen (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_all_invoker (GimpProcedure         *procedure,
                       Gimp                  *gimp,
                       GimpContext           *context,
                       GimpProgress          *progress,
                       const GimpValueArray  *args,
                       GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      gimp_channel_all (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_none_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      gimp_channel_clear (gimp_image_get_mask (image), NULL, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_feather_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gdouble radius;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  radius = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      /* FIXME: "edge-lock" hardcoded to  TRUE */
      gimp_channel_feather (gimp_image_get_mask (image),
                            radius, radius, TRUE, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_border_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 radius;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  radius = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      /* FIXME: "style" and "edge-lock" hardcoded to SMOOTH and TRUE, respectively. */
      gimp_channel_border (gimp_image_get_mask (image),
                           radius, radius,
                           GIMP_CHANNEL_BORDER_STYLE_SMOOTH,
                           TRUE, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_grow_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 steps;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  steps = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_channel_grow (gimp_image_get_mask (image),
                         steps, steps, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_shrink_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 steps;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  steps = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_channel_shrink (gimp_image_get_mask (image),
                           steps, steps, FALSE, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_flood_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      gimp_channel_flood (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
selection_save_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  GimpChannel *channel = NULL;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      channel = GIMP_CHANNEL (gimp_item_duplicate (GIMP_ITEM (gimp_image_get_mask (image)),
                                                   GIMP_TYPE_CHANNEL));

      if (channel)
        {
          /*  saved selections are not visible by default  */
          gimp_item_set_visible (GIMP_ITEM (channel), FALSE, FALSE);

          gimp_image_add_channel (image, channel,
                                  GIMP_IMAGE_ACTIVE_PARENT, -1, TRUE);
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_channel (gimp_value_array_index (return_vals, 1), channel);

  return return_vals;
}

void
register_selection_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-selection-bounds
   */
  procedure = gimp_procedure_new (selection_bounds_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-bounds");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-bounds",
                                     "Find the bounding box of the current selection.",
                                     "This procedure returns whether there is a selection for the specified image. If there is one, the upper left and lower right corners of the bounding box are returned. These coordinates are relative to the image. Please note that the pixel specified by the lower right coordinate of the bounding box is not part of the selection. The selection ends at the upper left corner of this pixel. This means the width of the selection can be calculated as (x2 - x1), its height as (y2 - y1).",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("non-empty",
                                                         "non empty",
                                                         "TRUE if there is a selection",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("x1",
                                                          "x1",
                                                          "x coordinate of upper left corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("y1",
                                                          "y1",
                                                          "y coordinate of upper left corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("x2",
                                                          "x2",
                                                          "x coordinate of lower right corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("y2",
                                                          "y2",
                                                          "y coordinate of lower right corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-value
   */
  procedure = gimp_procedure_new (selection_value_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-value");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-value",
                                     "Find the value of the selection at the specified coordinates.",
                                     "This procedure returns the value of the selection at the specified coordinates. If the coordinates lie out of bounds, 0 is returned.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("x",
                                                      "x",
                                                      "x coordinate of value",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("y",
                                                      "y",
                                                      "y coordinate of value",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("value",
                                                          "value",
                                                          "Value of the selection",
                                                          0, 255, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-is-empty
   */
  procedure = gimp_procedure_new (selection_is_empty_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-is-empty");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-is-empty",
                                     "Determine whether the selection is empty.",
                                     "This procedure returns TRUE if the selection for the specified image is empty.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("is-empty",
                                                         "is empty",
                                                         "Is the selection empty?",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-translate
   */
  procedure = gimp_procedure_new (selection_translate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-translate");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-translate",
                                     "Translate the selection by the specified offsets.",
                                     "This procedure actually translates the selection for the specified image by the specified offsets. Regions that are translated from beyond the bounds of the image are set to empty. Valid regions of the selection which are translated beyond the bounds of the image because of this call are lost.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "x offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "y offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-float
   */
  procedure = gimp_procedure_new (selection_float_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-float");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-float",
                                     "Float the selection from the specified drawable with initial offsets as specified.",
                                     "This procedure determines the region of the specified drawable that lies beneath the current selection. The region is then cut from the drawable and the resulting data is made into a new layer which is instantiated as a floating selection. The offsets allow initial positioning of the new floating selection.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable from which to float selection",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "x offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "y offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer",
                                                             "layer",
                                                             "The floated layer",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-invert
   */
  procedure = gimp_procedure_new (selection_invert_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-invert");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-invert",
                                     "Invert the selection mask.",
                                     "This procedure inverts the selection mask. For every pixel in the selection channel, its new value is calculated as (255 - old-value).",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-sharpen
   */
  procedure = gimp_procedure_new (selection_sharpen_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-sharpen");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-sharpen",
                                     "Sharpen the selection mask.",
                                     "This procedure sharpens the selection mask. For every pixel in the selection channel, if the value is > 127, the new pixel is assigned a value of 255. This removes any \"anti-aliasing\" that might exist in the selection mask's boundary.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-all
   */
  procedure = gimp_procedure_new (selection_all_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-all");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-all",
                                     "Select all of the image.",
                                     "This procedure sets the selection mask to completely encompass the image. Every pixel in the selection channel is set to 255.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-none
   */
  procedure = gimp_procedure_new (selection_none_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-none");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-none",
                                     "Deselect the entire image.",
                                     "This procedure deselects the entire image. Every pixel in the selection channel is set to 0.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-feather
   */
  procedure = gimp_procedure_new (selection_feather_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-feather");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-feather",
                                     "Feather the image's selection",
                                     "This procedure feathers the selection. Feathering is implemented using a gaussian blur.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("radius",
                                                    "radius",
                                                    "Radius of feather (in pixels)",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-border
   */
  procedure = gimp_procedure_new (selection_border_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-border");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-border",
                                     "Border the image's selection",
                                     "This procedure borders the selection. Bordering creates a new selection which is defined along the boundary of the previous selection at every point within the specified radius.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("radius",
                                                      "radius",
                                                      "Radius of border (in pixels)",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-grow
   */
  procedure = gimp_procedure_new (selection_grow_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-grow");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-grow",
                                     "Grow the image's selection",
                                     "This procedure grows the selection. Growing involves expanding the boundary in all directions by the specified pixel amount.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("steps",
                                                      "steps",
                                                      "Steps of grow (in pixels)",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-shrink
   */
  procedure = gimp_procedure_new (selection_shrink_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-shrink");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-shrink",
                                     "Shrink the image's selection",
                                     "This procedure shrinks the selection. Shrinking involves trimming the existing selection boundary on all sides by the specified number of pixels.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("steps",
                                                      "steps",
                                                      "Steps of shrink (in pixels)",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-flood
   */
  procedure = gimp_procedure_new (selection_flood_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-flood");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-flood",
                                     "Remove holes from the image's selection",
                                     "This procedure removes holes from the selection, that can come from selecting a patchy area with the Fuzzy Select Tool. In technical terms this procedure floods the selection. See the Algorithms page in the developer wiki for details.",
                                     "Ell",
                                     "Ell",
                                     "2016",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-save
   */
  procedure = gimp_procedure_new (selection_save_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-save");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-save",
                                     "Copy the selection mask to a new channel.",
                                     "This procedure copies the selection mask and stores the content in a new channel. The new channel is automatically inserted into the image's list of channels.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_channel_id ("channel",
                                                               "channel",
                                                               "The new channel",
                                                               pdb->gimp, FALSE,
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
