/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpitemtransform_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_ITEM_TRANSFORM_PDB_H__
#define __GIMP_ITEM_TRANSFORM_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gint32 gimp_item_transform_translate     (gint32              item_ID,
                                          gdouble             off_x,
                                          gdouble             off_y);
gint32 gimp_item_transform_flip_simple   (gint32              item_ID,
                                          GimpOrientationType flip_type,
                                          gboolean            auto_center,
                                          gdouble             axis);
gint32 gimp_item_transform_flip          (gint32              item_ID,
                                          gdouble             x0,
                                          gdouble             y0,
                                          gdouble             x1,
                                          gdouble             y1);
gint32 gimp_item_transform_perspective   (gint32              item_ID,
                                          gdouble             x0,
                                          gdouble             y0,
                                          gdouble             x1,
                                          gdouble             y1,
                                          gdouble             x2,
                                          gdouble             y2,
                                          gdouble             x3,
                                          gdouble             y3);
gint32 gimp_item_transform_rotate_simple (gint32              item_ID,
                                          GimpRotationType    rotate_type,
                                          gboolean            auto_center,
                                          gdouble             center_x,
                                          gdouble             center_y);
gint32 gimp_item_transform_rotate        (gint32              item_ID,
                                          gdouble             angle,
                                          gboolean            auto_center,
                                          gdouble             center_x,
                                          gdouble             center_y);
gint32 gimp_item_transform_scale         (gint32              item_ID,
                                          gdouble             x0,
                                          gdouble             y0,
                                          gdouble             x1,
                                          gdouble             y1);
gint32 gimp_item_transform_shear         (gint32              item_ID,
                                          GimpOrientationType shear_type,
                                          gdouble             magnitude);
gint32 gimp_item_transform_2d            (gint32              item_ID,
                                          gdouble             source_x,
                                          gdouble             source_y,
                                          gdouble             scale_x,
                                          gdouble             scale_y,
                                          gdouble             angle,
                                          gdouble             dest_x,
                                          gdouble             dest_y);
gint32 gimp_item_transform_matrix        (gint32              item_ID,
                                          gdouble             coeff_0_0,
                                          gdouble             coeff_0_1,
                                          gdouble             coeff_0_2,
                                          gdouble             coeff_1_0,
                                          gdouble             coeff_1_1,
                                          gdouble             coeff_1_2,
                                          gdouble             coeff_2_0,
                                          gdouble             coeff_2_1,
                                          gdouble             coeff_2_2);


G_END_DECLS

#endif /* __GIMP_ITEM_TRANSFORM_PDB_H__ */
