/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpgradients_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpgradients
 * @title: gimpgradients
 * @short_description: Operations related to gradients.
 *
 * Operations related to gradients.
 **/


/**
 * gimp_gradients_refresh:
 *
 * Refresh current gradients. This function always succeeds.
 *
 * This procedure retrieves all gradients currently in the user's
 * gradient path and updates the gradient dialogs accordingly.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_gradients_refresh (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-gradients-refresh",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_gradients_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_gradients: The number of loaded gradients.
 *
 * Retrieve the list of loaded gradients.
 *
 * This procedure returns a list of the gradients that are currently
 * loaded. You can later use the gimp_context_set_gradient() function
 * to set the active gradient.
 *
 * Returns: The list of gradient names. The returned value must be
 * freed with g_strfreev().
 **/
gchar **
gimp_gradients_get_list (const gchar *filter,
                         gint        *num_gradients)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **gradient_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-gradients-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_gradients = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_gradients = return_vals[1].data.d_int32;
      if (*num_gradients > 0)
        {
          gradient_list = g_new0 (gchar *, *num_gradients + 1);
          for (i = 0; i < *num_gradients; i++)
            gradient_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
        }
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return gradient_list;
}
