/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpbrushes_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpbrushes
 * @title: gimpbrushes
 * @short_description: Functions for manipulating brushes.
 *
 * Functions related to getting and setting brushes.
 **/


/**
 * gimp_brushes_refresh:
 *
 * Refresh current brushes. This function always succeeds.
 *
 * This procedure retrieves all brushes currently in the user's brush
 * path and updates the brush dialogs accordingly.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_brushes_refresh (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-brushes-refresh",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_brushes_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_brushes: The number of brushes in the brush list.
 *
 * Retrieve a complete listing of the available brushes.
 *
 * This procedure returns a complete listing of available GIMP brushes.
 * Each name returned can be used as input to the
 * gimp_context_set_brush() procedure.
 *
 * Returns: The list of brush names. The returned value must be freed
 * with g_strfreev().
 **/
gchar **
gimp_brushes_get_list (const gchar *filter,
                       gint        *num_brushes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **brush_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-brushes-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_brushes = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_brushes = return_vals[1].data.d_int32;
      if (*num_brushes > 0)
        {
          brush_list = g_new0 (gchar *, *num_brushes + 1);
          for (i = 0; i < *num_brushes; i++)
            brush_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
        }
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return brush_list;
}
