subroutine run_clean(line,comm,error)
  use clean_arrays
  use clean_default
  use gbl_message
  use mapping_interfaces, except_this=>run_clean
  !----------------------------------------------------------------------
  ! @ public
  !
  ! MAPPING   Main routine
  !   Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line  ! Command line
  character(len=*), intent(in)    :: comm  ! Command name
  logical,          intent(out)   :: error ! Logical error flag
  !
  ! Local variables
  integer, save :: icall=0
  integer :: i
  !
  if (icall.ne.0) then
     Print *,'Rentrant call to RUN_CLEAN ',comm
     read(5,*) i
  endif
  icall = icall+1
  !
  call map_message(seve%c,'CLEAN',line)
  !
  ! Analyze command
  select case (comm)
  case ('LOAD')
    call load_buffer(line,error)
  case ('READ')
    call read_image(line,error)
  case ('CLEAN')
    call dispatch_clean(line,error)
  case ('CLARK')
    call clark_clean(line,error)
  case ('FIT')
    call clean_beam(line,error)
  case ('HOGBOM')
    call hogbom_clean(line,error)
  case ('WRITE')
    call write_image(line,error)
  case ('SUPPORT')
    call com_support(line,error)
  case ('MOSAIC')
    call mode_mosaic(line,error)
  case ('MRC')
    call mrc_clean(line,error)
  case ('MULTI')
    call multi_clean(line,error)
  case ('SHOW')
    call display_buffer('SHOW',line,error)
  case ('VIEW')
    call display_buffer('VIEW',line,error)
  case ('SDI')
    call sdi_clean(line,error)
  case ('UV_MAP')
    if (themap%nfields.ne.0) then
      call map_message(seve%i,'UV_MOSAIC','UV data is a Mosaic')
      call uv_shift_mosaic(line,error)
      call mosaic_uvmap('UV_MOSAIC',line,error)
    else if (map_version.ne.0) then
      ! Old or intermediate version
      call uvmap('OLDUV_MAP',line,error)
    else
      ! New version
      call sg_map('UV_MAP',line,error)
    endif
  case ('MX')
    if (themap%nfields.ne.0) then
      call map_message(seve%e,comm,'UV data is a Mosaic, not supported')
      error = .true.
    else
      call uvmap('MX',line,error)
    endif
  case ('STATISTIC')
    call statistic(line,error)
  case ('ALMA')
    call alma_clean(line,error)
  case ('UV_SORT')
    call uv_sort_comm(line,error)
  case ('UV_STAT')
    call uv_stat_comm(line,error)
  case ('UV_FLAG')
    call uv_flag_comm(line,error)
  case ('UV_RESAMPLE','UV_COMPRESS')
    call uv_resample_comm(line,comm,error)
  case ('UV_RESTORE')
    if (themap%nfields.ne.0) then
      call map_message(seve%w,comm,'UV data is a Mosaic, under test...')
      call mosaic_restore(line,error)
    else if (map_version.ne.0) then
      call uv_restore(line,error)
    else
      call sg_map('UV_RESTORE',line,error)
    endif
  case ('UV_RMS')
    call uv_rms_comm(line,error)
  case ('UV_SHIFT')
    call uv_shift_mosaic(line,error)
  case ('UV_STACK')
    call uv_stack_comm(line,error)
  case ('DUMP')
    call debug_all(line,error)
  case ('UV_CONTINUUM')
    call uv_line2cont(line,error)
  case ('UV_FILTER')
    call uv_filter_main(line,error)
  case ('UV_BASELINE')
     call uv_baseline_main(line,error)
  case ('UV_EXTRACT')
     call uv_extract_main(line,error)
  case ('UV_TIME')
    if (themap%nfields.ne.0) call map_message(seve%w,comm,'UV data is a Mosaic')
    call uv_time_comm(line,error)
  case ('UV_TRUNCATE')
    call uv_truncate_comm(line,error)
  case ('UV_REWEIGHT')
    call uv_reweight_comm(line,error)
  case ('UV_CHECK')
    call uv_check_comm(line,error)
  case ('PRIMARY')
    call primary_comm(line,error)
  case ('SPECIFY')
    call com_modify(line,error)
  case ('MFS')
    call clean_mfs(line,error)
  case ('FLUX_SCALE')
    call flux_dispatch(line,error)
!  case ('SG_DEBUG')
!    call sg_debug(line,error)
  case ('UV_RESIDUAL')
    if (themap%nfields.ne.0) then
      call map_message(seve%w,comm,'UV data is a Mosaic - UNDER TESTS !!!')
    endif
    call uv_residual(line,error)
  case ('MAP_RESAMPLE','MAP_COMPRESS','MAP_INTEGRATE') 
    call map_resample_comm(line,comm,error)
  case ('STOKES')
    call do_stokes(line,comm,error)
  case default
    call map_message(seve%i,'CLEAN',comm//' not yet implemented')
  end select
  icall = icall-1
  !
end subroutine run_clean
!
subroutine init_clean
  use gkernel_interfaces
  use mapping_interfaces, except_this=>init_clean
  !----------------------------------------------------------------------
  ! @ public
  !
  ! MAPPING
  !   Initialize Mapping Languages
  !----------------------------------------------------------------------
  use clean_def
  use clean_arrays
  use clean_default
  !
  logical, save :: MappingError
  !
  ! vocabulaire de CLEAN
  integer mclean
  parameter (mclean=106+1)  ! MFS 
  character(len=16) vocab(mclean)
  character(len=40) version
  ! /QUERY is obsolete, its taken out of the help, during repackaging it must be taken out of the code.
  data vocab /' DUMP',   &
       ' ALMA', '/FLUX', '/PLOT', '/QUERY', '/NOISE', '/METHOD', &
       ' CLEAN', '/FLUX', '/PLOT', '/QUERY', '/NITER', '/ARES', &  !No conflict with ALMA ?
       ' CLARK', '/FLUX', '/PLOT', '/QUERY', &
       ' FIT', ' FLUX_SCALE', &
       ' HOGBOM', '/FLUX', &
       ' LOAD', &
       ' MAP_COMPRESS', ' MAP_RESAMPLE', ' MAP_INTEGRATE', &
       ' MOSAIC', &
       ' MRC', '/FLUX', '/PLOT', '/QUERY', &
       ' MFS', &
       ' MULTI', '/FLUX', &
       ' MX', '/FLUX', '/PLOT', '/QUERY', &
       ' PRIMARY', '/TRUNCATE', &
       ' READ', '/COMPACT', '/FREQUENCY', '/PLANE', '/RANGE',  '/NOTRAIL', '/TELESCOPE', &
       ' SHOW', &
       ' SDI', '/FLUX', '/PLOT', '/QUERY', &
       ' SPECIFY', &
       ' STATISTIC', '/WHOLE', &
       ' STOKES', &
       ' SUPPORT', '/CURSOR', '/MASK', '/PLOT', '/RESET', '/THRESHOLD', '/VARIABLE', &
       ' UV_BASELINE', '/CHANNELS', '/FREQUENCY', '/RANGE', '/WIDTH', &
       ' UV_CHECK', ' UV_COMPRESS', ' UV_CONTINUUM','/INDEX', &
       ' UV_EXTRACT', '/RANGE', '/FREQUENCY', '/WIDTH', &
       ' UV_FLAG', '/ANTENNA', '/RESET', &
       ' UV_FILTER', '/CHANNELS', '/FREQUENCY', '/RANGE', '/WIDTH', '/ZERO', &
       ' UV_MAP', '/TRUNCATE',  '/FIELDS', &
       ' UV_RESAMPLE',  ' UV_RESIDUAL', ' UV_RESTORE', '/COPY', '/SLOW', ' UV_REWEIGHT', &
       ' UV_RMS', ' UV_SHIFT', ' UV_SORT',' UV_STACK',  ' UV_STAT',  ' UV_TIME', '/WEIGHT', ' UV_TRUNCATE', &
       ' VIEW',     &
       ' WRITE', '/APPEND ', '/RANGE', '/REPLACE', '/TRIM'/
  logical error
  integer :: iout
  version = '3.3-05 03-Jul-2017 S.Guilloteau, J.Pety'
  !
  call sic_begin('CLEAN','GAG_HELP_CLEAN',mclean,vocab, version, run_clean, gr_error)
  !
  call sic_defstructure('OMP_MAP',.true.,error)
  omp_compiled = .false.
  !$ omp_compiled = .true.
  call sic_def_logi('OMP_MAP%COMPILED',omp_compiled,.false.,error)
  call sic_def_logi('OMP_MAP%DEBUG',omp_debug,.false.,error)
  call sic_def_logi('OMP_MAP%UV_MAP',omp_uvmap,.false.,error)
  call sic_def_inte('OMP_MAP%GRID',omp_grid,0,0,.false.,error)
  call sic_def_logi('OMP_MAP%RESTORE_FAST',omp_restore_fast,.false.,error)
  call sic_def_logi('OMP_MAP%UV_MAP_LOCK',omp_uvmap_lock,.false.,error)
  call sic_def_inte('OMP_MAP%SINGLE_BEAM_CODE',omp_single_beam,0,0,.false.,error)
  call sic_def_inte('CLEAN_CONVERGE',clean_converge,0,0,.false.,error)
  !
  user_method%do_mask = .true.  ! Unclear why ...
  call sic_def_logi('METHOD_DOMASK',user_method%do_mask,.false.,error) ! To check
  nullify(duvr)
  nullify(duvs)
  call define_var(error)
  MappingError = .false.
  call sic_def_logi('MAPPING_ERROR',MappingError,.false.,error)
  !
  call sic_def_inte('MAP_VERSION',map_version,0,0,.false.,error)
  call sic_def_real('MAP_ROUNDING',map_rounding,0,0,.false.,error)
  call sic_def_inte('MAP_POWER   ',map_power,0,0,.false.,error)
  call gi4_round_forfft(64,iout,error,map_rounding,map_power)
end subroutine init_clean
!
subroutine save_result(error)
  use gkernel_interfaces
  use gildas_def
  use clean_types
  use gbl_message
  logical error
  character(len=filename_length) :: ans
  character(len=filename_length) :: autosave='autosave'  ! Default name when saving
  character(len=commandline_length) line
  character(len=message_length) :: chain
  character(len=*), parameter :: rname = 'MAPPING'
  integer :: n, icode
  logical :: do_write,noprompt
  !
  ans = ' '
  error = .false.
  do_write = .false.
  call gmaster_get_exitnoprompt(noprompt)  ! Check for SIC\EXIT /NOPROMPT
  !
  if (any(save_data) .and. .not.noprompt) then
    call map_message(seve%w,rname,'There are unsaved data, should we save them?')
    do while (.true.)
      call sic_wprn('Y)es, N)o, C)ancel exit (default No): ',ans,n)
      call sic_upper(ans)
      if (ans(1:1).eq.'C') then
        error = .true.
        return
      elseif (ans(1:1).eq.'N' .or. ans(1:1).eq.' ') then
        do_write = .false.
      elseif (ans(1:1).ne.'Y') then
        call map_message(seve%e,rname,'Unrecognized answer '//ans)
        cycle
      else 
        do_write = .true.
      endif
      exit
    enddo
  endif
  !
  call sic_delvariable('DIRTY',.false.,error)
  call sic_delvariable('CLEAN',.false.,error)
  call sic_delvariable('RESIDUAL',.false.,error)
  call sic_delvariable('PRIMARY',.false.,error)
  call sic_delvariable('SKY',.false.,error)
  if (.not.do_write) return
  !
  do icode=1,mtype
    ans = ' '
    error = .false.
    do while (save_data(icode))
       write(chain,100) vtype(icode)
       call sic_wprn(trim(chain)//' ',ans,n)
       if (ans.eq.' ') ans = autosave
       line = 'CLEAN'//char(92)//'WRITE '//vtype(icode)//' "'//trim(ans)//'"'
       call exec_command (line,error)
    enddo
  enddo
  !
100 format('Enter a filename for ',a,' (default ''autosave''): ')
end subroutine save_result
!
subroutine debug_all(line,error)
  use gkernel_interfaces
  use mapping_interfaces, except_this => debug_all
  use clean_def
  use clean_arrays
  use clean_types
  use clean_default
  use gbl_message
  !----------------------------------------------------------------------
  ! @  private
  !
  ! MAPPING     Print debug information
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line
  logical, intent(out) :: error
  !
  character(len=4) meth
  integer :: n, nc, ier
  integer, allocatable :: mic(:)
  !
  call sic_ke(line,0,1,meth,n,.false.,error)
  if (error) return
  if (meth.eq.'USER') then
     call mapping_print_debug(user_method)
  else if (meth.eq.'METH') then
     call mapping_print_debug(method)
  else if (meth.eq.'BUFF') then
    call uv_dump_buffers('DUMP')
  else if (meth.eq.'SG') then
    !
    nc = huv%gil%nchan
    if (nc.ne.hcct%gil%dim(2)) then
      Print *,'Mismatch number of channels between HUV ',nc,' and CCT ',hcct%gil%dim(2)
    endif
    !
    allocate(mic(nc),stat=ier)
    call uv_clean_sizes(hcct,dcct,mic,1,nc)
    Print *,'SG_DEBUG -- MIC ',mic
    deallocate(mic)
  else
    Print *,' DEBUG  BUFFers|METHod|SG|USER'
  endif
end subroutine debug_all
!
subroutine mode_mosaic (line,error)
  use gkernel_interfaces
  use mapping_interfaces, only : sub_mosaic
  !----------------------------------------------------------------------
  ! @  private
  !
  ! MAPPING     MOSAIC ON|OFF
  !             Activates or desactivates the mosaic mode
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line
  logical, intent(out) :: error
  !
  integer na,iv
  character(len=8) name,argum,voc1(2)
  data voc1/'OFF','ON'/
  !
  ! Mosaic mode. Default = .true.
  argum = 'ON'
  call sic_ke (line,0,1,argum,na,.false.,error)
  if (error) return
  call sic_ambigs ('MOSAIC',argum,name,iv,voc1,2,error)
  if (error) return
  call sub_mosaic(name,error)
end subroutine mode_mosaic
