!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_histogram
  use cube_types
  use cubetools_parameters
  use cubemain_messaging
  use cubemain_image_real
  use cubetools_parse
  !
  public :: histo_axis_user_t,histo2d_t
  public :: cubemain_histogram_axis_register_option
  public :: cubemain_histogram_axis_parse
  public :: cubemain_histogram_axis_user2prog
  public :: cubemain_histogram_axis_feedback
  private
  !
  integer(kind=4), parameter :: code_kind_default = 1
  integer(kind=4), parameter :: nkinds = 3
  character(len=argu_l), parameter :: kinds(nkinds)=&
       ['*          ',&
        'LINEAR     ',&
        'LOGARITHMIC']
  !
  integer(kind=code_k), parameter :: code_method_default = 3
  integer(kind=4), parameter :: nmethods = 4
  character(len=argu_l), parameter :: methods(nmethods)=&
       ['*      ',&
        'SQRT   ',&
        'STURGES',&
        'RICE   ']
  !
  type histo_axis_user_t
     logical :: present = .false.
     character(len=argu_l) :: kind = strg_star
     character(len=argu_l) :: nbin = strg_star
     character(len=argu_l) :: range(2) = [strg_star,strg_star]
  end type histo_axis_user_t
  !
  type histo_axis_prog_t
     logical :: dolog = .false.
     character(len=argu_l) :: method
     integer(kind=data_k) :: n
     real(kind=coor_k) :: min
     real(kind=coor_k) :: max
     real(kind=coor_k) :: inc
  end type histo_axis_prog_t
  !
  type histo2d_t
     logical :: donorm  = .true. ! Normalize histogram?
     logical :: doblank = .true. ! Blank empty bins?
     type(histo_axis_prog_t) :: x
     type(histo_axis_prog_t) :: y
     type(cube_t), pointer :: cub
  end type histo2d_t
  !
contains
  !
  subroutine cubemain_histogram_axis_register_option(name,option,nbin_arg,error)
    use cubetools_structure
    use cubetools_keyword_arg
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*),             intent(in)    :: name
    type(option_t),      pointer, intent(out)   :: option
    type(keyword_arg_t), pointer, intent(out)   :: nbin_arg
    logical,                      intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    type(keyword_arg_t)  :: keyarg
    character(len=*), parameter :: rname='HISTOGRAM>AXIS>REGISTER>OPTION'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         trim(name)//'AXIS','[lin [nbin min max] | log [nbin max dyn]]',&
         'Define a regular sampling of the '//trim(name)//' axis',&
         strg_id,&
         option,error)
    call stdarg%register(&
         trim(name)//'KIND',&
         'Linearly or logarithmically axis',&
         strg_id,&
         code_arg_optional,&
         error)
    call keyarg%register(&
         trim(name)//'NBIN',&
         'Number of bins or method to determine it',&
         strg_id,&
         code_arg_optional,&
         methods, &
         flexible, &
         nbin_arg, &
         error)
    call stdarg%register(&
         trim(name)//'RANGE1',&
         'Minimum or maximum for a linear or logarithmic axis, respectively',&
         strg_id,&
         code_arg_optional,&
         error)
    call stdarg%register(&
         trim(name)//'RANGE2',&
         'Maximum or dynamical range for a linear or logarithmic axis, respectively',&
         strg_id,&
         code_arg_optional,&
         error)
  end subroutine cubemain_histogram_axis_register_option
  !
  subroutine cubemain_histogram_axis_parse(line,opt,uaxis,error)
    use cubetools_structure
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*),        intent(in)    :: line
    type(option_t),          intent(in)    :: opt
    type(histo_axis_user_t), intent(inout) :: uaxis ! user axis
    logical,                 intent(inout) :: error    
    !
    character(len=*), parameter :: rname='HISTOGRAM>AXIS>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call opt%present(line,uaxis%present,error)
    if (error) return
    if (uaxis%present) then
       call cubetools_getarg(line,opt,1,uaxis%kind,mandatory,error)
       if (error) return
       call cubetools_getarg(line,opt,2,uaxis%nbin,mandatory,error)
       if (error) return
       call cubetools_getarg(line,opt,3,uaxis%range(1),mandatory,error)
       if (error) return
       call cubetools_getarg(line,opt,4,uaxis%range(2),mandatory,error)
       if (error) return
    endif
  end subroutine cubemain_histogram_axis_parse
  !
  subroutine cubemain_histogram_axis_user2prog(cube,nbin_arg,user,prog,error)
    use cubetools_arrelt_types
    use cubetools_header_methods
    use cubetools_keyword_arg
    !----------------------------------------------------------------------
    ! The number of good data (ngood) is only an approximation to the real
    ! size of the data to be put into the histo1d as we can't know a priori
    ! how many data points will be excluded for being outside the user
    ! defined range.
    !----------------------------------------------------------------------
    type(cube_t),            intent(in)    :: cube
    type(keyword_arg_t),     intent(in)    :: nbin_arg
    type(histo_axis_user_t), intent(in)    :: user
    type(histo_axis_prog_t), intent(inout) :: prog
    logical,                 intent(inout) :: error
    !
    integer(kind=data_k) :: ngood
    type(arrelt_t) :: cubemin,cubemax
    character(len=*), parameter :: rname='HISTOGRAM>AXIS>USER2PROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_header_get_array_minmax(cube%head,cubemin,cubemax,error)
    if (error) return
    call cubemain_histogram_range2minmax(&
         real(cubemin%val,kind=coor_k),&
         real(cubemax%val,kind=coor_k),&
         user%kind,user%range,&
         prog%dolog,prog%min,prog%max,error)
    if (error) return
    call cubetools_header_get_array_ngood(cube%head,ngood,error)
    if (error) return
    call cubemain_histogram_nbin_user2prog(ngood,nbin_arg,user%nbin,&
         prog%method,prog%n,error)
    if (error) return
    prog%inc = (prog%max-prog%min)/prog%n
  end subroutine cubemain_histogram_axis_user2prog
  !
  subroutine cubemain_histogram_range2minmax(cubmin,cubmax,userkind,range,dolog,min,max,error)
    use cubetools_disambiguate
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    real(kind=coor_k), intent(in)    :: cubmin
    real(kind=coor_k), intent(in)    :: cubmax
    character(len=*),  intent(in)    :: userkind
    character(len=*),  intent(in)    :: range(2)
    logical,           intent(out)   :: dolog
    real(kind=coor_k), intent(out)   :: min
    real(kind=coor_k), intent(out)   :: max
    logical,           intent(inout) :: error
    !
    real(kind=coor_k), parameter :: margin = 0.0 ! 10% of margin
    real(kind=coor_k) :: defmin,defmax,defdyn,dyn,myrange
    integer(kind=4) :: ikey
    character(len=argu_l) :: progkind
    character(len=*), parameter :: rname='HISTOGRAM>RANGE2MINMAX'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_disambiguate_strict(userkind,kinds,ikey,progkind,error)
    if (error) return
    !
    defmin = cubmin
    defmax = cubmax
    select case(progkind)
    case('LINEAR',strg_star)
       dolog = .false.
       myrange = defmax-defmin
       defmin = defmin-margin*myrange
       defmax = defmax+margin*myrange
       call cubemain_histogram_value_user2prog(range(1),defmin,min,error)
       if (error) return
       call cubemain_histogram_value_user2prog(range(2),defmax,max,error)
       if (error) return
    case('LOGARITHMIC')
       dolog = .true.
       defmax = defmax*(1.0+margin)
       if (defmin.gt.0) then
          defdyn = defmax/defmin
       else
          defdyn = 1d6
       endif
       call cubemain_histogram_value_user2prog(range(1),defmax,max,error)
       if (error) return
       call cubemain_histogram_value_user2prog(range(2),defdyn,dyn,error)
       if (error) return
       if (max.gt.0) then
          max = log10(max)
       else
          call cubemain_message(seve%e,rname,'Maximum of a logarithmic axis must be positive')
          error = .true.
          return
       endif
       if (dyn.gt.0) then
          dyn = log10(dyn)
       else
          call cubemain_message(seve%e,rname,'Dynamic range of a logarithmic axis must be positive')
          error = .true.
          return
       endif
       min = max-dyn
    case default
       call cubemain_message(seve%e,rname,'Unknown histogram axis kind: '//trim(progkind))
       error = .true.
       return
    end select
  end subroutine cubemain_histogram_range2minmax
  !
  subroutine cubemain_histogram_value_user2prog(user,default,value,error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*),  intent(in)    :: user
    real(kind=coor_k), intent(in)    :: default
    real(kind=coor_k), intent(out)   :: value
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname='HISTOGRAM>VALUE>USER2PROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (user.eq.strg_star) then
       value = default
    else
       call sic_math_dble(user,argu_l,value,error)
       if (error) return
    endif
  end subroutine cubemain_histogram_value_user2prog
  !
  subroutine cubemain_histogram_nbin_user2prog(ndata,nbin_arg,user,method,nbin,error)
    use cubetools_keyword_arg
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=data_k),  intent(in)    :: ndata
    type(keyword_arg_t),   intent(in)    :: nbin_arg
    character(len=*),      intent(in)    :: user
    character(len=argu_l), intent(out)   :: method
    integer(kind=data_k),  intent(out)   :: nbin
    logical,               intent(inout) :: error
    !
    integer(kind=4) :: nc,ikey,nbin_i4
    character(len=*), parameter :: rname='HISTOGRAM>NBIN>USER2PROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_keyword_user2prog(nbin_arg,user,ikey,method,error)
    if (error) return
    if (method.eq.strg_unresolved) then
       method = 'USER INPUT'
    endif
    !
    select case(method)
    case('USER INPUT')
       nc = len(trim(user))
       call sic_math_inte(trim(user),nc,nbin_i4,error)
       if (error) return
       nbin = int(nbin_i4,kind=data_k)
    case('SQRT')
       nbin = ceiling(sqrt(1.0*ndata))
    case('STURGES')
       ! R default
       method = 'STURGES'
       nbin = ceiling(log(1.0*ndata))+1
    case('RICE',strg_star)
       nbin = ceiling(2*(1.0*ndata)**(1/3.))
    case default
       call cubemain_message(seve%e,rname,'Unknown method for defining nbin: '//trim(method))
       error = .true.
       return
    end select
    if (nbin.lt.1) then
       call cubemain_message(seve%e,rname,'Number of bins must be greater than 0')
       error = .true.
       return
    endif
  end subroutine cubemain_histogram_nbin_user2prog
  !
  subroutine cubemain_histogram_axis_feedback(prog,error)
    use cubetools_format
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(histo_axis_prog_t), intent(inout) :: prog
    logical,                 intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='HISTOGRAM>AXIS>FEEDBACK'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    write(mess,'(2x,a,i0,a,a,a,'//fsimple//',a,'//fsimple//',a,'//fsimple//')') &
         'Axis: ',prog%n,' bins (Method: ',trim(prog%method),&
         ') from ',prog%min,' to ',prog%max, ' by ',prog%inc
    call cubemain_message(seve%r,rname,mess)
  end subroutine cubemain_histogram_axis_feedback
end module cubemain_histogram
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
