!
! Id: rangesReceiver.inc,v 1.2.6    2017-03-23 Hans Ungerechts
!                                   revision of EMIR "rules" from EMIR astronomers wiki 
! Id: rangesReceiver.inc,v 1.2.5    2016-03-31 Hans Ungerechts
! Id: rangesReceiver.inc,v 1.2.3.4  2016-01-14 Hans Ungerechts
!        <-- patches from :
!                        v 1.1.15.5 2015-11-11 Hans Ungerechts                  
!                        v 1.1.15.5 2015-11-11 E090 E150 upgrade
! Id: rangesReceiver.inc,v 1.2.3.3  2014-08-29 Hans Ungerechts
! Id: rangesReceiver.inc,v 1.2.3    2014-04-24 Hans Ungerechts
! Id: rangesReceiver.inc,v 1.1.15.2 2013-10-10 Hans Ungerechts
!
! 2013-10-10: HU: EMIR E330 limits  
! 2013-10-09: HU: EMIR E150 upgrade 2013-09 --> defaults, limits
! 2013-08-27: HU: EMIR E150 upgrade 2013-09
!
! 2012-11-02  HU: according to email SN of 2012-10-25, EMIR wiki
!                 With the existing Gunn local oscillator the upper frequency limit of
!                 the E330 receiver is 358 GHz for the center of the UO band. This limit
!                 is even higher for the YIG oscillator so we have a spare and can be
!                 confident if we increase the limit in pako (I think it is 353 GHz
!                 right now) to this value.
! 2011-10-19  HU: EMIR upgrade 2011-11
!                 change defaults to support 2-band combos
!                 change limits for E230 and E330 according to 
!                 EMIR wiki http://www.iram.es/IRAMES/mainWiki/EmirforAstronomers (CK)
!                 (3, 4)
!                 A new local oscillator for the E330 band has been installed
!                 at the 30m on 17-Nov-2009. Band 4 has been commissioned Nov 09 - Feb
!                 2010 (Reports). Frequencies above 348GHz are not accessible. This
!                 upper frequency limit of E3 is given by the limitations of the Local
!                 Oscillator which will not be changed for the upgrade in Nov-2011.
!                 (4)
!                 In November 2011, EMIR bands E2 and E3 will be upgraded
!                 to full dual-polarisation, dual-sideband 8GHz each mixers. The
!                 frequency ranges will change, in particular the overlap region between
!                 E2 and E3. The new frequency ranges of E2 are 202-274 and 277-352 for
!                 E3. We give here the centers of the outer bands which are reachable by
!                 all backends including VESPA. The FTS at 200kHz can reach frequencies
!                 which lie 2GHz further out.  
! 2009-06     HU: set Default effBeam = effForward for HERA and EMIR 
!                 as requested by CK to match /Scale antenna
! 2008-12     HU: EMIR
!
! 2007-08-28: HU: adjusted limits for T_cold lookup 
!                 according to tables by DJ (+/- 0.5 GHz)
! 2006-02-10: HU: adjusted frequency limits for 
!                 C150, D150, C270, D270 according to SN
!
! *** ranges for receivers ***
!
vars(iDefault,  iA100  )%name                 =  rec%A100
vars(iDefault,  iA100  )%isConnected          =  .False.
vars(iDefault,  iA100  )%gunnOn               =  .False.
!
vars(iDefault,  iA100  )%nChannels            =  1
vars(iDefault,  iA100  )%bolometerName        =  GPnone
vars(iDefault,  iA100  )%gainBolometer        =  GPnoneI
vars(iDefault,  iA100  )%channel              =  1
!
vars(iDefault,  iA100  )%frequency%unit       =  fu%Ghz
vars(iDefault,  iA100  )%frequency%doppler    =  doppler%doppler
vars(iDefault,  iA100  )%frequency%value      =  115.271204D0
!                               
vars(iDefault,  iA100  )%fOffset               =  vars(iDefault,  iA100  )%frequency
vars(iDefault,  iA100  )%fOffset%value         =  GPnoneD
!                               
vars(iDefault,  iA100  )%lineName             =  "12CO(1-0)"
!
vars(iDefault,  iA100  )%sideBand             =  sb%lsb
vars(iDefault,  iA100  )%width                =  width%narrow
!
vars(iDefault,  iA100  )%effForward           =    0.95
vars(iDefault,  iA100  )%effBeam              =    0.75
vars(iDefault,  iA100  )%scale                =  scale%antenna
vars(iDefault,  iA100  )%gainImage%value      =    0.001
vars(iDefault,  iA100  )%gainImage%db         =  -30.0
vars(iDefault,  iA100  )%tempAmbient          =  270.0
vars(iDefault,  iA100  )%tempCold             =   86.0
!
vars(iDefault,  iA100  )%tempColdCode         =  GPnone
vars(iDefault,  iA100  )%tempAmbientCode      =  GPnone
!
vars(iDefault,  iA100  )%derotatorSystem      =  GPnone
vars(iDefault,  iA100  )%derotatorAngle       =  GPnoneR
!                     
vars(iDefault,  iA100  )%iPixel               =    1
!
vars(iDefault,  iA100  )%nPixels              =    1
!
vars(iDefault,  iA100  )%centerIF             =  IF%low
!                               
vars(iDefault,  iA100  )%bandWidth            =  BW%narrow
vars(iDefault,  iA100  )%disBoxInput          =    1
vars(iDefault,  iA100  )%IF2                  =  IF2%low
vars(iDefault,  iA100  )%isFlippingIF2        =  .True.
vars(iDefault,  iA100  )%polarization         =  pol%ver
vars(iDefault,  iA100  )%useSpecialLO         =  .False.
!
! ****
!
vars(iStd1:iLimit2,  iA100  )                 =   vars(iDefault,  iA100  )
!
! ****
!
coldLimits(1,   iA100  )%frequency%value      =   80.5D0
coldLimits(2,   iA100  )%frequency%value      =  115.5D0
!
vars(iStd1,     iA100  )%frequency%value      =   80.0D0
vars(iStd2,     iA100  )%frequency%value      =  115.5D0
vars(ILimit1,   iA100  )%frequency%value      =   70.0D0
vars(iLimit2,   iA100  )%frequency%value      =  118.0D0
!                               
vars(iStd1,     iA100  )%fOffset%value         =   -0.5D0
vars(iStd2,     iA100  )%fOffset%value         =    0.5D0
vars(ILimit1,   iA100  )%fOffset%value         =   -0.5D0
vars(iLimit2,   iA100  )%fOffset%value         =    0.5D0
!                               
vars(iStd1,     iA100  )%effForward           =    0.88
vars(iStd2,     iA100  )%effForward           =    0.96
vars(ILimit1,   iA100  )%effForward           =    0.5
vars(iLimit2,   iA100  )%effForward           =    1.0
!                               
vars(iStd1,     iA100  )%effBeam              =    0.40
vars(iStd2,     iA100  )%effBeam              =    0.96
vars(ILimit1,   iA100  )%effBeam              =    0.3
vars(iLimit2,   iA100  )%effBeam              =    1.0
!                               
vars(iStd1,     iA100  )%gainImage%value      =    0.001
vars(iStd2,     iA100  )%gainImage%value      =    0.1
vars(ILimit1,   iA100  )%gainImage%value      =    0.0001
vars(iLimit2,   iA100  )%gainImage%value      =    1.0
!
vars(iStd1,     iA100  )%gainImage%db         =  -30.0
vars(iStd2,     iA100  )%gainImage%db         =  -10.0
vars(ILimit1,   iA100  )%gainImage%db         =  -40.0
vars(iLimit2,   iA100  )%gainImage%db         =    0.0
!
vars(iStd1,     iA100  )%tempAmbient          =  250.0
vars(iStd2,     iA100  )%tempAmbient          =  290.0
vars(ILimit1,   iA100  )%tempAmbient          =  200.0
vars(iLimit2,   iA100  )%tempAmbient          =  320.0
!                               
vars(iStd1,     iA100  )%tempCold             =   60.0
vars(iStd2,     iA100  )%tempCold             =  100.0
vars(ILimit1,   iA100  )%tempCold             =   60.0
vars(iLimit2,   iA100  )%tempCold             =  200.0
!                     
vars(iStd1,     iA100  )%derotatorAngle       =    0.0
vars(iStd2,     iA100  )%derotatorAngle       =    0.0
vars(ILimit1,   iA100  )%derotatorAngle       =    0.0
vars(iLimit2,   iA100  )%derotatorAngle       =    0.0
!                     
!     ******************************************************
!
Vars(iDefault:iLimit2,  iB100  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iB100  )%name                 =  rec%B100
vars(iDefault,  iB100  )%isConnected          =  .False.
vars(iDefault,  iB100  )%gunnOn               =  .False.
!
vars(iDefault,  iB100  )%frequency%value      =  vars(iDefault,  iA100  )%frequency%value   
!                                                                                          
vars(iDefault,  iB100  )%lineName             =  vars(iDefault,  iA100  )%lineName          
!                                                                                          
vars(iDefault,  iB100  )%width                =  width%narrow
!
vars(iDefault,  iB100  )%effForward           =  vars(iDefault,  iA100  )%effForward        
vars(iDefault,  iB100  )%effBeam              =  vars(iDefault,  iA100  )%effBeam           
!                                                                                          
vars(iDefault,  iB100  )%gainImage%value      =    0.001
vars(iDefault,  iB100  )%gainImage%db         =  -30.0
!
vars(iDefault,  iB100  )%tempCold             =   86.0
!
vars(iDefault,  iB100  )%centerIF             =  IF%low                               
!
vars(iDefault,  iB100  )%bandWidth            =  BW%narrow
vars(iDefault,  iB100  )%disBoxInput          =    3
vars(iDefault,  iB100  )%IF2                  =  IF2%low
vars(iDefault,  iB100  )%isFlippingIF2        =  .True.
vars(iDefault,  iB100  )%polarization         =  pol%hor
vars(iDefault,  iB100  )%useSpecialLO         =  .False.
!
vars(iStd1,     iB100  )%frequency%value      =   81.0D0
vars(iStd2,     iB100  )%frequency%value      =  115.5D0
vars(ILimit1,   iB100  )%frequency%value      =   70.0D0
vars(iLimit2,   iB100  )%frequency%value      =  118.0D0
!                               
coldLimits(1:2, iB100  )                      =  coldLimits(1:2, iA100)
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iA230  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iA230  )%name                 =  rec%A230
vars(iDefault,  iA230  )%isConnected          =  .False.
vars(iDefault,  iA230  )%gunnOn               =  .False.
!
vars(iDefault,  iA230  )%frequency%value      =  230.537990D0
!      
vars(iDefault,  iA230  )%lineName             =  "12CO(2-1)"
!
vars(iDefault,  iA230  )%width                =  width%wide
!
vars(iDefault,  iA230  )%effForward           =    0.91
vars(iDefault,  iA230  )%effBeam              =    0.52
!
vars(iDefault,  iA230  )%gainImage%value      =    0.031622776601684
vars(iDefault,  iA230  )%gainImage%db         =  -15.0
!
vars(iDefault,  iA230  )%tempCold             =   86.0
!
vars(iDefault,  iA230  )%centerIF             =  IF%wide 
!                               
vars(iDefault,  iA230  )%bandWidth            =  BW%wide
vars(iDefault,  iA230  )%disBoxInput          =    2
vars(iDefault,  iA230  )%IF2                  =  IF2%wide
vars(iDefault,  iA230  )%isFlippingIF2        =  .True.
vars(iDefault,  iA230  )%polarization         =  pol%ver
vars(iDefault,  iA230  )%useSpecialLO         =  .False.
!
vars(iStd1,     iA230  )%frequency%value      =  200.0D0
vars(iStd2,     iA230  )%frequency%value      =  266.0D0
vars(ILimit1,   iA230  )%frequency%value      =  194.0D0
vars(iLimit2,   iA230  )%frequency%value      =  275.0D0
!                               
coldLimits(1,   iA230  )%frequency%value      =  203.5D0
coldLimits(2,   iA230  )%frequency%value      =  260.5D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iB230  )              =  vars(iDefault:iLimit2,  iA230  )
!
vars(iDefault,  iB230  )%name                 =  rec%B230
vars(iDefault,  iB230  )%isConnected          =  .False.
vars(iDefault,  iB230  )%gunnOn               =  .False.
!
vars(iDefault,  iB230  )%frequency%value      =  vars(iDefault,  iA230  )%frequency%value   
!                                                                                          
vars(iDefault,  iB230  )%lineName             =  vars(iDefault,  iA230  )%lineName          
!                                                                                          
vars(iDefault,  iB230  )%width                =  width%wide
!
vars(iDefault,  iB230  )%effForward           =  vars(iDefault,  iA230  )%effForward        
vars(iDefault,  iB230  )%effBeam              =  vars(iDefault,  iA230  )%effBeam           
!                                                                                          
vars(iDefault,  iB230  )%gainImage%value      =    0.031622776601684
vars(iDefault,  iB230  )%gainImage%db         =  -15.0
!
vars(iDefault,  iB230  )%tempCold             =   86.0
!
vars(iDefault,  iB230  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iB230  )%bandWidth            =  BW%wide
vars(iDefault,  iB230  )%disBoxInput          =    4
vars(iDefault,  iB230  )%IF2                  =  IF2%wide
vars(iDefault,  iB230  )%isFlippingIF2        =  .True.
vars(iDefault,  iB230  )%polarization         =  pol%hor
vars(iDefault,  iB230  )%useSpecialLO         =  .False.
!
vars(iStd1,     iB230  )%frequency%value      =  200.0D0
vars(iStd2,     iB230  )%frequency%value      =  266.0D0
vars(ILimit1,   iB230  )%frequency%value      =  195.0D0
vars(iLimit2,   iB230  )%frequency%value      =  275.0D0
!
coldLimits(1:2, iB230  )                      =  coldLimits(1:2, iA230)
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iC150  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iC150  )%name                 =  rec%C150
vars(iDefault,  iC150  )%isConnected          =  .False.
vars(iDefault,  iC150  )%gunnOn               =  .False.
!
vars(iDefault,  iC150  )%frequency%value      =  146.969049D0
!      
vars(iDefault,  iC150  )%lineName             =  "CS(3-2)"
!
vars(iDefault,  iC150  )%width                =  width%wide
!
vars(iDefault,  iC150  )%effForward           =    0.93
vars(iDefault,  iC150  )%effBeam              =    0.69
!
vars(iDefault,  iC150  )%gainImage%value      =    0.01
vars(iDefault,  iC150  )%gainImage%db         =  -20.0
!
vars(iDefault,  iC150  )%tempCold             =   86.0
!
vars(iDefault,  iC150  )%centerIF             =  IF%wide 
!                               
vars(iDefault,  iC150  )%bandWidth            =  BW%wide
vars(iDefault,  iC150  )%disBoxInput          =    1
vars(iDefault,  iC150  )%IF2                  =  IF2%wide
vars(iDefault,  iC150  )%isFlippingIF2        =  .True.
vars(iDefault,  iC150  )%polarization         =  pol%ver
vars(iDefault,  iC150  )%useSpecialLO         =  .False.
!
vars(iStd1,     iC150  )%frequency%value      =  129.5D0
vars(iStd2,     iC150  )%frequency%value      =  175.0D0
vars(ILimit1,   iC150  )%frequency%value      =  129.0D0
vars(iLimit2,   iC150  )%frequency%value      =  187.0D0
!                               
coldLimits(1,   iC150  )%frequency%value      =  129.5D0
coldLimits(2,   iC150  )%frequency%value      =  183.5D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iD150  )              =  vars(iDefault:iLimit2,  iC150  )
!
vars(iDefault,  iD150  )%name                 =  rec%D150
vars(iDefault,  iD150  )%isConnected          =  .False.
vars(iDefault,  iD150  )%gunnOn               =  .False.
!
vars(iDefault,  iD150  )%frequency%value      =  vars(iDefault,  iC150  )%frequency%value   
!                                                                                          
vars(iDefault,  iD150  )%lineName             =  vars(iDefault,  iC150  )%lineName          
!                                                                                          
vars(iDefault,  iD150  )%width                =  width%wide
!
vars(iDefault,  iD150  )%effForward           =  vars(iDefault,  iC150  )%effForward        
vars(iDefault,  iD150  )%effBeam              =  vars(iDefault,  iC150  )%effBeam           
!                                                                                          
vars(iDefault,  iD150  )%gainImage%value      =    0.1
vars(iDefault,  iD150  )%gainImage%db         =  -10.0
!
vars(iDefault,  iD150  )%tempCold             =   86.0
!
vars(iDefault,  iD150  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iD150  )%bandWidth            =  BW%wide
vars(iDefault,  iD150  )%disBoxInput          =    3
vars(iDefault,  iD150  )%IF2                  =  IF2%wide
vars(iDefault,  iD150  )%isFlippingIF2        =  .True.
vars(iDefault,  iD150  )%polarization         =  pol%hor
vars(iDefault,  iD150  )%useSpecialLO         =  .False.
!
vars(iStd1,     iD150  )%frequency%value      =  129.5D0
vars(iStd2,     iD150  )%frequency%value      =  175.0D0
vars(ILimit1,   iD150  )%frequency%value      =  129.0D0
vars(iLimit2,   iD150  )%frequency%value      =  187.0D0
!
coldLimits(1:2, iD150  )                      =  coldLimits(1:2, iC150)
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iC270  )              =  vars(iDefault:iLimit2,  iC150  )
!
vars(iDefault,  iC270  )%name                 =  rec%C270
vars(iDefault,  iC270  )%isConnected          =  .False.
vars(iDefault,  iC270  )%gunnOn               =  .False.
!
vars(iDefault,  iC270  )%frequency%value      =  265.886432D0
!                                                                                          
vars(iDefault,  iC270  )%lineName             =  "HCN(3-2)"
!                                                                                          
vars(iDefault,  iC270  )%width                =  width%wide
!
vars(iDefault,  iC270  )%effForward           =    0.88
vars(iDefault,  iC270  )%effBeam              =    0.46
!                                                                                          
vars(iDefault,  iC270  )%gainImage%value      =    0.1
vars(iDefault,  iC270  )%gainImage%db         =  -10.0
!
vars(iDefault,  iC270  )%tempCold             =   86.0
!
vars(iDefault,  iC270  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iC270  )%bandWidth            =  BW%wide
vars(iDefault,  iC270  )%disBoxInput          =    2
vars(iDefault,  iC270  )%IF2                  =  IF2%wide
vars(iDefault,  iC270  )%isFlippingIF2        =  .True.
vars(iDefault,  iC270  )%polarization         =  pol%ver
vars(iDefault,  iC270  )%useSpecialLO         =  .False.
!
vars(iStd1,     iC270  )%frequency%value      =  241.0D0
vars(iStd2,     iC270  )%frequency%value      =  281.0D0
vars(ILimit1,   iC270  )%frequency%value      =  240.0D0
vars(iLimit2,   iC270  )%frequency%value      =  285.0D0
!
coldLimits(1,   iC270  )%frequency%value      =  239.5D0
coldLimits(2,   iC270  )%frequency%value      =  280.5D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iD270  )              =  vars(iDefault:iLimit2,  iC270  )
!
vars(iDefault,  iD270  )%name                 =  rec%D270
vars(iDefault,  iD270  )%isConnected          =  .False.
vars(iDefault,  iD270  )%gunnOn               =  .False.
!
vars(iDefault,  iD270  )%frequency%value      =  vars(iDefault,  iC270  )%frequency%value   
!                                                                                          
vars(iDefault,  iD270  )%lineName             =  vars(iDefault,  iC270  )%lineName          
!                                                                                          
vars(iDefault,  iD270  )%width                =  width%wide
!
vars(iDefault,  iD270  )%effForward           =  vars(iDefault,  iC270  )%effForward        
vars(iDefault,  iD270  )%effBeam              =  vars(iDefault,  iC270  )%effBeam           
!                                                                                          
vars(iDefault,  iD270  )%gainImage%value      =    0.1
vars(iDefault,  iD270  )%gainImage%db         =  -10.0
!
vars(iDefault,  iD270  )%tempCold             =   86.0
!
vars(iDefault,  iD270  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iD270  )%bandWidth            =  BW%wide
vars(iDefault,  iD270  )%disBoxInput          =    4
vars(iDefault,  iD270  )%IF2                  =  IF2%wide
vars(iDefault,  iD270  )%isFlippingIF2        =  .True.
vars(iDefault,  iD270  )%polarization         =  pol%hor
vars(iDefault,  iD270  )%useSpecialLO         =  .False.
!
vars(iStd1,     iD270  )%frequency%value      =  241.0D0
vars(iStd2,     iD270  )%frequency%value      =  281.0D0
vars(ILimit1,   iD270  )%frequency%value      =  240.0D0
vars(iLimit2,   iD270  )%frequency%value      =  285.0D0
!
coldLimits(1:2, iD270  )                      =  coldLimits(1:2, iC270)
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iHERA  )              =  vars(iDefault:iLimit2,  iA230  )
!
vars(iDefault,  iHERA  )%name                 =  rec%HERA
vars(iDefault,  iHERA  )%isConnected          =  .False.
vars(iDefault,  iHERA  )%gunnOn               =  .False.
!
vars(iDefault,  iHERA  )%frequency%value      =  vars(iDefault,  iA230  )%frequency%value   
!                                                                                          
vars(iDefault,  iHERA  )%lineName             =  vars(iDefault,  iA230  )%lineName          
!                                                                                          
vars(iDefault,  iHERA  )%width                =  width%wide
!
vars(iDefault,  iHERA  )%effForward           =  vars(iDefault,  iA230  )%effForward        
vars(iDefault,  iHERA  )%effBeam              =  vars(iDefault,  iA230  )%effBeam           
vars(iDefault,  iHERA  )%effBeam              =  vars(iDefault,  iHERA  )%effForward           
!                                                                                          
vars(iDefault,  iHERA  )%gainImage%value      =    0.1
vars(iDefault,  iHERA  )%gainImage%db         =  -10.0
!
vars(iDefault,  iHERA  )%tempCold             =   86.0
vars(iStd1,     iHERA  )%tempCold             =   60.0
vars(iStd2,     iHERA  )%tempCold             =  140.0
vars(ILimit1,   iHERA  )%tempCold             =   60.0
vars(iLimit2,   iHERA  )%tempCold             =  200.0
!                     
!
vars(iDefault,  iHERA  )%derotatorSystem      =  derot%fra
vars(iDefault,  iHERA  )%derotatorAngle       =    0.0
!                     
vars(iDefault,  iHERA  )%iPixel               =    1
!
vars(iDefault,  iHERA  )%nPixels              =   18
!
vars(iDefault,  iHERA  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iHERA  )%bandWidth            =  BW%wide
vars(iDefault,  iHERA  )%disBoxInput          =  GPnoneI
vars(iDefault,  iHERA  )%IF2                  =  IF2%wide
vars(iDefault,  iHERA  )%isFlippingIF2        =  .True.
vars(iDefault,  iHERA  )%polarization         =  GPnone
vars(iDefault,  iHERA  )%useSpecialLO         =  .False.
!
vars(iStd1,     iHERA  )%frequency%value      =  215.0D0
vars(iStd2,     iHERA  )%frequency%value      =  245.0D0
vars(ILimit1,   iHERA  )%frequency%value      =  215.0D0
vars(iLimit2,   iHERA  )%frequency%value      =  245.0D0
!
coldLimits(1,   iHERA  )%frequency%value      =  vars(iLimit1,   iHERA  )%frequency%value
coldLimits(2,   iHERA  )%frequency%value      =  vars(iLimit2,   iHERA  )%frequency%value
!
vars(iStd1,     iHERA  )%derotatorAngle       = -135.0
vars(iStd2,     iHERA  )%derotatorAngle       =  135.0
vars(ILimit1,   iHERA  )%derotatorAngle       = -720.0     !  values from old CS
vars(iLimit2,   iHERA  )%derotatorAngle       =  720.0
!                     
vars(iStd1,     iHERA  )%iPixel               =    1
vars(iStd2,     iHERA  )%iPixel               =  vars(iDefault,iHERA)%nPixels
vars(ILimit1,   iHERA  )%iPixel               =    1
vars(iLimit2,   iHERA  )%iPixel               =  vars(iDefault,iHERA)%nPixels
!
                     derotatorLimitFrame (1)  =  -83.0     !  special limits for "frame"
                     derotatorLimitFrame (2)  =   83.0     !  values from old CS
!                     
!     ******************************************************
!
vars(iDefault:iLimit2,  iHERA1 )              =  vars(iDefault:iLimit2,  iHERA  )
!
vars(iDefault,  iHERA1 )%name                 =  rec%HERA1
vars(iDefault,  iHERA1 )%isConnected          =  .False.
vars(iDefault,  iHERA1 )%gunnOn               =  .False.
!
vars(iDefault,  iHERA1 )%frequency%value      =  vars(iDefault,  iHERA  )%frequency%value   
!                                                                                          
vars(iDefault,  iHERA1 )%lineName             =  vars(iDefault,  iHERA  )%lineName          
!                                                                                          
vars(iDefault,  iHERA1 )%width                =  width%wide
!
vars(iDefault,  iHERA1 )%effForward           =  vars(iDefault,  iHERA  )%effForward        
vars(iDefault,  iHERA1 )%effBeam              =  vars(iDefault,  iHERA  )%effBeam           
!                                                                                          
vars(iDefault,  iHERA1 )%gainImage%value      =  vars(iDefault,  iHERA  )%gainImage%value   
vars(iDefault,  iHERA1 )%gainImage%db         =  vars(iDefault,  iHERA  )%gainImage%db      
!
vars(iDefault,  iHERA1 )%tempCold             =   86.0
!
vars(iDefault,  iHERA1 )%iPixel               =    1
!
vars(iDefault,  iHERA1 )%nPixels              =    9
!
vars(iDefault,  iHERA1 )%centerIF             =  IF%wide                               
!
vars(iDefault,  iHERA1 )%bandWidth            =  BW%wide
vars(iDefault,  iHERA1 )%disBoxInput          =    1    
vars(iDefault,  iHERA1 )%IF2                  =  IF2%wide
vars(iDefault,  iHERA1 )%isFlippingIF2        =  .True.
vars(iDefault,  iHERA1 )%polarization         =  pol%ver
vars(iDefault,  iHERA1 )%useSpecialLO         =  .False.
!
vars(iStd1,     iHERA1 )%frequency%value      =  215.0D0
vars(iStd2,     iHERA1 )%frequency%value      =  268.0D0
vars(ILimit1,   iHERA1 )%frequency%value      =  215.0D0
vars(iLimit2,   iHERA1 )%frequency%value      =  268.000
!
coldLimits(1,   iHERA1 )%frequency%value      =  vars(iLimit1,   iHERA1 )%frequency%value
coldLimits(2,   iHERA1 )%frequency%value      =  vars(iLimit2,   iHERA1 )%frequency%value
!
vars(iStd1,     iHERA1 )%iPixel               =    1
vars(iStd2,     iHERA1 )%iPixel               =  vars(iDefault,iHERA1)%nPixels
vars(ILimit1,   iHERA1 )%iPixel               =    1
vars(iLimit2,   iHERA1 )%iPixel               =  vars(iDefault,iHERA1)%nPixels
!
!     ******************************************************
!
vars(iDefault:iLimit2,  iHERA2 )              =  vars(iDefault:iLimit2,  iHERA  )
!
vars(iDefault,  iHERA2 )%name                 =  rec%HERA2
vars(iDefault,  iHERA2 )%isConnected          =  .False.
vars(iDefault,  iHERA2 )%gunnOn               =  .False.
!
vars(iDefault,  iHERA2 )%frequency%value      =  vars(iDefault,  iHERA  )%frequency%value   
!                                                                                          
vars(iDefault,  iHERA2 )%lineName             =  vars(iDefault,  iHERA  )%lineName          
!                                                                                          
vars(iDefault,  iHERA2 )%width                =  width%wide
!
vars(iDefault,  iHERA2 )%effForward           =  vars(iDefault,  iHERA  )%effForward        
vars(iDefault,  iHERA2 )%effBeam              =  vars(iDefault,  iHERA  )%effBeam           
!                                                                                          
vars(iDefault,  iHERA2 )%gainImage%value      =  vars(iDefault,  iHERA  )%gainImage%value   
vars(iDefault,  iHERA2 )%gainImage%db         =  vars(iDefault,  iHERA  )%gainImage%db      
!
vars(iDefault,  iHERA2 )%tempCold             =   86.0
!
vars(iDefault,  iHERA2 )%iPixel               =    1
!
vars(iDefault,  iHERA2 )%nPixels              =    9
!
vars(iDefault,  iHERA2 )%centerIF             =  IF%wide                               
!
vars(iDefault,  iHERA2 )%bandWidth            =  BW%wide
vars(iDefault,  iHERA2 )%disBoxInput          =    2
vars(iDefault,  iHERA2 )%IF2                  =  IF2%wide
vars(iDefault,  iHERA2 )%isFlippingIF2        =  .True.
vars(iDefault,  iHERA2 )%polarization         =  pol%hor
vars(iDefault,  iHERA2 )%useSpecialLO         =  .False.
!
vars(iStd1,     iHERA2 )%frequency%value      =  210.0D0
vars(iStd2,     iHERA2 )%frequency%value      =  245.0D0
vars(ILimit1,   iHERA2 )%frequency%value      =  210.0D0
vars(iLimit2,   iHERA2 )%frequency%value      =  245.000
!
coldLimits(1,   iHERA2 )%frequency%value      =  vars(iLimit1,   iHERA2 )%frequency%value
coldLimits(2,   iHERA2 )%frequency%value      =  vars(iLimit2,   iHERA2 )%frequency%value
!
vars(iStd1,     iHERA2 )%iPixel               =    1
vars(iStd2,     iHERA2 )%iPixel               =  vars(iDefault,iHERA2)%nPixels
vars(ILimit1,   iHERA2 )%iPixel               =    1
vars(iLimit2,   iHERA2 )%iPixel               =  vars(iDefault,iHERA2)%nPixels
!
!     ******************************************************
!
vars(iDefault:iLimit2,  iRxTest  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iRxTest  )%name                 =  "HOLOGRAPHY"
vars(iDefault,  iRxTest  )%isConnected          =  .False.
vars(iDefault,  iRxTest  )%gunnOn               =  .False.
!
vars(iDefault,  iRxTest  )%frequency%value      =  39.402d0
vars(iDefault,  iRxTest  )%frequency%doppler    =  doppler%fixed
!                                                                                          
vars(iDefault,  iRxTest  )%lineName             =  "2013-03-8A"
!                                                                                          
vars(iDefault,  iRxTest  )%sideBand             =  sb%usb
vars(iDefault,  iRxTest  )%width                =  GPnone
!
vars(iDefault,  iRxTest  )%effForward           =  0.95
vars(iDefault,  iRxTest  )%effBeam              =  vars(iDefault,  iRxTest  )%effForward           
!                                                                                          
vars(iDefault,  iRxTest  )%gainImage%value      =    1.0
vars(iDefault,  iRxTest  )%gainImage%db         =    0.0
!
vars(iDefault,  iRxTest  )%tempCold             =  100.0
vars(iStd1,     iRxTest  )%tempCold             =  100.0
vars(iStd2,     iRxTest  )%tempCold             =  100.0
vars(ILimit1,   iRxTest  )%tempCold             =  100.0
vars(iLimit2,   iRxTest  )%tempCold             =  100.0
!                     
!
vars(iDefault,  iRxTest  )%derotatorSystem      =  derot%fra
vars(iDefault,  iRxTest  )%derotatorAngle       =    0.0
!                     
vars(iDefault,  iRxTest  )%iPixel               =    1
!
vars(iDefault,  iRxTest  )%nPixels              =    1
!
vars(iDefault,  iRxTest  )%centerIF             =  0.150       !!   150 MHz
!
vars(iDefault,  iRxTest  )%bandWidth            =  0.004       !!     4 MHz
vars(iDefault,  iRxTest  )%disBoxInput          =  GPnoneI
vars(iDefault,  iRxTest  )%IF2                  =  0.000005    !!     5 kHz
vars(iDefault,  iRxTest  )%isFlippingIF2        =  .False.
vars(iDefault,  iRxTest  )%polarization         =  GPnone
vars(iDefault,  iRxTest  )%useSpecialLO         =  .False.
!
vars(iStd1,     iRxTest  )%frequency%value      =   10.0D0
vars(iStd2,     iRxTest  )%frequency%value      =  400.0D0
vars(ILimit1,   iRxTest  )%frequency%value      =   10.0D0
vars(iLimit2,   iRxTest  )%frequency%value      = 1000.0D0
!
coldLimits(1,   iRxTest  )%frequency%value      =  vars(iLimit1,   iRxTest  )%frequency%value
coldLimits(2,   iRxTest  )%frequency%value      =  vars(iLimit2,   iRxTest  )%frequency%value
!
vars(iStd1,     iRxTest  )%iPixel               =    1
vars(iStd2,     iRxTest  )%iPixel               =  vars(iDefault,iRxTest)%nPixels
vars(ILimit1,   iRxTest  )%iPixel               =    1
vars(iLimit2,   iRxTest  )%iPixel               =  vars(iDefault,iRxTest)%nPixels
!
!     ******************************************************
!
vars(iDefault:iLimit2,  iBOLO  )              =  vars(iDefault:iLimit2,  iA230  )
!
vars(iDefault,  iBOLO  )%name                 =  rec%BOLO
vars(iDefault,  iBOLO  )%isConnected          =  .False.
vars(iDefault,  iBOLO  )%gunnOn               =  .False.
!
vars(iDefault,  iBOLO  )%nChannels            =   9999
vars(iDefault,  iBOLO  )%bolometerName        =  bolo%nika
vars(iDefault,  iBOLO  )%gainBolometer        =   1
vars(iDefault,  iBOLO  )%channel              =   1
!
vars(iDefault,  iBOLO  )%frequency%value      =  250.0D0
vars(iDefault,  iBOLO  )%frequency%doppler    =  GPnone
!
vars(iDefault,  iBOLO  )%lineName             =  GPnone
!
vars(iDefault,  iBOLO  )%sideBand             =  GPnone
vars(iDefault,  iBOLO  )%width                =  GPnone
!
vars(iDefault,  iBOLO  )%scale                =  GPnone
!
vars(iDefault,  iBOLO  )%effForward           =  GPnoneR
vars(iDefault,  iBOLO  )%effBeam              =  GPnoneR
!                                                                                          
vars(iDefault,  iBOLO  )%gainImage%value      =  GPnoneR
vars(iDefault,  iBOLO  )%gainImage%db         =  GPnoneR
!
vars(iDefault,  iBOLO  )%tempAmbient          =  GPnoneR
vars(iDefault,  iBOLO  )%tempCold             =  GPnoneR
!
vars(iDefault,  iBOLO  )%iPixel               =    1
!
vars(iDefault,  iBOLO  )%nPixels              =  vars(iDefault,  iBOLO  )%nChannels 
!
vars(iDefault,  iBOLO  )%centerIF             =  GPnoneD
!
vars(iDefault,  iBOLO  )%bandWidth            =  GPnoneD
vars(iDefault,  iBOLO  )%disBoxInput          =  GPnoneI
vars(iDefault,  iBOLO  )%IF2                  =  GPnoneD
vars(iDefault,  iBOLO  )%isFlippingIF2        =  GPnoneL
vars(iDefault,  iBOLO  )%polarization         =  GPnone
vars(iDefault,  iBOLO  )%useSpecialLO         =  GPnoneL
!
vars(iStd1,     iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
vars(iStd2,     iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
vars(ILimit1,   iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
vars(iLimit2,   iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
!
vars(iStd1,     iBOLO  )%iPixel               =    1
vars(iStd2,     iBOLO  )%iPixel               =  vars(iDefault,iBOLO)%nPixels
vars(ILimit1,   iBOLO  )%iPixel               =    1
vars(iLimit2,   iBOLO  )%iPixel               =  vars(iDefault,iBOLO)%nPixels
!
! ********************************************
!
gainBolometerChoices(1) =   1.0
gainBolometerChoices(2) =   2.0
gainBolometerChoices(3) =   5.0
gainBolometerChoices(4) =  10.0
gainBolometerChoices(5) =  20.0
gainBolometerChoices(6) =  50.0
gainBolometerChoices(7) = 100.0
!
iCombos(:,1)  =  (/ 1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0 /)
iCombos(:,2)  =  (/ 0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0 /)
iCombos(:,3)  =  (/ 1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0 /)
iCombos(:,4)  =  (/ 0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0 /)
iCombos(:,5)  =  (/ 0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0 /)
iCombos(:,6)  =  (/ 0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0 /)
iCombos(:,7)  =  (/ 0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0 /)
!
!!$      write (6,'(12I3)') iCombos(:,1)
!!$      write (6,'(12I3)') iCombos(:,2)
!!$      write (6,'(12I3)') iCombos(:,3)
!!$      write (6,'(12I3)') iCombos(:,4)
!!$      write (6,'(12I3)') iCombos(:,5)
!!$      write (6,'(12I3)') iCombos(:,6)
!!$      write (6,'(12I3)') iCombos(:,7)
!
where (iCombos.gt.0)
   iCombosN = 0
elsewhere
   iCombosN = 1
end where
!
!  *******************************************************************************
!
!  ** EMIR
!
vars(iDefault,  iE090  )%name                 =  rec%E090
vars(iDefault,  iE090  )%isConnected          =  .True.
vars(iDefault,  iE090  )%gunnOn               =  .True.
!
vars(iDefault,  iE090  )%nChannels            =  1
vars(iDefault,  iE090  )%bolometerName        =  GPnone
vars(iDefault,  iE090  )%gainBolometer        =  GPnoneI
vars(iDefault,  iE090  )%channel              =  1
!
vars(iDefault,  iE090  )%frequency%unit       =  fu%Ghz
vars(iDefault,  iE090  )%frequency%doppler    =  doppler%doppler
vars(iDefault,  iE090  )%frequency%value      =  97.980968
!                               
vars(iDefault,  iE090  )%fOffset              =  vars(iDefault,  iE090  )%frequency
vars(iDefault,  iE090  )%fOffset%value        =  GPnoneD
!                               
vars(iDefault,  iE090  )%lineName             =  "CS(2-1)"
!
vars(iDefault,  iE090  )%width                =  GPnone
!
vars(iDefault,  iE090  )%sideBand             =  esb%li
!
vars(iDefault,  iE090  )%horizontalSubbands   =  vars(iDefault,  iE090  )%sideBand
vars(iDefault,  iE090  )%verticalSubbands     =  vars(iDefault,  iE090  )%sideBand
!
vars(iDefault,  iE090  )%effForward           =    0.95
vars(iDefault,  iE090  )%effBeam              =    0.81
vars(iDefault,  iE090  )%effBeam              =  vars(iDefault,  iE090  )%effForward           
vars(iDefault,  iE090  )%scale                =  scale%antenna
vars(iDefault,  iE090  )%gainImage%value      =    0.0501187
vars(iDefault,  iE090  )%gainImage%db         =  -13.0
vars(iDefault,  iE090  )%tempAmbient          =  270.0
vars(iDefault,  iE090  )%tempCold             =   86.0
!
vars(iDefault,  iE090  )%tempColdCode         =  "L"
vars(iDefault,  iE090  )%tempAmbientCode      =  "L"
!
vars(iDefault,  iE090  )%derotatorSystem      =  GPnone
vars(iDefault,  iE090  )%derotatorAngle       =  GPnoneR
!                     
vars(iDefault,  iE090  )%iPixel               =    1
!
vars(iDefault,  iE090  )%nPixels              =    1
!
vars(iDefault,  iE090  )%centerIF             =  IF%EMIRinner
!                               
vars(iDefault,  iE090  )%bandWidth            =  BW%EMIRsubband
vars(iDefault,  iE090  )%disBoxInput          =  GPnoneI
vars(iDefault,  iE090  )%IF2                  =  IF2%EMIRinner
vars(iDefault,  iE090  )%isFlippingIF2        =  .True.
vars(iDefault,  iE090  )%polarization         =  GPnone
vars(iDefault,  iE090  )%useSpecialLO         =  .False.
!
! ****
!
vars(iStd1:iLimit2,  iE090  )                 =   vars(iDefault,  iE090  )
!
! ****
!
vars(iStd1,     iE090  )%frequency%value      =   73.0D0                         !  !!  EMIR wiki 2016-03
vars(iStd2,     iE090  )%frequency%value      =  117.0D0                         
vars(ILimit1,   iE090  )%frequency%value      =  vars(iStd1,     iE090  )%frequency%value 
vars(iLimit2,   iE090  )%frequency%value      =  vars(iStd2,     iE090  )%frequency%value 
!
!!$vars(iStd1,     iE090  )%frequency%value      =   71.0D0    !!   email CK 2015-10-20
!!$vars(iStd2,     iE090  )%frequency%value      =  117.0D0    !!                                     
!!$vars(ILimit1,   iE090  )%frequency%value      =   66.0D0                                  !! -0.1D0
!!$vars(iLimit2,   iE090  )%frequency%value      =  vars(iStd2,     iE090  )%frequency%value !! +0.1D0
!!$!
!!$vars(iStd1,     iE090  )%frequency%value      =   83.0D0    !!   wiki EmirforAstronomers 2010-07-28
!!$vars(iStd2,     iE090  )%frequency%value      =  117.0D0    !!                                     
!!$vars(ILimit1,   iE090  )%frequency%value      =   78.0D0                                  !! -0.1D0
!!$vars(iLimit2,   iE090  )%frequency%value      =  vars(iStd2,     iE090  )%frequency%value !! +0.1D0
!!$!
!!$vars(iStd1,     iE090  )%frequency%value      =   90.0D0    !!  for tests
!!$vars(iStd2,     iE090  )%frequency%value      =  100.0D0    !!  for tests
!!$vars(ILimit1,   iE090  )%frequency%value      =   85.0D0    !!  for tests
!!$vars(iLimit2,   iE090  )%frequency%value      =  105.0D0    !!  for tests
!                               
coldLimits(1,   iE090  )%frequency%value      =  vars(ILimit1,   iE090  )%frequency%value
coldLimits(2,   iE090  )%frequency%value      =  vars(iLimit2,   iE090  )%frequency%value
!
vars(iStd1,     iE090  )%fOffset%value         =   -3.0D0
vars(iStd2,     iE090  )%fOffset%value         =    3.0D0
vars(ILimit1,   iE090  )%fOffset%value         =  -10.0D0
vars(iLimit2,   iE090  )%fOffset%value         =   10.0D0
!                               
vars(iStd1,     iE090  )%effForward           =    0.88
vars(iStd2,     iE090  )%effForward           =    0.96
vars(ILimit1,   iE090  )%effForward           =    0.5
vars(iLimit2,   iE090  )%effForward           =    1.0
!                               
vars(iStd1,     iE090  )%effBeam              =    0.40
vars(iStd2,     iE090  )%effBeam              =    0.96
vars(ILimit1,   iE090  )%effBeam              =    0.3
vars(iLimit2,   iE090  )%effBeam              =    1.0
!                               
vars(iStd1,     iE090  )%gainImage%value      =    0.001
vars(iStd2,     iE090  )%gainImage%value      =    0.1
vars(ILimit1,   iE090  )%gainImage%value      =    0.0001
vars(iLimit2,   iE090  )%gainImage%value      =    1.0
!
vars(iStd1,     iE090  )%gainImage%db         =  -30.0
vars(iStd2,     iE090  )%gainImage%db         =  -10.0
vars(ILimit1,   iE090  )%gainImage%db         =  -40.0
vars(iLimit2,   iE090  )%gainImage%db         =    0.0
!
vars(iStd1,     iE090  )%tempAmbient          =  250.0
vars(iStd2,     iE090  )%tempAmbient          =  290.0
vars(ILimit1,   iE090  )%tempAmbient          =  200.0
vars(iLimit2,   iE090  )%tempAmbient          =  320.0
!                               
vars(iStd1,     iE090  )%tempCold             =   20.0
vars(iStd2,     iE090  )%tempCold             =   80.0
vars(ILimit1,   iE090  )%tempCold             =    5.0
vars(iLimit2,   iE090  )%tempCold             =  200.0
!                     
vars(iStd1,     iE090  )%derotatorAngle       =    0.0
vars(iStd2,     iE090  )%derotatorAngle       =    0.0
vars(ILimit1,   iE090  )%derotatorAngle       =    0.0
vars(iLimit2,   iE090  )%derotatorAngle       =    0.0
!                     
!  *******************************************************************************
!
!  ** EMIR
!
vars(iDefault:iLimit2,  iE150  )              =  vars(iDefault:iLimit2,  iE090  )
!
vars(iDefault,  iE150  )%name                 =  rec%E150
vars(iDefault,  iE150  )%isConnected          =  .False.
vars(iDefault,  iE150  )%gunnOn               =  .False.
!
vars(iDefault,  iE150  )%nChannels            =  1
vars(iDefault,  iE150  )%bolometerName        =  GPnone
vars(iDefault,  iE150  )%gainBolometer        =  GPnoneI
vars(iDefault,  iE150  )%channel              =  1
!
vars(iDefault,  iE150  )%frequency%unit       =  fu%Ghz
vars(iDefault,  iE150  )%frequency%doppler    =  doppler%doppler
vars(iDefault,  iE150  )%frequency%value      =  146.969049
!                               
vars(iDefault,  iE150  )%fOffset              =  vars(iDefault,  iE150  )%frequency
vars(iDefault,  iE150  )%fOffset%value        =  GPnoneD
!                               
vars(iDefault,  iE150  )%lineName             =  "CS(3-2)"
!
vars(iDefault,  iE150  )%sideBand             =  esb%li
!
vars(iDefault,  iE150  )%horizontalSubbands   =  vars(iDefault,  iE150  )%sideBand
vars(iDefault,  iE150  )%verticalSubbands     =  vars(iDefault,  iE150  )%sideBand
!
vars(iDefault,  iE150  )%effForward           =  0.93
vars(iDefault,  iE150  )%effBeam              =  0.74
vars(iDefault,  iE150  )%effBeam              =  vars(iDefault,  iE150  )%effForward           
!
! ****
!
!! vars(iStd1,     iE150  )%frequency%value      =  125.0D0                         !  !!  EMIR wiki 2016-03
vars(iStd1,     iE150  )%frequency%value      =  124.0D0                         !  !! 2017-03-23
vars(iStd2,     iE150  )%frequency%value      =  184.0D0                                  
vars(iLimit1,   iE150  )%frequency%value      =  vars(iStd1,     iE150  )%frequency%value 
vars(iLimit2,   iE150  )%frequency%value      =  189.0D0
!!
!!$vars(iStd1,     iE150  )%frequency%value      =  125.0D0                                  !! upgrade E150 2013-10 /commissioning
!!$vars(iStd2,     iE150  )%frequency%value      =  186.0D0                                  !! upgrade E150 2013-10 /commissioning 
!!$vars(iLimit1,   iE150  )%frequency%value      =  vars(iStd1,     iE150  )%frequency%value !! -0.1D0
!!$vars(iLimit2,   iE150  )%frequency%value      =  vars(iStd2,     iE150  )%frequency%value !! +0.1D0
!!$!!
!!$vars(iStd1,     iE150  )%frequency%value      =  127.0D0                                  !! upgrade E150 2013-09
!!$vars(iStd2,     iE150  )%frequency%value      =  179.0D0                                  !! upgrade E150 2013-09                
!!$vars(iLimit1,   iE150  )%frequency%value      =  vars(iStd1,     iE150  )%frequency%value !! -0.1D0
!!$vars(iLimit2,   iE150  )%frequency%value      =  186.0D0                                  !! +0.1D0
!!$vars(iLimit2,   iE150  )%frequency%value      =  189.0D0                                  !! wiki EmirforAstronomers since 2011-09
!!
!!                                                            !!   before upgrade E150 2013-09
!!$vars(iStd1,     iE150  )%frequency%value      =  129.0D0   !!   wiki EmirforAstronomers 2010-07-28
!!$vars(iStd2,     iE150  )%frequency%value      =  174.0D0   !!                                     
!!$vars(ILimit1,   iE150  )%frequency%value      =  vars(iStd1,     iE150  )%frequency%value !! -0.1D0
!!$vars(iLimit2,   iE150  )%frequency%value      =  186.0D0                                  !! +0.1D0
!!$vars(iLimit2,   iE150  )%frequency%value      =  189.0D0                                  !! wiki EmirforAstronomers since 2011-09
!                               
coldLimits(1,   iE150  )%frequency%value      =  vars(ILimit1,   iE150  )%frequency%value
coldLimits(2,   iE150  )%frequency%value      =  vars(iLimit2,   iE150  )%frequency%value
!                               
!  *******************************************************************************
!
!  ** EMIR
!
vars(iDefault:iLimit2,  iE230  )              =  vars(iDefault:iLimit2,  iE090  )
!
vars(iDefault,  iE230  )%name                 =  rec%E230
vars(iDefault,  iE230  )%isConnected          =  .False.
vars(iDefault,  iE230  )%gunnOn               =  .False.
!
vars(iDefault,  iE230  )%nChannels            =  1
vars(iDefault,  iE230  )%bolometerName        =  GPnone
vars(iDefault,  iE230  )%gainBolometer        =  GPnoneI
vars(iDefault,  iE230  )%channel              =  1
!
vars(iDefault,  iE230  )%frequency%unit       =  fu%Ghz
vars(iDefault,  iE230  )%frequency%doppler    =  doppler%doppler
vars(iDefault,  iE230  )%frequency%value      =  230.537990
!                               
vars(iDefault,  iE230  )%fOffset               =  vars(iDefault,  iE230  )%frequency
vars(iDefault,  iE230  )%fOffset%value         =  GPnoneD
!                               
vars(iDefault,  iE230  )%lineName             =  "CO(2-1)"
!
vars(iDefault,  iE230  )%sideBand             =  esb%li
!
vars(iDefault,  iE230  )%horizontalSubbands   =  vars(iDefault,  iE230  )%sideBand
vars(iDefault,  iE230  )%verticalSubbands     =  vars(iDefault,  iE230  )%sideBand
!
vars(iDefault,  iE230  )%effForward           =  0.92
vars(iDefault,  iE230  )%effBeam              =  0.58
vars(iDefault,  iE230  )%effBeam              =  vars(iDefault,  iE230  )%effForward           
!
! ****
!
!                                                                                !  !!  following limits agree 
!                                                                                !  !!  with EMIR wiki 2016-03
vars(iStd1,     iE230  )%frequency%value      =  202.0D0                         !!  2011-11-11  
vars(iStd2,     iE230  )%frequency%value      =  274.0D0                         !!  2011-11-11                         
!!$vars(iLimit1,   iE230  )%frequency%value      =  vars(iStd1,     iE230  )%frequency%value  -1.0D0  !!  -0.58D0
!!$vars(iLimit2,   iE230  )%frequency%value      =  vars(iStd2,     iE230  )%frequency%value  +1.0D0  !!  +0.58D0
vars(iLimit1,   iE230  )%frequency%value      =  vars(iStd1,     iE230  )%frequency%value
vars(iLimit2,   iE230  )%frequency%value      =  vars(iStd2,     iE230  )%frequency%value
!                               
coldLimits(1,   iE230  )%frequency%value      =  vars(iLimit1,   iE230  )%frequency%value
coldLimits(2,   iE230  )%frequency%value      =  vars(iLimit2,   iE230  )%frequency%value
!                               
!  *******************************************************************************
!
!  ** Emir
!
vars(iDefault:iLimit2,  iE300  )              =  vars(iDefault:iLimit2,  iE090  )
!
vars(iDefault,  iE300  )%name                 =  rec%E300
vars(iDefault,  iE300  )%isConnected          =  .False.
vars(iDefault,  iE300  )%gunnOn               =  .False.
!
vars(iDefault,  iE300  )%nChannels            =  1
vars(iDefault,  iE300  )%bolometerName        =  GPnone
vars(iDefault,  iE300  )%gainBolometer        =  GPnoneI
vars(iDefault,  iE300  )%channel              =  1
!
vars(iDefault,  iE300  )%frequency%unit       =  fu%Ghz
vars(iDefault,  iE300  )%frequency%doppler    =  doppler%doppler
vars(iDefault,  iE300  )%frequency%value      =  330.587957
!                               
vars(iDefault,  iE300  )%fOffset              =  vars(iDefault,  iE300  )%frequency
vars(iDefault,  iE300  )%fOffset%value        =  GPnoneD
!                               
vars(iDefault,  iE300  )%lineName             =  "13CO(3-2)"
!
vars(iDefault,  iE300  )%sideBand             =  esb%li
!
vars(iDefault,  iE300  )%horizontalSubbands   =  vars(iDefault,  iE300  )%sideBand
vars(iDefault,  iE300  )%verticalSubbands     =  vars(iDefault,  iE300  )%sideBand
!
vars(iDefault,  iE300  )%effForward           =  0.82   !!  memo JP 2010-04-15
vars(iDefault,  iE300  )%effBeam              =  0.35   !!  wiki Iram30mEfficiencies 2010-03-03
vars(iDefault,  iE300  )%effBeam              =  vars(iDefault,  iE300  )%effForward           
!
vars(iStd1,     iE300  )%effForward           =    0.78
vars(iStd2,     iE300  )%effForward           =    0.90
vars(ILimit1,   iE300  )%effForward           =    0.5
vars(iLimit2,   iE300  )%effForward           =    1.0
!                               
vars(iStd1,     iE300  )%effBeam              =    0.2
vars(iStd2,     iE300  )%effBeam              =    0.5
vars(ILimit1,   iE300  )%effBeam              =    0.1
vars(iLimit2,   iE300  )%effBeam              =    1.0
!                               
! ****
!    
vars(iStd1,     iE300  )%frequency%value      =  277.0D0                         !  !!  EMIR wiki 2016-03
vars(iStd2,     iE300  )%frequency%value      =  350.0D0                         
vars(iLimit1,   iE300  )%frequency%value      =  vars(iStd1,     iE300  )%frequency%value 
vars(iLimit2,   iE300  )%frequency%value      =  375.0D0                         !  !!  E330 YIG 2013-09  
!                               
!!$!                                                                                !!  upgrade E330 YIG 2013-09 
!!$vars(iStd1,     iE300  )%frequency%value      =  277.0D0                         !!  2011-11-11  
!!$vars(iStd2,     iE300  )%frequency%value      =  358.0D0                         !!  2012-10-25 email SN
!!$vars(iLimit1,   iE300  )%frequency%value      =  vars(iStd1,     iE300  )%frequency%value 
!!$vars(iLimit2,   iE300  )%frequency%value      =  375.0D0                         !!  upgrade E330 YIG 2013-09  
!!$!                                                                                !!  plot  SN 2013-08-30 --> loc osc ~ 365 ++ ~ 10 (subband LO)
!!$!                                                                                !!  email CK 2013-08-07 --> up to about 370
!!$!                               
!!                                                                                  !!   before upgrade E330 YIG 2013-09 
!!$vars(iStd1,     iE300  )%frequency%value      =  277.0D0                         !!  2011-11-11  
!!$vars(iStd2,     iE300  )%frequency%value      =  358.0D0                         !!  2012-10-25 email SN
!!$!! OLD !!vars(iStd2,     iE300  )%frequency%value      =  352.0D0                         !!  2011-11-11                         
!!$!! OLD !!vars(iLimit1,   iE300  )%frequency%value      =  vars(iStd1,     iE300  )%frequency%value  -1.0D0  !!  -0.58D0
!!$!! OLD !!vars(iLimit2,   iE300  )%frequency%value      =  vars(iStd2,     iE300  )%frequency%value  +1.0D0  !!  +0.58D0
!!$vars(iLimit1,   iE300  )%frequency%value      =  vars(iStd1,     iE300  )%frequency%value  
!!$vars(iLimit2,   iE300  )%frequency%value      =  vars(iStd2,     iE300  )%frequency%value  
!                               
coldLimits(1,   iE300  )%frequency%value      =  vars(iLimit1,   iE300  )%frequency%value
coldLimits(2,   iE300  )%frequency%value      =  vars(iLimit2,   iE300  )%frequency%value
!                               
!  *******************************************************************************   
!
!  ** frequency and Local Oscillator ranges
!
EMIRloRange(iE090)%fLOmin    =   82.000     !!  ALF
EMIRloRange(iE090)%fLOmax    =  114.000     !!  ALF
EMIRloRange(iE090)%fLOmin    =   81.000     !!  SN
EMIRloRange(iE090)%fLOmax    =  116.000     !!  SN
EMIRloRange(iE090)%fLOmin    =   82.500     !!  SN 2010-07-27
EMIRloRange(iE090)%fLOmin    =   75.429     !!  implied by email CK 2015-10-20
EMIRloRange(iE090)%fLOmax    =  117.000     !!  SN 2010-07-27
!
EMIRloRange(iE090)%fEdgeMin  =  EMIRloRange(iE090)%fLOmin -12.0
EMIRloRange(iE090)%fEdgeMax  =  EMIRloRange(iE090)%fLOmax +12.0
!
EMIRloRange(iE150)%fLOmin    =  135.000     !!  ALF
EMIRloRange(iE150)%fLOmax    =  174.000     !!  ALF
EMIRloRange(iE150)%fLOmin    =  132.000     !!  SN   == SN 2010-07-27
EMIRloRange(iE150)%fLOmax    =  188.000     !!  SN   == SN 2010-07-27
!! TBD EMIRloRange(iE150)%fLOmin    =  vars(iLimit1,   iE150  )%frequency%value +9.43D0 !!  ?? E150 upgrade 2013-09
!! TBD EMIRloRange(iE150)%fLOmax    =  vars(iLimit2,   iE150  )%frequency%value -9.43D0 !!  ?? E150 upgrade 2013-09
!
!!$EMIRloRange(iE150)%fEdgeMin  =  EMIRloRange(iE150)%fLOmin -8.0
!!$EMIRloRange(iE150)%fEdgeMax  =  EMIRloRange(iE150)%fLOmax +8.0
EMIRloRange(iE150)%fEdgeMin  =  EMIRloRange(iE150)%fLOmin -12.0                    !!  E150 upgrade 2013-09
EMIRloRange(iE150)%fEdgeMax  =  EMIRloRange(iE150)%fLOmax +12.0                    !!  E150 upgrade 2013-09
!                                                                            
EMIRloRange(iE230)%fLOmin    =  207.000     !!  ALF
EMIRloRange(iE230)%fLOmax    =  273.000     !!  ALF
EMIRloRange(iE230)%fLOmin    =  192.000     !!  SN   == SN 2010-07-27
EMIRloRange(iE230)%fLOmax    =  291.000     !!  SN   == SN 2010-07-27
EMIRloRange(iE230)%fLOmin    =  vars(iLimit1,   iE230  )%frequency%value +9.43D0 !!  2011-11-11 implied by EMIR wiki               
EMIRloRange(iE230)%fLOmax    =  vars(iLimit2,   iE230  )%frequency%value -9.43D0 !!  2011-11-11                         
!
EMIRloRange(iE230)%fEdgeMin  =  EMIRloRange(iE230)%fLOmin -12.0D0                !!  2011-11-11                         
EMIRloRange(iE230)%fEdgeMax  =  EMIRloRange(iE230)%fLOmax +12.0D0                !!  2011-11-11                         
!                                                                            
!!$EMIRloRange(iE300)%fLOmin    =  266.000     !!  ALF
!!$EMIRloRange(iE300)%fLOmax    =  345.000     !!  ALF
!!$EMIRloRange(iE300)%fLOmin    =  234.000     !!  SN   !! typing error? should be 264 ?
!!$EMIRloRange(iE300)%fLOmax    =  345.000     !!  SN
!!$EMIRloRange(iE300)%fLOmin    =  264.000     !!  SN 2010-07-27
!!$EMIRloRange(iE300)%fLOmax    =  342.000     !!  SN 2010-07-27
EMIRloRange(iE300)%fLOmin    =  vars(iLimit1,   iE300  )%frequency%value +9.43D0 !!  2011-11-11 implied by EMIR wiki
EMIRloRange(iE300)%fLOmax    =  vars(iLimit2,   iE300  )%frequency%value -9.43D0 !!  2011-11-11                         
!
EMIRloRange(iE300)%fEdgeMin  =  EMIRloRange(iE300)%fLOmin -12.0D0                !!  2011-11-11                         
EMIRloRange(iE300)%fEdgeMax  =  EMIRloRange(iE300)%fLOmax +12.0D0                !!  2011-11-11                         
!
!!$EMIRloRange(iE300)%fLOgapMin =  300.000     !!  SN 2012-06-04 
!!$EMIRloRange(iE300)%fLOgapMax =  306.000     !!  SN 2012-06-04 
EMIRloRange(iE300)%fLOgapMin =  328.000     !!  SN 2012-11-02
EMIRloRange(iE300)%fLOgapMax =  332.000     !!  SN 2012-11-02 
!                                                                            
!  ** frequency and mixer  ranges
!
EMIRmixRange(iE090)%fDSBmin   =   76.000    !!  SN 2010-07-27
EMIRmixRange(iE090)%fDSBmin   =   67.429    !!  <-- implied by email CK 2015-10-20
EMIRmixRange(iE090)%fDSBmax   =  122.000    !!  SN 2010-07-27
!
EMIRmixRange(iE150)%fLSBmin   =  129.000    !!  SN 2010-07-27
EMIRmixRange(iE150)%fLSBmax   =  168.000    !!  SN 2010-07-27
EMIRmixRange(iE150)%fUSBmin   =  142.000    !!  SN 2010-07-27
EMIRmixRange(iE150)%fUSBmax   =  186.000    !!  SN 2010-07-27
EMIRmixRange(iE150)%fUSBmax   =  188.75     !!  implied by wiki EmirforAstronomers since 2011-09 
EMIRmixRange(iE150)%fDSBmin   =  vars(iLimit1, iE150 )%frequency%value +1.43D0   !!  E150 upgrade 2013-09
EMIRmixRange(iE150)%fDSBmax   =  vars(iLimit2, iE150 )%frequency%value -1.43D0   !!  E150 upgrade 2013-09
!
EMIRmixRange(iE230)%fLSBmin   =  201.000    !!  SN 2010-07-27
EMIRmixRange(iE230)%fLSBmax   =  267.000    !!  SN 2010-07-27
EMIRmixRange(iE230)%fUSBmin   =  219.000    !!  SN 2010-07-27
EMIRmixRange(iE230)%fUSBmax   =  267.000    !!  SN 2010-07-27
EMIRmixRange(iE230)%fDSBmin   =  vars(iLimit1, iE230 )%frequency%value +1.43D0   !!  2011-11-11 
EMIRmixRange(iE230)%fDSBmax   =  vars(iLimit2, iE230 )%frequency%value -1.43D0   !!  2011-11-11 
!
!!$EMIRmixRange(iE300)%fDSBmin   =  260.000    !!  SN 2010-07-27
!!$EMIRmixRange(iE300)%fDSBmax   =  351.000    !!  SN 2010-07-27
EMIRmixRange(iE300)%fDSBmin   =  vars(iLimit1, iE300 )%frequency%value +1.43D0   !!  2011-11-11 
EMIRmixRange(iE300)%fDSBmax   =  vars(iLimit2, iE300 )%frequency%value -1.43D0   !!  2011-11-11 
!
!  *******************************************************************************
!
!  *** EMIR rules 2016    !!    EMIRrules is defined in variablesReceiver.inc
!
EMIRrules( 1)%band        =    rec%E090                                          !  !! basic rules for E090
EMIRrules( 1)%subBand     =    esb%LO
EMIRrules( 1)%test        =    EMIRtest%inRange
EMIRrules( 1)%lo          =     73.0D0 +0D0
!! EMIRrules( 1)%hi          =    117.0D0 -(deltaUO+deltaUO)
EMIRrules( 1)%hi          =    105.0D0 -(deltaUO-deltaUI)                        !  !! 2017-03-23
EMIRrules( 1)%priority    =    priorityE
EMIRrules( 1)%severity    =    severityE
EMIRrules( 1)%message     =    "not "//EMIRrules( 1)%test
!
EMIRrules( 2)%band        =    rec%E090
EMIRrules( 2)%subBand     =    esb%LI
EMIRrules( 2)%test        =    EMIRtest%inRange
EMIRrules( 2)%lo          =     73.0D0 +(deltaUO-deltaUI)
!! EMIRrules( 2)%hi          =    117.0D0 -(deltaUO+deltaUI)
EMIRrules( 2)%hi          =    105.0D0                                           !  !! 2017-03-23
EMIRrules( 2)%priority    =    priorityE
EMIRrules( 2)%severity    =    severityE
EMIRrules( 2)%message     =    "not "//EMIRrules( 2)%test
!
EMIRrules( 3)%band        =    rec%E090
EMIRrules( 3)%subBand     =    esb%UI
EMIRrules( 3)%test        =    EMIRtest%inRange
EMIRrules( 3)%lo          =     73.0D0 +(deltaUO+deltaUI)
EMIRrules( 3)%hi          =    117.0D0 -(deltaUO-deltaUI)  
EMIRrules( 3)%priority    =    priorityE
EMIRrules( 3)%severity    =    severityE
EMIRrules( 3)%message     =    "not "//EMIRrules( 3)%test
!
EMIRrules( 4)%band        =    rec%E090
EMIRrules( 4)%subBand     =    esb%UO
EMIRrules( 4)%test        =    EMIRtest%inRange
EMIRrules( 4)%lo          =     73.0D0 +(deltaUO+deltaUO)
EMIRrules( 4)%hi          =    117.0D0 -0D0
EMIRrules( 4)%priority    =    priorityE
EMIRrules( 4)%severity    =    severityE
EMIRrules( 4)%message     =    "not "//EMIRrules( 4)%test
!
!
EMIRrules( 5)%band        =    rec%E150                                          !  !! basic rules for E150
EMIRrules( 5)%subBand     =    esb%LO
EMIRrules( 5)%test        =    EMIRtest%inRange
!! EMIRrules( 5)%lo          =    125.0D0 +0D0
EMIRrules( 5)%lo          =    124.0D0 +0D0                                      !  !! 2017-03-23 
EMIRrules( 5)%hi          =    184.0D0 -(deltaUO+deltaUO)
EMIRrules( 5)%priority    =    priorityE
EMIRrules( 5)%severity    =    severityE
EMIRrules( 5)%message     =    "not "//EMIRrules( 5)%test
!
EMIRrules( 6)%band        =    rec%E150
EMIRrules( 6)%subBand     =    esb%LI
EMIRrules( 6)%test        =    EMIRtest%inRange
!! EMIRrules( 6)%lo          =    125.0D0 +(deltaUO-deltaUI)
EMIRrules( 6)%lo          =    124.0D0 +(deltaUO-deltaUI)                        !  !! 2017-03-23 
EMIRrules( 6)%hi          =    184.0D0 -(deltaUO+deltaUI)
EMIRrules( 6)%priority    =    priorityE
EMIRrules( 6)%severity    =    severityE
EMIRrules( 6)%message     =    "not "//EMIRrules( 6)%test
!
EMIRrules( 7)%band        =    rec%E150
EMIRrules( 7)%subBand     =    esb%UI
EMIRrules( 7)%test        =    EMIRtest%inRange
!! EMIRrules( 7)%lo          =    125.0D0 +(deltaUO+deltaUI)
EMIRrules( 7)%lo          =    124.0D0 +(deltaUO+deltaUI)                        !  !! 2017-03-23
EMIRrules( 7)%hi          =    184.0D0 -(deltaUO-deltaUI)  
EMIRrules( 7)%priority    =    priorityE
EMIRrules( 7)%severity    =    severityE
EMIRrules( 7)%message     =    "not "//EMIRrules( 7)%test
!
EMIRrules( 8)%band        =    rec%E150
EMIRrules( 8)%subBand     =    esb%UO
EMIRrules( 8)%test        =    EMIRtest%inRange
!! EMIRrules( 8)%lo          =    125.0D0 +(deltaUO+deltaUO)
EMIRrules( 8)%lo          =    124.0D0 +(deltaUO+deltaUO)                        !  !! 2017-03-23
EMIRrules( 8)%hi          =    184.0D0 -0D0
EMIRrules( 8)%priority    =    priorityE
EMIRrules( 8)%severity    =    severityE
EMIRrules( 8)%message     =    "not "//EMIRrules( 8)%test
!
!
EMIRrules( 9)%band        =    rec%E230                                          !  !! basic rules for E230
EMIRrules( 9)%subBand     =    esb%LO
EMIRrules( 9)%test        =    EMIRtest%inRange
EMIRrules( 9)%lo          =    202.0D0 +0D0
EMIRrules( 9)%hi          =    263.5D0 -(deltaUO-deltaUI)   !!  corrected after EMIR D13 tests
!! EMIRrules( 9)%hi          =    268.0D0 -(deltaUO-deltaUI)   !!  274.0D0 -(deltaUO+deltaUO)
EMIRrules( 9)%priority    =    priorityE
EMIRrules( 9)%severity    =    severityE
EMIRrules( 9)%message     =    "not "//EMIRrules( 9)%test
!
EMIRrules(10)%band        =    rec%E230
EMIRrules(10)%subBand     =    esb%LI
EMIRrules(10)%test        =    EMIRtest%inRange
EMIRrules(10)%lo          =    202.0D0 +(deltaUO-deltaUI)
EMIRrules(10)%hi          =    263.5D0 +0D0                 !!  corrected after EMIR D13 tests
!                                                           !!  staff meeting email SN 2016-10-26
!! EMIRrules(10)%hi          =    268.0D0 +0D0                 !!  274.0D0 -(deltaUO+deltaUI)
EMIRrules(10)%priority    =    priorityE
EMIRrules(10)%severity    =    severityE
EMIRrules(10)%message     =    "not "//EMIRrules(10)%test
!
EMIRrules(11)%band        =    rec%E230
EMIRrules(11)%subBand     =    esb%UI
EMIRrules(11)%test        =    EMIRtest%inRange
EMIRrules(11)%lo          =    217.0D0 +0D0                 !!  202.0D0 +(deltaUO+deltaUI)
EMIRrules(11)%hi          =    274.0D0 -(deltaUO-deltaUI)  
EMIRrules(11)%priority    =    priorityE
EMIRrules(11)%severity    =    severityE
EMIRrules(11)%message     =    "not "//EMIRrules(11)%test
!
EMIRrules(12)%band        =    rec%E230
EMIRrules(12)%subBand     =    esb%UO
EMIRrules(12)%test        =    EMIRtest%inRange
EMIRrules(12)%lo          =    217.0D0 +(deltaUO-deltaUI)   !!  202.0D0 +(deltaUO+deltaUO)
EMIRrules(12)%hi          =    274.0D0 -0D0
EMIRrules(12)%priority    =    priorityE
EMIRrules(12)%severity    =    severityE
EMIRrules(12)%message     =    "not "//EMIRrules(12)%test
!
!
EMIRrules(13)%band        =    rec%E300                                          !  !! basic rules for E300
EMIRrules(13)%subBand     =    esb%LO
EMIRrules(13)%test        =    EMIRtest%inRange
EMIRrules(13)%lo          =    277.0D0 +0D0
!! EMIRrules(13)%hi          =    375.0D0 -(deltaUO+deltaUO)
EMIRrules(13)%hi          =    335.0D0                                           !  !! 2017-03-23
EMIRrules(13)%priority    =    priorityE
EMIRrules(13)%severity    =    severityE
EMIRrules(13)%message     =    "not "//EMIRrules(13)%test
!
EMIRrules(14)%band        =    rec%E300
EMIRrules(14)%subBand     =    esb%LI
EMIRrules(14)%test        =    EMIRtest%inRange
EMIRrules(14)%lo          =    277.0D0 +(deltaUO-deltaUI)
!! EMIRrules(14)%hi          =    375.0D0 -(deltaUO+deltaUI)
EMIRrules(14)%hi          =    335.0D0 +(deltaUO-deltaUI)                        !  !! 2017-03-23
EMIRrules(14)%priority    =    priorityE
EMIRrules(14)%severity    =    severityE
EMIRrules(14)%message     =    "not "//EMIRrules(14)%test
!
EMIRrules(15)%band        =    rec%E300
EMIRrules(15)%subBand     =    esb%UI
EMIRrules(15)%test        =    EMIRtest%inRange
EMIRrules(15)%lo          =    277.0D0 +(deltaUO+deltaUI)
EMIRrules(15)%hi          =    375.0D0 -(deltaUO-deltaUI)  
EMIRrules(15)%priority    =    priorityE
EMIRrules(15)%severity    =    severityE
EMIRrules(15)%message     =    "not "//EMIRrules(15)%test
!
EMIRrules(16)%band        =    rec%E300
EMIRrules(16)%subBand     =    esb%UO
EMIRrules(16)%test        =    EMIRtest%inRange
EMIRrules(16)%lo          =    277.0D0 +(deltaUO+deltaUO)
EMIRrules(16)%hi          =    375.0D0 -0D0
EMIRrules(16)%priority    =    priorityE
EMIRrules(16)%severity    =    severityE
EMIRrules(16)%message     =    "not "//EMIRrules(16)%test
!
!
EMIRrules(21)%band        =    rec%E090                                          !  !! additional rules for E090
EMIRrules(21)%subBand     =    esb%LO
EMIRrules(21)%test        =    EMIRtest%under
EMIRrules(21)%lo          =     73.0D0 +0D0
EMIRrules(21)%hi          =    108.0D0 -deltaUO
EMIRrules(21)%priority    =    priorityW
EMIRrules(21)%severity    =    severityW
EMIRrules(21)%message     =    "not "//EMIRrules(21)%test
EMIRrules(21)%comment     =                                                      &
     & "Comment 1.2: for LSB loc. osc. should be at most 108.0 GHz"              !
!
EMIRrules(22)%band        =    rec%E090
EMIRrules(22)%subBand     =    esb%LI
EMIRrules(22)%test        =    EMIRtest%under
EMIRrules(22)%lo          =     73.0D0 +(deltaUO-deltaUI)
EMIRrules(22)%hi          =    108.0D0 -deltaUI
EMIRrules(22)%priority    =    priorityW
EMIRrules(22)%severity    =    severityW
EMIRrules(22)%message     =    "not "//EMIRrules(22)%test
EMIRrules(22)%comment     =                                                      &
     & "Comment 1.2: for LSB loc. osc. should be at most 108.0 GHz"              !
!
!
EMIRrules(31)%band        =    rec%E150                                          !  !! additional rules for E150
EMIRrules(31)%subBand     =    esb%UO
EMIRrules(31)%test        =    EMIRtest%under
EMIRrules(31)%lo          =    125.0D0 +(deltaUO+deltaUO)
EMIRrules(31)%hi          =    184.0D0 +0.0D0
EMIRrules(31)%priority    =    priorityW
EMIRrules(31)%severity    =    severityW
EMIRrules(31)%message     =    "not "//EMIRrules(31)%test
EMIRrules(31)%comment     =                                                      &
     & "Comment 2: over 184 GHz requires special strategy (for gain ratios) "    !
!
!
!                                                                                !  !! additional rules for E300
!!$EMIRrules(51)%band        =    rec%E300                                          !! de-activated 2017-03-23
!!$EMIRrules(51)%subBand     =    esb%LO
!!$EMIRrules(51)%test        =    EMIRtest%under
!!$EMIRrules(51)%lo          =    277.0D0 +0D0
!!$EMIRrules(51)%hi          =    350.0D0 -(deltaUO+deltaUO)
!!$EMIRrules(51)%priority    =    priorityW
!!$EMIRrules(51)%severity    =    severityW
!!$EMIRrules(51)%message     =    "not "//EMIRrules(51)%test
!!$Write (EMIRrules(51)%comment,                                                    &
!!$     &   '( A,F12.3,3A )')     "Comment 6: over ", EMIRrules(51)%hi,             &
!!$     &                                        " ", EMIRrules(51)%subBand,        &
!!$     &                                     " requires YIG local oscillator "     !
!!$!
!!$EMIRrules(52)%band        =    rec%E300                                          
!!$EMIRrules(52)%subBand     =    esb%LI
!!$EMIRrules(52)%test        =    EMIRtest%under
!!$EMIRrules(52)%lo          =    277.0D0 +(deltaUO-deltaUI)
!!$EMIRrules(52)%hi          =    350.0D0 -(deltaUO+deltaUI)
!!$EMIRrules(52)%priority    =    priorityW
!!$EMIRrules(52)%severity    =    severityW
!!$EMIRrules(52)%message     =    "not "//EMIRrules(52)%test
!!$Write (EMIRrules(52)%comment,                                                    &
!!$     &   '( A,F12.3,3A )')     "Comment 6: over ", EMIRrules(52)%hi,             &
!!$     &                                        " ", EMIRrules(52)%subBand,        &
!!$     &                                     " requires YIG local oscillator "     !
!
EMIRrules(53)%band        =    rec%E300                                          
EMIRrules(53)%subBand     =    esb%UI
EMIRrules(53)%test        =    EMIRtest%under
EMIRrules(53)%lo          =    277.0D0 +(deltaUO+deltaUI)
EMIRrules(53)%hi          =    350.0D0 -(deltaUO-deltaUI)
EMIRrules(53)%priority    =    priorityW
EMIRrules(53)%severity    =    severityW
EMIRrules(53)%message     =    "not "//EMIRrules(53)%test
Write (EMIRrules(53)%comment,                                                    &
     &   '( A,F12.3,3A )')     "Comment 6: over ", EMIRrules(53)%hi,             &
     &                                        " ", EMIRrules(53)%subBand,        &
     &                                     " requires YIG local oscillator "     !
!
EMIRrules(54)%band        =    rec%E300                                          
EMIRrules(54)%subBand     =    esb%UO
EMIRrules(54)%test        =    EMIRtest%under
EMIRrules(54)%lo          =    277.0D0 +(deltaUO+deltaUO)
EMIRrules(54)%hi          =    350.0D0 +0.0D0
EMIRrules(54)%priority    =    priorityW
EMIRrules(54)%severity    =    severityW
EMIRrules(54)%message     =    "not "//EMIRrules(54)%test
Write (EMIRrules(54)%comment,                                                    &
     &   '( A,F12.3,3A )')     "Comment 6: over ", EMIRrules(54)%hi,             &
     &                                        " ", EMIRrules(54)%subBand,        &
     &                                     " requires YIG local oscillator "     !
!


