subroutine uv_reweight_comm(line,error)
  use gkernel_interfaces
  use mapping_interfaces, except_this=>uv_reweight_comm
  use clean_def
  use clean_arrays
  use gbl_message
  use phys_const
  !------------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING
  !   Reweight the data
  !------------------------------------------------------------------------
  character(len=*), intent(in) :: line  ! Command line
  logical, intent(out) :: error         ! Error flag
  !
  character(len=*), parameter :: rname = 'UV_REWEIGHT'
  integer(kind=index_length) :: iv
  integer :: ic
  real(4) :: scale
  !
  if (huv%loca%size.eq.0) then
    call map_message(seve%e,rname,'No UV data loaded')
    error = .true.
    return
  endif
  !
  error = .false.
  call sic_r4(line,0,1,scale,.true.,error)
  if (error) return
  !
  do iv=1,huv%gil%nvisi
    do ic=1,huv%gil%nchan
      duv(3*ic+huv%gil%fcol-1,iv) = scale * duv(3*ic+huv%gil%fcol-1,iv)
    enddo
  enddo
  do_weig = .true.
end subroutine uv_reweight_comm
!
subroutine uv_resample_comm(line,comm,error)
  use gkernel_interfaces
  use mapping_interfaces, except_this=>uv_resample_comm
  use clean_def
  use clean_arrays
  use clean_types
  use gbl_message
  use phys_const
  !---------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING
  !   Resample in velocity the UV Table or compress it
  !   Support for commands
  !     UV_RESAMPLE NC [Ref Val Inc]
  !     UV_COMPRESS NC
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line  ! Command line
  character(len=*), intent(in) :: comm  ! Calling command
  logical, intent(out) :: error         ! Error flag
  !
  character(len=11) :: rname = 'UV_RESAMPLE'
  real, pointer :: duv_previous(:,:), duv_next(:,:)
  character(len=80) :: chain
  character(len=4) :: arg(4)
  real(8) :: convert(3), velo
  integer :: nt, nc, nchan, na
  type (gildas) :: uvout
  integer :: nu, nv, ni, i
  !
  if (huv%loca%size.eq.0) then
    call map_message(seve%e,'UV_MAP','No UV data loaded')
    error = .true.
    return
  endif
  !
  error = .false.
  ! No argument: get back to the original UV data
  if (sic_narg(0).eq.0) then
    call uv_reset_buffer(rname)
    do_weig = .true.
    return
  endif
  !
  ! Compute the Frequency Conversion from the Velocity Conversion
  call gildas_null(uvout, type = 'UVT')
  call gdf_copy_header(huv,uvout,error)
  !
  if (comm.eq.'UV_RESAMPLE') then
    nc = 0
    !    SIC__CH would complain if argument is too long, SIC_KE is silent
    call sic_ke(line,0,1,arg(1),na,.true.,error)
    error = .false.
    if (arg(1).ne.'*') call sic_i4(line,0,1,nc,.true.,error)
    if (error) return
    !
    ! Set default resampling in Velocity
    convert(1) = huv%gil%ref(1)
    convert(2) = huv%gil%voff
    convert(3) = huv%gil%vres
    ! Get new one
    do i=2,sic_narg(0)
      call sic_ke(line,0,i,arg(i),na,.false.,error)
      error = .false.
      if (arg(i).ne.'*') call sic_r8(line,0,i,convert(i-1),.false.,error)
      if (error) return
    enddo
    !
    ! Fill missing arguments
    if (nc.eq.0) then
      nc = nint(abs(huv%gil%nchan*huv%gil%vres/convert(3)))
      if (arg(2).eq.'*') then
        ! Keep the middle channel in the middle
        velo = (0.5d0*huv%gil%nchan-huv%gil%ref(1))*huv%gil%vres + huv%gil%voff
        convert(1) = 0.5d0*nc - (velo-convert(2))/convert(3)
      endif
    endif
    !
    call getuv_conversion(uvout,nc,convert)
    !
  else if (comm.eq.'UV_COMPRESS') then
    call sic_i4(line,0,1,nc,.true.,error)
    if (error) return
    if (nc.gt.huv%gil%nchan) nc = huv%gil%nchan
    write(chain,'(A,I6,A)') 'Averaging by chunks of ',nc,' channels'
    call map_message(seve%i,comm,chain)
    uvout%gil%inc(1) = uvout%gil%inc(1)*nc
    uvout%gil%ref(1) = (2.0d0*uvout%gil%ref(1)+nc-1.0)/(2*nc)
    uvout%gil%vres = nc*uvout%gil%vres
    uvout%gil%fres = nc*uvout%gil%fres
    ! Change the number of channels
    uvout%gil%nchan = uvout%gil%nchan/nc
  else
    call map_message(seve%e,rname,'Unrecognized choice '//comm)
    error = .true.
    return
  endif
  !
  ! Work with complete structure
  uvout%gil%dim(1) = 3*uvout%gil%nchan + 7 + uvout%gil%ntrail ! and nothing more ?...
  if (uvout%gil%ntrail.ne.0) then
    do i=1,code_uvt_last
      if (uvout%gil%column_pointer(i).gt.uvout%gil%lcol) uvout%gil%column_pointer(i) =  &
        & uvout%gil%column_pointer(i) + uvout%gil%dim(1) - huv%gil%dim(1)
    enddo
  endif
  !
  ni = huv%gil%dim(1)
  nu = uvout%gil%dim(1)
  nv = uvout%gil%dim(2)
  nt = uvout%gil%ntrail
  nchan = uvout%gil%nchan
  !
  ! Prepare appropriate array...
  ! Prepare appropriate array...
  nullify (duv_previous, duv_next)
  call uv_find_buffers (comm,nu,nv,duv_previous, duv_next,error)
  if (error) then
    call map_message(seve%e,comm,'Cannot set buffer pointers')
    return
  endif
  !
  ! Now resample
  if (comm.eq.'UV_RESAMPLE') then
    call resample_uv (huv,uvout,duv_previous,duv_next,nt)
  else if (comm.eq.'UV_COMPRESS') then
    call compress_uv (duv_next,nu,nv,nchan,duv_previous,ni,nc,nt)
  endif
  !
  ! Set header
  call gdf_copy_header(uvout,huv,error)
  !
  ! Reset proper pointers
  call uv_clean_buffers (duv_previous, duv_next,error)
  if (error) return
  !
  if (allocated(duvt)) deallocate (duvt)            ! UV data not plotted
  uv_plotted = .false.
  !
  ! Indicate optimization and save status
  optimize(code_save_uv)%change = optimize(code_save_uv)%change + 1
  save_data(code_save_uv) = .true.
  do_weig = .true.  ! Recompute weight
  !
  ! Redefine SIC variables 
  call sic_delvariable ('UV',.false.,error)
  call sic_mapgildas ('UV',huv,error,duv) 
end subroutine uv_resample_comm
!
