module ast_horizon
! Old horizon.inc
      integer(kind=4), parameter :: m_horiz=9
      integer(kind=4), parameter :: m_source=1000
!
      real(kind=8) :: horiz(m_horiz), rise(m_source, m_horiz)
      real(kind=8) :: set (m_source, m_horiz), transit(m_source)
      real(kind=8) :: declin(m_source), righta(m_source),dsun(m_source)
      real(kind=8) :: sunriz(4),sunset(4),moonphse, moonmag
      integer(kind=4) :: n_horiz, next_source(2), n_rise
      logical :: airmass, night_mark
!
      character(len=36) :: c_rise(m_source)
      integer(kind=4) :: min_elev(m_source)
!
      type :: astro_source_mem
        integer(kind=4)   :: soukind
        character(len=32) :: name
        character(len=2)  :: coord
        real(kind=4)   :: equinox
        real(kind=8)      :: lambda  ! radians
        real(kind=8)      :: beta  ! radians
        character(len=2)  :: vtype
        real(kind=8) :: velocity
        real(kind=8) :: redshift
      end type astro_source_mem
!
! Old projec.inc
      character(len=4) :: c_proj(m_source)
      character(len=8) :: c_freq(m_source)
      character(len=4) :: c_weig(m_source)
end module ast_horizon
!
module ast_line
! PDBI/ALMA receiver/correlator setup
      integer(kind=4) :: pdbi_year
      integer(kind=4) :: alma_cycle
! NOEMA mode (ONLINE or OFFLINE)
      character(len=8) :: noema_mode
!
! spurious lines
      real(kind=8) :: flo1ref
      logical :: do_spurious
!
! correlator setup
      logical :: narrow_def
      integer(kind=4) :: narrow_input(2)
      integer(kind=4), parameter :: nunit=8
      logical :: unit_def(nunit)
      integer(kind=4) :: unit_band(nunit)
      real(kind=4) :: unit_cent(nunit)
      integer(kind=4) :: unit_wind(nunit)
      integer(kind=4) :: unit_bmode(nunit)
!
! ALMA correlator setup
      logical :: bb_def(4)
      real(kind=4) :: bb_cfreq(4)
      integer(kind=4) :: bb_sideband(4)
      integer(kind=4) :: bb_nspw(4)
      real(kind=4) :: tolerance_freq
!
      integer(kind=4) :: maxsp
      parameter(maxsp=40)
      real spw_width(4,maxsp)
      real spw_cfreq(4,maxsp)
      integer spw_polar(4,maxsp)
      real spw_use(4,maxsp)
      integer spw_sideband(4,maxsp)
!---------------------------------------------
!
! Molecules
      integer nmol
    integer, parameter :: mmol=1000
      character(len=20) molname(mmol)
      real(8) molfreq(mmol)
      real(4) width
!------------------------------------
!
! plot
      real(8) flo1
      integer plot_mode
      real(4) iflim(2), userlim(2)
      integer sky
      character(len=132) label
!
! for plot /atmosphere
      logical do_atmplot
      real plotwater
!
! for print command
      character(len=80) linecomm
      integer recband
end module

module ast_constant
    real(kind=8),  parameter :: pi=3.141592653589793d0
    real(kind=8),  parameter ::  halfpi=pi/2d0
    real(kind=8),  parameter :: twopi = pi*2d0
    real(kind=8),  parameter :: j2000 = 2451545.0d0
    real(kind=8),  parameter :: light = 299792.458d0   ! km/s
    real(kind=8),  parameter :: radius=6367.435d0      ! earth radius in kilometers
    real(kind=8), parameter :: astro_nullr8=-1.2345d36
    real(kind=4), parameter :: astro_nullr4=-1.2345e36
    real(kind=8), parameter :: astro_nulli8=-12345678
    real(kind=4), parameter :: astro_nulli4=-12345678
    character(len=4), parameter :: astro_nulla='NULL'
end module

module ast_astro
      logical :: library_mode  ! Astro loaded in Library or Interactive mode?
      !
! astro.inc
      real(kind=8) :: jnow_utc              ! date julienne utc
      real(kind=8) :: jnow_ut1              ! date julienne ut1
      real(kind=8) :: jnow_tdt              ! date julienne tdt
      real(kind=8) :: d_ut1                 ! ut1 - utc (seconds)
      real(kind=8) :: d_tdt                 ! tdt - utc (seconds)
      real(kind=8) :: lst                   ! local "true" sidereal time
      real(kind=8) :: lonlat(2)             ! e-longitude, latitude in degrees
      real(kind=8) :: altitude              ! altitude in kilometers
      real(kind=8) :: xsun_0(3)             ! earth_sun vector, in r0 , in km
      real(kind=8) :: xsun_2(3)             ! sun az-el at current time
      real(kind=8) :: xg_0(3)               ! earth_g vector, in r0 , in km
      real(kind=8) :: vg_0(3)               ! earth_g vector derivative, in r0 , in km/s
      real(kind=8) :: trfm_30(9)            ! matrix r0 to r3
      real(kind=8) :: trfm_20(9)            ! matrix r0 to r2
      real(kind=8) :: trfm_23(9)            ! matrix r3 to r2
      real(kind=8) :: trfm_43(9)            ! matrix r3 to r4
      real(kind=8) :: trfm_05(9)            ! matrix r5 (day ecliptic) to r0 (j2000 ecliptic)
      real(kind=8) :: s_1(2)                ! source reference coords.
      real(kind=8) :: azimuth, elevation    ! horizontal coords
      real(kind=8) :: ra, dec               ! present_day equatorial coords
      real(kind=8) :: parallactic_angle     ! parallactic angle
      real(kind=8) :: azimuth_old, elevation_old  ! horizontal coords
      real(kind=8) :: ra_old, dec_old       ! present_day equatorial coords
      real(kind=8) :: slimit                ! sun avoidance radius
      real(kind=8) :: fshift                ! frequency ratio due to doppler effect
      real(kind=8) :: freq                  ! frequency (rest) in ghz
      real(kind=8) :: primbeam              ! telescope primary beam width in radian (value used in computations)
      real(kind=8) :: velocity              ! source velocity
      real(kind=8) :: redshift              ! source redshift
      real(kind=4) :: z_axis
      logical :: projection
      integer(kind=4) :: name_out
      character(len=36) :: source_name
      ! Possible values for sourcetype
      integer(kind=4), parameter :: msoukind=4
      integer(kind=4), parameter :: soukind_none=1      ! no source defined
      integer(kind=4), parameter :: soukind_full=2      ! source defined, full computations
      integer(kind=4), parameter :: soukind_vlsr=3      ! use only LSR
      integer(kind=4), parameter :: soukind_red=4      ! use only Redshift
      character(len=12), parameter ::soukinds(msoukind)= (/ 'NO SOURCE   ','ASTRO SOURCE', &
                                                            'LSR         ','REDSHIFT    ' /)
      integer(kind=4) :: soukind=soukind_none
!
! Support for ASTRO%SOURCE% variable
      character(len=60) :: source_alpha, source_delta
      real(kind=8):: source_az, source_el
      real(kind=8):: source_ra, source_dec
      character(len=36) :: astro_source_name
      real(kind=8) :: source_vlsr, source_dop, source_vshift, source_lsr
      real(kind=8) :: source_redshift
! Support for ASTRO%SOURCE%IN variable
      character(len=2)  :: source_incoord
      character(len=2)  :: source_invtype
      character(len=14) :: source_inbetasexa,source_inlambdasexa
      real(kind=4)      :: source_ineq
      real(kind=8)      :: source_invelocity,source_inredshift
!       Planet stuff
      real(kind=4) :: planet_tmb            ! planet main beam brightness
      real(kind=4) :: planet_flux           ! planet flux
      real(kind=4) :: planet_size(3)        ! planet size
!
      character(len=2) :: z_axis_type
      character(len=12) :: frame           ! 'horizontal','equatorial' display
      character(len=128) :: catalog_name(2) ! for sources
      character(len=1) :: azref
      character(len=2) :: vtype           ! velocity system ('ls', 'ea', 'he','re')
      character(len=16) :: obsname         ! observatory name
!
! For plots
      integer(kind=4) :: msplot, nsplot
      parameter (msplot=2000)
      real(kind=8) :: xsplot(msplot), ysplot(msplot), zsplot(msplot)
      character(len=36) :: splot(msplot)
      character(len=80) :: ccplot(msplot)

end module ast_astro
!
module atm_params
  !---------------------------------------------------------------------
  ! ATM input and output parameters.
  ! For portability, SAVE Fortran variables which are target of SIC
  ! variables.
  !---------------------------------------------------------------------
  real(kind=4), save :: t0,p0,p1,h0,water,airmass
  real(kind=4), save :: freqs,freqi,feff,trec,gim,tsys,tant
  real(kind=4), save :: tauox,tauw,taut,temis,temii,paths,pathi,tatms,tatmi
  logical, save :: atm_initdone=.false.
  !
  ! Noise information
  real(kind=4) :: bandwidth
  real(kind=4) :: jy_per_k
  real(kind=4) :: inttime
  real(kind=4) :: uvweight
end module atm_params
