      PROGRAM TRUE_COLOR
      USE GILDAS_DEF
      USE GKERNEL_INTERFACES
      USE GBL_FORMAT
C----------------------------------------------------------------------
C GILDAS
C	A dedicated routine to produce bipolar outflow maps
C	Input : a VLM cube (N by NX by NY)
C	Output : a cube (3 by NX by NY) containing the maps of the
C		width and of the red and blue lobes
C	Method :
C		For each spectrum, determines the peak channel,
C	then determines on each side of this channel the velocity
C	at a given threshold. From this velocity, integrates out
C	to a second threshold. The area found is the contribution
C	to the blue (or red) lobe of the flow.
C S.Guilloteau 12-Nov-1986
C----------------------------------------------------------------------
      INCLUDE 'gbl_xpar.inc'
      INCLUDE 'gbl_ypar.inc'
      INCLUDE 'gbl_memory.inc'
*
      CHARACTER(LEN=FILENAME_LENGTH) NAMEX,NAMEY
      LOGICAL ERROR
      REAL*8 VELO(4)
      INTEGER LENC
      INTEGER N
      INTEGER(KIND=INDEX_LENGTH) BLC(4), TRC(4)
      INTEGER(KIND=ADDRESS_LENGTH) IPX, IPY, WORK, GAG_POINTER
      DATA BLC/4*0/, TRC/4*0/
*
      CALL GILDAS_OPEN
      CALL GILDAS_CHAR('IN$',NAMEY)
      CALL GILDAS_CHAR('OUT$',NAMEX)
      CALL GILDAS_DBLE('VELOCITIES$',VELO,4)
      CALL GILDAS_CLOSE
*
* Open first input map, the one to be placed in Y place
      N = LENC(NAMEY)
      IF (N.EQ.0) GOTO 100
      CALL SIC_PARSEF(NAMEY(1:N),Y_FILE,' ','.gdf')
      CALL GDF_GEIS (Y_ISLO,ERROR)
      IF (.NOT.ERROR) CALL
     &GDF_REIS (Y_ISLO,Y_TYPE,Y_FILE,Y_FORM,Y_SIZE,ERROR)
      IF (ERROR) THEN
         WRITE(6,*) 'F-TRUE_COLOR,  Cannot read input file'
         GOTO 100
      ENDIF
      CALL GDF_READY(Y_ISLO,ERROR)
*
* Same as above for X image
      CALL GDF_CHYX
      N = LENC(NAMEX)
      IF (N.EQ.0) GOTO 100
      CALL SIC_PARSEF(NAMEX(1:N),X_FILE,' ','.gdf')
*
* Modify the requested part of the X Header
      X_DIM(1) = Y_DIM(2)
      X_REF1 = Y_REF2
      X_VAL1 = Y_VAL2
      X_INC1 = Y_INC2
      X_DIM(2) = Y_DIM(3)
      X_REF2 = Y_REF3
      X_VAL2 = Y_VAL3
      X_INC2 = Y_INC3
      X_DIM(3) = 3
      X_REF3 = 1
      X_VAL3 = 1
      X_INC3 = 1
      X_SIZE = X_DIM(1)*X_DIM(2)*X_DIM(3)
      IF (X_PROJ.NE.0) THEN
         X_XAXI = X_XAXI-1
         X_YAXI = X_YAXI-1
      ENDIF
      X_EXTR = 0
* Get work space
      IF (SIC_GETVM(8*X_DIM(1)*X_DIM(2),WORK).NE.1) GOTO 100
*
* Create the image (with write access of course) (CRIS)
      CALL GDF_GEIS (X_ISLO,ERROR)
      CALL GDF_WRITX(X_ISLO,ERROR)
      X_FORM = FMT_R4
      X_SIZE = X_DIM(1)*X_DIM(2)*X_DIM(3)*X_DIM(4)
      IF (.NOT.ERROR) CALL
     &GDF_CRIS (X_ISLO,X_TYPE,X_FILE,X_FORM,X_SIZE,ERROR)
      IF (ERROR) THEN
         WRITE(6,*) 'F-TRUE_COLOR,  Cannot create output image'
         GOTO 100
      ENDIF
*
* Do some useful job
      CALL GDF_GEMS (Y_MSLO,Y_ISLO,BLC,TRC,Y_ADDR,Y_FORM,ERROR)
      CALL GDF_GEMS (X_MSLO,X_ISLO,BLC,TRC,X_ADDR,X_FORM,ERROR)
      IPX = GAG_POINTER(X_ADDR,MEMORY)
      IPY = GAG_POINTER(Y_ADDR,MEMORY)
      CALL SUB_TRUE_COLOR (
     &MEMORY(IPX+2*X_DIM(1)*X_DIM(2)),   ! Address of the X image
     &MEMORY(IPY),                       ! Address of the Z image
     &X_DIM(1),                          ! Dimension of images
     &X_DIM(2),
     &Y_DIM(1),
     &Y_REF1,Y_VAL1,Y_INC1,
     &VELO,
     &X_BVAL,X_EVAL,
     &MEMORY(IPX),MEMORY(IPX+X_DIM(1)*X_DIM(2)) )
      CALL GDF_FRIS (X_ISLO,ERROR)
      CALL GDF_FRIS (Y_ISLO,ERROR)
      CALL GAGOUT ('S-TRUE_COLOR,  Successful completion')
      CALL SYSEXI (1)
*
* Error processing :
100   CALL SYSEXI (FATALE)
      END PROGRAM TRUE_COLOR
*<FF>
      SUBROUTINE SUB_TRUE_COLOR(COLOR,VLM,NX,NY,NV,VREF,VVAL,VINC,
     &VELO,BVAL,EVAL,LOW,HIGH)
C----------------------------------------------------------------------
C
C----------------------------------------------------------------------
      INTEGER NX,NY,NV
      REAL COLOR(NX,NY),VLM(NV,NX,NY),LOW(NX,NY),HIGH(NX,NY)
      REAL BVAL,EVAL
      REAL*8 VREF,VVAL,VINC,VELO(4)
*
      INTEGER I,J,K,NVM,IMIN,IMAX
      REAL*8 RRMIN,RRMAX,RBMIN,RBMAX
      REAL*4 MINHIGH,MAXHIGH,MINLOW,MAXLOW,A,B
*
* Loop over all spectra
      IF (VINC.GT.0.) THEN
         RBMIN = (VELO(1)-VVAL)/VINC+VREF
         RBMAX = (VELO(2)-VVAL)/VINC+VREF
         RRMIN = (VELO(3)-VVAL)/VINC+VREF
         RRMAX = (VELO(4)-VVAL)/VINC+VREF
      ELSE
         RRMAX = (VELO(1)-VVAL)/VINC+VREF
         RRMIN = (VELO(2)-VVAL)/VINC+VREF
         RBMAX = (VELO(3)-VVAL)/VINC+VREF
         RBMIN = (VELO(4)-VVAL)/VINC+VREF
      ENDIF
      IMIN = INT(RBMAX+1.5D0)
      IMAX = INT(RRMIN-0.5D0)
      IF (IMIN.LT.1 .OR. IMAX.GT.NX) THEN
         WRITE (6,*) 'Velocity range ',RBMIN,RBMAX,RRMIN,RRMAX
         STOP 'F-TRUE_COLOR, out of range'
      ENDIF
      NVM = NV/2
      MINLOW = 1E38
      MINHIGH = 1E38
      MAXLOW = -1E38
      MAXHIGH = -1E38
      DO K=1,NY
         DO J=1,NX
            IF (ABS(VLM(NVM,J,K)-BVAL).LE.EVAL) THEN
               LOW(J,K) = 0.0
               HIGH(J,K) = 0.0
            ELSE
               IMIN = INT(RBMIN+1.5D0)
               IMAX = INT(RBMAX-0.5D0)
               LOW(J,K) = (IMIN-0.5D0-RBMIN)*VLM(IMIN-1,J,K)
               DO I=IMIN,IMAX
                  LOW(J,K) = LOW(J,K)+VLM(I,J,K)
               ENDDO
               LOW(J,K) = LOW(J,K)+(RBMAX-IMAX-0.5D0)*VLM(IMAX+1,J,K)
               IMIN = INT(RRMIN+1.5D0)
               IMAX = INT(RRMAX-0.5D0)
               HIGH(J,K) = (IMAX-0.5D0-RRMIN)*VLM(IMIN-1,J,K)
               DO I=IMIN,IMAX
                  HIGH(J,K) = HIGH(J,K)+VLM(I,J,K)
               ENDDO
               HIGH(J,K) = HIGH(J,K)+(RRMAX-IMAX-0.5D0)*VLM(IMAX+1,J,K)
            ENDIF
         ENDDO
      ENDDO
*
      MINHIGH = HIGH(1,1)
      MAXHIGH = HIGH(1,1)
      MINLOW = LOW(1,1)
      MAXLOW = LOW(1,1)
      DO K=1,NY
         DO J=1,NX
            IF (HIGH(J,K).LT.MINHIGH) THEN
               MINHIGH = HIGH(J,K)
            ELSEIF (HIGH(J,K).GT.MAXHIGH) THEN
               MAXHIGH = HIGH(J,K)
            ENDIF
         ENDDO
      ENDDO
      DO K=1,NY
         DO J=1,NX
            IF (LOW(J,K).LT.MINLOW) THEN
               MINLOW = LOW(J,K)
            ELSEIF (LOW(J,K).GT.MAXLOW) THEN
               MAXLOW = LOW(J,K)
            ENDIF
         ENDDO
      ENDDO
      DO K=1,NY
         DO J=1,NX
            IF (LOW(J,K).EQ.0 .AND. HIGH(J,K).EQ.0) THEN
               COLOR(J,K) = 0.0
            ELSE
               A = MIN(INT((LOW(J,K)-MINLOW)/
     &         (MAXLOW-MINLOW)*15),14)+1
               B = MIN(INT((HIGH(J,K)-MINHIGH)/
     &         (MAXHIGH-MINHIGH)*15),14)+1
               COLOR(J,K) = A+15*B
            ENDIF
         ENDDO
      ENDDO
      END
