subroutine display_buffer(comm,line,error)
  use gkernel_interfaces
  use imager_interfaces, only : display_buffer_sub, map_message
  use clean_arrays
  use clean_def
  use clean_types
  use clean_support
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING support routine for command
  !     SHOW Name
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: comm  ! Command (SHOW or VIEW)
  character(len=*), intent(in)  :: line  ! Command line
  logical,          intent(out) :: error ! Logical error flag
  ! Local variables
  integer(kind=size_length) :: locasize
  integer, parameter :: mnoise=2
  integer ntype,nc,is,nnoise
  character argu*12,dtype*12
  character(len=12) :: dnoise
  character(len=6) :: vnoise(mnoise)=['DIRTY ', 'CLEAN ']
  !
  ! Parse input line
  call sic_ke(line,0,1,argu,nc,.true.,error)
  if (error) return
  if (argu.eq.'?') argu = ' '
  call sic_ambigs(comm,argu,dtype,ntype,vtype,mtype,error)
  if (error) return
  !
  ! Special case first
  select case (dtype)
  case ('FIELDS') 
    if (hprim%loca%size.eq.0 .or. comm.eq.'SHOW') then
      if (themap%nfields.eq.0) then
        call map_message(seve%e,comm,'No Mosaic loaded')
        error = .true.
      else
        call exec_program('@ p_plot_fields FIELDS')
      endif
      return
    else
      call create_fields(error)
      if (error) return
      dtype = 'FIELDS'
    endif
  case ('PRIMARY') 
    call create_fields(error)
    if (error) return
    dtype = 'FIELDS'
  case ('SELFCAL')
    is = sic_start(0,2)
    if (is.eq.0) then
      call exec_program('@ p_show_selfcal ')
    else
      call exec_program('@ p_show_selfcal '//line(is:))
    endif
    return
  case ('NOISE')
    if (sic_present(0,2)) then
      call sic_ke(line,0,2,argu,nc,.true.,error)
      if (error) return
      call sic_ambigs(trim(comm)//' NOISE',argu,dnoise,nnoise,vnoise,mnoise,error)
      if (error) return
      if (dnoise.eq.'CLEAN') then
        locasize = hclean%loca%size
      else
        locasize = hdirty%loca%size
      endif
      if (locasize.eq.0) then
        call map_message(seve%e,comm,'No '//trim(dnoise)//' image')
        error = .true.
      else
        call exec_program('@ p_show_noise '//dnoise)
      endif
    else  if (hclean%loca%size.ne.0) then
      call exec_program('@ p_show_noise CLEAN')
    else if (hdirty%loca%size.ne.0) then
      call exec_program('@ p_show_noise DIRTY')
    else
      call map_message(seve%e,comm,'No CLEAN or DIRTY image')
      error = .true.
    endif
    return
  case ('SUPPORT') 
    if (supportpol%ngon.ge.2) call greg_poly_plot(supportpol,error) 
    return 
  case default
    continue
  end select
  !
  ! Display the buffer
  call display_buffer_sub(comm,ntype,dtype,line,error)
  if (sic_lire().eq.0) call sic_insert(line)
  !
end subroutine display_buffer
!
subroutine display_buffer_sub(comm,ntype,dtype,line,error)
  use gkernel_interfaces
  use imager_interfaces, only : display_uv
  use clean_types
  use clean_arrays
  !----------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER support routine for command
  !     SHOW or VIEW Name
  !
  !----------------------------------------------------------------------
  character(len=*), intent(in) :: comm
  integer, intent(in)  :: ntype ! Buffer type
  logical, intent(out) :: error ! Logical error flag
  character(len=*), intent(in) :: dtype
  character(len=*), intent(in) :: line
  !
  character(len=40) :: argu1,argu2,c_more,chain
  integer :: nc,first,last,ic
  logical :: do_dirty
  character(len=12) :: xtype,ytype
  !
  ! Load into SIC buffer
  if (comm.eq.'SHOW' .and. ntype.eq.1) then
    !
    ! SHOW Coverage
    call sic_get_inte('FIRST',first,error)
    call sic_get_inte('LAST',last,error)
    call sic_get_char('XTYPE',xtype,nc,error)
    call sic_get_char('YTYPE',ytype,nc,error)
    call sic_let_char('XTYPE','u',error)
    call sic_let_char('YTYPE','v',error)
    if (first.eq.0 .and. last.eq.0) then
      ic = huv%gil%nchan/3
      call sic_let_inte('FIRST',nc,error)
      call sic_let_inte('LAST',nc,error)
    endif
    chain = 'UV'
    call display_uv (chain,error)
    call sic_let_char('XTYPE',xtype,error)
    call sic_let_char('YTYPE',ytype,error)
    call sic_let_inte('FIRST',first,error)
    call sic_let_inte('LAST',last,error)
    return
  endif
  !
  ! Plot SIC buffer with adequate plotting procedure
  if (comm.eq.'SHOW' .or. comm.eq.'UV_FLAG') then
    if (dtype.eq.'UV') then
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = dtype//' '//trim(argu1)//' '//trim(argu2)
       call display_uv(chain,error)
    else if (dtype.eq.'CCT') then
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       call exec_program('@ p_show_cct cct '//argu1)
    else
       c_more = ' '
       call sic_get_logi('DO_DIRTY',do_dirty,error)
       if (do_dirty) then
         c_more = 'BEAM'
       endif
       !
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = dtype//trim(c_more)//' '//trim(argu1)//' '//trim(argu2)
       call exec_program('@ p_show_map '//chain)
    endif
  else if (comm.eq.'VIEW') then
    if (dtype.eq.'UV') then
       continue
    else if (dtype.eq.'CCT') then
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = dtype//trim(argu1)//' '//trim(argu2)
       call exec_program('@ p_view_cct '//chain)
    else
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = dtype//trim(argu1)//' '//trim(argu2)
       call exec_program('@ p_view_map '//chain)
    endif
  endif
  !
end subroutine display_buffer_sub
!
subroutine create_fields(error)
  use gkernel_interfaces
  use clean_arrays
  use clean_types
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING internalroutine for command
  !     Create the FIELDS array (transposed version of the PRIMARY array)
  !----------------------------------------------------------------------
  logical, intent(out) :: error
  ! Local variables
  !
  character(len=4) :: code
  integer(kind=index_length) :: nfirst,nsecon,nmiddl,nelems,nlast,iblock(5)
  integer :: ier
  !
  if (hprim%loca%size.eq.0) then
    error = .true.
    return
  endif
  error = .false.
  !
  ! If it is allocated, it should be the right one, but play safe...
  if (allocated(dfields)) then
    if (hfields%loca%size.eq.hprim%loca%size) return
    call sic_delvariable('FIELDS',.false.,error)
    deallocate(dfields)
  endif
  call gildas_null(hfields)
  !
  code = '231'
  call gdf_transpose_header(hprim,hfields,code,error)
  ! Determine chunk sizes from code and dimensions.
  call transpose_getblock(hprim%gil%dim,gdf_maxdims,code,iblock,error)
  if (error) return
  !
  ! With only one beam per frequency so far
  if (.not.allocated(dfields)) then
    allocate(dfields(hprim%gil%dim(2),hprim%gil%dim(3),hprim%gil%dim(1),hprim%gil%dim(4)),stat=ier)
    if (ier.ne.0) then
      error = .true.
      return
    endif
  endif
  !
  nelems = iblock(1)
  nfirst = iblock(2)
  nmiddl = iblock(3)
  nsecon = iblock(4)
  nlast  = iblock(5)
  call trans4all(dfields,dprim,nelems,nfirst,nmiddl,nsecon,nlast)
  !
  ! Set Type of First Axis
  hfields%gil%inc(3) = 1.0
  hfields%char%code(3) = 'FIELD'
  call sic_mapgildas ('FIELDS',hfields,error,dfields)
  !
end subroutine create_fields
