!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeformats_engine_types
  use cube_types
  use cubeformats_uv
  !---------------------------------------------------------------------
  ! Support module for registering the supported node types, and
  ! provide their identifying codes
  !---------------------------------------------------------------------
  !
  integer(kind=4), protected :: code_ftype_cube=0  ! cube_t identifier in the DAG (initialized at init)
  integer(kind=4), protected :: code_ftype_uv=0    ! uv_t identifier in the DAG (initialized at init)
  !
  public :: code_ftype_cube
  public :: code_ftype_uv
  public :: cubeformats_types_register
  private
  !
contains
  !
  subroutine cubeformats_types_register(cubset,error)
    use cubetools_setup_types
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    type(cube_setup_t), intent(in)    :: cubset
    logical,            intent(inout) :: error
    !
    call cubeformats_cube_register(cubset,code_ftype_cube,error)
    if (error)  return
    call cubeformats_uv_register(cubset,code_ftype_uv,error)
    if (error)  return
  end subroutine cubeformats_types_register
  !
end module cubeformats_engine_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
