!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeuv_language
  use cubetools_structure
  use cubeuv_messaging
  !
  use cubeuv_table2image
  !
  public :: cubeuv_register_language
  private
  !
  integer(kind=lang_k) :: langid
  !
contains
  !
  subroutine cubeuv_register_language(error)
    !----------------------------------------------------------------------
    ! Register the UV\ language
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    call cubetools_register_language('UV',&
         'J.Pety, S.Bardeau',&
         'Commands to work on uv tables',&
         'gag_doc:hlp/cube-help-ima.hlp',& !***JP: Shall it be a different name
         cubeuv_execute_command,langid,error)
    if (error) return
    !
    call table2image%register(error)
    if (error) return
    !
    call cubetools_register_dict(error)
    if (error) return
  end subroutine cubeuv_register_language
  !
  subroutine cubeuv_execute_command(line,comm,error)
    use cubeadm_opened
    use cubeadm_timing
    !----------------------------------------------------------------------
    ! Execute a command of the UV\ language
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    character(len=*), intent(in)    :: comm
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXECUTE>COMMAND'
    !
    error = .false.
    if (comm.eq.'UV?') then
       call cubetools_list_language_commands(langid,error)
       if (error) return
    else
       call cubeadm_timing_init()
       call cubetools_execute_command(line,langid,comm,error)
       if (error) continue ! To ensure error recovery in the call to finalize_all
       call cubeadm_finish_all(comm,line,error)
       if (error) continue ! To ensure error recovery in timing
       call cubeadm_timing_final(comm)
    endif
  end subroutine cubeuv_execute_command
end module cubeuv_language
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
