!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubestatistics_mean
  use cubestatistics_one2two_real_template
  use cubestatistics_messaging
  !
  public :: cubestatistics_mean_register
  private
  !
  type(one2two_real_comm_t) :: mean
  !
contains
  !
  subroutine cubestatistics_mean_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='MEAN>REGISTER'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call mean%register_syntax(&
         'MEAN',cubestatistics_mean_command,&
         'mean',[flag_mean,flag_image],&
         'rms', [flag_rms ,flag_image],&
         error)
    if (error) return
    call mean%register_act(cubestatistics_mean_prog_act,error)
    if (error) return
  end subroutine cubestatistics_mean_register
  !
  subroutine cubestatistics_mean_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(one2two_real_user_t) :: user
    character(len=*), parameter :: rname='MEAN>COMMAND'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call mean%parse(line,user,error)
    if (error) return
    call mean%main(user,error)
    if (error) continue
  end subroutine cubestatistics_mean_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubestatistics_mean_prog_act(prog,ie,spectrum,spemean,sperms,error)
    use cubetools_parameters
    use cubetools_nan
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2two_real_prog_t), intent(inout) :: prog
    integer(kind=entr_k),       intent(in)    :: ie
    type(spectrum_t),           intent(inout) :: spectrum
    type(spectrum_t),           intent(inout) :: spemean
    type(spectrum_t),           intent(inout) :: sperms
    logical,                    intent(inout) :: error
    !
    real(kind=sign_k) :: xval,yval
    real(kind=sign_k) :: num,den
    integer(kind=chan_k) :: if,il,iz
    integer(kind=chan_k), parameter :: one=1
    character(len=*), parameter :: rname='MEAN>PROG>ACT'
    !
    call spectrum%get(ie,error)
    if (error) return
    if = prog%region%iz%first
    il = prog%region%iz%last
    num = 0
    den = 0
    do iz=if,il
       xval = spectrum%x%val(iz)
       yval = spectrum%y%val(iz)
       if (ieee_is_finite(yval)) then
          num = num+yval*xval
          den = den+yval
       endif
    enddo ! iz
    if (den.ne.0) then
       spemean%y%val(one) = num/den
       sperms%y%val(one) = num/den
    else
       spemean%y%val(one) = gr4nan
       sperms%y%val(one) = gr4nan
    endif
    call spemean%put(ie,error)
    if (error) return
    call sperms%put(ie,error)
    if (error) return
  end subroutine cubestatistics_mean_prog_act
end module cubestatistics_mean
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
