!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_topology
  use cubetools_parameters
  use cubemain_messaging
  use cube_types
  !
  type channel_t
     integer(kind=chan_k) :: first = 0
     integer(kind=chan_k) :: last  = 0
     integer(kind=chan_k) :: nc    = 0
  end type channel_t
  !
contains
  !
  subroutine cubemain_topo_vrange2crange(cube,vrange,crange,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(in)    :: vrange(2)
    integer(kind=chan_k),intent(out)   :: crange(2)
    logical,             intent(inout) :: error
    !
    integer(kind=chan_k) :: irange(2)
    character(len=*), parameter :: rname='TOPO>VRANGE2CRANGE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (cube%head%spe%inc%v.ne.0) then
       irange = nint(cube%head%spe%ref%c+(vrange-cube%head%spe%ref%v)/cube%head%spe%inc%v)
       crange(1) = max(min(irange(1),irange(2)),1)
       crange(2) = min(max(irange(1),irange(2)),cube%head%arr%n%c)
    else
       error = .true.
    endif
  end subroutine cubemain_topo_vrange2crange
  !
  subroutine cubemain_topo_channel2velocity(cube,rchannel,velocity,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(in)    :: rchannel
    real(kind=coor_k),   intent(out)   :: velocity
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='TOPO>CHANNEL2VELOCITY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    velocity = cube%head%spe%ref%v + cube%head%spe%inc%v * (rchannel-cube%head%spe%ref%c)
  end subroutine cubemain_topo_channel2velocity
  !
  subroutine cubemain_topo_velocity2channel(cube,velocity,ichannel,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(in)    :: velocity
    integer(kind=chan_k),intent(out)   :: ichannel
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='TOPO>VELOCITY2CHANNEL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (cube%head%spe%inc%v.ne.0) then
       ichannel = nint(cube%head%spe%ref%c+(velocity-cube%head%spe%ref%v)/cube%head%spe%inc%v)
    else
       error = .true.
    endif
  end subroutine cubemain_topo_velocity2channel
  !
  subroutine cubemain_topo_velocity2rchannel(cube,velocity,rchannel,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(in)    :: velocity
    real(kind=coor_k),   intent(out)   :: rchannel
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='TOPO>VELOCITY2CHANNEL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (cube%head%spe%inc%v.ne.0) then
       rchannel = cube%head%spe%ref%c+(velocity-cube%head%spe%ref%v)/cube%head%spe%inc%v
    else
       error = .true.
    endif
  end subroutine cubemain_topo_velocity2rchannel
  !
  subroutine cubemain_topo_set_channel(line,opt,iarg,cube,range,error)
    use cubetools_structure
    !----------------------------------------------------------------------
    ! Not used
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    integer(kind=4),  intent(in)    :: iarg
    type(cube_t),     intent(in)    :: cube
    type(channel_t),  intent(out)   :: range
    logical,          intent(inout) :: error
    !
    integer(kind=chan_k) :: nc,first,last
    integer(kind=4) :: narg
    logical :: present
    character(len=*), parameter :: rname='TOPO>SET>CHANNEL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    nc = cube%head%arr%n%c
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       narg = opt%getnarg()
       if (narg.ge.1) then
          call cubetools_getarg(line,opt,iarg,first,mandatory,error)
          if (error) return
          if (narg.gt.1) then
             call cubetools_getarg(line,opt,iarg+1,last,mandatory,error)
             if (error) return
          else
             last = first
          endif
       else
          first = 1
          last = nc
       endif
       range%first = max(min(first,last),1)
       range%last  = min(max(first,last),nc)
       range%nc = range%last-range%first+1
    else
       range%first = 1
       range%last  = nc
       range%nc    = nc
    endif
  end subroutine cubemain_topo_set_channel
  !
  subroutine cubemain_topo_vminvmax(cube,vmin,vmax,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(out)   :: vmin
    real(kind=coor_k),   intent(out)   :: vmax
    logical,             intent(inout) :: error
    !
    if (cube%head%spe%inc%v.gt.0) then
       call cubemain_topo_channel2velocity(cube,0.5d0,vmin,error)
       if (error) return
       call cubemain_topo_channel2velocity(cube,cube%head%arr%n%c+0.5d0,vmax,error)
       if (error) return
    else
       call cubemain_topo_channel2velocity(cube,0.5d0,vmax,error)
       if (error) return
       call cubemain_topo_channel2velocity(cube,cube%head%arr%n%c+0.5d0,vmin,error)
       if (error) return
    endif
  end subroutine cubemain_topo_vminvmax
  !
  subroutine cubemain_topo_channel2frequency(cube,rchannel,frequence,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(in)    :: rchannel
    real(kind=coor_k),   intent(out)   :: frequence
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='TOPO>CHANNEL2FREQUENCY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    frequence = cube%head%spe%ref%f + cube%head%spe%inc%f * (rchannel-cube%head%spe%ref%c)
  end subroutine cubemain_topo_channel2frequency
  !
  subroutine cubemain_topo_frequency2channel(cube,frequency,ichannel,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(in)    :: frequency
    integer(kind=chan_k),intent(out)   :: ichannel
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='TOPO>FREQUENCY2CHANNEL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (cube%head%spe%inc%v.ne.0) then
       ichannel = nint(cube%head%spe%ref%c+(frequency-cube%head%spe%ref%f)/cube%head%spe%inc%f)
    else
       error = .true.
    endif
  end subroutine cubemain_topo_frequency2channel
  !
  subroutine cubemain_topo_fminfmax(cube,fmin,fmax,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(cube_t),        intent(in)    :: cube
    real(kind=coor_k),   intent(out)   :: fmin
    real(kind=coor_k),   intent(out)   :: fmax
    logical,             intent(inout) :: error
    !
    if (cube%head%spe%inc%f.gt.0) then
       call cubemain_topo_channel2frequency(cube,0.5d0,fmin,error)
       if (error) return
       call cubemain_topo_channel2frequency(cube,cube%head%arr%n%c+0.5d0,fmax,error)
       if (error) return
    else
       call cubemain_topo_channel2frequency(cube,0.5d0,fmax,error)
       if (error) return
       call cubemain_topo_channel2frequency(cube,cube%head%arr%n%c+0.5d0,fmin,error)
       if (error) return
    endif
  end subroutine cubemain_topo_fminfmax
end module cubemain_topology
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
