subroutine gag_diff_char(caller,secname,secwarned,elemname,a,b)
  use gbl_message
  use gmath_interfaces, except_this=>gag_diff_char
  !---------------------------------------------------------------------
  ! @ public-generic gag_diff_elem
  ! Returns a message if the two elements a and b differ.
  ! If the elements are part of a larger section (name section), a
  ! warning about the section is also issued if not yet done.
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: caller
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  character(len=*), intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call gmath_message(seve%r,caller,secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call gmath_message(seve%r,caller,mess)
  !
10 format(2X,A,T32,A,T52,A)
end subroutine gag_diff_char
!
subroutine gag_diff_inte(caller,secname,secwarned,elemname,a,b)
  use gbl_message
  use gmath_interfaces, except_this=>gag_diff_inte
  !---------------------------------------------------------------------
  ! @ public-generic gag_diff_elem
  ! Returns a message if the two elements a and b differ.
  ! If the elements are part of a larger section (name section), a
  ! warning about the section is also issued if not yet done.
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: caller
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  integer(kind=4),  intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call gmath_message(seve%r,caller,secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call gmath_message(seve%r,caller,mess)
  !
10 format(2X,A,T32,I0,T52,I0)
end subroutine gag_diff_inte
!
subroutine gag_diff_long(caller,secname,secwarned,elemname,a,b)
  use gbl_message
  use gmath_interfaces, except_this=>gag_diff_long
  !---------------------------------------------------------------------
  ! @ public-generic gag_diff_elem
  ! Returns a message if the two elements a and b differ.
  ! If the elements are part of a larger section (name section), a
  ! warning about the section is also issued if not yet done.
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: caller
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  integer(kind=8),  intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (a.eq.b)  return
  !
  if (.not.secwarned) then
    call gmath_message(seve%r,caller,secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call gmath_message(seve%r,caller,mess)
  !
10 format(2X,A,T32,I0,T52,I0)
end subroutine gag_diff_long
!
subroutine gag_diff_real(caller,secname,secwarned,elemname,a,b)
  use gbl_message
  use gmath_interfaces, except_this=>gag_diff_real
  !---------------------------------------------------------------------
  ! @ public-generic gag_diff_elem
  ! Returns a message if the two elements a and b differ (with some
  ! machine tolerance).
  ! If the elements are part of a larger section (name section), a
  ! warning about the section is also issued if not yet done.
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: caller
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  real(kind=4),     intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (nearly_equal(a,b,1.e-6))  return
  !
  if (.not.secwarned) then
    call gmath_message(seve%r,caller,secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call gmath_message(seve%r,caller,mess)
  !
10 format(2X,A,T32,1PG12.5,T52,1PG12.5)
  !
contains
  !
  function nearly_equal(a,b,eps)
    logical :: nearly_equal
    real(kind=4), intent(in) :: a,b
    real(kind=4), intent(in) :: eps  ! Acceptable relative difference
    ! Local
    real(kind=4) :: diff
    !
    if (a.eq.b) then
      nearly_equal = .true.
      return
    endif
    !
    diff = abs(a-b)
    if (a.eq.0. .or. b.eq.0. .or. diff.lt.tiny(a)) then
      ! a or b is zero or both are extremely close to it. Note the use
      ! of tiny() which returns the smallest floating point number
      ! representable without being a denormal number.
      ! Relative error is less meaningful here
      nearly_equal = diff.lt.eps*tiny(a)
      return
    endif
    !
    ! Use relative error. Note this test is commutative
    nearly_equal = diff/(abs(a)+abs(b)).lt.eps
    !
  end function nearly_equal
  !
end subroutine gag_diff_real
!
subroutine gag_diff_dble(caller,secname,secwarned,elemname,a,b)
  use gbl_message
  use gmath_interfaces, except_this=>gag_diff_dble
  !---------------------------------------------------------------------
  ! @ public-generic gag_diff_elem
  ! Returns a message if the two elements a and b differ (with some
  ! machine tolerance).
  ! If the elements are part of a larger section (name section), a
  ! warning about the section is also issued if not yet done.
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: caller
  character(len=*), intent(in)    :: secname
  logical,          intent(inout) :: secwarned
  character(len=*), intent(in)    :: elemname
  real(kind=8),     intent(in)    :: a,b
  ! Local
  character(len=message_length) :: mess
  !
  if (nearly_equal(a,b,1.d-14))  return
  !
  if (.not.secwarned) then
    call gmath_message(seve%r,caller,secname//' sections differ')
    secwarned = .true.
  endif
  !
  write(mess,10)  elemname,a,b
  call gmath_message(seve%r,caller,mess)
  !
10 format(2X,A,T32,1PG19.12,T52,1PG19.12)
  !
contains
  !
  function nearly_equal(a,b,eps)
    logical :: nearly_equal
    real(kind=8), intent(in) :: a,b
    real(kind=8), intent(in) :: eps  ! Acceptable relative difference
    ! Local
    real(kind=8) :: diff
    !
    if (a.eq.b) then
      nearly_equal = .true.
      return
    endif
    !
    diff = abs(a-b)
    if (a.eq.0. .or. b.eq.0. .or. diff.lt.tiny(a)) then
      ! a or b is zero or both are extremely close to it. Note the use
      ! of tiny() which returns the smallest floating point number
      ! representable without being a denormal number.
      ! Relative error is less meaningful here
      nearly_equal = diff.lt.eps*tiny(a)
      return
    endif
    !
    ! Use relative error. Note this test is commutative
    nearly_equal = diff/(abs(a)+abs(b)).lt.eps
    !
  end function nearly_equal
end subroutine gag_diff_dble
