###########################################################################
#
# This file defines useful bash functions for GILDAS/USERS interaction
# at IRAM Grenoble.
#
# Warnings:
#
#   This files is loaded very early in the logging process.
#   You thus must put here only fonction and variable definitions.
#
#   Forbidden stuffs: 
#      1. DISPLAY and KEYBOARD related variable definitions.
#      2. Any executable commands.
#
# J.Pety and P.Dumontroty 2004
#
###########################################################################
#
# This function loads the GILDAS environment of the corresponding version.
# Type "gagiram -h" for more details. 
#
function gagiram() { 
    export gaghome=~gildas/gildas
    source $gaghome/gildas-admin/source-gag.sh "$@"
    set --
    if [ -f ~gildas/bin/set-iram-gag-search-path ]; then
        source ~gildas/bin/set-iram-gag-search-path
    fi
}
#
function gagiramgit() { 
    # Non-public function which loads Gildas compiled from git
    export gaghome=~gildas/gildas-git
    source $gaghome/gildas-admin/source-gag.sh "$@"
    set --
    if [ -f ~gildas/bin/set-iram-gag-search-path ]; then
        source ~gildas/bin/set-iram-gag-search-path
    fi
}
#
# This function enables easy browsing of the GILDAS source or executable 
# tree. $gagsrcdir and $gagexedir must be defined. You can use 
# "gagiram -ms" or "gagiram -me" to define them. 
# Type "go -h" for more details.
#
function go() {
    if [ -z "$gagadmdir" ]; then
	echo 'Please select first a GILDAS version using gagiram' 1>&2
    else
	source $gagadmdir/go.sh "$@"
    fi
}
#
# Shortcut for parallel version compiled at IRAM. This hides details
# about compiler (kind and version) and config used:
function gagpara() {
    gagiram -c gfortran81 -o openmp "$@"
}
#
# Shortcut for profiling version compiled at IRAM. This hides details
# about compiler (kind and version) and config used:
function gagprofile() {
    gagiram -c gfortran81 -o profile "$@"
}
#
# Shortcut for sanitizer version compiled at IRAM. This hides details
# about compiler (kind and version) and config used:
function gagsanitize() {
    gagiram -c gfortran81 -o sanitize "$@"
}
#
# GIT public shortcuts
function gitiram() {  # Default is parallel version
    gagiramgit -c gfortran81 -o openmp "$@"
}
function gitpara() {
    gagiramgit -c gfortran81 -o openmp "$@"
}
function gitserial() {
    gagiramgit -c gfortran81 "$@"
}
#
# PIIC shortcut
function gagpiic() {
    gagiram -c ifort may18
}
#
export -f gagiram gagiramgit go gagpara gagprofile gagsanitize gitiram gitpara gitserial gagpiic
#
# The next command automatically loads the environment variables
# needed for the default GILDAS version (ie last fully compiled).
# That standard IRAM users will have a working GILDAS version without
# any personal customization. The user (in particular developers) may
# decide to avoid this just by creating the following file:
# $HOME/.no-initial-gagiram
#
if [ ! -e $HOME/.no-initial-gagiram ]; then
    gagiram > /dev/null 2>&1
fi
#
###########################################################################
