module cubeio_cube_define
  !-----------------------------------------------------------------------
  ! Support routines to define a 'cube_define_t'
  !-----------------------------------------------------------------------
  use cubetools_parameters

  type cube_define_t
    logical               :: dobuffering=.false. ! Supersede default buffering mode?
    integer(kind=4)       :: buffering           ! Buffering mode, if superseded
    logical               :: dofilename=.false.  ! Supersede default file naming?
    character(len=file_l) :: filename            ! Input file name, if superseded
    logical               :: doid=.false.        ! An identifier if provided?
    character(len=file_l) :: id                  ! Identifier to be used in feedback messages
    logical               :: dotransname=.false. !
    character(len=file_l) :: transname           ! Transposed file name
    logical               :: doorder=.false.     ! Order enabled?
    integer(kind=4)       :: order               ! Image set or spectrum set
    logical               :: doaccess=.false.    ! Access enabled?
    integer(kind=4)       :: access              ! Image set, spectrum set, or any
    logical               :: doaction=.false.    ! Action mode enabled?
    integer(kind=4)       :: action              ! Action mode (read, write, update)
    logical               :: dounblank=.false.   ! Unblank mode enabled?
    integer(kind=4)       :: unblank             ! Unblank mode (none, error, patch)
    logical               :: doreblank=.false.   ! Reblank mode enabled?
    real(kind=4)          :: bval,eval           ! Reblank values
    logical               :: dofilekind=.false.  ! Custom format enabled?
    integer(kind=code_k)  :: filekind            ! GDF or FITS format (write mode)
  end type cube_define_t

  public :: cube_define_t
  public :: cubeio_cube_define_reset,cubeio_cube_define_copy
  public :: cubeio_cube_define_buffering,cubeio_cube_define_filename, &
            cubeio_cube_define_transname,cubeio_cube_define_order,  &
            cubeio_cube_define_access,cubeio_cube_define_action,  &
            cubeio_cube_define_unblank,cubeio_cube_define_reblank,  &
            cubeio_cube_define_filekind,cubeio_cube_define_id
  private

contains

  subroutine cubeio_cube_define_reset(cubdef,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(out)   :: cubdef
    logical,             intent(inout) :: error
    !
    ! cubdef is reset thanks to intent(out), nothing more to do.
    continue
  end subroutine cubeio_cube_define_reset
  !
  subroutine cubeio_cube_define_buffering(cubdef,mode,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    integer(kind=4),     intent(in)    :: mode
    logical,             intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%dobuffering = .true.
    cubdef%buffering = mode
  end subroutine cubeio_cube_define_buffering
  !
  subroutine cubeio_cube_define_filekind(cubdef,filekind,error)
    !---------------------------------------------------------------------
    ! Define the file kind (GDF, FITS,...) to be used if the cube is
    ! associated to a file on DISK.
    !---------------------------------------------------------------------
    type(cube_define_t),  intent(inout) :: cubdef
    integer(kind=code_k), intent(in)    :: filekind
    logical,              intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%dofilekind = .true.
    cubdef%filekind = filekind
  end subroutine cubeio_cube_define_filekind
  !
  subroutine cubeio_cube_define_filename(cubdef,filename,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    character(len=*),    intent(in)    :: filename
    logical,             intent(inout) :: error
    !
    cubdef%dofilename = .true.
    cubdef%filename = filename
  end subroutine cubeio_cube_define_filename
  !
  subroutine cubeio_cube_define_id(cubdef,id,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    character(len=*),    intent(in)    :: id
    logical,             intent(inout) :: error
    !
    cubdef%doid = .true.
    cubdef%id = id
  end subroutine cubeio_cube_define_id
  !
  subroutine cubeio_cube_define_transname(cubdef,transname,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    character(len=*),    intent(in)    :: transname
    logical,             intent(inout) :: error
    !
    cubdef%dotransname = .true.
    cubdef%transname = transname
  end subroutine cubeio_cube_define_transname
  !
  subroutine cubeio_cube_define_order(cubdef,order,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    integer(kind=4),     intent(in)    :: order   ! code_cube_*
    logical,             intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%doorder = .true.
    cubdef%order = order
  end subroutine cubeio_cube_define_order
  !
  subroutine cubeio_cube_define_access(cubdef,access,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    integer(kind=4),     intent(in)    :: access  ! code_access_*
    logical,             intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%doaccess = .true.
    cubdef%access = access
  end subroutine cubeio_cube_define_access
  !
  subroutine cubeio_cube_define_action(cubdef,action,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    integer(kind=4),     intent(in)    :: action
    logical,             intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%doaction = .true.
    cubdef%action = action
  end subroutine cubeio_cube_define_action
  !
  subroutine cubeio_cube_define_unblank(cubdef,unblank,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    integer(kind=4),     intent(in)    :: unblank
    logical,             intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%dounblank = .true.
    cubdef%unblank = unblank
  end subroutine cubeio_cube_define_unblank
  !
  subroutine cubeio_cube_define_reblank(cubdef,bval,eval,error)
    !---------------------------------------------------------------------
    !---------------------------------------------------------------------
    type(cube_define_t), intent(inout) :: cubdef
    real(kind=4),        intent(in)    :: bval,eval
    logical,             intent(inout) :: error
    !
    ! ZZZ add sanity check
    cubdef%doreblank = .true.
    cubdef%bval = bval
    cubdef%eval = eval
  end subroutine cubeio_cube_define_reblank
  !
  subroutine cubeio_cube_define_copy(in,out)
    !---------------------------------------------------------------------
    ! Duplicate a cube_define_t
    !---------------------------------------------------------------------
    type(cube_define_t), intent(in)  :: in
    type(cube_define_t), intent(out) :: out
    !
    out = in  ! As of today, simple copy is enough
  end subroutine cubeio_cube_define_copy
end module cubeio_cube_define
