module mapping_interfaces_none
  interface
    subroutine compact_data(error)
      use clean_def
      use clean_arrays
      use gbl_message
      logical error
    end subroutine compact_data
  end interface
  !
  interface
    subroutine save_result(error)
      use gildas_def
      use clean_types
      use gbl_message
      logical error
    end subroutine save_result
  end interface
  !
  interface
    subroutine define_var (error)
      use gildas_def
      use clean_def
      use clean_arrays
      use clean_types
      use mapping_default_types
      use clean_support
      !
      logical :: error  ! Logical error flag
    end subroutine define_var
  end interface
  !
  interface
    subroutine big_wait(n,b)
      real, intent(inout) :: b
      integer, intent(in) :: n
    end subroutine big_wait
  end interface
  !
  interface
    subroutine get_stopping(miter,ares,iplane)
      use clean_arrays
      !
      integer, intent(inout) :: miter
      real, intent(inout) :: ares
      integer, intent(in) :: iplane
    end subroutine get_stopping
  end interface
  !
  interface
    subroutine maxcmp(nx,ny,wl,a)
      integer, intent(in) :: nx,ny
      real, intent(in) :: wl(2,nx,ny)
      real, intent(out) :: a
    end subroutine maxcmp
  end interface
  !
  interface
    subroutine userc (nv,coords,xref,xval,xinc,yref,yval,yinc)
      integer, intent(in) :: nv                     !
      real(4), intent(out) :: coords(2,nv)          !
      real(8), intent(in) :: xref                   !
      real(8), intent(in) :: xval                   !
      real(8), intent(in) :: xinc                   !
      real(8), intent(in) :: yref                   !
      real(8), intent(in) :: yval                   !
      real(8), intent(in) :: yinc                   !
    end subroutine userc
  end interface
  !
  interface
    subroutine mos_inverse (n,weight,thre)
      integer, intent(in) :: n
      real, intent(inout) :: weight(n)
      real, intent(in) :: thre
    end subroutine mos_inverse
  end interface
  !
  interface
    subroutine mos_addsq (n,nf,weight,lobe)
      integer, intent(in) :: n                      ! Size of arrays
      integer, intent(in) :: nf                     ! Number of fields
      real, intent(inout) :: weight(n)              ! Total weight
      real, intent(in) :: lobe(nf,n)                ! Primary beam array
    end subroutine mos_addsq
  end interface
  !
  interface
    subroutine connect_flux
      !
    end subroutine connect_flux
  end interface
  !
  interface
    subroutine mrc_clear
    end subroutine mrc_clear
  end interface
  !
  interface
    function minimum(n,a)
      integer n,i
      real a(*)
      real minimum
    end function minimum
  end interface
  !
  interface
    subroutine map_beams(task,map_beam,huv,nx,ny,nb,nc)
      use gbl_message
      use image_def
      use uv_continuum
      !
      character(len=*), intent(in) :: task
      integer, intent(inout) :: map_beam
      type(gildas), intent(in) :: huv
      integer, intent(in) :: nx ! X size
      integer, intent(in) :: ny ! Y size
      integer, intent(in) :: nc ! Number of channels
      integer, intent(out) :: nb ! Number of beams
    end subroutine map_beams
  end interface
  !
  interface
    subroutine map_message_set_id(id)
      use gbl_message
      !---------------------------------------------------------------------
      ! Alter library id into input id. Should be called by the library
      ! which wants to share its id with the current one.
      !---------------------------------------------------------------------
      integer, intent(in) :: id
    end subroutine map_message_set_id
  end interface
  !
  interface
    subroutine mapping_pack_set(pack)
      use gpack_def
      !
      type(gpack_info_t), intent(out) :: pack
    end subroutine mapping_pack_set
  end interface
  !
  interface
    subroutine mapping_pack_init(gpack_id,error)
      use sic_def
      use clean_language
      !----------------------------------------------------------------------
      !
      !----------------------------------------------------------------------
      integer :: gpack_id
      logical :: error
    end subroutine mapping_pack_init
  end interface
  !
  interface
    subroutine mapping_pack_on_exit(error)
      !----------------------------------------------------------------------
      !
      !----------------------------------------------------------------------
      logical :: error
    end subroutine mapping_pack_on_exit
  end interface
  !
end module mapping_interfaces_none
