!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module clean_sdi
  use gbl_message
  !
  public :: sdi_comm
  private
  !
contains
  !
  subroutine sdi_comm(line,error)
    use gkernel_interfaces
    use mapping_interfaces
    use clean_def
    use clean_arrays
    !----------------------------------------------------------------------
    ! Implementation of Steer Dewdney Ito Clean
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    integer :: iv,na,m_iter
    character(len=8) :: name,argum,voc1(2)
    data voc1/'CLEAN','RESIDUAL'/
    !
    ! Save default number of components
    m_iter = user_method%m_iter
    user_method%m_iter = hdirty%gil%dim(1) * hdirty%gil%dim(2)
    !
    ! Data checkup: method must be defined first ?
    user_method%method = 'SDI'
    call clean_data (error)
    if (error) return
    !
    ! Parameter Definitions
    call beam_unit_conversion(user_method)
    call copy_method(user_method,method)
    method%pflux = .false.
    method%pcycle = sic_present(2,0)
    method%qcycle = sic_present(3,0)
    if (method%pcycle) then
       argum = 'RESIDUAL'
       call sic_ke (line,2,1,argum,na,.false.,error)
       if (error) return
       call sic_ambigs ('PLOT',argum,name,iv,voc1,2,error)
       if (error) return
       method%pclean = iv.eq.1
    else
       method%pclean = .false.
    endif
    call sub_clean(line,error)
    ! Restore default number of components
    user_method%m_iter = m_iter
  end subroutine sdi_comm
end module clean_sdi
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
