!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_parse
  use cubetools_structure
  use cubetools_parameters
  use cubetools_messaging
  !
  public :: cubetools_parse_keyword, cubetools_parse_string2value, cubetools_parse_elements
  public :: cubetools_parse_varname, cubetools_parse_basename
  private 
  !
contains
  !
  subroutine cubetools_parse_keyword(rname,line,opt,iarg,keys,nkey,ikey,error)
    use cubetools_disambiguate
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    character(len=*),     intent(in)    :: rname
    character(len=*),     intent(in)    :: line
    type(option_t),       intent(in)    :: opt
    integer(kind=4),      intent(in)    :: iarg
    integer(kind=argu_k), intent(in)    :: nkey
    character(len=*),     intent(in)    :: keys(nkey)
    integer(kind=argu_k), intent(out)   :: ikey
    logical,              intent(inout) :: error
    !
    logical :: do
    character(len=argu_l) :: arg,key
    !
    call opt%present(line,do,error)
    if (error) return
    if (do) then
       call cubetools_getarg(line,opt,iarg,arg,mandatory,error)
       if (error) return
       call cubetools_disambiguate_strict(arg,keys,ikey,key,error)
       if (error) return
    endif
  end subroutine cubetools_parse_keyword
  !
  subroutine cubetools_parse_string2value(rname,line,opt,iarg,defstring,defval,argval,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    character(len=*),  intent(in)    :: rname
    character(len=*),  intent(in)    :: line
    type(option_t),    intent(in)    :: opt
    integer(kind=4),   intent(in)    :: iarg
    character(len=*),  intent(in)    :: defstring
    real(kind=real_k), intent(in)    :: defval
    real(kind=real_k), intent(out)   :: argval
    logical,           intent(inout) :: error
    !
    logical :: do
    character(len=argu_l) :: arg
    character(len=mess_l) :: mess
    !
    call opt%present(line,do,error)
    if (error) return
    if (do) then
       call cubetools_getarg(line,opt,iarg,arg,mandatory,error)
       if (error) return
       if (trim(arg).eq.defstring) then
          argval = defval
       else
          call sic_math_real(arg,argu_l,argval,error)
          if (error) then
             write(mess,'(3a)') 'Cannot convert ',arg,' to REAL' 
             call cubetools_message(seve%e,rname,mess)
             return
          endif
       endif
    endif
  end subroutine cubetools_parse_string2value
  !
  subroutine cubetools_parse_basename(line,opt,name,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(inout) :: name
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='PARSE>BASENAME'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    name = ''
    call cubetools_getarg(line,opt,1,name,.false.,error)
    if (error) return
  end subroutine cubetools_parse_basename
  !
  subroutine cubetools_parse_elements(string,sep,elements,nelements,error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    character(len=*),                   intent(in)    :: string
    character(len=*),                   intent(in)    :: sep
    character(len=argu_l), allocatable, intent(out)   :: elements(:)
    integer(kind=4),                    intent(out)   :: nelements
    logical,                            intent(inout) :: error
    !
    integer(kind=4) :: nlength,ichar,ochar,ier,ielement
    logical :: warned
    character(len=*), parameter :: rname='PARSE>ELEMENTS'
    nlength = file_l
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    nlength = len_trim(string)
    nelements = 1
    do ichar=1, nlength
       if (string(ichar:ichar).eq.sep(1:1).or.string(ichar:ichar).eq.'/') nelements = nelements+1
    end do
    !
    allocate(elements(nelements),stat=ier)
    if (failed_allocate(rname,'Element names',ier,error)) return
    !
    ochar = 1
    ielement = 1
    elements(:)(:) = ' '
    warned = .false.
    do ichar=1, nlength
       if (string(ichar:ichar).eq.sep(1:1).or.string(ichar:ichar).eq.'/') then
          ochar = 1
          ielement  = ielement+1
          warned = .false.
          cycle
       endif
       if (ochar.gt.argu_l) then
          if (.not.warned)  then
             call cubetools_message(seve%w,rname,'Truncating element to '//elements(ielement))
             warned = .true.
          endif
          cycle
       endif
       elements(ielement)(ochar:ochar) = string(ichar:ichar)
       ochar = ochar+1
    end do
  end subroutine cubetools_parse_elements
  !
  subroutine cubetools_parse_varname(line,opt,varname,error)
    !----------------------------------------------------------------------
    ! not used
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(inout) :: varname
    logical,          intent(inout) :: error
    !
    logical :: do
    character(len=*), parameter :: rname='PARSE>VARNAME'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call opt%present(line,do,error)
    if (error) return
    if (do) then
       call cubetools_getarg(line,opt,1,varname,.true.,error)
       if (error) return
    else
       ! *** JP: Default behavior
    endif
  end subroutine cubetools_parse_varname
  !
end module cubetools_parse
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
