!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_phase
  use cubecompute_messaging
  use cubecompute_visi2image_template
  !
  public :: phase
  public :: cubecompute_phase_command
  private
  !
  type, extends(visi2image_comm_t) :: phase_comm_t
   contains
     procedure, public  :: register => cubecompute_phase_register
  end type phase_comm_t
  type(phase_comm_t) :: phase
  !
  type, extends(visi2image_prog_t) :: phase_prog_t
   contains
     procedure, private :: act => cubecompute_phase_prog_act
  end type phase_prog_t
  !
contains
  !
  subroutine cubecompute_phase_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='PHASE>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call phase%command(line,error)
    if (error) return
  end subroutine cubecompute_phase_command
  !
  subroutine cubecompute_phase_register(phase,error)
    use cubetools_structure
    use cubeadm_cubeid_types
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(phase_comm_t), intent(inout) :: phase
    logical,             intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract=&
         'Compute the phase from a complex cube'
    character(len=*), parameter :: comm_help=strg_id
    character(len=*), parameter :: rname='PHASE>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'PHASE','[cubeid]',&
         comm_abstract,&
         comm_help,&
         cubecompute_phase_command,&
         phase%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Input complex data',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
  end subroutine cubecompute_phase_register
  !
  subroutine cubecompute_phase_prog_act(prog,ie,visi,image,error)
    use cubetools_parameters
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(phase_prog_t),  intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: visi
    type(image_t),        intent(inout) :: image
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='PHASE>PROG>ACT'
    !
    call visi%get(ie,error)
    if (error) return
    do iy=1,visi%ny
       do ix=1,visi%nx
          image%val(ix,iy) = atan2(real(visi%val(ix,iy)),aimag(visi%val(ix,iy)))
       enddo ! ix
    enddo ! iy
    call image%put(ie,error)
    if (error) return
  end subroutine cubecompute_phase_prog_act
end module cubecompute_phase
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
