module clean_arrays
  use clean_def
  use image_def
  !
  ! Static variables first, allocatable next.
  !
  type (uvmap_par), save :: themap
  type (clean_par), target :: method, user_method
  type (gildas), save, target :: hbeam, hdirty, hclean, hresid
  type (gildas), save, target :: hprim, huvi, huv, huvt, hfields
  type (gildas), save, target :: hcct, hmask, hsky
  type (gildas), save :: huvm
  !
  ! Support variable for the SIC variable 'W':
  type (gildas), save :: w_plot
  type (gildas), save :: b_plot
  !
  ! These are UV data
  real, pointer :: duv(:,:)
  logical, save :: uv_plotted
  ! For the Multi-Primary beams Mosaic deconvolution
  ! C_ stands for "Compact Array"
  type (clean_par), target :: c_method, cuse_method
  type (gildas), save :: c_hbeam, c_hdirty, c_hresid, c_hclean
  type (gildas), save :: c_hprim
  !
  real, allocatable, save :: g_weight(:)  ! UV weights
  real, allocatable, save :: g_v(:)       ! V values
  logical, save :: do_weig                ! Optimization of weight computing
  !
  ! Imaging and deconvolution arrays
  real, allocatable, target, save :: dbeam(:,:,:,:) ! 4-D
  real, allocatable, target, save :: ddirty(:,:,:)  ! Dirty 3-D 
  real, allocatable, target, save :: dclean(:,:,:)  ! Clean 3-D
  real, allocatable, target, save :: dresid(:,:,:)  ! Residual 3-D
  real, allocatable, target, save :: dprim(:,:,:,:) ! Primary beam 4-D
  real, allocatable, target, save :: weight(:,:,:)  ! Mosaic weights 3-D
  real, allocatable, target, save :: dsky(:,:,:)      ! Primary beam corrected 3-D
  real, allocatable, target, save :: dfields(:,:,:,:) ! Mosaic fields 4-D
  !
  ! Deconvolution arrays
  real, allocatable, target, save :: dmask(:,:,:)   ! Input 3-D 0, #0 mask
  integer, allocatable, target, save :: d_list(:)   ! List of selected pixels
  logical, allocatable, target, save :: d_mask(:,:) ! Logical mask for pixel selection
  real, allocatable, target, save :: dcct(:,:,:)    ! Clean component values
  type (cct_par), allocatable, save :: tcc(:)       ! Clean component list
  !
  ! These are UV data
  real, allocatable, target, save :: duvi(:,:)  ! Original UV data
  real, pointer :: duvr(:,:)                    ! Resampled UV data
  real, pointer :: duvs(:,:)                    ! Sorted UV data
  real, allocatable, target, save :: duvt(:,:)  ! Time-Baseline sorted UV data, for UV_FLAG
  real, allocatable, target, save :: duvm(:,:)  ! Model UV data
  !
  ! For the Multi-Primary beams Mosaic deconvolution
  ! C_ stands for "Compact Array"
  real, allocatable, target, save :: c_dbeam(:,:,:)
  real, allocatable, target, save :: c_ddirty(:,:,:)
  real, allocatable, target, save :: c_dclean(:,:,:)
  real, allocatable, target, save :: c_dresid(:,:,:)
  real, allocatable, target, save :: c_dprim(:,:,:)
  logical, allocatable, target, save :: c_mask(:,:)
  integer, allocatable, target, save :: c_list(:)
  real, allocatable, target, save :: c_weight(:,:,:)  ! 3-D
  !
  integer :: niter_listsize=0
  integer, allocatable :: niter_list(:)
  integer :: ares_listsize=0
  real, allocatable :: ares_list(:)
  ! List of selected fields in UV_MAP (used for UV_RESTORE and
  ! also for SHOW FIELDS)
  integer :: selected_fieldsize=0
  integer, allocatable :: selected_fields(:)
end module clean_arrays
!
module clean_support
  use gkernel_types
  ! CLEAN\SUPPORT polygon, mapped on SUPPORT%
  type(polygon_t), save :: supportpol
  integer, save :: support_type  
  integer, parameter :: support_mask = 1 
  integer, parameter :: support_poly = -1
  integer, parameter :: support_none = 0
  character(len=varname_length), parameter :: supportvar='SUPPORT'
end module clean_support
!
module clean_types
  use gkernel_types
  integer mtype
  parameter(mtype=13)
  character(len=12) :: vtype(1:mtype) = (/ &
  &  'COVERAGE    ',  &
  &  'UV          ',  &
  &  'BEAM        ',  &
  &  'DIRTY       ',  &
  &  'CLEAN       ',  &
  &  'PRIMARY     ',  &
  &  'RESIDUAL    ',  &
  &  'MASK        ',  &
  &  'SUPPORT     ',  &
  &  'CCT         ',  &
  &  'MODEL       ',  &
  &  'SKY         ',  &
  &  'FIELDS      ' /)
  !
  character(len=12) :: etype(1:mtype) = (/ &
  & '.uvt        ',  &
  & '.uvt        ',  &
  & '.beam       ',  &
  & '.lmv        ',  &
  & '.lmv-clean  ',  &
  & '.lobe       ',  &
  & '.lmv-res    ',  &
  & '.msk        ',  &
  & '.pol        ',  &
  & '.cct        ',  &
  & '.uvt        ',  &
  & '.lmv-sky    ',  &
  & '.fields     '  /)
  !
  character(len=12) ctype
  !
  integer, parameter :: code_save_uv=2
  integer, parameter :: code_save_beam=3
  integer, parameter :: code_save_dirty=4
  integer, parameter :: code_save_clean=5
  integer, parameter :: code_save_primary=6
  integer, parameter :: code_save_resid=7
  integer, parameter :: code_save_mask=8
  integer, parameter :: code_save_support=9
  integer, parameter :: code_save_cct=10
  integer, parameter :: code_save_model=11
  integer, parameter :: code_save_sky=12
  integer, parameter :: code_save_fields=13
  logical :: save_data(mtype)
  !
  ! Read / Write optimization
  type readop_t
    type(mfile_t) :: modif
    integer :: lastnc(2) = 0
    integer :: change = 0
  end type
  !
  type (readop_t), save :: optimize(mtype)
  !
  integer :: rw_optimize
end module clean_types
!
module clean_default
  use clean_def
  !
  real d_min,d_max                   ! min max of dirty image
  real major_sec
  real minor_sec
  !
  type (uvmap_par), save :: default_map, old_map, save_map
  !
  ! OPEN-MP control parameters
  logical, save :: omp_compiled = .false.
  logical, save :: omp_uvmap = .false.
  integer, save :: omp_grid = 0
  logical, save :: omp_restore_fast = .true.
  logical, save :: omp_uvmap_lock = .false.
  integer, save :: omp_single_beam = 0
  logical, save :: omp_debug = .false.
  !
  ! Parameter to select the imaging tool version. Non zero means old
  ! non-optimized code.
  integer, save :: map_version = 0
  !
  ! Parameters for determining image size
  integer, save :: map_power = 2         ! Max exponent of powers of 3 and 5
  real, save :: map_rounding = 0.05      ! Tolerance for rounding to floor
  !
  ! Cleaning convergence criterium
  integer, save :: clean_converge = 10
end module clean_default

module code_names
  use image_def
  character(len=12), save :: items(code_uvt_last)
  character(len=4), save :: stoke(-22:22)
end module code_names

