!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_image2visi
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubetemplate_sperange_types
  use cubetemplate_messaging
  !
  public :: image2visi
  public :: cubetemplate_image2visi_command
  private
  !
  type :: image2visi_comm_t
     type(option_t), pointer :: comm
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, public  :: register => cubetemplate_image2visi_register
     procedure, private :: parse    => cubetemplate_image2visi_parse
     procedure, private :: main     => cubetemplate_image2visi_main
  end type image2visi_comm_t
  type(image2visi_comm_t) :: image2visi  
  !
  integer(kind=4), parameter :: icube = 1
  type image2visi_user_t
     type(cubeid_user_t)   :: cubeids
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, private :: toprog => cubetemplate_image2visi_user_toprog
  end type image2visi_user_t
  !
  type image2visi_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubetemplate_image2visi_prog_header
     procedure, private :: data   => cubetemplate_image2visi_prog_data
     procedure, private :: loop   => cubetemplate_image2visi_prog_loop
     procedure, private :: act    => cubetemplate_image2visi_prog_act
  end type image2visi_prog_t
  !
contains
  !
  subroutine cubetemplate_image2visi_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(image2visi_user_t) :: user
    character(len=*), parameter :: rname='IMAGE2VISI>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call image2visi%parse(line,user,error)
    if (error) return
    call image2visi%main(user,error)
    if (error) continue
  end subroutine cubetemplate_image2visi_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_image2visi_register(image2visi,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image2visi_comm_t), intent(inout) :: image2visi
    logical,                  intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = 'Template command to input per image and output per visi'
    character(len=*), parameter :: comm_help = &
         'Input cube is real and output cube is complex'
    character(len=*), parameter :: rname='IMAGE2VISI>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'IMAGE2VISI','[cube]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_image2visi_command,&
         image2visi%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call image2visi%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         image2visi%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'Multiplicative factor',&
         'Default to 1',&
         code_arg_mandatory, error)
    if (error) return
  end subroutine cubetemplate_image2visi_register
  !
  subroutine cubetemplate_image2visi_parse(image2visi,line,user,error)
    !----------------------------------------------------------------------
    ! IMAGE2VISI cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(image2visi_comm_t), intent(in)    :: image2visi
    character(len=*),         intent(in)    :: line
    type(image2visi_user_t),  intent(out)   :: user
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE2VISI>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,image2visi%comm,user%cubeids,error)
    if (error) return
    call image2visi%range%parse(line,user%range,error)
    if (error) return
    call cubetemplate_image2visi_parse_factor(line,image2visi%factor,user%factor,error)
    if (error) return
  end subroutine cubetemplate_image2visi_parse
  !
  subroutine cubetemplate_image2visi_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: user
    logical,          intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='IMAGE2VISI>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_image2visi_parse_factor
  !
  subroutine cubetemplate_image2visi_main(comm,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image2visi_comm_t), intent(in)    :: comm
    type(image2visi_user_t),  intent(inout) :: user
    logical,                  intent(inout) :: error
    !
    type(image2visi_prog_t) :: prog
    character(len=*), parameter :: rname='IMAGE2VISI>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_image2visi_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_image2visi_user_toprog(user,comm,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image2visi_user_t), intent(in)    :: user
    type(image2visi_comm_t),  intent(in)    :: comm
    type(image2visi_prog_t),  intent(out)   :: prog
    logical,                  intent(inout) :: error
    !
    type(unit_user_t) :: nounit
    real(kind=sign_k), parameter :: default=1.0
    character(len=*), parameter :: rname='IMAGE2VISI>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(comm%comm,icube,user%cubeids,&
         code_access_imaset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    call cubetools_unit_get(strg_star,unit_unk%id,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,prog%factor,error)
    if (error) return
  end subroutine cubetemplate_image2visi_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_image2visi_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    use cubetools_header_methods
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image2visi_prog_t), intent(inout) :: prog
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE2VISI>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_template,prog%oucube,error)
    if (error) return
    call cubetools_header_make_array_cplx(prog%oucube%head,error)
    if (error) return
  end subroutine cubetemplate_image2visi_prog_header
  !
  subroutine cubetemplate_image2visi_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(image2visi_prog_t), intent(inout) :: prog
    logical,                  intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='IMAGE2VISI>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter%first,iter%last,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubetemplate_image2visi_prog_data
  !   
  subroutine cubetemplate_image2visi_prog_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image2visi_prog_t), intent(inout) :: prog
    integer(kind=entr_k),     intent(in)    :: first
    integer(kind=entr_k),     intent(in)    :: last
    logical,                  intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(image_t) :: inima
    type(visi_t) :: ouima
    character(len=*), parameter :: rname='IMAGE2VISI>PROG>LOOP'
    !
    call inima%associate('inima',prog%incube,error)
    if (error) return
    call ouima%allocate('ouima',prog%oucube,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error) return
      call prog%act(ie,inima,ouima,error)
      if (error) return
    enddo ! ie
  end subroutine cubetemplate_image2visi_prog_loop
  !   
  subroutine cubetemplate_image2visi_prog_act(prog,ie,inima,ouima,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image2visi_prog_t), intent(inout) :: prog
    integer(kind=entr_k),     intent(in)    :: ie
    type(image_t),            intent(inout) :: inima
    type(visi_t),             intent(inout) :: ouima
    logical,                  intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='IMAGE2VISI>PROG>ACT'
    !
    call inima%get(ie,error)
    if (error) return
    do iy=1,inima%ny
       do ix=1,inima%nx
          ouima%val(ix,iy) = prog%factor*cmplx(inima%val(ix,iy),ix+iy+ie)
       enddo ! ix
    enddo ! iy
    call ouima%put(ie,error)
    if (error) return
  end subroutine cubetemplate_image2visi_prog_act
end module cubetemplate_image2visi
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
