!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! As of 2022-12-28, the possibility to output ASCII file is tagged obsolete
! and the associated code is commented out. It will be remove in one year if
! nobody complains about it.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_circle
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_messaging
  use cubetemplate_spapos_types
  use cubemain_spaelli_types
  !
  public :: circle
  public :: cubemain_circle_command
  private
  !
  integer(kind=4), parameter :: nout = 6
  !
  type :: circle_comm_t
     type(option_t), pointer :: comm
     type(spapos_opt_t)      :: center
     type(ellipse_opt_t)     :: ellipse
!!$     type(option_t), pointer :: ascii
   contains
     procedure, public  :: register => cubemain_circle_register
     procedure, private :: parse    => cubemain_circle_parse
     procedure, private :: main     => cubemain_circle_main
  end type circle_comm_t
  type(circle_comm_t) :: circle
  !
  integer(kind=4), parameter :: icube = 1
  type circle_user_t
     type(cubeid_user_t)   :: cubeids
     type(spapos_user_t)   :: center   ! [Absolute|relative]
     type(ellipse_user_t)  :: ellipse
!!$     logical               :: doascii  ! Print Ascii output
   contains
     procedure, private :: toprog => cubemain_circle_user_toprog
  end type circle_user_t
  !
  type circle_prog_t
     type(cube_t), pointer     :: cube        ! Input cube
     type(cube_t), pointer     :: npix        ! # of pix in each radius
     type(cube_t), pointer     :: summ        ! Sum
     type(cube_t), pointer     :: aver        ! Average
     type(cube_t), pointer     :: sigm        ! Sigma 
     type(cube_t), pointer     :: mini        ! Minimum
     type(cube_t), pointer     :: maxi        ! Maximum
     logical                   :: doellipse
     integer(kind=pixe_k)      :: nr          ! # of radii
     real(kind=4), allocatable :: indice(:,:) ! Output indices
     real(kind=coor_k)         :: inc         ! Incement in circle radius
     type(spapos_prog_t)       :: center      ! circle center
     type(ellipse_prog_t)      :: ellipse     ! ellipse
   contains
     procedure, private :: header          => cubemain_circle_prog_header
     procedure, private :: header_one      => cubemain_circle_prog_header_one
     procedure, private :: compute_indices => cubemain_circle_prog_compute_indices
     procedure, private :: data            => cubemain_circle_prog_data
     procedure, private :: loop            => cubemain_circle_prog_loop
     procedure, private :: act             => cubemain_circle_prog_act
!!$     procedure, private :: toascii         => cubemain_circle_prog_toascii
  end type circle_prog_t
  !
contains
  !
  subroutine cubemain_circle_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(circle_user_t) :: user
    character(len=*), parameter :: rname='CIRCLE>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call circle%parse(line,user,error)
    if (error) return
    call circle%main(user,error)
    if (error) continue
  end subroutine cubemain_circle_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_circle_register(circle,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_comm_t), intent(inout) :: circle
    logical,              intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract = &
         'Average intensities of a cube along ellipses'
    character(len=*), parameter :: comm_help = &
         'By default the averaging is circular and centered at the&
         & projection center. This can be changed by using options&
         & /CENTER and /ELLIPSE. The axes given to option /ELLIPSE&
         & will be used to derive the aspect ratio over which to&
         & compute the azimuthal average.'
    character(len=*), parameter :: rname='CIRCLE>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'CIRCLE','[cube]',&
         comm_abstract,&
         comm_help,&
         cubemain_circle_command,&
         circle%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Signal cube',  &
         strg_id,&
         code_arg_optional,  &
         [flag_cube], &
         error)
    if (error) return
    !
    call circle%center%register('CENTER',&
         'Center of the ellipse',&
         error)
    if (error) return
    !
    call circle%ellipse%register(&
         'ELLIPSE',&
         'Define ellipse axes and position angle',&
         error)
    if (error) return
    !
!!$    call cubetools_register_option(&
!!$         'ASCII','',&
!!$         'Produce ASCII output',&
!!$         strg_id,&
!!$         circle%ascii,error)
!!$    if (error) return
  end subroutine cubemain_circle_register
  !
  subroutine cubemain_circle_parse(circle,line,user,error)
    use cubetools_parse
    !----------------------------------------------------------------------
    ! CIRCLE cubname
    ! /CENTER xcenter ycenter
    ! /ELLIPSE major [minor [pa]]
    ! /ASCII
    !----------------------------------------------------------------------
    class(circle_comm_t), intent(in)    :: circle
    character(len=*),     intent(in)    :: line
    type(circle_user_t),  intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='CIRCLE>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,circle%comm,user%cubeids,error)
    if (error) return
    call circle%center%parse(line,user%center,error)
    if (error) return
    call circle%ellipse%parse(line,user%ellipse,error)
    if (error) return
!!$    call circle%ascii%present(line,user%doascii,error)
!!$    if (error) return
  end subroutine cubemain_circle_parse
  !
  subroutine cubemain_circle_main(circle,user,error)
    use cubedag_parameters
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_comm_t), intent(in)    :: circle
    type(circle_user_t),  intent(in)    :: user
    logical,              intent(inout) :: error
    !
    type(circle_prog_t) :: prog
    character(len=*), parameter :: rname='CIRCLE>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    !
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
!!$    if (user%doascii) then 
!!$       call prog%toascii(error)
!!$       if (error) return
!!$    endif
  end subroutine cubemain_circle_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_circle_user_toprog(user,prog,error)
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_user_t), intent(in)    :: user
    type(circle_prog_t),  intent(out)   :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='CIRCLE>USER>TOPROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(circle%comm,icube,user%cubeids,&
         code_access_imaset,code_read,prog%cube,error)
    if (error) return
    !
    call user%center%toprog(prog%cube,prog%center,error)
    if (error) return
    prog%doellipse = user%ellipse%do
    if (prog%doellipse) then
       call user%ellipse%toprog(prog%cube,prog%ellipse,error)
       if (error) return
    endif
    !
    call prog%compute_indices(error)
    if (error) return
  end subroutine cubemain_circle_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_circle_prog_header(prog,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='CIRCLE>PROG>HEADER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call prog%header_one(flag_npix,prog%npix,error)
    if (error) return
    call prog%header_one(flag_sum,prog%summ,error)
    if (error) return
    call prog%header_one(flag_average,prog%aver,error)
    if (error) return
    call prog%header_one(flag_noise,prog%sigm,error)
    if (error) return
    call prog%header_one(flag_minimum,prog%mini,error)
    if (error) return
    call prog%header_one(flag_maximum,prog%maxi,error)
    if (error) return
  end subroutine cubemain_circle_prog_header
  !
  subroutine cubemain_circle_prog_header_one(prog,code_flag,out,error)
    use cubetools_axis_types
    use cubetools_header_methods
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_prog_t),  intent(in)    :: prog
    type(flag_t),          intent(in)    :: code_flag
    type(cube_t), pointer, intent(inout) :: out
    logical,               intent(inout) :: error
    !
    type(axis_t) :: axis
    character(len=*), parameter :: rname='CIRCLE>PROG>HEADER>ONE'
    !
    call cubeadm_clone_header(prog%cube,[flag_circle,code_flag],out,error)
    if (error) return
    call cubetools_header_get_axis_head_l(out%head,axis,error)
    if (error) return
    axis%n   = prog%nr
    axis%inc = prog%inc
    axis%ref = 1
    call cubetools_header_update_axset_l(axis,out%head,error)
    if (error) return
    call cubetools_header_nullify_axset_m(out%head,error)
    if (error) return
  end subroutine cubemain_circle_prog_header_one
  !
  subroutine cubemain_circle_prog_compute_indices(prog,error)
    use gkernel_interfaces
    use cubetools_header_methods
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=4) :: ier
    real(coor_k) :: inc1,val1,ref1,xval
    real(coor_k) :: inc2,val2,ref2,yval
    real(coor_k) :: cval,rval,excent,theta
    integer(kind=pixe_k) :: ix,nx
    integer(kind=pixe_k) :: iy,ny
    integer(kind=pixe_k) :: ir
    character(len=*), parameter :: rname='CIRCLE>COMPUTE_INDICES'
    !
    call cubetools_header_get_nlnm(prog%cube%head,nx,ny,error)
    if (error) return
    !
    inc1 = prog%cube%head%spa%l%inc
    inc2 = prog%cube%head%spa%m%inc
    val1 = -prog%center%rela(1)
    val2 = -prog%center%rela(2)
    ref1 = prog%cube%head%spa%l%ref
    ref2 = prog%cube%head%spa%m%ref
    !
    if (prog%doellipse) then
       excent = sqrt(prog%ellipse%major**2-prog%ellipse%minor**2)/prog%ellipse%major
    else
       excent = 0.0
    endif
    !
    allocate(prog%indice(nx,ny),stat=ier)
    if (failed_allocate(rname,'indices',ier,error)) return
    !
    prog%inc = sqrt(abs(inc1*inc2))
    prog%nr = 1
    do iy=1,ny
       yval = (iy-ref2)*inc2+val2
       do ix=1,nx
          xval = (ix-ref1)*inc1+val1
          rval = sqrt(xval**2+yval**2)
          if (rval.ne.0d0) then
             theta = atan2(yval/rval,xval/rval)
          else
             theta = 0d0
          endif
          theta = theta-prog%ellipse%pang
          cval = sqrt( rval**2 * (1-(excent*cos(theta))**2)/(1-excent**2) )
          ir = nint(cval/prog%inc)+1 ! ir = 1 when cval = 0
          prog%nr = max(prog%nr,ir)
          prog%indice(ix,iy) = ir
       enddo ! ix
    enddo ! iy
  end subroutine cubemain_circle_prog_compute_indices
  !
  subroutine cubemain_circle_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: itertask
    character(len=*), parameter :: rname='CIRCLE>PROG>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(itertask,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(itertask)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(itertask,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(itertask)
       if (.not.error) &
         call prog%loop(itertask%first,itertask%last,error)
       !$OMP END TASK
    enddo ! itertask
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubemain_circle_prog_data
  !
  subroutine cubemain_circle_prog_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_prog_t), intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='CIRCLE>PROG>LOOP'
    !
    integer(kind=entr_k) :: ie
    type(image_t) :: ima,npix,summ,aver,sigm,mini,maxi
    !
    call ima%associate('ima',prog%cube,error)
    if (error) return
    call npix%allocate('npix',prog%npix,error)
    if (error) return
    call summ%allocate('summ',prog%summ,error)
    if (error) return
    call aver%allocate('aver',prog%aver,error)
    if (error) return
    call sigm%allocate('sigm',prog%sigm,error)
    if (error) return
    call mini%allocate('mini',prog%mini,error)
    if (error) return
    call maxi%allocate('maxi',prog%maxi,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error) return
      call prog%act(ie,ima,npix,summ,aver,sigm,mini,maxi,error)
      if (error) return
    enddo ! ie
  end subroutine cubemain_circle_prog_loop
  !
  subroutine cubemain_circle_prog_act(prog,ie,ima,npix,summ,aver,sigm,mini,maxi,error)
    use cubetools_nan
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(circle_prog_t), intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: ima
    type(image_t),        intent(inout) :: npix
    type(image_t),        intent(inout) :: summ
    type(image_t),        intent(inout) :: aver
    type(image_t),        intent(inout) :: sigm
    type(image_t),        intent(inout) :: mini
    type(image_t),        intent(inout) :: maxi
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy,ir
    integer(kind=pixe_k), parameter :: one=1
    character(len=*), parameter :: rname='CIRCLE>PROG>ACT'
    !
    call ima%get(ie,error)
    if (error) return
    !
    mini%val =  huge(mini%val)
    maxi%val = -huge(maxi%val)
    summ%val = 0e0
    npix%val = 0e0
    do iy=one,ima%ny
       do ix=one,ima%nx
          ir = prog%indice(ix,iy)
          if (.not.ieee_is_nan(ima%val(ix,iy))) then
             mini%val(ir,one) = min(mini%val(ir,one),ima%val(ix,iy))
             maxi%val(ir,one) = max(maxi%val(ir,one),ima%val(ix,iy))
             summ%val(ir,one) = summ%val(ir,one)+ima%val(ix,iy)
             npix%val(ir,one) = npix%val(ir,one)+1.0
          endif
       enddo ! ix
    enddo ! iy
    !
    do ir=one,prog%nr
       if (npix%val(ir,one).ge.1.0) then
          aver%val(ir,one) = summ%val(ir,one)/npix%val(ir,one)
       else
          aver%val(ir,one) = 0
          mini%val(ir,one) = 0
          maxi%val(ir,one) = 0
       endif
    enddo ! ir
    !
    sigm%val = 0d0
    do iy=one,ima%ny
       do ix=one,ima%nx
          ir = prog%indice(ix,iy)
          if (.not.ieee_is_nan(ima%val(ix,iy))) then
             sigm%val(ir,one) = sigm%val(ir,one)+(ima%val(ix,iy)-aver%val(ir,one))**2
          endif
       enddo ! ix
    enddo ! iy
    !
    do ir=one,prog%nr
       if (npix%val(ir,one).gt.1.0) then
          sigm%val(ir,one) = sqrt(sigm%val(ir,one)/(npix%val(ir,one)-1.0))
       else
          sigm%val(ir,one) = 0
       endif
    enddo ! ir
    !
    call npix%put(ie,error)
    if (error) return
    call summ%put(ie,error)
    if (error) return
    call aver%put(ie,error)
    if (error) return
    call sigm%put(ie,error)
    if (error) return
    call mini%put(ie,error)
    if (error) return
    call maxi%put(ie,error)
    if (error) return
  end subroutine cubemain_circle_prog_act
  !
!!$  subroutine cubemain_circle_prog_toascii(prog,error)
!!$    use cubetools_ascii
!!$    use gkernel_interfaces
!!$    use phys_const
!!$    use cubeadm_image_types
!!$    !----------------------------------------------------------------------
!!$    !
!!$    !----------------------------------------------------------------------
!!$    class(circle_prog_t), intent(inout) :: prog
!!$    logical,              intent(inout) :: error
!!$    !
!!$    real(kind=coor_k) :: radius
!!$    integer(kind=chan_k) :: ic
!!$    integer(kind=pixe_k) ::ir
!!$    character(len=file_l) :: filename
!!$    character(len=writ_l) :: line
!!$    character(len=argu_l) :: velo
!!$    type(ascii_file_t)    :: file
!!$    type(image_t) :: npix,summ,aver,sigm,mini,maxi
!!$    character(len=*), parameter :: rname='CIRCLE>PROG>TOASCII'
!!$    !
!!$    call npix%associate('npix',prog%npix,error)
!!$    if (error) return
!!$    call summ%associate('summ',prog%summ,error)
!!$    if (error) return
!!$    call aver%associate('aver',prog%aver,error)
!!$    if (error) return
!!$    call sigm%associate('sigm',prog%sigm,error)
!!$    if (error) return
!!$    call mini%associate('mini',prog%mini,error)
!!$    if (error) return
!!$    call maxi%associate('maxi',prog%maxi,error)
!!$    if (error) return
!!$    !
!!$    do ic=1,prog%npix%head%arr%n%c
!!$       ! Get and open lun
!!$       write(velo,'(f0.2)') prog%npix%head%spe%v%coord(ic)
!!$       write(filename,'(3a)') 'circ-v',trim(velo),'.dat'
!!$       call file%open(filename,'write',error)
!!$       if (error) return
!!$       !
!!$       ! Get data
!!$       call npix%get(ic,error)
!!$       if (error) return
!!$       call summ%get(ic,error)
!!$       if (error) return
!!$       call aver%get(ic,error)
!!$       if (error) return
!!$       call sigm%get(ic,error)
!!$       if (error) return
!!$       call mini%get(ic,error)
!!$       if (error) return
!!$       call maxi%get(ic,error)
!!$       if (error) return
!!$       !
!!$       ! Write
!!$       call file%write_next('    Radius[1]      '//&
!!$            'Npix[2]        Sum[3]         Aver[4]        '//&
!!$            'Sigma[5]       Min[6]         Max[7]',error)
!!$       if (error) return
!!$       do ir=1,prog%npix%head%arr%n%l
!!$          radius = prog%npix%head%spa%l%coord(ir)
!!$          radius = radius*sec_per_rad
!!$          write(line,'(7e15.5)') radius,&
!!$               npix%val(ir,1),summ%val(ir,1),aver%val(ir,1),&
!!$               sigm%val(ir,1),mini%val(ir,1),maxi%val(ir,1)
!!$          call file%write_next(line,error)
!!$          if (error) return
!!$       enddo ! ir
!!$       ! Complete
!!$       call file%close(error)
!!$       if (error) return
!!$    enddo ! ic
!!$  end subroutine cubemain_circle_prog_toascii
end module cubemain_circle
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
