module cubeadm_transpose
  use cubetools_structure
  use cubetools_keyword_arg
  use cubedag_allflags
  use cube_types
  use cubeadm_cubeid_types
  use cubeadm_messaging
  !
  public :: transpose
  public :: cubeadm_transpose_command
  private
  !
  type :: transpose_comm_t
    type(option_t),      pointer :: comm
    type(option_t),      pointer :: access
    type(keyword_arg_t), pointer :: access_arg
  contains
    procedure, public  :: register => cubeadm_transpose_register
    procedure, private :: parse    => cubeadm_transpose_parse
    procedure, private :: main     => cubeadm_transpose_main
  end type transpose_comm_t
  type(transpose_comm_t) :: transpose
  !
  type transpose_user_t
    type(cubeid_user_t)   :: cubeid
     integer(kind=code_k) :: access
  contains
    procedure, private :: toprog => cubeadm_transpose_user_toprog
  end type transpose_user_t
  !
  integer(kind=4), parameter :: icube = 1
  type transpose_prog_t
    type(cube_t), pointer :: incube  ! Input cube
  contains
    procedure, public :: do => cubeadm_transpose_do
  end type transpose_prog_t
  !
contains
  !
  subroutine cubeadm_transpose_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command TRANSPOSE
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(transpose_user_t) :: user
    character(len=*), parameter :: rname='TRANSPOSE>COMMAND'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call transpose%parse(line,user,error)
    if (error) return
    call transpose%main(user,error)
    if (error) return
  end subroutine cubeadm_transpose_command
  !
  subroutine cubeadm_transpose_register(transpose,error)
    !-------------------------------------------------------------------
    ! Register ADM\TRANSPOSE command and its options
    !-------------------------------------------------------------------
    class(transpose_comm_t), intent(inout) :: transpose
    logical,                 intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(keyword_arg_t) :: keyarg
    integer(kind=4), parameter :: naccesses=2
    character(len=*), parameter :: accesses(naccesses) =  &
         (/ 'IMAGE   ','SPECTRUM' /)
    character(len=*), parameter :: rname='TRANSPOSE>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    ! Command
    call cubetools_register_command(&
         'TRANSPOSE','[cube]',&
         'Transpose a cube to the desired access',&
         'Transpose a cube to the desired access by populating its tuple &
         &if relevant. This command is mostly for testing or debugging, as &
         &the transposition is an automatic feature triggered by the commands &
         &when appropriate.',&
         cubeadm_transpose_command,&
         transpose%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         '[CubeID]',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'ACCESS','Type',&
         'Specify the access order of the transposed',&
         'Default is IMAGE',&
         transpose%access,error)
    if (error) return
    call keyarg%register( &
         'Type',  &
         'Access type', &
         strg_id,&
         code_arg_mandatory, &
         accesses,  &
         .not.flexible,  &
         transpose%access_arg,  &
         error)
    if (error) return
  end subroutine cubeadm_transpose_register
  !
  subroutine cubeadm_transpose_parse(transpose,line,user,error)
    use cubetools_disambiguate
    !-------------------------------------------------------------------
    ! Parsing facility for command
    !   TRANSPOSE [CubeID]
    !-------------------------------------------------------------------
    class(transpose_comm_t), intent(in)    :: transpose
    character(len=*),        intent(in)    :: line
    type(transpose_user_t),  intent(out)   :: user
    logical,                 intent(inout) :: error
    !
    character(len=argu_l) :: argum
    character(len=12) :: key
    integer(kind=4) :: iaccess
    logical :: doaccess
    character(len=*), parameter :: rname='TRANSPOSE>PARSE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,transpose%comm,user%cubeid,error)
    if (error) return
    !
    ! /ACCESS IMAGE|SPECTRUM
    call transpose%access%present(line,doaccess,error)
    if (error) return
    if (doaccess) then
      call cubetools_getarg(line,transpose%access,1,argum,mandatory,error)
      if (error) return
      call cubetools_keyword_user2prog(transpose%access_arg,argum,iaccess,key,error)
      if (error) return
      select case (key)
      case ('IMAGE')
        user%access = code_access_imaset
      case ('SPECTRUM')
        user%access = code_access_speset
      case default
        call cubeadm_message(seve%e,rname,'Unknown access')
        error = .true.
        return
      end select
    else
      user%access = code_access_imaset  ! Default
    endif
  end subroutine cubeadm_transpose_parse
  !
  subroutine cubeadm_transpose_main(transpose,user,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(transpose_comm_t), intent(in)    :: transpose
    type(transpose_user_t),  intent(in)    :: user
    logical,                 intent(inout) :: error
    !
    type(transpose_prog_t) :: prog
    character(len=*), parameter :: rname='TRANSPOSE>MAIN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%do(error)
    if (error) return
  end subroutine cubeadm_transpose_main
  !
  subroutine cubeadm_transpose_user_toprog(user,prog,error)
    use cubeadm_get
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(transpose_user_t), intent(in)    :: user
    type(transpose_prog_t),  intent(out)   :: prog
    logical,                 intent(inout) :: error
    !
    character(len=*), parameter :: rname='TRANSPOSE>USER2PROG'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(transpose%comm,icube,user%cubeid,&
         user%access,code_read,prog%incube,error)
    if (error) return
  end subroutine cubeadm_transpose_user_toprog
  !
  subroutine cubeadm_transpose_do(prog,error)
    use cubetuple_transpose
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    class(transpose_prog_t), intent(in)    :: prog
    logical,                 intent(inout) :: error
    !
    call cubetuple_autotranspose_cube(prog%incube,error)
    if (error)  return
  end subroutine cubeadm_transpose_do
end module cubeadm_transpose
