!
!  Id: parametersSource,v 1.2.4 2015-06-18 Hans Ungerechts
!  Id: parametersSource,v 1.2.3 2014-10-16 Hans Ungerechts
!  Id: parametersSource,v 1.2.3 2014-06-09 Hans Ungerechts
!  Id: parametersSource,v 1.2.3 2014-02-13 Hans Ungerechts
!  Id: parametersSource,v 1.2.3 2014-01-23 Hans Ungerechts
!  Id: parametersSource,v 1.2.2 2013-08-** Hans Ungerechts
!  based on:
!  Id: parametersSource,v 1.1.3 2010-09-23 Hans Ungerechts
!
Call pako_message(seve%t,programName,                                            &
     &    " module source,   --> parametersSource,v 1.2.4 2015-06-18 ")          !
!
catalogOpen = .False.
!
error  = .False.
errorL = .False.
errorC = .False.
errorR = .False.
!
vars(iIn)%isPlanet    = .False.
vars(iIn)%isSatellite = .False.
vars(iIn)%isBody      = .False.
vars(iIn)%isTipCurAzi = .False.
!
vars(iIn)%projectID   = GPnone 
!
longitudeFromVariable = .False.
latitudeFromVariable  = .False.
longitudeValue        = ""
latitudeValue         = ""
!
! *** Source name
!
If (SIC_NARG(0).Ge.1.) Then
   !
   If (GV%doDebugMessages) Then
      Write (6,*) "   -> Read parameters for Source: "
      Write (6,*) "      ERROR:   ", ERROR
   End If
   !
   !     --> NB: the following part revised 2014-01-22, 23                       ! !! --> 2014-01-22, 23
   !             to check against source name > 12 characters                      
   !             and to clean up error propragation
   !             Note analogy to handling of line name in RECEIVER
   !
   !D    Write (6,*) "   -> read source name into cInputLong "
   !
   iOption   = 0
   iArgument = 1
   If (SIC_PRESENT(iOption,iArgument)) Then
      Call SIC_CH(LINE,iOption,iArgument,                                        &
           &         cInputLong,lengthInput,.True.,errorC)                       !
   Else
      errorL = .True.
      messageText = "no source name specified"       
      Call PakoMessage(priorityI,severityI,command,messageText)
   End If
   !
   ERROR = ERROR .Or. errorC .Or. errorL
   !
   If (GV%doDebugMessages) Then
      Write (6,*) "      errorC:  ", errorC
      Write (6,*) "      errorL:  ", errorL
      Write (6,*) "      ERROR:   ", ERROR
   End If
   !
   !D    If (GV%doDebugMessages) Then
   !D       Write (6,*) "  "
   !D    Write (6,*) "  --> handle special case TipCurrentAzimuth"
   !D    Write (6,*) "      SpecialSources%TipCurAzi :   -->",                         &
   !D         &                          SpecialSources%TipCurAzi, "<--"               !
   !D       Write (6,*) "  cInputLong:                 ",                              &
   !D            &                           "-->", cInputLong, "<--"                  !
   !D       Write (6,*) "  lengthInput:                ", lengthInput
   !D       Write (6,*) "  cInputLong(1:lengthInput):  ",                              &
   !D            &                           "-->", cInputLong(1:lengthInput), "<--"   !
   !D       Write (6,*) "  "
   !D       Write (6,*) "      vars(iIn)%isTipCurAzi: ", vars(iIn)%isTipCurAzi
   !D    End If
   !
   If ( cInputLong(1:lengthInput)                                                &
        &     .Eq.SpecialSources%TipCurAzi(1:lengthInput) ) Then                 !
      !
      messageText = "special source "//SpecialSources%TipCurAzi
      Call PakoMessage(priorityI,severityI,command,messageText)
      vars(iIn)%isTipCurAzi = .True.
      !
   Else
      !
      !D    Write (6,*) "   -> check length "
      !
      errorC = lengthInput.Lt.1 .Or. lengthInput.Gt.12
      If (errorC) then
         messageText = "source name must have between 1 and 12 charcters"
         Call PakoMessage(priorityI,severityI,command,messageText)
      End If
      !
   End If
   !
   ERROR = ERROR .Or. errorC
   !
   !D    Write (6,*) "   -> check special char "
   !
   If (GV%privilege .Eq. setPrivilege%ncsTeam) Then
      Call pakoSpecialChar(cInputLong,"/<>&",command=command,hasSpecial=errorC)
   Else
      Call pakoSpecialChar(cInputLong,"/<>&()",command=command,hasSpecial=errorC)
   End If
   !
   ERROR = ERROR .Or. errorC
   !
   If (ERROR) Then
      messageText = " --> source name "//cInputLong(1:lengthInput)//" invalid"
      Call PakoMessage(priorityE,severityE,command,messageText)
   End If
   !
   If (.Not.ERROR) Then
      cInput       = cInputLong(1:12)
      cInputUpper  = cInput
      cInputUpper2 = cInput
      Call SIC_UPPER(cInputUpper2)
   End If
   !
   !D    Write (6,*) "      cInput:        ", cInput
   !D    Write (6,*) "      cInputUpper:   ", cInputUpper
   !D    Write (6,*) "      cInputUpper2:  ", cInputUpper2
   !
   If (SIC_PRESENT(iOption,iArgument)                                            &
        &       .And. .Not. ERROR) Then                                          !
      vars(iIn)%sourceName = cInput
      messageText =                                                              &
           &        "SOURCE  "//                                                 &
           &        vars(iIn)%sourceName                                         !
      Call PakoMessage(priorityI,severityI,command,messageText)
   End If
   !
Else   !!!   --> not (SIC_NARG(0).Ge.1.)
   !
   errorL = .True.
   messageText = "no source name specified"
   Call pakoMessage(priorityI,severityI,command,messageText)
   !
End If
!
!!  TBD: is this needed?
!!  ERROR = ERROR .OR. errorL
!
If (GV%doDebugMessages) Then
   Write (6,*) "      errorC:  ", errorC
   Write (6,*) "      errorL:  ", errorL
   Write (6,*) "      ERROR:   ", ERROR
End If
!                                                                                ! !! 2014-01-22, 23 <--
!
If (.Not. error) Then
   !
   ! *** solar system BODY
   !
   If (cInputUpper2 .Eq. "BODY") Then
      !
      If (SIC_NARG(0).Eq.8) Then
         !
         vars(iIn)%isBody      = .True.
         vars(iIn)%isPlanet    = .False.
         vars(iIn)%isSatellite = .False.
         !
         messageText =                                                           &
              &        "Solar System Body ..."                                   !
         Call pakoMessage(priorityI,severityI,command//' Body',messageText)
         !
         ! **  Body name
         iOption   = 0
         iArgument = 2
         Call SIC_CH(LINE,iOption,iArgument,                                     &
              &        cInput,lengthInput,.True.,errorC)                         !
         cInputUpper = cInput
         !
         If (.Not. errorC) Then
            vars(iIn)%sourceName = cInput
         Else
            errorL = .True.
            messageText =                                                        &
                 &        "no body name specified"                               !
            Call pakoMessage(priorityE,severityE,command,messageText)
         End If
         !
         error = error .Or. errorC .Or. errorL
         !
         ! **  Perihelion Epoch
         iArgument = 3
         If (SIC_PRESENT(0,iArgument)) Then
            Call SIC_CH(LINE,0,iArgument,                                        &
                 &           cInputVar,lengthInput,.False.,errorC)               !
            If (cInputVar(1:1).Ne.'*') Then
               Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
               !D  Write (6,*) "   cInputVar :  ", cInputVar(1:lengthInput)
               !D  Write (6,*) "   dInput    :  ", dInput
               !D  Write (6,*) "   errorC    :  ", errorC
               !D  Write (6,*) "   errorR    :  ", errorR
               If (.Not. errorR) Then
                  Call checkR8(command,dInput,                                   &
                       &               vars%perihelionEpoch,                     &
                       &               errorR)                                   !
               Endif
            Endif
         End If
         !
         error = error .Or. errorC .Or. errorR
         !
         ! **  Ascending Node
         iArgument = 4
         If (SIC_PRESENT(0,iArgument)) Then
            Call SIC_CH(LINE,0,iArgument,                                        &
                 &           cInputVar,lengthInput,.False.,errorC)               !
            If (cInputVar(1:1).Ne.'*') Then
               Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
               If (.Not. errorR) Then
                  Call checkR8(command,dInput,                                   &
                       &               vars%ascendingNode,                       &
                       &               errorR)                                   !
               Endif
            Endif
         End If
         !
         error = error .Or. errorC .Or. errorR
         !
         ! **  Argument of Perihelion
         iArgument = 5
         If (SIC_PRESENT(0,iArgument)) Then
            Call SIC_CH(LINE,0,iArgument,                                        &
                 &           cInputVar,lengthInput,.False.,errorC)               !
            If (cInputVar(1:1).Ne.'*') Then
               Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
               If (.Not. errorR) Then
                  Call checkR8(command,dInput,                                   &
                       &               vars%argumentOfPerihelion,                &
                       &               errorR)                                   !
               Endif
            Endif
         End If
         !
         error = error .Or. errorC .Or. errorR
         !
         ! **  Inclination
         iArgument = 6
         If (SIC_PRESENT(0,iArgument)) Then
            Call SIC_CH(LINE,0,iArgument,                                        &
                 &           cInputVar,lengthInput,.False.,errorC)               !
            If (cInputVar(1:1).Ne.'*') Then
               Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
               If (.Not. errorR) Then
                  Call checkR8(command,dInput,                                   &
                       &               vars%inclination,                         &
                       &               errorR)                                   !
               Endif
            Endif
         End If
         !
         error = error .Or. errorC .Or. errorR
         !
         ! **  Perihelion Distance
         iArgument = 7
         If (SIC_PRESENT(0,iArgument)) Then
            Call SIC_CH(LINE,0,iArgument,                                        &
                 &           cInputVar,lengthInput,.False.,errorC)               !
            If (cInputVar(1:1).Ne.'*') Then
               Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
               If (.Not. errorR) Then
                  Call checkR8(command,dInput,                                   &
                       &               vars%perihelionDistance,                  &
                       &               errorR)                                   !
               Endif
            Endif
         End If
         !
         error = error .Or. errorC .Or. errorR
         !
         ! **  Eccentricity
         iArgument = 8
         If (SIC_PRESENT(0,iArgument)) Then
            Call SIC_CH(LINE,0,iArgument,                                        &
                 &           cInputVar,lengthInput,.False.,errorC)               !
            If (cInputVar(1:1).Ne.'*') Then
               Call SIC_R8(LINE,iOption,iArgument,dInput,.False.,errorR)
               If (.Not. errorR) Then
                  Call checkR8(command,dInput,                                   &
                       &               vars%eccentricity,                        &
                       &               errorR)                                   !
               Endif
            Endif
         End If
         !
         error = error .Or. errorC .Or. errorR
         !
      Else
         messageText =                                                           &
              &        "body's name + 6 more arguments are required"             !
         Call pakoMessage(priorityE,severityE,command//' BODY',messageText)
         ERROR = .True.
         vars(iIn)%isBody     = .False.
      End If
   Else
      vars(iIn)%isBody     = .False.
   End If
   !
   ! *** Match for planets or satellites if syntax is: "SOURCE something"
   ! *** Planets
   !
   If ( GV%matchSource .Eq. setMatchSource%Start) Then
      howTo = " start upper quiet"
   Else If ( GV%matchSource .Eq. setMatchSource%Match) Then
      howTo = " match upper quiet"
   Else
      howTo = " exact upper quiet"
   End If
   !
   !D       Write (6,*) "            howTo: ", howTo
   !
   If (.Not.vars(iIn)%isBody .And. SIC_NARG(0).Eq.1) Then
      !
      !D       Write (6,*) " SOURCE --> try for Planets"
      !D       Write (6,*) "            cInputUpper: ", cInputUpper
      !D       Write (6,*) "            planetChoices: ", planetChoices
      !
      Call pakoUmatchKey (                                                       &
           &              keys=planetChoices,                                    &
           &              key=cInputUpper,                                       &
           &              command=command,                                       &
           &              howto=howTo,                                           &
           &              iMatch=iMatch,                                         & 
           &              nMatch=nMatch,                                         &
           &              error=errorM,                                          &
           &              errorCode=errorCode                                    &
           &             )                                                       !
      !
      If (.Not. errorM) Then
         vars(iIn)%sourceName  = planetChoices(iMatch)
         vars(iIn)%isPlanet    = .True.
         vars(iIn)%isSatellite = .False.
         vars(iIn)%isBody      = .False.
      End If
      !
   End If
   !
   ! *** Satellites
   !
   If (.Not.vars(iIn)%isBody .And. .Not.(vars(iIn)%isPlanet)                     &
        &                    .And. SIC_NARG(0).Eq.1 ) Then                       !
      !
      Call pakoUmatchKey (                                                       &
           &              keys=satChoices,                                       &
           &              key=cInputUpper,                                       &
           &              command=command,                                       &
           &              howto=howTo,                                           &
           &              iMatch=iMatch,                                         & 
           &              nMatch=nMatch,                                         &
           &              error=errorM,                                          &
           &              errorCode=errorCode                                    &
           &             )                                                       !
      !
      !D               Write (6,*) ' SOURCE --> iMatch: ', iMatch
      !D               Write (6,*) ' SOURCE --> nMatch: ', nMatch
      !D               Write (6,*) ' SOURCE --> errorM: ', errorM
      !D               Write (6,*) ' SOURCE --> errorCode: ', errorCode
      !
      If (.Not. errorM) Then
         vars(iIn)%sourceName  = satChoices(iMatch)
         vars(iIn)%isPlanet    = .False.
         vars(iIn)%isSatellite = .True.
         vars(iIn)%isBody      = .False.
      End If
      !
   End If
   !
   If (vars(iIn)%isPlanet .Or. vars(iIn)%isSatellite) Then
      !
      vars(iIn)%systemName = "PL"
      vars(iIn)%epoch      = 2000.0
      vars(iIn)%longitude%name="longitude  "
      vars(iIn)%longitude%text="  :  :  "
      vars(iIn)%longitude%rad=0.0d0
      vars(iIn)%longitude%deg=0.0d0
      vars(iIn)%longitude%hour=0.0d0
      vars(iIn)%latitude%name="latitude  "
      vars(iIn)%latitude%text="  :  :  "
      vars(iIn)%latitude%rad=0.0d0
      vars(iIn)%latitude%deg=0.0d0
      vars(iIn)%latitude%hour=0.0d0
      vars(iIn)%velocity%name="radialVelo"
      vars(iIn)%velocity%type="none"
      vars(iIn)%velocity%unit="km/s"
      vars(iIn)%velocity%value=0.0
      vars(iIn)%flux=0.0
      vars(iIn)%index=0.0
      !
   End If
   !
   ! *** Source with coordinates
   !
   If (            .Not.vars(iIn)%isBody                                         &
        &    .And. .Not.vars(iIn)%isPlanet                                       &
        &    .And. .Not.vars(iIn)%isSatellite ) Then                             !
      !
      !D Write (6,*) ' SOURCE --> source from command line or catalog'
      !
      If (.Not.error) Then
         !
         If (SIC_PRESENT(0,2)) Then                                                ! Source coordinates should be in command line
            !
            ! **  Source coordinates should be in command line
            !
            !!OLD  ii = Index(line,'/')
            !!OLD  If (ii.Eq.0) ii = LENC(line)+1
            !!OLD  cInputLong  = line(12:ii-1)                                     ! skip language, command, and options
            !!OLD  Write (6,*) "   cInputLong ->", cInputLong, "<-"
            !!OLD  lengthInput = LENC(cInputLong)
            !
            ii = Index(line,char(92))+1
            If (ii.Le.1) ii = 1
            jj = Index(line,'/')-1
            If (jj.Lt.1) jj = len_trim(line)
            cInputLong  = line(ii:jj)                                              ! skip language and options
            lengthInput = len_trim(cInputLong)
            !
            Call SIC_BLANC(cInputLong,lengthInput)
            !
            nPar = 1
            lPar = 12
            Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)                       ! skip SOURCE
            Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)                       ! skip source name
            !D Write (6,*) "   cInputLong ->", cInputLong,   "<-"
            !D Write (6,*) "   cPar       ->", cPar(1:lPar), "<-"
            errorNotFound = .False.
            !
         Else                                                                      ! Source coordinates should be in catalog
            !
            ! **  Source coordinates should be in catalog
            !
            If (vars(iIn)%sourceCatalog .Ne. GPnone) Then
               cFile = vars(iIn)%sourceCatalog
            Else
               cFile = GVsourceCatalog(1)
            End If
            !
            If (Len_trim(cFile).Eq.0) Then
               errorNotFound = .True.
               messageText = "no source catalog specified"
               Call pakoMessage(priorityE,severityE,command,messageText)
            Else
               ! 
               Close(unit=ioUnit%read)
               Open(unit=ioUnit%read, action='read',                             &
                    &                 file=cFile(1:Len_trim(cFile)),             &
                    &                 status='old', iostat=ier)                  !
               If (ier .Gt. 0) Then
                  errorNotFound = .True.
                  messageText = "could not open source catalog: "                &
                       &        //cFile(1:Len_trim(cFile))                       !
                  Call pakoMessage(priorityE,severityE,command,messageText)
               Else
                  catalogOpen = .True.
                  found = .False.
                  ioerr = 0
                  !
                  Do While (.Not. found .And. ioerr.Eq.0)
                     Read(ioUnit%read,'(Q,A)',iostat=ioerr)                      &
                          &           lengthInput, cInputLong                    !
                     !
                     !        ignore empty lines & comments 
                     If (lengthInput.Gt.0 .And. cInputLong(1:1).Ne.'!') Then
                        Call SIC_BLANC(cInputLong,lengthInput)
                        nPar = 1
                        lPar = 36
                        Call SIC_NEXT(cInputLong,cPar,lPar,nPar)
                        If (lPar.Ne.0) Then
                           found = .False.
                           name  = vars(iIn)%sourceName
                           lname = Len_trim(name)
                           Call SIC_UPPER(name)
                           cPar2 = cPar
                           Call SIC_UPPER(cPar2)
                           !
                           !
                           !
                           !
                           !
                           If ( GV%matchSource .Eq. setMatchSource%Start) Then   
                              If (name(1:lname).Eq.cPar2(1:lname)) Then
                                 found = .True.
                              End If
                           Else If ( GV%matchSource .Eq. setMatchSource%Match)   &
                                &   Then                                         !
                              If (Index(cPar2,name(1:lname)) .Ge. 1) Then
                                 found = .True.
                              End If
                           Else
                              Call CHECKSOURCE(name,lname,cPar2,lPar,found)
                           End If
                           !
                        Endif
                     Endif
                  Enddo
                  Close(unit=ioUnit%read)
                  !
                  If (found) Then
                     errorNotFound = .False.
                     errorSourceNotInCatalog = .False.
                     vars(iIn)%sourceName = cPar(1:Len_trim(cPar))
                  Else
                     errorNotFound = .True.
                     errorSourceNotInCatalog = .True.
                     messageText =                                               &
                          &           "source not found in catalog: "            &
                          &           //cFile(1:Len_trim(cFile))                 !
                     Call pakoMessage(priorityE,severityE,command,messageText)
                  End If
                  !
               End If
               !
            End If
            !
         End If   !!   source coordinates in command line or catalog
         !
      End If
      !
      ERROR = ERROR .Or. errorNotFound
      !
      If (.Not. ERROR) Then
         !
         ! **  coordinate system and epoch
         !
         nPar1 = nPar                                     ! position system  
         lPar  = 2
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar) ! system type ?
         !
         If (lpar.Gt.0) Then
            !
            ioerr = 0
            !
            cpar2 = cpar
            !
            !D             Write (6,*) ' system ->cpar2       -->',cpar2(1:len_trim(cpar)),"<--"
            !D             Write (6,*) ' system ->systemChoices: ', systemChoices
            !D             Write (6,*) '          cpar2(1:1): -->',cpar2(1:1),"<--"
            !
            !!  check if cpar2(1:1) is 0 1 or 2 (reasonable values for RA)
            !
            If (         cpar2(1:1).Eq."0"                                       &
                 &  .Or. cpar2(1:1).Eq."1"                                       &
                 &  .Or. cpar2(1:1).Eq."2"   ) Then                              !
               !
               vars(iIn)%systemName        = sys%equatorial
               vars(iIn)%equinoxSystemName = equ%B
               vars(iIn)%epoch             = 1950.0
               npar = npar1
               !
               errorM = .True.  !! to be consistent with following pakoUmatchKey
               !
               messageText = "default system and equinox: eq B1950.0 "
               Call pakoMessage(priorityI,severityI,command,messageText)
               !
            Else
               ! 
               Call pakoUmatchKey (                                              &
                    &              keys=systemChoices,                           &
                    &              key=cpar2,                                    &
                    &              command=command,                              &
                    &              howto='start upper',                          &
                    &              iMatch=iMatch,                                & 
                    &              nMatch=nMatch,                                &
                    &              error=errorM,                                 &
                    &              errorCode=errorCode                           &
                    &             )                                              !
               !
               If      (      .Not. errorM                                       &
                    &   .And. iMatch.Ne.0                                        &
                    &   .And. .Not. (     iMatch.Eq.iEquatorial                  &
                    &                .Or. iMatch.Eq.iGalactic                    &
                    &                .Or. iMatch.Eq.iHorizontal )                &
                    &  )  Then                                                   !
                  errorM = .True.
                  messageText =                                                  &
                       & "system "//systemChoices(iMatch)                        &
                       &          //" is not yet supported"                      !
                  Call pakoMessage(priorityE,severityE,command,messageText)
               End If
               !
               If      (            iMatch.Eq.ihorizontal                        &
                    &  )  Then                                                   !
                  messageText =                                                  &
                       & "system "//systemChoices(iMatch)//                      &
                       & " is ONLY useful in special cases"                      !
                  Call pakoMessage(priorityW,severityW,command,messageText)
               End If
               !
               If      (      .Not. errorM                                       &
                    &   .And. iMatch.Ne.0                                        &
                    &   .And. vars(iIn)%isTipCurAzi                              &
                    &   .And. .Not. iMatch.Eq.iHorizontal                        &
                    &  )  Then                                                   !
                  errorM = .True.
                  messageText =                                                  &
                       &   " for source "//SpecialSources%TipCurAzi              &
                       & //" system MUST be "//sys%horizontal                    !
                  Call pakoMessage(priorityE,severityE,command,messageText)
               End If
               !
               If (.Not.errorM) Then
                  vars(iIn)%systemName = systemChoices(iMatch)
               End If
               !
               ERROR = ERROR .Or. errorM
               !
            End If  !!  cpar2(1:1) is 0 1 or 2 
            !
            If (.Not.errorM .And.                                                &
                 &  vars(iIn)%systemName .Eq. sys%equatorial .Or.                &
                 &  vars(iIn)%systemName .Eq. sys%ecliptic) Then                 !
               lPar = 12
               Call SIC_NEXT(cInputLong(nPar:),cPar3,lPar,nPar)                  ! Epoch 
               If (lPar.Ge.2) Then
                  cPar4 = cPar3(1:1)
                  Call pakoUmatchKey (                                           &
                       &              keys=equinoxChoices,                       &
                       &              key=cpar4,                                 &
                       &              command=command,                           &
                       &              howto='start upper quiet',                 &
                       &              iMatch=iMatch,                             & 
                       &              nMatch=nMatch,                             &
                       &              error=errorM,                              &
                       &              errorCode=errorCode                        &
                       &             )                                           !
                  If (.Not. errorM) Then
                     vars(iIn)%equinoxSystemName = equinoxChoices(iMatch)
                     cPar3 = cPar3(2:Len_trim(cPar3))
                  Else
                     vars(iIn)%equinoxSystemName = equ%J
                  End If
               End If
               lPar = Len_trim(cPar3)
               If (lPar.Ge.1) Then
                  Read(cPar3(1:lPar),*,iostat=ioerr) epoch
               End If
               If (lPar.Gt.0 .And. ioerr.Eq.0) Then
                  Call checkR4(command,epoch,                                    &
                       vars%epoch,                                               &
                       errorR)                                                   !
                  error = error .Or. errorR
               Else
                  ERROR = .True.
                  messageText =                                                  &
                       & "error decoding system and epoch: "                     &
                       & //cPar(1:Len_trim(cpar))//" "//cPar3(1:lPar)            !
                  Call pakoMessage(priorityE,severityE,command,messageText)
               End If
            End If
            !
            If (abs(vars(iIn)%epoch-2000.0).Ge.0.001) Then
               Write (messageText,*)                                             &
                    & "epoch ", vars(iIn)%epoch," is NOT yet well tested "       !
               Call pakoMessage(priorityW,severityW,command,messageText)
            End If
            !
            !D Write (6,*) "  vars(iIn)%systemName:         ",                   &
            !D      &  vars(iIn)%systemName                                      !
            !D Write (6,*) "  vars(iIn)%equinoxSystemName:  ",                   &
            !D      &  vars(iIn)%equinoxSystemName                               !
            !D Write (6,*) "  vars(iIn)%epoch:              ",                   &
            !D      &  vars(iIn)%epoch                                           !
            !
         End If
         !
      End If   ! ERROR
      !
      If (.Not. ERROR) Then
         !
         ! *** longitude
         errorR = .False.
         lPar = 40
         Call SIC_NEXT(cInputLong(nPar:),cPar,lPar,nPar) 
         !
         !     --> NB: the following part revised 2014-02-13                     ! !! --> 2014-02-13
         !             to evaluate longitude from command LINE,
         !             in particular, allow longitude in a character(!) variable        
         !
         If (GV%doDebugMessages) Then
            Write (6,*) "    cInputLong ->",cInputLong(1:lengthInput),"<-"
            Write (6,*) "    nPar:        ",nPar
            Write (6,*) "    lPar:        ",lPar
            Write (6,*) "    cPar       ->",cPar(1:lPar),"<-"
         End If
         !
         If (        vars(iIn)%systemName.Eq.sys%equatorial      ) Then
            iOption   = 0
            iArgument = 4
         End If
         !
         If (          vars(iIn)%systemName.Eq.sys%horizontal                    &
              &  .Or.  vars(iIn)%systemName.Eq.sys%galactic   ) Then             !
            iOption   = 0
            iArgument = 3
         End If
         !
         If (SIC_PRESENT(iOption,iArgument)) Then
            !
            Call SIC_CH(LINE,iOption,iArgument,                                  &
                 &         cInput,lengthInput,.True.,errorC)                     !
            !
            If (.Not. errorC) Then
               longitudeInCommandLine = .True.
               longitudeFromVariable  = .True.                                   !  !!  2015-06-18          
               longitudeValue = cInput(1:12)                                     !  !!  for display of value
            End if
            !        
            If (GV%doDebugMessages) Then 
               Write (6,*) "    LINE                  ->",                       &
                    &           LINE(1:len_trim(LINE)),"<-"                      !
               Write (6,*) "    cInput                ->",                       &
                    &           cInput(1:len_trim(cInput)),"<-"                  !
               Write (6,*) "    longitudeFromVariable:  ", longitudeFromVariable
               Write (6,*) "    longitudeValue        ->",                       &
                    &           longitudeValue(1:len_trim(longitudeValue)),"<-"  !
            End If
            !
         Else
            longitudeInCommandLine = .False.
            messageText = "no longitude specified on command line"
            Call PakoMessage(priorityI,severityI,command,messageText)
         End If
         !
         If (lPar.Gt.0 ) Then
            !
            If (        vars(iIn)%systemName.Eq.sys%equatorial                   &
                 & .Or. vars(iIn)%systemName.Eq.sys%apparentEquatorial           &
                 & .Or. vars(iIn)%systemName.Eq.sys%haDec                        &
                 &  ) Then                                                       !
               If (vars(iIn)%systemName.Eq.sys%equatorial                        &
                    &   .And.longitudeInCommandLine) Then                        !
                  Call CVDEG(cInput,lengthInput,'H',LAMBDA,errorR)               ! !! decode lambda Hours from command line
               Else
                  Call CVDEG(cPar,lPar,'H',LAMBDA,errorR)                        ! !! decode lambda Hours
               End If
            Else
               If (          (       vars(iIn)%systemName.Eq.sys%horizontal      &
                    &          .Or.  vars(iIn)%systemName.Eq.sys%galactic        &
                    &        )                                                   &
                    &   .And. longitudeInCommandLine) Then                       !
                  Call CVDEG(cInput,lengthInput,'D',LAMBDA,errorR)               ! !! decode lambda Deg from command line
               Else
                  Call CVDEG(cPar,lPar,'D',LAMBDA,errorR)                        ! !! decode lambda Deg
               End If
            Endif
            !
            !D             Write (6,*) "   lambda: ", lambda
            !
            !                                                                    ! !! 2014-02-13 <--
            !
            If (.Not. errorR) Then
               Call checkR8(command,lambda,                                      &
                    vars%longitude%rad,                                          &
                    errorR)                                                      !
               If (.Not. errorR) Then
                  vars(iIn)%longitude%name="longitude  "
                  vars(iIn)%longitude%text=cPar(1:12)
                  If (SIC_PRESENT(iOption,iArgument)) Then                       !  !!  2015-06-18          
                     vars(iIn)%longitude%text=longitudeValue                     !  !!  for display of value
                  End If                                                         !  !!  from variable
                  vars(iIn)%longitude%rad=lambda
                  vars(iIn)%longitude%deg=vars(iIn)%longitude%rad/degs
                  vars(iIn)%longitude%hour=vars(iIn)%longitude%rad/degs/15.0d0
               Else
                  messageText = "can not decode "//cPar(1:12)
                  Call pakoMessage(priorityE,severityE,command,messageText)
               End If
               error = error .Or. errorR
            End If
            error = error .Or. errorR  !! added 2007-02-08
            !
            !D Write (6,*) "  vars(iIn)%longitude%name: ",                       &
            !D      &               vars(iIn)%longitude%name
            !D Write (6,*) "  vars(iIn)%longitude%text: ",                       &
            !D      &               vars(iIn)%longitude%text
            !D Write (6,*) "  vars(iIn)%longitude%rad: ",                        &
            !D      &               vars(iIn)%longitude%rad
            !D Write (6,*) "  vars(iIn)%longitude%hour: ",                       &
            !D      &               vars(iIn)%longitude%hour
            !D Write (6,*) "  vars(iIn)%longitude%deg: ",                        &
            !D      vars(iIn)%longitude%deg
            !
         End If  ! lPar
      End If     ! ERROR
      !
      If (.Not. ERROR) Then
         !
         ! *** latitude
         errorR = .False.
         lPar = 40
         Call SIC_NEXT(cInputLong(nPar:),cPar,lPar,nPar)
         !
         !     --> NB: the following part revised 2014-02-13                     ! !! --> 2014-02-13
         !             to evaluate longitude from command LINE,
         !             in particular, allow latitude in a character(!) variable
         !
         If (GV%doDebugMessages) Then
            Write (6,*) "    cInputLong ->",cInputLong(1:lengthInput),"<-"
            Write (6,*) "    nPar:        ",nPar
            Write (6,*) "    lPar:        ",lPar
            Write (6,*) "    cPar       ->",cPar(1:lPar),"<-"
         End If
         !
         If (        vars(iIn)%systemName.Eq.sys%equatorial      ) Then
            iOption   = 0
            iArgument = 5
         End If
         !
         If (          vars(iIn)%systemName.Eq.sys%horizontal                    &
              &  .Or.  vars(iIn)%systemName.Eq.sys%galactic   ) Then             !
            iOption   = 0
            iArgument = 4
         End If
         !
         If (SIC_PRESENT(iOption,iArgument)) Then
            !
            Call SIC_CH(LINE,iOption,iArgument,                                  &
                 &         cInput,lengthInput,.True.,errorC)                     !
            !
            If (.Not. errorC) Then
               latitudeInCommandLine = .True.
               latitudeFromVariable  = .True.                                    !  !!  2015-06-18          
               latitudeValue = cInput(1:12)                                      !  !!  for display of value
            End if
            !        
            If (GV%doDebugMessages) Then 
               Write (6,*) "    LINE                  ->",                       &
                    &           LINE(1:len_trim(LINE)),"<-"                      !
               Write (6,*) "    cInput                ->",                       &
                    &           cInput(1:len_trim(cInput)),"<-"                  !
               Write (6,*) "    latitudeFromVariable:  ", latitudeFromVariable
               Write (6,*) "    latitudeValue        ->",                        &
                    &           latitudeValue(1:len_trim(latitudeValue)),"<-"    !
            End If
            !
         Else
            latitudeInCommandLine = .False.
            messageText = "no latitude specified on command line"
            Call PakoMessage(priorityI,severityI,command,messageText)
         End If
         !
         If (lPar.Gt.0 ) Then
            !
            If (         (       vars(iIn)%systemName.Eq.sys%equatorial          & 
                 &         .Or.  vars(iIn)%systemName.Eq.sys%horizontal          &
                 &         .Or.  vars(iIn)%systemName.Eq.sys%galactic            &
                 &       )                                                       &
                 & .And. latitudeInCommandLine) Then                             !
               Call CVDEG(cInput,lengthInput,'D',BETA,errorR)                    ! !! decode beta Deg from command line
            Else
               Call CVDEG(cPar,lPar,'D',BETA,errorR)                             ! !! decode beta Deg
            End If
            !
            !D             Write (6,*) "   beta: ", beta
            !
            !
            !                                                                    ! !! 2014-02-13 <--
            !
            If (.Not. errorR) Then
               Call checkR8(command,beta,                                        &
                    &vars%latitude%rad,                                          &
                    &errorR)                                                     !
               If (.Not. errorR) Then
                  vars(iIn)%latitude%name="latitude  "
                  vars(iIn)%latitude%text=cPar(1:12)
                  If (SIC_PRESENT(iOption,iArgument)) Then                       !  !!  2015-06-18          
                     vars(iIn)%latitude%text=latitudeValue                       !  !!  for display of value
                  End If                                                         !  !!  from variable
                  vars(iIn)%latitude%rad=beta
                  vars(iIn)%latitude%deg=vars(iIn)%latitude%rad/degs
                  vars(iIn)%latitude%hour=vars(iIn)%latitude%rad/degs/15.0d0
               Else
                  messageText = "can not decode "//cPar(1:12)
                  Call pakoMessage(6,3,command,messageText)
               End If
               error = error .Or. errorR
            End If
            !
            !D      Write (6,*) "  vars(iIn)%latitude%name: ",                   &
            !D     &               vars(iIn)%latitude%name
            !D      Write (6,*) "  vars(iIn)%latitude%text: ",                   &
            !D     &               vars(iIn)%latitude%text
            !D      Write (6,*) "  vars(iIn)%latitude%rad: ",                    &
            !D     &               vars(iIn)%latitude%rad
            !D      Write (6,*) "  vars(iIn)%latitude%hour: ",                   &
            !D     &               vars(iIn)%latitude%hour
            !D      Write (6,*) "  vars(iIn)%latitude%deg: ",                    &
            !D                     vars(iIn)%latitude%deg
            !D
            !
         End If  ! lPar
      End If     ! ERROR
      !
      !
      If (.Not. ERROR) Then
         !
         ! *** velocity
         !
         nPar1 = nPar                                       ! previous position 
         lPar = 1
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
         !
         If (lpar.Gt.0) Then
            !
            ioerr = 0
            !
            cPar2 = cPar
            Call SIC_UPPER(cPar2)
            !
            !!OLD !!$ If (cPar2(1:2).Eq."EA") Then
            !!OLD !!$    cPar2 = refFrame%geocentric  ! for compa PdB
            !!OLD !!$    messageText = 'reference frame '//cPar(1:Len_trim(cPar))  &
            !!OLD !!$         &    //' interpreted as: '//refFrame%geocentric
            !!OLD !!$    Call pakoMessage(priorityW,severityW,command,messageText)
            !!OLD !!$ End If
            !
            Call pakoUmatchKey (                                                 &
                 &              keys=refFrameChoices,                            &
                 &              key=cPar2,                                       &
                 &              command=command,                                 &
                 &              howto='start upper',                             &
                 &              iMatch=iMatch,                                   & 
                 &              nMatch=nMatch,                                   &
                 &              error=errorM,                                    &
                 &              errorCode=errorCode                              &
                 &             )                                                 !
            !
            ERROR = ERROR .Or. errorM
            !
            If (.Not. ERROR) Then
               !
               vars(iIn)%velocity%name = "radialVelo"
               vars(iIn)%velocity%type = refFrameChoices(iMatch)
               vars(iIn)%velocity%unit = "km/s"
            End If
            !
            !!OLD !!$            If (cPar(1:2).Eq."LS") Then
            !!OLD !!$               cPar = "LSR"
            !!OLD !!$            Elseif (cPar(1:2).Eq."HE") Then
            !!OLD !!$               cPar = "HEL"
            !!OLD !!$            Elseif (cPar(1:2).Eq."EA") Then
            !!OLD !!$               cPar = "EAR"
            !!OLD !!$            Elseif (cPar(1:2).Eq."NU") Then
            !!OLD !!$               cPar = "NUL"
            !!OLD !!$               vars(iIn)%velocity%value=0.0D0
            !!OLD !!$            Else
            !!OLD !!$               cPar = "NUL"
            !!OLD !!$               vars(iIn)%velocity%value=0.0D0
            !!OLD !!$            End If
            !!OLD !!$            !
            !
            ! *** velocity value
            !
            If (.Not. ERROR) Then
               lPar = 12
               Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
               !!OLD !!$ If (vars(iIn)%velocity%type.Ne.refFrame%null) Then
               If (lPar.Gt.0) Then
                  ioerr = 0
                  Read(cPar(1:lPar),*,iostat=ioerr) velo
               Else
                  velo = 0.0
               Endif
               !!OLD !!$ Else
               !!OLD !!$    velo = 0.0
               !!OLD !!$ Endif
               !
               Call checkR8(command,velo,                                        &
                    vars%velocity%value,                                         &
                    errorR)                                                      !
               If (.Not. errorR) Then
                  vars(iIn)%velocity%value=velo
               End If
               ERROR = ERROR .Or. errorR
               !
               !D      Write (6,*) "  vars(iIn)%velocity%name:  ",               &
               !D     &               vars(iIn)%velocity%name
               !D      Write (6,*) "  vars(iIn)%velocity%type:  ",               &
               !D     &               vars(iIn)%velocity%type
               !D      Write (6,*) "  vars(iIn)%velocity%unit:  ",               &
               !D     &               vars(iIn)%velocity%unit
               !D      Write (6,*) "  vars(iIn)%velocity%value: ",               &
               !D     &               vars(iIn)%velocity%value
               !
            End If
         End If  ! lPar
      End If     ! ERROR
      !
      !
      If (.Not. ERROR) Then
         !
         ! *** flux
         nPar1 = nPar
         lPar = 1
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
         !
         Call SIC_UPPER(cPar)
         !
         If (cPar(1:lPar).Eq.'FLUX') Then
            lPar = 12
            Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
         Else
            lPar = 0
         Endif
         If (lPar.Gt.0) Then
            ioerr = 0
            Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) FLUX
            ! #1
            Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
            If (lPar.Gt.0) Then
               ioerr = 0
               Read(cPar(1:lPar),'(f20.0)',iostat=ioerr) fluxIndex
            Else
               fluxIndex = 0.
            Endif
            ! #1
         Else
            FLUX = 0.
            fluxIndex = 0.
         Endif
         !
         !! vars(iIn)%flux=flux
         !! vars(iIn)%index=fluxIndex
         !
         errorL = .False.
!!         Call checkR4(command,flux,                                 &
!!              vars%flux,                                            &
!!              errorR)
!!         errorL = errorR
!!         Call checkR4(command,fluxIndex,                            &
!!              vars%index,                                           &
!!              errorR)
!!         errorL = errorL .Or. errorR
         If (.Not. errorL) Then
            vars(iIn)%flux=flux
            vars(iIn)%index=fluxIndex
         End If
         error = error .Or. errorL
         !
         !D         Write (6,*) "  vars(iIn)%flux:           ",                      &
         !D              &               vars(iIn)%flux
         !D         Write (6,*) "  vars(iIn)%index:          ",                      &
         !D              &               vars(iIn)%index
         !
      End If     ! ERROR
      !
      If (.Not. Error) Then
         !
         !  ** Project ID
         npar1 = npar
         lPar = 1
         Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
         !
         Call SIC_UPPER(cPar)
         !
         !D         Write (6,*) " decoding project "
         !D         Write (6,*) "    lPar: ", lPar
         !D         Write (6,*) "    cPar: ", cPar
         !
         If (cPar(1:lPar).Eq.'PROJECT') Then
            lPar = 12
            Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)
         Else
            lPar = 0
         End If
         !
         !D         Write (6,*) " decoding project ID "
         !D         Write (6,*) "    lPar: ", lPar
         !D         Write (6,*) "    cPar: ", cPar
         !
         If (lPar.Ge.1) Then
            vars(iIn)%projectID = cPar(1:lPar)
         End If
         !
         !D         Write (6,*) "    vars(iIn)%projectID: ", vars(iIn)%projectID
         !
      End If
      !
      !D      Write (6,*) "    vars(iIn)%projectID: ", vars(iIn)%projectID
      !
   End If  !!  .Not. (isPlanet or isBody or isSatellite)
      !
End If   !!   If (.Not. error) Then
!
If (GV%doDebugMessages) Then 
   Write (6,*) "           cFile(1:len_trim(cFile)):  -->",                      &
        &                  cFile(1:len_trim(cFile)) ,"<--"                       !
End If
!
Call pako_message(seve%t,programName,                                            &
     &    " module source,   <-- parametersSource,v 1.2.3 2014-06-09 ")          !
!
