!
!     $Id: rangesReceiver.inc,v 1.1 2005/03/23 14:25:48 pety Exp $
!
! *** ranges for receivers ***
!
vars(iDefault,  iA100  )%name                 =  rec%A100
vars(iDefault,  iA100  )%isConnected          =  .True.
vars(iDefault,  iA100  )%gunnOn               =  .True.
!
vars(iDefault,  iA100  )%nChannels            =  GPnoneI
vars(iDefault,  iA100  )%bolometerName        =  GPnone
vars(iDefault,  iA100  )%gainBolometer        =  GPnoneI
vars(iDefault,  iA100  )%channel              =  GPnoneI
!
vars(iDefault,  iA100  )%frequency%unit       =  fu%Ghz
vars(iDefault,  iA100  )%frequency%doppler    =  doppler%doppler
vars(iDefault,  iA100  )%frequency%value      =  115.271204D0
!                               
vars(iDefault,  iA100  )%offset               =  vars(iDefault,  iA100  )%frequency
vars(iDefault,  iA100  )%offset%value         =  GPnoneD
!                               
vars(iDefault,  iA100  )%lineName             =  "12CO(1-0)"
!
vars(iDefault,  iA100  )%sideBand             =  sb%lsb
vars(iDefault,  iA100  )%width                =  width%narrow
!
vars(iDefault,  iA100  )%effForward           =    0.95
vars(iDefault,  iA100  )%effBeam              =    0.75
vars(iDefault,  iA100  )%scale                =  scale%antenna
vars(iDefault,  iA100  )%gainImage%value      =    0.001
vars(iDefault,  iA100  )%gainImage%db         =  -30.0
vars(iDefault,  iA100  )%tempAmbient          =  270.0
vars(iDefault,  iA100  )%tempCold             =   86.0
!                     
vars(iDefault,  iA100  )%iPixel               =    1
!
vars(iDefault,  iA100  )%nPixels              =    1
!
vars(iDefault,  iA100  )%centerIF             =  IF%low
!                               
vars(iDefault,  iA100  )%bandWidth            =  BW%narrow
vars(iDefault,  iA100  )%disBoxInput          =    1
vars(iDefault,  iA100  )%IF2                  =  IF2%low
vars(iDefault,  iA100  )%isFlippingIF2        =  .True.
vars(iDefault,  iA100  )%polarization         =  pol%ver
vars(iDefault,  iA100  )%useSpecialLO         =  .False.
!
! ****
!
vars(iStd1:iLimit2,  iA100  )                 =   vars(iDefault,  iA100  )
!
! ****
!
vars(iStd1,     iA100  )%frequency%value      =   80.0D0
vars(iStd2,     iA100  )%frequency%value      =  115.5D0
vars(ILimit1,   iA100  )%frequency%value      =   70.0D0
vars(iLimit2,   iA100  )%frequency%value      =  118.0D0
!                               
vars(iStd1,     iA100  )%offset%value         =    0.0D0
vars(iStd2,     iA100  )%offset%value         =    0.5D0
vars(ILimit1,   iA100  )%offset%value         =    0.0D0
vars(iLimit2,   iA100  )%offset%value         =    0.5D0
!                               
vars(iStd1,     iA100  )%effForward           =    0.90
vars(iStd2,     iA100  )%effForward           =    0.99
vars(ILimit1,   iA100  )%effForward           =    0.5
vars(iLimit2,   iA100  )%effForward           =    1.0
!                               
vars(iStd1,     iA100  )%effBeam              =    0.70
vars(iStd2,     iA100  )%effBeam              =    0.80
vars(ILimit1,   iA100  )%effBeam              =    0.3
vars(iLimit2,   iA100  )%effBeam              =    1.0
!                               
vars(iStd1,     iA100  )%gainImage%value      =    0.001
vars(iStd2,     iA100  )%gainImage%value      =    0.1
vars(ILimit1,   iA100  )%gainImage%value      =    0.0001
vars(iLimit2,   iA100  )%gainImage%value      =    1.0
!
vars(iStd1,     iA100  )%gainImage%db         =  -30.0
vars(iStd2,     iA100  )%gainImage%db         =  -10.0
vars(ILimit1,   iA100  )%gainImage%db         =  -40.0
vars(iLimit2,   iA100  )%gainImage%db         =    0.0
!
vars(iStd1,     iA100  )%tempAmbient          =  250.0
vars(iStd2,     iA100  )%tempAmbient          =  290.0
vars(ILimit1,   iA100  )%tempAmbient          =  200.0
vars(iLimit2,   iA100  )%tempAmbient          =  320.0
!                               
vars(iStd1,     iA100  )%tempCold             =   60.0
vars(iStd2,     iA100  )%tempCold             =  100.0
vars(ILimit1,   iA100  )%tempCold             =   60.0
vars(iLimit2,   iA100  )%tempCold             =  100.0
!                     
!     ******************************************************
!
vars(iDefault:iLimit2,  iB100  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iB100  )%name                 =  rec%B100
vars(iDefault,  iB100  )%isConnected          =  .False.
vars(iDefault,  iB100  )%gunnOn               =  .False.
!
vars(iDefault,  iB100  )%frequency%value      =  vars(iDefault,  iA100  )%frequency%value   
!                                                                                          
vars(iDefault,  iB100  )%lineName             =  vars(iDefault,  iA100  )%lineName          
!                                                                                          
vars(iDefault,  iB100  )%width                =  width%narrow
!
vars(iDefault,  iB100  )%effForward           =  vars(iDefault,  iA100  )%effForward        
vars(iDefault,  iB100  )%effBeam              =  vars(iDefault,  iA100  )%effBeam           
!                                                                                          
vars(iDefault,  iB100  )%gainImage%value      =  vars(iDefault,  iA100  )%gainImage%value   
vars(iDefault,  iB100  )%gainImage%db         =  vars(iDefault,  iA100  )%gainImage%db      
!
vars(iDefault,  iB100  )%tempCold             =   86.0
!
vars(iDefault,  iB100  )%centerIF             =  IF%low                               
!
vars(iDefault,  iB100  )%bandWidth            =  BW%narrow
vars(iDefault,  iB100  )%disBoxInput          =    3
vars(iDefault,  iB100  )%IF2                  =  IF2%low
vars(iDefault,  iB100  )%isFlippingIF2        =  .True.
vars(iDefault,  iB100  )%polarization         =  pol%hor
vars(iDefault,  iB100  )%useSpecialLO         =  .False.
!
vars(iStd1,     iB100  )%frequency%value      =   81.0D0
vars(iStd2,     iB100  )%frequency%value      =  115.5D0
vars(ILimit1,   iB100  )%frequency%value      =   70.0D0
vars(iLimit2,   iB100  )%frequency%value      =  118.0D0
!                               
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iA230  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iA230  )%name                 =  rec%A230
vars(iDefault,  iA230  )%isConnected          =  .False.
vars(iDefault,  iA230  )%gunnOn               =  .False.
!
vars(iDefault,  iA230  )%frequency%value      =  230.537990D0
!      
vars(iDefault,  iA230  )%lineName             =  "12CO(2-1)"
!
vars(iDefault,  iA230  )%width                =  width%wide
!
vars(iDefault,  iA230  )%effForward           =    0.91
vars(iDefault,  iA230  )%effBeam              =    0.52
!
vars(iDefault,  iA230  )%gainImage%value      =    0.1
vars(iDefault,  iA230  )%gainImage%db         =  -10.0
!
vars(iDefault,  iA230  )%tempCold             =   86.0
!
vars(iDefault,  iA230  )%centerIF             =  IF%wide 
!                               
vars(iDefault,  iA230  )%bandWidth            =  BW%wide
vars(iDefault,  iA230  )%disBoxInput          =    2
vars(iDefault,  iA230  )%IF2                  =  IF2%wide
vars(iDefault,  iA230  )%isFlippingIF2        =  .True.
vars(iDefault,  iA230  )%polarization         =  pol%ver
vars(iDefault,  iA230  )%useSpecialLO         =  .False.
!
vars(iStd1,     iA230  )%frequency%value      =  200.0D0
vars(iStd2,     iA230  )%frequency%value      =  266.0D0
vars(ILimit1,   iA230  )%frequency%value      =  194.0D0
vars(iLimit2,   iA230  )%frequency%value      =  275.0D0
!                               
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iB230  )              =  vars(iDefault:iLimit2,  iA230  )
!
vars(iDefault,  iB230  )%name                 =  rec%B230
vars(iDefault,  iB230  )%isConnected          =  .False.
vars(iDefault,  iB230  )%gunnOn               =  .False.
!
vars(iDefault,  iB230  )%frequency%value      =  vars(iDefault,  iA230  )%frequency%value   
!                                                                                          
vars(iDefault,  iB230  )%lineName             =  vars(iDefault,  iA230  )%lineName          
!                                                                                          
vars(iDefault,  iB230  )%width                =  width%wide
!
vars(iDefault,  iB230  )%effForward           =  vars(iDefault,  iA230  )%effForward        
vars(iDefault,  iB230  )%effBeam              =  vars(iDefault,  iA230  )%effBeam           
!                                                                                          
vars(iDefault,  iB230  )%gainImage%value      =  vars(iDefault,  iA230  )%gainImage%value   
vars(iDefault,  iB230  )%gainImage%db         =  vars(iDefault,  iA230  )%gainImage%db      
!
vars(iDefault,  iB230  )%tempCold             =   86.0
!
vars(iDefault,  iB230  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iB230  )%bandWidth            =  BW%wide
vars(iDefault,  iB230  )%disBoxInput          =    4
vars(iDefault,  iB230  )%IF2                  =  IF2%wide
vars(iDefault,  iB230  )%isFlippingIF2        =  .True.
vars(iDefault,  iB230  )%polarization         =  pol%hor
vars(iDefault,  iB230  )%useSpecialLO         =  .False.
!
vars(iStd1,     iB230  )%frequency%value      =  200.0D0
vars(iStd2,     iB230  )%frequency%value      =  266.0D0
vars(ILimit1,   iB230  )%frequency%value      =  195.0D0
vars(iLimit2,   iB230  )%frequency%value      =  275.0D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iC150  )              =  vars(iDefault:iLimit2,  iA100  )
!
vars(iDefault,  iC150  )%name                 =  rec%C150
vars(iDefault,  iC150  )%isConnected          =  .False.
vars(iDefault,  iC150  )%gunnOn               =  .False.
!
vars(iDefault,  iC150  )%frequency%value      =  146.969049D0
!      
vars(iDefault,  iC150  )%lineName             =  "CS(3-2)"
!
vars(iDefault,  iC150  )%width                =  width%wide
!
vars(iDefault,  iC150  )%effForward           =    0.93
vars(iDefault,  iC150  )%effBeam              =    0.69
!
vars(iDefault,  iC150  )%gainImage%value      =    0.01
vars(iDefault,  iC150  )%gainImage%db         =  -20.0
!
vars(iDefault,  iC150  )%tempCold             =   86.0
!
vars(iDefault,  iC150  )%centerIF             =  IF%wide 
!                               
vars(iDefault,  iC150  )%bandWidth            =  BW%wide
vars(iDefault,  iC150  )%disBoxInput          =    1
vars(iDefault,  iC150  )%IF2                  =  IF2%wide
vars(iDefault,  iC150  )%isFlippingIF2        =  .True.
vars(iDefault,  iC150  )%polarization         =  pol%ver
vars(iDefault,  iC150  )%useSpecialLO         =  .False.
!
vars(iStd1,     iC150  )%frequency%value      =  129.5D0
vars(iStd2,     iC150  )%frequency%value      =  175.0D0
vars(ILimit1,   iC150  )%frequency%value      =  129.5D0
vars(iLimit2,   iC150  )%frequency%value      =  187.0D0
!                               
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iD150  )              =  vars(iDefault:iLimit2,  iC150  )
!
vars(iDefault,  iD150  )%name                 =  rec%D150
vars(iDefault,  iD150  )%isConnected          =  .False.
vars(iDefault,  iD150  )%gunnOn               =  .False.
!
vars(iDefault,  iD150  )%frequency%value      =  vars(iDefault,  iC150  )%frequency%value   
!                                                                                          
vars(iDefault,  iD150  )%lineName             =  vars(iDefault,  iC150  )%lineName          
!                                                                                          
vars(iDefault,  iD150  )%width                =  width%wide
!
vars(iDefault,  iD150  )%effForward           =  vars(iDefault,  iC150  )%effForward        
vars(iDefault,  iD150  )%effBeam              =  vars(iDefault,  iC150  )%effBeam           
!                                                                                          
vars(iDefault,  iD150  )%gainImage%value      =  vars(iDefault,  iC150  )%gainImage%value   
vars(iDefault,  iD150  )%gainImage%db         =  vars(iDefault,  iC150  )%gainImage%db      
!
vars(iDefault,  iD150  )%tempCold             =   86.0
!
vars(iDefault,  iD150  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iD150  )%bandWidth            =  BW%wide
vars(iDefault,  iD150  )%disBoxInput          =    3
vars(iDefault,  iD150  )%IF2                  =  IF2%wide
vars(iDefault,  iD150  )%isFlippingIF2        =  .True.
vars(iDefault,  iD150  )%polarization         =  pol%hor
vars(iDefault,  iD150  )%useSpecialLO         =  .False.
!
vars(iStd1,     iD150  )%frequency%value      =  129.5D0
vars(iStd2,     iD150  )%frequency%value      =  175.0D0
vars(ILimit1,   iD150  )%frequency%value      =  129.5D0
vars(iLimit2,   iD150  )%frequency%value      =  187.0D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iC270  )              =  vars(iDefault:iLimit2,  iC150  )
!
vars(iDefault,  iC270  )%name                 =  rec%C270
vars(iDefault,  iC270  )%isConnected          =  .False.
vars(iDefault,  iC270  )%gunnOn               =  .False.
!
vars(iDefault,  iC270  )%frequency%value      =  265.886432D0
!                                                                                          
vars(iDefault,  iC270  )%lineName             =  "HCN(3-2)"
!                                                                                          
vars(iDefault,  iC270  )%width                =  width%wide
!
vars(iDefault,  iC270  )%effForward           =    0.88
vars(iDefault,  iC270  )%effBeam              =    0.46
!                                                                                          
vars(iDefault,  iC270  )%gainImage%value      =    0.1
vars(iDefault,  iC270  )%gainImage%db         =  -10.0
!
vars(iDefault,  iC270  )%tempCold             =   86.0
!
vars(iDefault,  iC270  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iC270  )%bandWidth            =  BW%wide
vars(iDefault,  iC270  )%disBoxInput          =    2
vars(iDefault,  iC270  )%IF2                  =  IF2%wide
vars(iDefault,  iC270  )%isFlippingIF2        =  .True.
vars(iDefault,  iC270  )%polarization         =  pol%ver
vars(iDefault,  iC270  )%useSpecialLO         =  .False.
!
vars(iStd1,     iC270  )%frequency%value      =  241.0D0
vars(iStd2,     iC270  )%frequency%value      =  281.0D0
vars(ILimit1,   iC270  )%frequency%value      =  241.0D0
vars(iLimit2,   iC270  )%frequency%value      =  281.0D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iD270  )              =  vars(iDefault:iLimit2,  iC270  )
!
vars(iDefault,  iD270  )%name                 =  rec%D270
vars(iDefault,  iD270  )%isConnected          =  .False.
vars(iDefault,  iD270  )%gunnOn               =  .False.
!
vars(iDefault,  iD270  )%frequency%value      =  vars(iDefault,  iC270  )%frequency%value   
!                                                                                          
vars(iDefault,  iD270  )%lineName             =  vars(iDefault,  iC270  )%lineName          
!                                                                                          
vars(iDefault,  iD270  )%width                =  width%wide
!
vars(iDefault,  iD270  )%effForward           =  vars(iDefault,  iC270  )%effForward        
vars(iDefault,  iD270  )%effBeam              =  vars(iDefault,  iC270  )%effBeam           
!                                                                                          
vars(iDefault,  iD270  )%gainImage%value      =  vars(iDefault,  iC270  )%gainImage%value   
vars(iDefault,  iD270  )%gainImage%db         =  vars(iDefault,  iC270  )%gainImage%db      
!
vars(iDefault,  iD270  )%tempCold             =   86.0
!
vars(iDefault,  iD270  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iD270  )%bandWidth            =  BW%wide
vars(iDefault,  iD270  )%disBoxInput          =    3
vars(iDefault,  iD270  )%IF2                  =  IF2%wide
vars(iDefault,  iD270  )%isFlippingIF2        =  .True.
vars(iDefault,  iD270  )%polarization         =  pol%hor
vars(iDefault,  iD270  )%useSpecialLO         =  .False.
!
vars(iStd1,     iD270  )%frequency%value      =  241.0D0
vars(iStd2,     iD270  )%frequency%value      =  281.0D0
vars(ILimit1,   iD270  )%frequency%value      =  241.0D0
vars(iLimit2,   iD270  )%frequency%value      =  281.0D0
!
!     ******************************************************
!                               
vars(iDefault:iLimit2,  iHERA  )              =  vars(iDefault:iLimit2,  iA230  )
!
vars(iDefault,  iHERA  )%name                 =  rec%HERA
vars(iDefault,  iHERA  )%isConnected          =  .False.
vars(iDefault,  iHERA  )%gunnOn               =  .False.
!
vars(iDefault,  iHERA  )%frequency%value      =  vars(iDefault,  iA230  )%frequency%value   
!                                                                                          
vars(iDefault,  iHERA  )%lineName             =  vars(iDefault,  iA230  )%lineName          
!                                                                                          
vars(iDefault,  iHERA  )%width                =  width%wide
!
vars(iDefault,  iHERA  )%effForward           =  vars(iDefault,  iA230  )%effForward        
vars(iDefault,  iHERA  )%effBeam              =  vars(iDefault,  iA230  )%effBeam           
!                                                                                          
vars(iDefault,  iHERA  )%gainImage%value      =  vars(iDefault,  iA230  )%gainImage%value   
vars(iDefault,  iHERA  )%gainImage%db         =  vars(iDefault,  iA230  )%gainImage%db      
!
vars(iDefault,  iHERA  )%tempCold             =   86.0
!
vars(iDefault,  iHERA  )%iPixel               =    1
!
vars(iDefault,  iHERA  )%nPixels              =   18
!
vars(iDefault,  iHERA  )%centerIF             =  IF%wide                               
!
vars(iDefault,  iHERA  )%bandWidth            =  BW%wide
vars(iDefault,  iHERA  )%disBoxInput          =  GPnoneI
vars(iDefault,  iHERA  )%IF2                  =  IF2%wide
vars(iDefault,  iHERA  )%isFlippingIF2        =  .True.
vars(iDefault,  iHERA  )%polarization         =  GPnone
vars(iDefault,  iHERA  )%useSpecialLO         =  .False.
!
vars(iStd1,     iHERA  )%frequency%value      =  215.0D0
vars(iStd2,     iHERA  )%frequency%value      =  245.0D0
vars(ILimit1,   iHERA  )%frequency%value      =  215.0D0
vars(iLimit2,   iHERA  )%frequency%value      =  245.0D0
!
vars(iStd1,     iHERA  )%iPixel               =    1
vars(iStd2,     iHERA  )%iPixel               =  vars(iDefault,iHERA)%nPixels
vars(ILimit1,   iHERA  )%iPixel               =    1
vars(iLimit2,   iHERA  )%iPixel               =  vars(iDefault,iHERA)%nPixels
!
!     ******************************************************
!
vars(iDefault:iLimit2,  iHERA1 )              =  vars(iDefault:iLimit2,  iHERA  )
!
vars(iDefault,  iHERA1 )%name                 =  rec%HERA1
vars(iDefault,  iHERA1 )%isConnected          =  .False.
vars(iDefault,  iHERA1 )%gunnOn               =  .False.
!
vars(iDefault,  iHERA1 )%frequency%value      =  vars(iDefault,  iHERA  )%frequency%value   
!                                                                                          
vars(iDefault,  iHERA1 )%lineName             =  vars(iDefault,  iHERA  )%lineName          
!                                                                                          
vars(iDefault,  iHERA1 )%width                =  width%wide
!
vars(iDefault,  iHERA1 )%effForward           =  vars(iDefault,  iHERA  )%effForward        
vars(iDefault,  iHERA1 )%effBeam              =  vars(iDefault,  iHERA  )%effBeam           
!                                                                                          
vars(iDefault,  iHERA1 )%gainImage%value      =  vars(iDefault,  iHERA  )%gainImage%value   
vars(iDefault,  iHERA1 )%gainImage%db         =  vars(iDefault,  iHERA  )%gainImage%db      
!
vars(iDefault,  iHERA1 )%tempCold             =   86.0
!
vars(iDefault,  iHERA1 )%iPixel               =    1
!
vars(iDefault,  iHERA1 )%nPixels              =    9
!
vars(iDefault,  iHERA1 )%centerIF             =  IF%wide                               
!
vars(iDefault,  iHERA1 )%bandWidth            =  BW%wide
vars(iDefault,  iHERA1 )%disBoxInput          =    1    
vars(iDefault,  iHERA1 )%IF2                  =  IF2%wide
vars(iDefault,  iHERA1 )%isFlippingIF2        =  .True.
vars(iDefault,  iHERA1 )%polarization         =  pol%ver
vars(iDefault,  iHERA1 )%useSpecialLO         =  .False.
!
vars(iStd1,     iHERA1 )%frequency%value      =  215.0D0
vars(iStd2,     iHERA1 )%frequency%value      =  268.0D0
vars(ILimit1,   iHERA1 )%frequency%value      =  215.0D0
vars(iLimit2,   iHERA1 )%frequency%value      =  268.000
!
vars(iStd1,     iHERA1 )%iPixel               =    1
vars(iStd2,     iHERA1 )%iPixel               =  vars(iDefault,iHERA1)%nPixels
vars(ILimit1,   iHERA1 )%iPixel               =    1
vars(iLimit2,   iHERA1 )%iPixel               =  vars(iDefault,iHERA1)%nPixels
!
!     ******************************************************
!
vars(iDefault:iLimit2,  iHERA2 )              =  vars(iDefault:iLimit2,  iHERA  )
!
vars(iDefault,  iHERA2 )%name                 =  rec%HERA2
vars(iDefault,  iHERA2 )%isConnected          =  .False.
vars(iDefault,  iHERA2 )%gunnOn               =  .False.
!
vars(iDefault,  iHERA2 )%frequency%value      =  vars(iDefault,  iHERA  )%frequency%value   
!                                                                                          
vars(iDefault,  iHERA2 )%lineName             =  vars(iDefault,  iHERA  )%lineName          
!                                                                                          
vars(iDefault,  iHERA2 )%width                =  width%wide
!
vars(iDefault,  iHERA2 )%effForward           =  vars(iDefault,  iHERA  )%effForward        
vars(iDefault,  iHERA2 )%effBeam              =  vars(iDefault,  iHERA  )%effBeam           
!                                                                                          
vars(iDefault,  iHERA2 )%gainImage%value      =  vars(iDefault,  iHERA  )%gainImage%value   
vars(iDefault,  iHERA2 )%gainImage%db         =  vars(iDefault,  iHERA  )%gainImage%db      
!
vars(iDefault,  iHERA2 )%tempCold             =   86.0
!
vars(iDefault,  iHERA2 )%iPixel               =    1
!
vars(iDefault,  iHERA2 )%nPixels              =    9
!
vars(iDefault,  iHERA2 )%centerIF             =  IF%wide                               
!
vars(iDefault,  iHERA2 )%bandWidth            =  BW%wide
vars(iDefault,  iHERA2 )%disBoxInput          =    2
vars(iDefault,  iHERA2 )%IF2                  =  IF2%wide
vars(iDefault,  iHERA2 )%isFlippingIF2        =  .True.
vars(iDefault,  iHERA2 )%polarization         =  pol%hor
vars(iDefault,  iHERA2 )%useSpecialLO         =  .False.
!
vars(iStd1,     iHERA2 )%frequency%value      =  210.0D0
vars(iStd2,     iHERA2 )%frequency%value      =  245.0D0
vars(ILimit1,   iHERA2 )%frequency%value      =  210.0D0
vars(iLimit2,   iHERA2 )%frequency%value      =  245.000
!
vars(iStd1,     iHERA2 )%iPixel               =    1
vars(iStd2,     iHERA2 )%iPixel               =  vars(iDefault,iHERA2)%nPixels
vars(ILimit1,   iHERA2 )%iPixel               =    1
vars(iLimit2,   iHERA2 )%iPixel               =  vars(iDefault,iHERA2)%nPixels
!
!     ******************************************************
!
vars(iDefault:iLimit2,  iBOLO  )              =  vars(iDefault:iLimit2,  iA230  )
!
vars(iDefault,  iBOLO  )%name                 =  rec%BOLO
vars(iDefault,  iBOLO  )%isConnected          =  .False.
vars(iDefault,  iBOLO  )%gunnOn               =  .False.
!
vars(iDefault,  iBOLO  )%nChannels            =   117
vars(iDefault,  iBOLO  )%bolometerName        =  "117"
vars(iDefault,  iBOLO  )%gainBolometer        =   1
vars(iDefault,  iBOLO  )%channel              =   1
!
vars(iDefault,  iBOLO  )%frequency%value      =  250.0D0
vars(iDefault,  iBOLO  )%frequency%doppler    =  GPnone
!
vars(iDefault,  iBOLO  )%lineName             =  GPnone
!
vars(iDefault,  iBOLO  )%sideBand             =  GPnone
vars(iDefault,  iBOLO  )%width                =  GPnone
!
vars(iDefault,  iBOLO  )%scale                =  GPnone
!
vars(iDefault,  iBOLO  )%effForward           =  GPnoneR
vars(iDefault,  iBOLO  )%effBeam              =  GPnoneR
!                                                                                          
vars(iDefault,  iBOLO  )%gainImage%value      =  GPnoneR
vars(iDefault,  iBOLO  )%gainImage%db         =  GPnoneR
!
vars(iDefault,  iBOLO  )%tempAmbient          =  GPnoneR
vars(iDefault,  iBOLO  )%tempCold             =  GPnoneR
!
vars(iDefault,  iBOLO  )%iPixel               =    1
!
vars(iDefault,  iBOLO  )%nPixels              =  vars(iDefault,  iBOLO  )%nChannels 
!
vars(iDefault,  iBOLO  )%centerIF             =  GPnoneD
!
vars(iDefault,  iBOLO  )%bandWidth            =  GPnoneD
vars(iDefault,  iBOLO  )%disBoxInput          =  GPnoneI
vars(iDefault,  iBOLO  )%IF2                  =  GPnoneD
vars(iDefault,  iBOLO  )%isFlippingIF2        =  GPnoneL
vars(iDefault,  iBOLO  )%polarization         =  GPnone
vars(iDefault,  iBOLO  )%useSpecialLO         =  GPnoneL
!
vars(iStd1,     iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
vars(iStd2,     iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
vars(ILimit1,   iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
vars(iLimit2,   iBOLO  )%frequency%value      =  vars(iDefault,  iBOLO  )%frequency%value
!
vars(iStd1,     iBOLO  )%iPixel               =    1
vars(iStd2,     iBOLO  )%iPixel               =  vars(iDefault,iBOLO)%nPixels
vars(ILimit1,   iBOLO  )%iPixel               =    1
vars(iLimit2,   iBOLO  )%iPixel               =  vars(iDefault,iBOLO)%nPixels
!
! ********************************************
!
gainBolometerChoices(1) =   1.0
gainBolometerChoices(2) =   2.0
gainBolometerChoices(3) =   5.0
gainBolometerChoices(4) =  10.0
gainBolometerChoices(5) =  20.0
gainBolometerChoices(6) =  50.0
gainBolometerChoices(7) = 100.0
!
iCombos(:,1)  =  (/ 1,1,1,1,0,0,0,0,0,0,0,0 /)
iCombos(:,2)  =  (/ 0,0,0,0,1,1,1,1,0,0,0,0 /)
iCombos(:,3)  =  (/ 1,1,0,0,0,0,1,1,0,0,0,0 /)
iCombos(:,4)  =  (/ 0,0,1,1,1,1,0,0,0,0,0,0 /)
iCombos(:,5)  =  (/ 0,0,0,0,0,0,0,0,1,0,0,0 /)
iCombos(:,6)  =  (/ 0,0,0,0,0,0,0,0,0,1,0,0 /)
iCombos(:,7)  =  (/ 0,0,0,0,0,0,0,0,0,0,1,1 /)
!
!!$      write (6,'(12I3)') iCombos(:,1)
!!$      write (6,'(12I3)') iCombos(:,2)
!!$      write (6,'(12I3)') iCombos(:,3)
!!$      write (6,'(12I3)') iCombos(:,4)
!!$      write (6,'(12I3)') iCombos(:,5)
!!$      write (6,'(12I3)') iCombos(:,6)
!!$      write (6,'(12I3)') iCombos(:,7)
!
where (iCombos.gt.0)
   iCombosN = 0
elsewhere
   iCombosN = 1
end where
!



