module gio_fitsdef
  use gfits_types
  !--------------------------------------------------------------------
  ! GIO global variable used to define FITS or UV FITS files
  !--------------------------------------------------------------------
  !
  ! Constants
  integer(kind=4), parameter :: code_fits_standard=0
  integer(kind=4), parameter :: code_fits_cpc=1
  integer(kind=4), parameter :: code_fits_spline=2
  integer(kind=4), parameter :: code_fits_uvfits=3
  integer(kind=4), parameter :: code_fits_aips=4
  integer(kind=4), parameter :: code_fits_sorted=5
  integer(kind=4), parameter :: code_fits_casa=6
  !
  ! Variables
  character(len=256) :: gdfname  ! Image name
  logical :: no_degen            ! Get rid of last degenerated dimensions?
  integer :: a_style             ! Style of processed FITS-tape
  logical :: question            ! Prompt when unrecognized axis type ?
  logical :: sort                ! Sort aips++ fits file ?
  !
  type(gfits_hdesc_t) :: fd
  !
  ! Variables for UV fits file
  real(kind=4) ::  cscal,czero                  ! Complex visibilities scale
  real(kind=4) ::  uscal,uzero                  ! U       scale
  real(kind=4) ::  vscal,vzero                  ! V        and
  real(kind=4) ::  wscal,wzero                  ! W       zero
  real(kind=4) ::  tscal,tzero                  ! Time scale and zero
  real(kind=4) ::  dscal,dzero                  ! Date scale and zero
  real(kind=4) ::  wps                          ! Weight scaling factor
  integer :: luu,lvv,lww,lbase,ldate,ltime,lsour,linte,lfreq
  integer, parameter :: mcount=9    ! Must handle all cases of 1 digit
  real(kind=4) ::  pscal(mcount),pzero(mcount)  ! Scale and Zero for Pgroup
  real(kind=8) :: crval(mcount),cdelt(mcount),crpix(mcount)  ! Axis conversion
  character(len=8) :: ptype(mcount), ctype(mcount)
  !
end module gio_fitsdef
