!
subroutine uv_sort (error,sorted,shift,new,uvmax,uvmin)
  use gkernel_interfaces
  use imager_interfaces, except_this=>uv_sort
  use clean_def
  use clean_arrays
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING
  !   Sort the input UV table
  !----------------------------------------------------------------------
  logical, intent(inout) :: sorted      ! Is table sorted ?
  logical, intent(inout) :: shift       ! Do we shift phase center ?
  logical, intent(out) :: error
  real(kind=8), intent(inout) :: new(3) ! New phase center and PA
  real, intent(out) :: uvmin            ! Min baseline
  real, intent(out) :: uvmax            ! Max baseline
  !
  ! Global variables:
  real(8), parameter :: pi=3.14159265358979323846d0
  real(8), parameter :: f_to_k = 2.d0*pi/299792458.d-6
  real(kind=8) freq, off(3)
  real pos(2), cs(2)
  integer nu,nv,ier
  real, pointer :: duv_previous(:,:)
  real, pointer :: duv_next(:,:)
  !
  ! The UV table is available in HUV%
  if (huv%loca%size.eq.0) then
    call map_message(seve%e,'UV_MAP','No UV data loaded')
    error = .true.
    return
  endif
  nu = huv%gil%dim(1)
  nv = huv%gil%dim(2)
  !
  ! Correct for new phase center if required
  if (shift) then
    if (huv%gil%ptyp.eq.p_none) then
      call map_message(seve%w,'SHIFT','No previous phase center info')
      huv%gil%a0 = huv%gil%ra
      huv%gil%d0 = huv%gil%dec
      huv%gil%pang = 0.d0
      huv%gil%ptyp = p_azimuthal
    elseif (huv%gil%ptyp.ne.p_azimuthal) then
      call map_message(seve%w,'SHIFT','Previous projection type not SIN')
      huv%gil%ptyp = p_azimuthal
    endif
    call uv_shift (new,huv%gil%a0,huv%gil%d0,huv%gil%pang,   &
        &      off,shift)
    huv%gil%posi_words = def_posi_words
    huv%gil%proj_words = def_proj_words
  endif
  if (shift) then
    sorted = .false.
  else
    call check_order (duv,nu,nv,sorted)
  endif
  !
  ! Get center frequency
  freq = gdf_uv_frequency(huv,huv%gil%ref(1))
  !
  ! If already sorted, use it
  if (sorted) then
    call map_message(seve%i,'UVSORT','UV table is already sorted')
    !
    ! Compute UVMAX
    call uvgmax (huv,duv,uvmax,uvmin)
    !
    ! Else, create another copy
  else
    call map_message(seve%i,'UVSORT','Sorting UV table...')
    !
    ! Compute observing frequency, and new phase center in wavelengths
    if (shift) then
      huv%gil%a0 = new(1)
      huv%gil%d0 = new(2)
      huv%gil%pang = new(3)
      cs(1)  =  cos(off(3))
      cs(2)  = -sin(off(3))
      ! Note that the new phase center is counter-rotated because rotations
      ! are applied before phase shift.
      pos(1) = - freq * f_to_k * ( off(1)*cs(1) - off(2)*cs(2) )
      pos(2) = - freq * f_to_k * ( off(2)*cs(1) + off(1)*cs(2) )
    else
      pos(1) = 0.0
      pos(2) = 0.0
      cs(1) = 1.0
      cs(2) = 0.0
    endif
    !
    !$ call uv_dump_buffers('UV_SORT')
    !
    ! OK, rotate, shift, sort and copy...
    nullify (duv_previous, duv_next)
    call uv_find_buffers ('UV_SORT',nu,nv, duv_previous, duv_next, error)
    if (error) return
    call uvsort_uv (nu,nv,huv%gil%ntrail,duv_previous,duv_next,   &
         &        pos,cs,uvmax,uvmin,error)
    huv%gil%basemax = uvmax
    huv%gil%basemin = uvmin
    call uv_clean_buffers (duv_previous, duv_next,error)
    if (error) return
  endif
  !
  ! Now transform UVMAX in kiloWavelength (including 2 pi factor)
  uvmax = uvmax*freq*f_to_k
  uvmin = uvmin*freq*f_to_k
  error = .false.
end subroutine uv_sort
