subroutine run_clean (line,comm,error)
  use clean_arrays
  use clean_default
  use gbl_message
  use imager_interfaces, except_this=>run_clean
  use gkernel_interfaces, only : sic_present, sic_mapgildas, sic_delvariable
  !----------------------------------------------------------------------
  ! @ public
  !
  ! MAPPING   Main routine
  !   Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line  ! Command line
  character(len=*), intent(in)    :: comm  ! Command name
  logical,          intent(out)   :: error ! Logical error flag
  !
  ! Local variables
  logical use_self
  character(len=1) :: code
  integer, save :: icall=0
  integer :: i
  !
  if (icall.ne.0) then
     Print *,'Rentrant call to RUN_CLEAN ',comm
     read(5,*) i
  endif
  icall = icall+1
  !
  MappingError = .false.
  call map_message(seve%c,'CLEAN',line)
  !
  ! Analyze command
  select case (comm)
!  case ('LOAD')
!    call load_buffer(line,error)
  case ('READ')
    call read_image(line,error)
  case ('CLEAN')
    call dispatch_clean(line,error)
  case ('CLARK')
    call clark_clean(line,error)
  case ('FIT')
    call clean_beam(line,error)
  case ('HOGBOM')
    call hogbom_clean(line,error)
  case ('WRITE')
    call write_image(line,error)
  case ('SUPPORT')
    call com_support(line,error)
  case ('MOSAIC')
    call mode_mosaic(line,error)
  case ('MRC')
    call mrc_clean(line,error)
  case ('MULTI')
    call multi_clean(line,error)
  case ('SHOW')
    call display_buffer('SHOW',line,error)
  case ('VIEW')
    call display_buffer('VIEW',line,error)
  case ('SDI')
    call sdi_clean(line,error)
  case ('MX')
    if (themap%nfields.ne.0) then
      call map_message(seve%e,comm,'UV data is a Mosaic, not supported')
      error = .true.
    else
      call uvmap('MX',line,error)
    endif
  case ('STATISTIC')
    call statistic(line,error)
  case ('ALMA')
    call alma_clean(line,error)
  case ('UV_FLAG')
    call uv_flag_comm(line,error)
  case ('UV_MAP')
    call uv_map_comm(line,comm,error)
  case ('UV_SORT')
    call uv_sort_comm(line,error)
  case ('UV_STAT')
    call uv_stat_comm(line,error)
  case ('UV_RESAMPLE','UV_COMPRESS')
    call uv_resample_comm(line,comm,error)
  case ('UV_RESTORE')
    call uv_map_comm(line,comm,error)
  case ('UV_SHIFT')
    call uv_shift_mosaic(line,error)
  case ('DUMP')
    call debug_all(line,error)
  case ('UV_CONTINUUM')
    call uv_line2cont (line,error)
  case ('UV_FILTER')
    call uv_filter (line,error)
  case ('UV_BASELINE')
    call uv_baseline (line,error)
  case ('UV_TIME')
    if (themap%nfields.ne.0) call map_message(seve%w,comm,'UV data is a Mosaic')
    call uv_time_comm (line,error)
  case ('UV_TRUNCATE')
    call uv_truncate_comm (line,error)
  case ('UV_REWEIGHT')
    call uv_reweight_comm (line,error)
  case ('UV_CHECK')
    call uv_check_comm (line,error)
  case ('PRIMARY')
    call primary_comm(line,error)
  case ('SPECIFY')
    call com_modify (line,error)
  case ('FLUX_SCALE')
    call flux_dispatch (line,error)
!  case ('SG_DEBUG')
!    call sg_debug(line,error)
  case ('UV_RESIDUAL')
    if (themap%nfields.ne.0) then
      call map_message(seve%w,comm,'UV data is a Mosaic - UNDER TESTS !!!')
    endif
    call uv_residual(line,error)
  case ('MAP_RESAMPLE','MAP_COMPRESS','MAP_INTEGRATE') 
    call map_resample_comm(line,comm,error)
  case ('STOKES')
    call do_stokes(line,comm,error)
  ! V1.2
  case ('CALIBRATE')
    call uv_calibrate(line,error)
  case ('MODEL') 
    call cct_fast_uvmodel(line,error)
  case ('SOLVE') 
    call solve_gain(line,error)
  case default
    call map_message(seve%i,'CLEAN',comm//' not yet implemented')
  end select
  icall = icall-1
  if (MappingError) error = .true.
  !
end subroutine run_clean
!
subroutine run_newstuff(line,comm,error)
  use clean_arrays
  use clean_default
  use gbl_message
  use imager_interfaces, except_this=>run_newstuff
  !----------------------------------------------------------------------
  ! @ public
  !
  ! MAPPING   Main routine
  !   Call appropriate subroutine according to COMM
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line  ! Command line
  character(len=*), intent(in)    :: comm  ! Command name
  logical,          intent(out)   :: error ! Logical error flag
  !
  ! Local variables
  integer, save :: icall=0
  integer :: i
  !
  if (icall.ne.0) then
     Print *,'Rentrant call to RUN_NEWSTUFF ',comm
     read(5,*) i
  endif
  icall = icall+1
  !
  MappingError = .false.
  call map_message(seve%c,'NEWSTUFF',line)
  !
  ! Analyze command
  select case (comm)
  case ('UV_PREVIEW')
    call uv_preview(line,error)
  case ('MAP_CONTINUUM')
    call map_continuum(line,error)
  case ('MFS')
    call clean_mfs (line,error)
  case ('UV_DEPROJECT','UV_RADIAL') 
    call uv_radial(line,comm,error)
  case ('UV_SHORT')
    call uvshort_com(line,error)
  case default
    call map_message(seve%i,'CLEAN',comm//' not yet implemented')
  end select
  icall = icall-1
  if (MappingError) error = .true.
end subroutine run_newstuff
!
subroutine init_clean
  use gkernel_interfaces
  use imager_interfaces, except_this=>init_clean
  !----------------------------------------------------------------------
  ! @ public
  !
  ! MAPPING
  !   Initialize Mapping Languages
  !----------------------------------------------------------------------
  use clean_def
  use clean_arrays
  use clean_default
  use clean_types
  !
  ! vocabulaire de CLEAN
  integer mclean
  parameter (mclean=108)  
  character(len=16) vocab(mclean)
  character(len=40) version
  data vocab /' DUMP',   &
       ' ALMA', '/FLUX', '/PLOT', '/QUERY', '/NOISE', '/METHOD', &
       ' CALIBRATE', '/FLAG', &  
       ' CLEAN', '/FLUX', '/PLOT', '/QUERY', '/NITER', '/ARES', &  !No conflict with ALMA ?
       ' CLARK', '/FLUX', '/PLOT', '/QUERY', &
       ' FIT', ' FLUX_SCALE', &
       ' HOGBOM', '/FLUX', &
!       ' LOAD', &
       ' MAP_COMPRESS', ' MAP_RESAMPLE', ' MAP_INTEGRATE', &
       ' MOSAIC', &
       ' MRC', '/FLUX', '/PLOT', '/QUERY', &
       ' MODEL', '/MINFLUX',  & ! Create a UV model from CCT components
       ' MULTI', '/FLUX', &
       ' MX', '/FLUX', '/PLOT', '/QUERY', &
       ' PRIMARY', '/TRUNCATE', &
       ' READ', '/COMPACT', '/FREQUENCY', '/PLANE', '/RANGE',  '/NOTRAIL', '/TELESCOPE', &
       ' SHOW', &
       ' SDI', '/FLUX', '/PLOT', '/QUERY', &
       ' SOLVE', '/MODE', &  ! Solve for Amplitude and/or Phase
       ' SPECIFY', &
       ' STATISTIC', '/WHOLE', '/NOISE', &
       ' STOKES', &
       ' SUPPORT', '/CURSOR', '/MASK', '/PLOT', '/RESET', '/THRESHOLD', '/VARIABLE', &
       ' UV_BASELINE', '/CHANNELS', '/FREQUENCY', '/VELOCITY', '/WIDTH', &
       ' UV_CHECK', ' UV_COMPRESS', ' UV_CONTINUUM','/INDEX', &
       ' UV_FLAG', '/ANTENNA', '/RESET', &
       ' UV_FILTER', '/CHANNELS', '/FREQUENCY', '/VELOCITY', '/WIDTH', '/ZERO', &
       ' UV_MAP', '/TRUNCATE',  '/FIELDS', '/SELF', &
       ' UV_RESAMPLE',  ' UV_RESIDUAL', ' UV_RESTORE', '/COPY', '/SLOW', '/SELF', &
       ' UV_REWEIGHT', &
       ' UV_SHIFT', ' UV_SORT',  ' UV_STAT',  ' UV_TIME', '/WEIGHT', ' UV_TRUNCATE', &
       ' VIEW',     &
       ' WRITE', '/APPEND ', '/RANGE', '/REPLACE', '/TRIM'/ 
  logical error
  integer, parameter :: news=9
  character(len=16) vnews(news)
  character(len=40) vernews
  data vnews/' MAP_CONTINUUM', ' MFS', & 
    & ' UV_DEPROJECT', & 
    & ' UV_PREVIEW', ' UV_RADIAL', '/SAMPLING', '/U_ONLY', '/ZERO',  & 
    & ' UV_SHORT' /
  ! 
  integer :: iout
  !
  ! version = '2.8-02 18-APR-2015 S.Guilloteau, J.Pety'
  ! 2.8-02  Add support for /RANGE option of WRITE
  ! version = '2.9-00 05-JUN-2015 S.Guilloteau, J.Pety'
  ! 2.9-00  Add support for one beam per channel, READ/WRITE optimisation
  !         UV_MOSAIC command (exp...) and MFS test (exp+++)
  ! version = '2.9-01 19-APR-2015 S.Guilloteau, J.Pety'
  ! 2.9-01  More flexible syntax for UV_BASELINE & UV_FILTER
  !         and better Read/Write optimization
  ! version = '2.9-02 23-APR-2015 S.Guilloteau, J.Pety'
  ! 2.9-02  Add UV_TRUNCATE
  ! version = '2.9-03 25-APR-2015 S.Guilloteau, J.Pety'
  ! 2.9-03  Arbitrary number of Channels per synthesized beam in
  !         single field imaging. Full support, but better rules
  !         still needed
  !version = '2.9-04 25-Jan-2016 S.Guilloteau, J.Pety'
  ! 2.9-04  Add UV_CHECK
  version = '2.9-05 06-Apr-2016 S.Guilloteau, J.Pety'
  ! 2.9-05  Add CLEAN command and /FREQUENCY option to READ command
  version = '2.9-06 02-May-2016 S.Guilloteau, J.Pety'
  ! 2.9-06  Add option /ANTENNA to UV_FLAG + Ability to Clean plane by plane
  version = '2.9-07 07-Jun-2016 S.Guilloteau, J.Pety'
  ! 2.9-07  Add UV_RESIDUAL command
  version = '3.0-00 04-Jul-2016 S.Guilloteau, J.Pety'
  ! 3.0-00  Allow UV_MAP do process complete mosaics, using the extra columns
  !         of a UV Table
  version = '3.0-01 20-Jul-2016 S.Guilloteau, J.Pety'
  ! 3.0-01  Changes in MAP_* SIC Variables and better handling of UV_CONT
  version = '3.0-01 20-Jul-2016 S.Guilloteau, J.Pety'
  ! 3.0-02  Use MAP_VERSION in command UV_MAP and remove SG_MAP/SG_RESTORE
  version = '3.0-02 16-Nov-2016 S.Guilloteau, J.Pety'  
  ! 3.0-03  New SUPPORT command with /THRESHOLD option 
  version = '3.0-03 31-Mar-2017 S.Guilloteau, J.Pety'  
  ! 3.1-00  Option /REPLACE for command WRITE
  version = '3.1-00 07-Apr-2017 S.Guilloteau, J.Pety'   
  ! 3.2-01  Remove the re-masking possibility in Deconvolution commands. 
  version = '3.2-01 16-May-2017 S.Guilloteau, J.Pety'  
  ! 3.2-02  New behaviour of UV_COMPRESS and UV_RESAMPLE
  version = '3.2-03 30-May-2017 S.Guilloteau, J.Pety'  
  ! 3.2-03  New usage of Cleaning MASKS: can be with different pixels 
  !         than images 
  version = '3.2-04 19-Jun-2017 S.Guilloteau, J.Pety'  
  ! 3.2-04  Bug corrections for Mosaics and UV_RESAMPLE
  version = '3.3-01 19-Jun-2017 S.Guilloteau, J.Pety'  
  ! 3.3-01  Removed wipe support
  version = '3.3-02 20-Jun-2017 S.Guilloteau, J.Pety'
  ! 3.3-02  Add /NITER & /ARES option to CLEAN command for plane dependent
  !         convergence.
  !         Add support for SHOW FIELDS just afer READ UV, and get list
  !         of fields through the FIELDS% structure
  version = '3.3-03 23-Jun-2017 S.Guilloteau, J.Pety'
  ! 3.3-03  Add option /FIELDS to command UV_MAP in Mosaic mode.
  !         Allow UV_RESIDUAL on Mosaics.
  !         Optimize (under user control, default not changed) the
  !         choice of MAP_SIZE using MAP_ROUNDING & MAP_POWER variables
  version = '3.3-04 30-Jun-2017 S.Guilloteau, J.Pety'
  ! 3.3-04  Allow UV_RESTORE on Mosaics.  Experimental (only tested on 1 channel).
  version = '3.3-05 03-Jul-2017 S.Guilloteau, J.Pety'
  ! 3.3-05  MAJOR Bug correction for MOSAIC in OMP (required a CRITICAL section). 
  !         Improved UV_RESTORE on Mosaics. Truncation levels still to be done. 
  version = '3.4-01 25-Jul-2017 S.Guilloteau, J.Pety'
  ! 3.4-01  Newer version of the SHOW and VIEW commands - Command CALIBRATE
  !         to apply self-calibration results.
  version = '3.4-02 05-Dec-2017 S.Guilloteau, J.Pety'
  ! 3.4-02  Bug correction in Robust weighting with small number of visibilities
  !         (leading to NBCV = 1)
  version = '4.0-01 08-Mar-2018 S.Guilloteau'
  ! 4.0-01  First IMAGER release with new Variable names (may still change)
  version = '4.0-01 08-Mar-2018 S.Guilloteau'
  ! 4.1-01  IMAGER release with Self Calibration commands
  version = '4.1-01 15-Mar-2018 S.Guilloteau'
  !
  vernews = '1.0-01 01-Dec-2017 S.Guilloteau'
  ! 1.0-01  Command UV_PREVIEW 
  vernews = '1.0-02 08-Mar-2018 S.Guilloteau'
  ! 1.0-02  Commands UV_DEPROJECT  and UV_RADIAL
  vernews = '1.1-02 08-Mar-2018 S.Guilloteau'
  ! 1.1-02  Template for Commands MODEL, SOLVE /MODE, CALIBRATE and UV_MAP /SELF 
  vernews = '1.2-01 10-Apr-2018 S.Guilloteau'
  ! 1.2-01  Template for Commands UV_SHORT
  !  
  call sic_begin('CLEAN','gag_doc:hlp/imager-help-clean.hlp',mclean,vocab, version, run_clean, gr_error)
  call sic_begin('NEWSTUFF','gag_doc:hlp/imager-help-news.hlp',news,vnews, vernews, run_newstuff, gr_error)
  call gagout('I-IMAGER,  CLEAN Version '//version)
  call gagout('I-IMAGER,  NEWSTUFF Version '//vernews)
  !
  call sic_defstructure('OMP_MAP',.true.,error)
  omp_compiled = .false.
  !$ omp_compiled = .true.
  call sic_def_logi('OMP_MAP%COMPILED',omp_compiled,.false.,error)
  call sic_def_logi('OMP_MAP%DEBUG',omp_debug,.false.,error)
  call sic_def_logi('OMP_MAP%UV_MAP',omp_uvmap,.false.,error)
  call sic_def_inte('OMP_MAP%GRID',omp_grid,0,0,.false.,error)
  call sic_def_logi('OMP_MAP%RESTORE_FAST',omp_restore_fast,.false.,error)
  call sic_def_logi('OMP_MAP%UV_MAP_LOCK',omp_uvmap_lock,.false.,error)
  call sic_def_inte('OMP_MAP%SINGLE_BEAM_CODE',omp_single_beam,0,0,.false.,error)
  !
  user_method%do_mask = .true.  ! Unclear why ...
  call sic_def_logi('METHOD_DOMASK',user_method%do_mask,.false.,error) ! To check
  nullify(duvr)
  nullify(duvs)
  call define_var(error)
  MappingError = .false.
  call sic_def_logi('MAPPING_ERROR',MappingError,.false.,error)
  !
  call sic_def_inte('MAP_VERSION',map_version,0,0,.false.,error)
  call sic_def_real('MAP_ROUNDING',map_rounding,0,0,.false.,error)
  call sic_def_inte('MAP_POWER   ',map_power,0,0,.false.,error)
  call gi4_round_forfft(64,iout,error,map_rounding,map_power)
  !
  call sic_def_login('SAVE_DATA',save_data,1,mtype,.false.,error)
  call gprompt_set('IMAGER')
end subroutine init_clean
!
subroutine save_result(error)
  use gkernel_interfaces
  use gildas_def
  use clean_types
  use gbl_message
  logical error
  character(len=filename_length) :: ans
  character(len=filename_length) :: autosave='autosave'  ! Default name when saving
  character(len=commandline_length) line
  character(len=message_length) :: chain
  character(len=*), parameter :: rname = 'MAPPING'
  integer :: n, icode
  logical :: do_write,noprompt
  !
  ans = ' '
  error = .false.
  do_write = .false.
  call gmaster_get_exitnoprompt(noprompt)  ! Check for SIC\EXIT /NOPROMPT
  !
  if (any(save_data) .and. .not.noprompt) then
    call map_message(seve%w,rname,'There are unsaved data, should we save them?')
    do while (.true.)
      call sic_wprn('Y)es, N)o, C)ancel exit (default No): ',ans,n)
      call sic_upper(ans)
      if (ans(1:1).eq.'C') then
        error = .true.
        return
      elseif (ans(1:1).eq.'N' .or. ans(1:1).eq.' ') then
        do_write = .false.
      elseif (ans(1:1).ne.'Y') then
        call map_message(seve%e,rname,'Unrecognized answer '//ans)
        cycle
      else 
        do_write = .true.
      endif
      exit
    enddo
  endif
  !
  call sic_delvariable('DIRTY',.false.,error)
  call sic_delvariable('CLEAN',.false.,error)
  call sic_delvariable('RESIDUAL',.false.,error)
  call sic_delvariable('PRIMARY',.false.,error)
  call sic_delvariable('SKY',.false.,error)
  if (.not.do_write) return
  !
  do icode=1,mtype
    ans = ' '
    error = .false.
    do while (save_data(icode))
       write(chain,100) vtype(icode)
       call sic_wprn(trim(chain)//' ',ans,n)
       if (ans.eq.' ') ans = autosave
       line = 'CLEAN'//char(92)//'WRITE '//vtype(icode)//' "'//trim(ans)//'"'
       call exec_command (line,error)
    enddo
  enddo
  !
100 format('Enter a filename for ',a,' (default ''autosave''): ')
end subroutine save_result
!
subroutine debug_all(line,error)
  use gkernel_interfaces
  use imager_interfaces, except_this => debug_all
  use clean_def
  use clean_arrays
  use clean_types
  use clean_default
  use gbl_message
  !----------------------------------------------------------------------
  ! @  private
  !
  ! MAPPING     Print debug information
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line
  logical, intent(out) :: error
  !
  character(len=4) meth
  integer :: n, nc, ier
  integer, allocatable :: mic(:)
  !
  call sic_ke(line,0,1,meth,n,.false.,error)
  if (error) return
  if (meth.eq.'USER') then
     call mapping_print_debug(user_method)
  else if (meth.eq.'METH') then
     call mapping_print_debug(method)
  else if (meth.eq.'BUFF') then
    call uv_dump_buffers('DUMP')
  else if (meth.eq.'SG') then
    !
    nc = huv%gil%nchan
    if (nc.ne.hcct%gil%dim(2)) then
      Print *,'Mismatch number of channels between HUV ',nc,' and CCT ',hcct%gil%dim(2)
    endif
    !
    allocate(mic(nc),stat=ier)
    call uv_clean_sizes(hcct,dcct,mic,1,nc)
    Print *,'SG_DEBUG -- MIC ',mic
    deallocate(mic)
  else
    Print *,' DEBUG  BUFFers|METHod|SG|USER'
  endif
end subroutine debug_all
!
subroutine mode_mosaic (line,error)
  use gkernel_interfaces
  use imager_interfaces, only : sub_mosaic
  !----------------------------------------------------------------------
  ! @  private
  !
  ! MAPPING     MOSAIC ON|OFF
  !             Activates or desactivates the mosaic mode
  !----------------------------------------------------------------------
  character(len=*), intent(inout) :: line
  logical, intent(out) :: error
  !
  integer na,iv
  character(len=8) name,argum,voc1(2)
  data voc1/'OFF','ON'/
  !
  ! Mosaic mode. Default = .true.
  argum = 'ON'
  call sic_ke (line,0,1,argum,na,.false.,error)
  if (error) return
  call sic_ambigs ('MOSAIC',argum,name,iv,voc1,2,error)
  if (error) return
  call sub_mosaic(name,error)
end subroutine mode_mosaic
