!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubego_load
  use cubetools_structure
  use cubetools_userspace
  use cube_types
  use cubeadm_cubeid_types
  use cubego_messaging
  use cubeedit_getdata
  use cubeedit_getheader
  !
  public :: load,cubego_load_command
  private
  !
  type :: load_comm_t
     type(option_t), pointer :: comm
     type(userspace_opt_t)   :: into
     type(getdata_comm_t)    :: data
     type(getheader_comm_t)  :: head
   contains
     procedure, public  :: register => cubego_load_register
     procedure, private :: parse    => cubego_load_parse
     procedure, private :: main     => cubego_load_main 
  end type load_comm_t
  type(load_comm_t) :: load
  !
  integer(kind=4), parameter :: icube =1
  type :: load_user_t
     type(userspace_user_t) :: userspace
     type(cubeid_user_t)    :: id
     type(getdata_user_t)   :: data
     type(getheader_user_t) :: head
  end type load_user_t
  !
  character(len=*), parameter :: defname = 'GOLOAD'
  !
contains
  !
  subroutine cubego_load_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(load_user_t) :: user
    character(len=*), parameter :: rname='LOAD>COMMAND'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call load%parse(line,user,error)
    if (error) return
    call load%main(user,error)
    if (error) return
  end subroutine cubego_load_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_load_register(load,error)
    use cubedag_allflags
    !-------------------------------------------------------------------
    ! Register GO\LOAD command and its options
    !-------------------------------------------------------------------
    class(load_comm_t), intent(inout) :: load
    logical,            intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    logical, parameter :: noiterator = .false.
    character(len=*), parameter :: comm_abstract = &
         'load information from a cube'
    character(len=*), parameter :: comm_help = &
         'Information loaded onto variables by GO\LOAD is intended as&
         & information. Modifying the values in these variables does&
         & not change the values for these parameters in the original&
         & cube. If option /INTO is not used the information&
         & gotten will be stored in a master structure called '//defname
    character(len=*), parameter :: rname='LOAD>REGISTER'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'LOAD','[cube]',&
         comm_abstract,&
         strg_id,&
         cubego_load_command,&
         load%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Input cube',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         error)
    if (error) return
    !
    call load%into%register(error)
    if (error) return
    call load%head%register(load%into,error)
    if (error)  return
    call load%data%register(load%into,access_not_fixed,noiterator,error)
    if (error) return
  end subroutine cubego_load_register
  !
  subroutine cubego_load_parse(load,line,user,error)
    !-------------------------------------------------------------------
    ! Support routine for command LOAD
    !-------------------------------------------------------------------
    class(load_comm_t), intent(in)    :: load
    character(len=*),   intent(in)    :: line
    type(load_user_t),  intent(inout) :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='LOAD>PARSE'
    !
    call load%into%parse(line,user%userspace,error)
    if (error) return
    !
    call cubeadm_cubeid_parse(line,load%comm,user%id,error)
    if (error) return
    call load%head%parse(line,user%userspace,user%head,error)
    if (error)  return
    call load%data%parse(line,user%userspace,user%data,error)
    if (error)  return
  end subroutine cubego_load_parse
  !
  subroutine cubego_load_main(load,user,error)
    use cubeadm_get
    !-------------------------------------------------------------------
    ! Support routine for command LOAD
    !-------------------------------------------------------------------
    class(load_comm_t), intent(in)    :: load
    type(load_user_t),  intent(in)    :: user
    logical,            intent(inout) :: error
    !
    type(cube_t), pointer :: cube
    integer(kind=entr_k) :: ie
    character(len=*), parameter :: rname='LOAD>MAIN'
    !
    if (.not.user%head%do .and. .not.user%data%do) then
       call load%head%list(error)
       if (error) return
       call load%data%list(error)
       if (error) return
       return
    endif
    !
    call cubeadm_cubeid_get_header(load%comm,icube,user%id,code_access_imaset_or_speset,  &
         code_read,cube,error)
    if (error) return
    if (user%head%do) then
       call load%head%get(user%head,cube,defname,user%data%do,error)
       if (error)  return
    end if
    if (user%data%do) then
       ie = entr_unk
       call load%data%get(user%data,cube,defname,user%head%do,ie,error)
       if (error)  return
    endif
  end subroutine cubego_load_main
end module cubego_load
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
