!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine mrtcal_calib_tracked_wsw(mrtset,backcal,backsci,filebuf,error)
  use gbl_message
  use gkernel_interfaces
  use mrtcal_level_codes
  use mrtcal_buffer_types
  use mrtcal_setup_types
  use mrtcal_interfaces, except_this => mrtcal_calib_tracked_wsw
  !---------------------------------------------------------------------
  ! @ private
  ! Gather all needed steps to read, calibrate, and write a 
  ! tracked wobbler switched scan for a given backend
  !---------------------------------------------------------------------
  type(mrtcal_setup_t),    intent(in)    :: mrtset
  type(calib_backend_t),   intent(in)    :: backcal
  type(science_backend_t), intent(inout) :: backsci
  type(imbfits_buffer_t),  intent(inout) :: filebuf
  logical,                 intent(inout) :: error
  ! Local
  integer(kind=4) :: ion,non
  integer(kind=4) :: iref,nref
  character(len=*), parameter :: rname='CALIB>TRACKED>WSW'
  !
  call mrtcal_message(seve%t,rname,'Welcome')
  !
  call mrtcal_init_refloop(backsci,nref,error)
  if (error) return
  do iref=1,nref
     call mrtcal_get_nextref(backsci,error)
     if (error) return
     call mrtcal_init_onloop(backsci,non,error)
     if (error) return
     do ion=1,non
        call mrtcal_get_nexton(backsci,error)
        if (error) return
        call mrtcal_sanity_check(backsci,error)
        if (error) return
        call mrtcal_init_cycleloop(&
             mrtset,&
             backsci%list,&
             backsci%on%curr%isub,&
             'track',&
             filebuf%imbf,&
             filebuf%subscanbuf,&
             backsci%switch,&
             error)
        if (failed_calibrate(rname,backsci%on%curr%isub,error))  return
        do while (backsci%switch%book%idump.le.backsci%switch%book%ndump)
           call mrtcal_get_nextcycle(&
                filebuf%imbf,&
                filebuf%subscanbuf%subscan,&
                filebuf%subscanbuf%databuf,&
                backsci,error)
           if (error) return
           if (backsci%switch%book%found) then
              call reassociate_chunkset_2d(backsci%switch%cycle%data(backsci%switch%cycle%ion),backsci%on%curr,error)
              if (error)  return
!!$           call reassociate_chunkset_2d(backsci%switch%cycle%data(backsci%switch%cycle%ioff),backsci%off%curr,error)
!!$           if (error)  return
              backsci%off%curr => backsci%switch%cycle%data(backsci%switch%cycle%ioff)
              call mrtcal_on_minus_off_new(istracked,notfsw,backcal,backsci,error)
              if (error) return
              call mrtcal_tscale_computation(backcal,backsci,error)
              if (error) return
              call mrtcal_tscale_application(backsci%tscale,backsci%diff,error)
              if (error) return
              call mrtcal_accumulate_or_write(level_cycl_code,mrtset,backsci,error)
              if (error) return
           endif
           ! User can interrupt the pipeline
           if (sic_ctrlc_status()) then
              error = .true.
              exit
           endif
        enddo ! switch%book%idump
        call mrtcal_switch_book_list(backsci%switch%book,error)
        if (error) return
        call mrtcal_accumulate_or_write(level_subs_code,mrtset,backsci,error)
        if (error) return
     enddo ! ion
  enddo ! iref
  call mrtcal_accumulate_or_write(level_scan_code,mrtset,backsci,error)
  if (error) return
  !
end subroutine mrtcal_calib_tracked_wsw
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine mrtcal_psw_fill_section_onecycle(list,cycle,error)
  use gbl_message
  use mrtcal_interfaces, except_this=>mrtcal_psw_fill_section_onecycle
  use mrtcal_calib_types
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  type(subscan_list_t), intent(in)    :: list
  type(switch_cycle_t), intent(inout) :: cycle
  logical,              intent(inout) :: error
  ! Local
  integer(kind=4) :: iphase
  character(len=*), parameter :: rname='PSW>FILL>SECTION>ONECYCLE'
  !
  call mrtcal_message(seve%t,rname,'Welcome')
  !
  do iphase=1,cycle%n
     call mrtcal_psw_fill_section_onephase(iphase,list,cycle,error)
     if (error) return
  enddo ! iphase
  !
end subroutine mrtcal_psw_fill_section_onecycle
!
subroutine mrtcal_psw_fill_section_onephase(iphase,list,cycle,error)
  use gbl_message
  use mrtcal_interfaces, except_this=>mrtcal_psw_fill_section_onephase
  use gbl_constant
  use mrtcal_calib_types
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  integer(kind=4),              intent(in)    :: iphase
  type(subscan_list_t),         intent(in)    :: list
  type(switch_cycle_t), target, intent(inout) :: cycle
  logical,                      intent(inout) :: error
  ! Local
!!$  type(class_switch_t), pointer :: sec
  character(len=*), parameter :: rname='PSW>FILL>SECTION>ONEPHASE'
  !
  call mrtcal_message(seve%t,rname,'Welcome')
!!$  !
!!$  ! Shortcut
!!$  sec => cycle%sec(iphase)
!!$  !
!!$  ! Initialize *** JP This should be done in the CLASS type definition.
!!$  sec%ldecal(:) = 0
!!$  sec%bdecal(:) = 0
!!$  sec%decal(:)  = 0
!!$  sec%poids(:)  = 0
!!$  sec%duree(:)  = 0
!!$  ! Fill the interesting part
!!$  sec%swmod = mod_pos
!!$  sec%nphas = cycle%n
!!$  if (iphase.eq.cycle%ion) then
!!$     sec%poids(iphase) = +1
!!$  else if (iphase.eq.cycle%ioff) then
!!$     sec%poids(iphase) = -1
!!$  else
!!$     call mrtcal_message(seve%e,rname,'Unknown phase number')
!!$     error = .true.
!!$     return
!!$  endif
!!$  sec%ldecal(iphase) = list%onoff%val1(iphase)
!!$  sec%bdecal(iphase) = list%onoff%val2(iphase)
!!$  sec%duree(iphase) = 0
  !
end subroutine mrtcal_psw_fill_section_onephase
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



