!     $Id: modulePakoSwBeam.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   SWITCH 
!     Siblings:        moduleSwBeam.f90
!     Siblings:        moduleSwFrequency.f90
!     Siblings:        moduleSwSpecial.f90
!     Siblings:        moduleSwTotalPower.f90
!     Siblings:        moduleSwWobbler.f90
!
!----------------------------------------------------------------------
!     PAKO module for  swBeam
!
Module modulePakoSwBeam
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  !
  Implicit None
  Save
  Private
  Public :: swBeam, saveSwBeam, writeXMLswBeam
  !     
  ! *** Variables for swBeam ***
  Include 'inc/variables/variablesSwBeam.inc'
  !
Contains
!!!
  Subroutine swBeam(programName,line,command,                 &
       &        error)
    !
    ! *** Arguments: ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    ! TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesSwBeam.inc'
    !
    !D      Write (6,*) " module swBeam ---> SR: swBeam "
    !D      Write (6,*) "                          "
    !D      Write (6,*) "        swModeSelected:   ", swModeSelected
    !
    ! *** initialize:   ***
!!$      If (.Not.isInitialized) Then
!!$         Include 'inc/variables/setDefaults.inc'
!!$         isInitialized = .True.
!!$      Endif
    !
    ! *** set In-values = previous Values   ***
!!$      If (.Not.ERROR) Then
!!$         vars(iIn) = vars(iValue)
!!$      End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    ! *** read Parameters, Options (to detect errors)         ***
    ! *** and check for validity and ranges                   ***
    Call checkNofParameters(command,                                 &
         &     0, 0,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
!!$         Include 'inc/options/readOptionsSwBeam.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
!!$            Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    ! *** read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
!!$      If (.Not. ERROR) Then
!!$         Include 'inc/options/readOptionsSwBeam.inc'
!!$      End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
!!$      If (.Not.ERROR) Then
!!$!
!!$         If (.Not. errorInconsistent) Then
!!$            vars(iTemp) = vars(iIn)
!!$         End If
!!$!
!!$      End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from Temp into persistent variables   ***
!!$      If (.Not.ERROR) Then
!!$            vars(iValue) = vars(iTemp)
!!$      End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Include 'inc/display/commandDisplaySwBeam.inc'
    !
    ! *** set "selected" switching mode ***
    If (.Not.error) Then
       swBeamCommand = line(1:lenc(line))
       !D         write (6,*) "     swBeamCommand   ->",                        &
       !D     &            swBeamCommand(1:lenc(swBeamCommand)),"<-"
       !
       GV%switchingMode = command
       Write (6,*) " GV%switchingMode ", GV%switchingMode
       !D         Write (6,*) "        swModeSelected:   ", swModeSelected
       !D         Write (6,*) "        switchingMode:    ", switchingMode
       write (messageText,*)                                         & 
            &         'Switching Mode selected: ',                            &
            &         GV%switchingMode,                                          &
            &         ' '
       CALL pakoMessage(priorityI,severityI,command,messageText)
    End If
    !
    Return
  End Subroutine swBeam
!!!
  Subroutine saveSwBeam(programName,LINE,commandToSave,      &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    contC = contNN
    !
    B = '\'
    S = ' '
    CMD =  programName//B//"SWBEAM"
    lCMD = lenc(CMD)
    !
    ERROR = .false.
    !
    write (iUnit,*) "! "
    write (iUnit,*) "! ", CMD(1:lCMD)
    write (iUnit,*) CMD(1:lCMD)
    !
    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveSwBeam
!!!
  Subroutine writeXMLswBeam(programName,LINE,commandToSave,      &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    character (len=24) :: valueC
    real               :: value
    logical :: errorXML
    !
    ERROR = .False.
    !
    !D      write (6,*)  "      moduleSwBeam --> SR: writeXMLBeam "
    !
    include 'inc/startXML/swBeam.inc'
    !
    Return
  End Subroutine writeXMLswBeam
!!!
End Module modulePakoSwBeam
!!!








