!     
!     $Id: modulePakoStart.f90,v 1.2 2005/06/22 14:46:29 ungerech Exp $
!    
! <DOCUMENTATION name="moduleStart">
!
! handle Start command.
!
! </DOCUMENTATION>
!
! <DEV> 
! TBD: - more documentation
! TBD: put file backup mechanism in utility SR
! TBD: put file operations like cp in utility SR
! <\DEV> 
!
Module modulePakoStart
  !
  Use modulePakoGlobalParameters
  Use modulePakoGlobalVariables
  Use modulePakoMessages
  Use modulePakoCalibrate
  Use modulePakoFocus
  Use modulePakoOnOff
  Use modulePakoOtfMap
  Use modulePakoPointing
!!$  Use modulePakoSubscanList
  Use modulePakoTip
  Use modulePakoTrack
  Use modulePakoVlbi
  !
  Implicit None
  Save
  Private
  !
  !
  ! *** Subroutines
  !
  Public :: pakoStart
  !
!!!
!!!
Contains
!!!
!!!
  Subroutine pakoStart(programName,LINE,COMMAND,                         &
       &        ERROR)
    !
    !**   arguments:   ***
    Character(len=4)  , Intent(in)    ::  programName
    Character(len=512), Intent(in)    ::  LINE
    Character(len=12) , Intent(in)    ::  COMMAND
    Logical           , Intent(out)  ::  ERROR
    !
    !**   specific local variables:    ***
    Character(len=12)   ::  commandToStart
    Character(len=64)   ::  baseFileName
    Character(len=128)  ::  startFile, startFileOLD
    Character(len=128)  ::  queueFile, queueFileOLD
    Character(len=128)  ::  htmlFile,  htmlFileOLD
    Character(len=128)  ::  htmlQFile, htmlQFileOLD
    Character(len=512)  ::  shellCommand
    Integer             ::  ier, priorityIlocal
    Logical             ::  doAppend
    !
    !**   functions called:   ***
    Logical  ::  SIC_PRESENT
    Integer  ::  SIC_NARG
    Integer  ::  SIC_GETLUN
!!$      Integer  ::  LENC
    Integer  ::  Rename
    Integer  ::  System
    !
    Logical errorS
    !
    !**   standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    priorityIlocal  = 1
    !
    errorL = .False.
    errorS = .False.
    !
    !**   read Parameters, Options   ***
    !
    commandToStart = GV%observingMode
    !
    Include 'inc/parameters/parametersCommandToStart.inc'
    !
    Call SIC_UPPER(commandToStart)
    !
    Write (6,*) '   --> moduleStart: SR pakoStart '
    !
    Write (6,*) '       commandToStart: ', commandToStart
    !
    If (commandToStart .Eq. 'SUBSCAN' .Or.         &
         &    commandToStart .Eq. 'SUBSCANLIST' .Or.         &
         &    commandToStart .Eq. 'LIST') Then
       commandToStart =  'SUBSCANLIST'
    End If
    !
    baseFileName = commandToStart(1:lenc(commandToStart))
    Call sic_lower(baseFileName)
    !
    startFile    = baseFileName(1:lenc(baseFileName))//".xml"
    startFileOLD = startFile(1:lenc(startFile))//"~"
    !
    htmlFile     = baseFileName(1:lenc(baseFileName))//".html"
    htmlFileOLD  = htmlFile(1:lenc(htmlFile))//"~"
    !
    queueFile    = 'QUEUE/startScan.xml'
    queueFileOLD = queueFile(1:lenc(queueFile))//"~"
    !
    htmlQFile    = 'QUEUE/startScan.html'
    htmlQFileOLD = queueFile(1:lenc(queueFile))//"~"
    !
!!$      Write (6,*) "  startFile    ->", startFile(1:lenc(startFile)),"<-"
!!$      Write (6,*) "  startFileOld ->", startFileOld(1:lenc(startFileOld)),"<-"
!!$      Write (6,*) "  htmlFile     ->", htmlFile(1:lenc(htmlFile)),"<-"
!!$      Write (6,*) "  htmlFileOld  ->", htmlFileOld(1:lenc(htmlFileOld)),"<-"
!!$      Write (6,*) "  queueFile    ->", queueFile(1:lenc(queueFile)),"<-"
!!$      Write (6,*) "  queueFileOld ->", queueFileOld(1:lenc(queueFileOld)),"<-"
!!$      Write (6,*) "  htmlQFile    ->", htmlQFile(1:lenc(htmlQFile)),"<-"
!!$      Write (6,*) "  htmlQFileOld ->", htmlQFileOld(1:lenc(htmlQFileOld)),"<-"
    !
    ier = Rename(startFile, startFileOLD)
    If (ier.Eq.0) Then
       Write (messageText,*)                                           &
            &           'renamed previous start file: "',                       &
            &           startFile(1:lenc(startFile)),                           &
            &           '"'
       Call pakoMessage(priorityIlocal,severityI,command,messageText)
       Write (messageText,*)                                           &
            &           '   to: "',                                             &
            &           startFileOLD(1:lenc(startFileOLD)),                     &
            &           '"'
       Call pakoMessage(priorityIlocal,severityI,command,messageText)
    End If
    !
    If ( GV%sessionMode.Eq.om%vlbi ) Then
       !
       !! shellCommand = 'ncsMessageSend.py sync operator:scan:done > /dev/null  2>&1 '  !  to work
       shellCommand = 'ncsMessageSend.py sync     test:scan:done > /dev/null  2>&1 '  !  for tests
       !D       Write (6,*) " shellCommand: "
       !D       Write (6,*)   shellCommand(1:Len_trim(shellCommand))
       ier = system(shellCommand)
       If (ier.Eq.0) Then
          Write (messageText,*)                                        &
               &           'it worked'
          Call pakoMessage(priorityI,severityI,command,messageText)
       Else
          Write (messageText,*)                                        &
               &           'ERROR', ier,                                           &
               &           '  shellCommand: ncsMessageSend.py '
          Call pakoMessage(priorityE,severityE,command,messageText)
       End If
       !
    End If
    !
    !! NOTE: check: SIC IER convention may be different from Unix!
    !! ier = sic_getlun(iunit)
    !! TBD: do this properly /debug!
    iunit =  111
    !
    Write (6,*) "         unit: iunit = ", iunit
    !D    Write (6,*) "         unit: ier =   ", ier
    !
    If (ier.Eq.0) Then      !!  unix convcention !
       !
       Open (unit=iUnit, file=startFile, recl=512,                     &
            &           status='unknown')
       !
       !     call the requested start method:   ***
       !
       If (.False.) Then
       Else If (commandToStart .Eq. 'CALIBRATE') Then
          Call startCalibrate(programName,LINE,commandToStart,       &
               &            iUnit, errorL)
       Else If (commandToStart .Eq. 'FOCUS') Then
          Call startFocus(programName,LINE,commandToStart,       &
               &            iUnit, errorL)
          !**            else if (commandToStart .eq. 'OTFCIRCLE') then
          !**               call startOtfCircle(programName,LINE,commandToStart,         &
          !**        &            iUnit, errorL)
          !**            else if (commandToStart .eq. 'OTFLINEAR') then
          !**               call startOtfLinear(programName,LINE,commandToStart,         &
          !**        &            iUnit, errorL)
       Else If (commandToStart .Eq. 'OTFMAP') Then
          Call startOtfMap(programName,LINE,commandToStart,         &
               &             iUnit, errorL)
       Else If (commandToStart .Eq. 'ONOFF') Then
          Call startOnOff(programName,LINE,commandToStart,         &
               &           iUnit, errorL)
       Else If (commandToStart .Eq. 'POINTING') Then
          Call startPointing(programName,LINE,commandToStart,       &
               &           iUnit, errorL)
!!$       Else If (commandToStart .Eq. 'SEGMENT') Then
!!$          Write (messageText,*)          &
!!$               &               'START SEGMENT is not possible'
!!$          Call pakoMessage(priorityW,severityW,command,messageText)
!!$          Write (messageText,*)          &
!!$               &               'try: START SUBSCAN'
!!$          Call pakoMessage(priorityW,severityW,command,messageText)
!!$          errorL = .True.
!!$       Else If (commandToStart .Eq. 'SUBSCAN') Then
!!$          Call startSubscanList(programName,LINE,commandToStart,    &
!!$               &            iUnit, errorL)
!!$       Else If (commandToStart .Eq. 'SUBSCANLIST') Then
!!$          Call startSubscanList(programName,LINE,commandToStart,    &
!!$               &            iUnit, errorL)                              
!!$       Else If (commandToStart .Eq. 'LIST') Then                    
!!$          Call startSubscanList(programName,LINE,commandToStart,    &
!!$               &            iUnit, errorL)
       Else If (commandToStart .Eq. 'TIP') Then
          Call startTip(programName,LINE,commandToStart,         &
               &             iUnit, errorL)
       Else If (commandToStart .Eq. 'TRACK') Then
          Call startTrack(programName,LINE,commandToStart,         &
               &             iUnit, errorL)
       Else If (commandToStart .Eq. 'VLBI') Then
          Call startVlbi(programName,LINE,commandToStart,         &
               &             iUnit, errorL)
       Else
          errorL = .True.
          errorS = .True. 
       End If
       !
       Close(unit=iunit)
!!       Call sic_frelun(iunit)
       !
    Else
       errorL = .True.
    End If
    !
    ERROR = ERROR .Or. errorL
    !
    If (.Not. ERROR) Then
       !     
       messageText =                                                   &
            &           " OK. wrote "//                                         &
            &           commandToStart(1:lenc(commandToStart))//                &
            &           " to file "//startFile(1:lenc(startFile))
       Call pakoMessage(priorityI,severityI,command,messageText)
       !
       ier = Rename(queueFile, queueFileOLD)
       If (ier.Eq.0) Then
          Write (messageText,*)                                        &
               &           'renamed previous queue file: "',                       &
               &           queueFile(1:lenc(queueFile)),                           &
               &           '"'
          Call pakoMessage(priorityIlocal,severityI,command,messageText)
          Write (messageText,*)                                        &
               &           '   to: "',                                             &
               &           queueFileOLD(1:lenc(queueFileOLD)),                     &
               &           '"'
          Call pakoMessage(priorityIlocal,severityI,command,messageText)
       End If
       !
!!$       ier = Rename(htmlFile, htmlFileOLD)
!!$       If (ier.Eq.0) Then
!!$          Write (messageText,*)                                        &
!!$               &           'renamed previous html file: "',                        &
!!$               &           htmlFile(1:lenc(htmlFile)),                             &
!!$               &           '"'
!!$          Call pakoMessage(priorityIlocal,severityI,command,messageText)
!!$          Write (messageText,*)                                        &
!!$               &           '   to: "',                                             &
!!$               &           htmlFileOLD(1:lenc(htmlFileOLD)),                       &
!!$               &           '"'
!!$          Call pakoMessage(priorityIlocal,severityI,command,messageText)
!!$       End If
       !
       shellCommand = 'cp '//                                          &
            &        startFile(1:lenc(startFile))//                             &
            &        ' '//                                                      &
            &        queueFile(1:lenc(queueFile))
       ier = system(shellCommand)
       If (ier.Eq.0) Then
          Write (messageText,*)                                        &
               &           'copied start file: "',                                 &
               &           startFile(1:lenc(startFile)),                           &
               &           '"'
          Call pakoMessage(priorityI,severityI,command,messageText)
       Else
          Write (messageText,*)                                        &
               &           'ERROR', ier,                                           &
               &           ' on copy of start file: "',                            &
               &           startFile(1:lenc(startFile))
          Call pakoMessage(priorityE,severityE,command,messageText)
       End If
       Write (messageText,*)                                           &
            &        '   to queue: "',                                          &
            &        queueFile(1:lenc(queueFile)),                              &
            &        '"'
       Call pakoMessage(priorityI,severityI,command,messageText)
       !
!!$       shellCommand = 'obsXMLtoHTML.py < '//                           &
!!$            &        startFile(1:lenc(startFile))//                             &
!!$            &        ' > '//                                                    &
!!$            &        htmlFile(1:lenc(htmlFile))
!!$       ier = 1
!!$       ier = system(shellCommand)
!!$       If (ier.Eq.0) Then
!!$          Write (messageText,*)                                        &
!!$               &           'transformed XML file: "',                              &
!!$               &           startFile(1:lenc(startFile)),                           &
!!$               &           '"'
!!$          Call pakoMessage(priorityIlocal,severityI,command,messageText)
!!$       Else
!!$          Write (messageText,*)                                        &
!!$               &           'ERROR', ier,                                           &
!!$               &           ' on transform of XML file: "',                         &
!!$               &           startFile(1:lenc(startFile))
!!$          Call pakoMessage(priorityE,severityE,command,messageText)
!!$       End If
!!$       Write (messageText,*)                                           &
!!$            &        '   to HTML file: "',                                      &
!!$            &        htmlFile(1:lenc(htmlFile)),                                &
!!$            &        '"'
!!$       Call pakoMessage(priorityIlocal,severityI,command,messageText)
!!$       !
!!$       shellCommand = 'cp '//                                          &
!!$            &        htmlFile(1:lenc(htmlFile))//                               &
!!$            &        ' '//                                                      &
!!$            &        htmlQFile(1:lenc(htmlQFile))
!!$       ier = system(shellCommand)
!!$       If (ier.Eq.0) Then
!!$          Write (messageText,*)                                        &
!!$               &           'copied html file: "',                                  &
!!$               &           htmlFile(1:lenc(htmlFile)),                             &
!!$               &           '"'
!!$          Call pakoMessage(priorityIlocal,severityI,command,messageText)
!!$       Else
!!$          Write (messageText,*)                                        &
!!$               &           'ERROR', ier,                                           &
!!$               &           ' on copy of html file: "',                             &
!!$               &           htmlFile(1:lenc(htmlFile))
!!$          Call pakoMessage(priorityE,severityE,command,messageText)
!!$       End If
!!$       Write (messageText,*)                                           &
!!$            &        '   to: "',                                                &
!!$            &        htmlQFile(1:lenc(htmlQFile)),                              &
!!$            &        '"'
!!$       Call pakoMessage(priorityIlocal,severityI,command,messageText)
       !
    Else If (errorS) Then
       !     
       messageText =                                                   &
            &          programName(1:lenc(programName))//                       &
            &        " does not know (yet) how to  start "//                    &
            &          commandToStart(1:lenc(commandToStart))
       Call pakoMessage(priorityE,severityE,command,messageText)
       !
    Else If (ERROR) Then
       !     
       messageText =                                                   &
            &          programName(1:lenc(programName))//                       &
            &        " could not start "//                                      &
            &          commandToStart(1:lenc(commandToStart))//                 &
            &        " to file "//startFile(1:lenc(startFile))
       Call pakoMessage(priorityE,severityE,command,messageText)
       !
    End If
    !
    Return
    !
    !
  End Subroutine pakoStart
!!!
!!!
End Module modulePakoStart



