subroutine cube_functions(error)
  use gbl_message
  use gkernel_interfaces
  use classcore_interfaces, except_this=>cube_functions
  !---------------------------------------------------------------------
  ! @ private
  ! Define cube-building functions
  !---------------------------------------------------------------------
  logical, intent(inout) :: error
  !
  call sic_def_func('TDV',   s_tdv,   d_tdv,   2,error,hlpfile='gag_help_func_class')
  call sic_def_func('STDV',  s_stdv,  d_stdv,  1,error,hlpfile='gag_help_func_class')
  call sic_def_func('TPEAK', s_tpeak, d_tpeak, 1,error,hlpfile='gag_help_func_class')
  call sic_def_func('VPEAK', s_vpeak, d_vpeak, 1,error,hlpfile='gag_help_func_class')
  call sic_def_func('TPEAKV',s_tpeakv,d_tpeakv,2,error,hlpfile='gag_help_func_class')
  call sic_def_func('VPEAKV',s_vpeakv,d_vpeakv,2,error,hlpfile='gag_help_func_class')
  if (error) &
     call class_message(seve%f,'CUBE_FUNCTIONS','Error in function definitions')
  !
end subroutine cube_functions
!
subroutine allinfo(obs,v1,v2,v,s0,data1)
  use gildas_def
  use classcore_interfaces, except_this=>allinfo
  use class_types
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  type(observation), intent(in)  :: obs    !
  real(kind=8),      intent(in)  :: v1     ! Lower bound of velocity interval
  real(kind=8),      intent(in)  :: v2     ! Upper bound of velocity interval
  real(kind=4),      intent(out) :: v      !
  real(kind=4),      intent(out) :: s0     !
  real(kind=4),      intent(out) :: data1  !
  ! Local
  real(kind=8) :: ri1,ri2
  integer(kind=4) :: i1,i2,imin,imax,nmax(1)
  !
  ! Compute the integrated area,Tmax,V of MaX
  call abscissa_velo2chan(obs%head,v1,ri1)
  call abscissa_velo2chan(obs%head,v2,ri2)
  i1 = nint(ri1)
  i2 = nint(ri2)
  imin = max(min(i1,i2),1)
  imax = min(max(i1,i2),obs%head%spe%nchan)
!!$  s0 = 0
!!$  n = 0
!!$  v = 0
!!$  nc=imin
!!$  data1 = obs%spectre(nc)
!!$  do while(obs%spectre(nc).eq.obs%head%spe%bad.and.nc.le.imax)
!!$     nc=nc+1
!!$  enddo
!!$  if (nc.lt.imax) data1 = obs%spectre(nc)
!!$  datav = 0.0
!!$  do i=nc,imax
!!$     if (obs%spectre(i).ne.obs%head%spe%bad) then
!!$        datav = obs%spectre(i)
!!$        n = n+1
!!$        s0 = s0+datav
!!$        if (datav.gt.data1) then
!!$           data1=datav
!!$           call abscissa_chan2velo(obs%head,i,v)
!!$        endif
!!$     endif
!!$  enddo
!!$  ! Transforms K*channels to K*km/s
!!$  if (n.ne.0) then
!!$     s0 = s0*abs(obs%head%spe%vres)
!!$  else
!!$     s0 = obs%head%spe%bad
!!$  endif
  data1 = maxval(obs%spectre(imin:imax),1,obs%spectre(imin:imax).ne.obs%head%spe%bad)
  s0    = sum   (obs%spectre(imin:imax),1,obs%spectre(imin:imax).ne.obs%head%spe%bad)
  nmax  = maxloc(obs%spectre(imin:imax),  obs%spectre(imin:imax).ne.obs%head%spe%bad)
  nmax  = imin+nmax-1
  call abscissa_chan2velo(obs%head,real(nmax(1)),v)
  if (s0.eq.0.) then
     s0 = obs%head%spe%bad
  else
     s0 = s0*abs(obs%head%spe%vres)
  endif
end subroutine allinfo
!
function s_tdv(v1,v2)
  use class_data
  use classcore_interfaces, except_this=>s_tdv
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !---------------------------------------------------------------------
  real(kind=4) :: s_tdv  !
  real(kind=8), intent(in) :: v1,v2  !
  ! Local
  real(kind=4) :: v,s0,data1
  !
  call allinfo(r,v1,v2,v,s0,data1)
  s_tdv=s0
end function s_tdv
!
function d_tdv(v1,v2)
  use class_data
  use classcore_interfaces, except_this=>d_tdv
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !-------------------------------------------------------------------
  real(kind=8) :: d_tdv  !
  real(kind=8), intent(in) :: v1,v2  !
  ! Local
  real(kind=4) :: v,s0,data1
  !
  call allinfo(r,v1,v2,v,s0,data1)
  d_tdv=dble(s0)
end function d_tdv
!
function s_tpeakv(v1,v2)
  use class_data
  use classcore_interfaces, except_this=>s_tpeakv
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !---------------------------------------------------------------------
  real(kind=4) :: s_tpeakv  !
  real(kind=8), intent(in) :: v1,v2  !
  ! Local
  real(kind=4) :: v,s0,data1
  !
  call allinfo(r,v1,v2,v,s0,data1)
  s_tpeakv=data1
end function s_tpeakv
!
function d_tpeakv(v1,v2)
  use class_data
  use classcore_interfaces, except_this=>d_tpeakv
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !-------------------------------------------------------------------
  real(kind=8) :: d_tpeakv  !
  real(kind=8), intent(in) :: v1,v2  !
  ! Local
  real(kind=4) v,s0,data1
  !
  call allinfo(r,v1,v2,v,s0,data1)
  d_tpeakv=dble(data1)
end function d_tpeakv
!
function s_vpeakv(v1,v2)
  use class_data
  use classcore_interfaces, except_this=>s_vpeakv
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !---------------------------------------------------------------------
  real(kind=4) :: s_vpeakv  !
  real(kind=8), intent(in) :: v1,v2  !
  ! Local
  real(kind=4) :: v,s0,data1
  !
  call allinfo(r,v1,v2,v,s0,data1)
  s_vpeakv=v
end function s_vpeakv
!
function d_vpeakv(v1,v2)
  use class_data
  use classcore_interfaces, except_this=>d_vpeakv
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !-------------------------------------------------------------------
  real(kind=8) :: d_vpeakv  !
  real(kind=8), intent(in) :: v1,v2  !
  ! Local
  real(kind=4) :: v,s0,data1
  !
  call allinfo(r,v1,v2,v,s0,data1)
  d_vpeakv=dble(v)
end function d_vpeakv
!
function s_stdv(dummy)
  use class_data
  use classcore_interfaces, except_this=>s_stdv
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !---------------------------------------------------------------------
  real(kind=4) :: s_stdv  !
  real(kind=8), intent(in) :: dummy  !
  ! Local
  real(kind=8) :: v1,v2
  real(kind=4) :: v,s0,data1
  !
  call abscissa_velo_left(r%head,v1)
  call abscissa_velo_right(r%head,v2)
  call allinfo(r,v1,v2,v,s0,data1)
  s_stdv=s0
end function s_stdv
!
function d_stdv(dummy)
  use class_data
  use classcore_interfaces, except_this=>d_stdv
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !-------------------------------------------------------------------
  real(kind=8) :: d_stdv  !
  real(kind=8), intent(in) :: dummy  !
  ! Local
  real(kind=8) :: v1,v2
  real(kind=4) :: v,s0,data1
  !
  call abscissa_velo_left(r%head,v1)
  call abscissa_velo_right(r%head,v2)
  call allinfo(r,v1,v2,v,s0,data1)
  d_stdv=dble(s0)
end function d_stdv
!
function s_tpeak(dummy)
  use class_data
  use classcore_interfaces, except_this=>s_tpeak
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !---------------------------------------------------------------------
  real(kind=4) :: s_tpeak  !
  real(kind=8), intent(in) :: dummy  !
  ! Local
  real(kind=8) :: v1,v2
  real(kind=4) :: v,s0,data1
  !
  call abscissa_velo_left(r%head,v1)
  call abscissa_velo_right(r%head,v2)
  call allinfo(r,v1,v2,v,s0,data1)
  s_tpeak=data1
end function s_tpeak
!
function d_tpeak(dummy)
  use class_data
  use classcore_interfaces, except_this=>d_tpeak
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !-------------------------------------------------------------------
  real(kind=8) :: d_tpeak  !
  real(kind=8), intent(in) :: dummy  !
  ! Local
  real(kind=8) :: v1,v2
  real(kind=4) :: v,s0,data1
  !
  call abscissa_velo_left(r%head,v1)
  call abscissa_velo_right(r%head,v2)
  call allinfo(r,v1,v2,v,s0,data1)
  d_tpeak=dble(data1)
end function d_tpeak
!
function s_vpeak(dummy)
  use class_data
  use classcore_interfaces, except_this=>s_vpeak
  !---------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !---------------------------------------------------------------------
  real(kind=4) :: s_vpeak  !
  real(kind=8), intent(in) :: dummy  !
  ! Local
  real(kind=8) :: v1,v2
  real(kind=4) :: v,s0,data1
  !
  call abscissa_velo_left(r%head,v1)
  call abscissa_velo_right(r%head,v2)
  call allinfo(r,v1,v2,v,s0,data1)
  s_vpeak=v
  return
end function s_vpeak
!
function d_vpeak(dummy)
  use class_data
  use classcore_interfaces, except_this=>d_vpeak
  !-------------------------------------------------------------------
  ! @ private
  ! CLASS internal routine
  !-------------------------------------------------------------------
  real(kind=8) :: d_vpeak  !
  real(kind=8), intent(in) :: dummy  !
  ! Local
  real(kind=8) :: v1,v2
  real(kind=4) :: v,s0,data1
  !
  call abscissa_velo_left(r%head,v1)
  call abscissa_velo_right(r%head,v2)
  call allinfo(r,v1,v2,v,s0,data1)
  d_vpeak=dble(v)
end function d_vpeak
