!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine class_pack_set(pack)
  use gpack_def
  use gkernel_interfaces
  !---------------------------------------------------------------------
  ! @ public-mandatory (because symbol is used elsewhere)
  !---------------------------------------------------------------------
  type(gpack_info_t), intent(out) :: pack
  !
  external :: ephem_pack_set
  external :: class_pack_init
  external :: class_pack_clean
  !
  pack%name='class'
  pack%ext='.class'
  pack%depend(1:2) = (/ locwrd(ephem_pack_set), locwrd(greg_pack_set) /)
  pack%init=locwrd(class_pack_init)
  pack%clean=locwrd(class_pack_clean)
  pack%authors="S.Bardeau, J.Pety, P.Hily-Blant, S.Guilloteau"
  !
end subroutine class_pack_set
!
subroutine class_pack_init(gpack_id,error)
  use gbl_message
  use sic_def
  use class_dependencies_interfaces
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  integer(kind=4), intent(in)    :: gpack_id
  logical,         intent(inout) :: error
  ! Global
  logical, external :: sas_function
  ! Local
  character(len=*), parameter :: rname='INIT'
  !
  ! One time initialization
  call classic_message_set_id(gpack_id)  ! Set library id
  call class_message_set_id(gpack_id)  ! Set library id
  !
  ! Allocate buffer memory
  call allocate_class(error)
  if (error) return
  !
  ! Local language
  call init_class(sas_function)  ! Must come after R/T association (in allocate_class)
  call load_map(error)
  if (error) return
  !
  ! Define Functions
  call cube_functions(error)
  if (error) return
  !
  call exec_program('sic'//backslash//'sic priority 1 las 2 analyse fit')
  ! Set defaults
  call exec_program('las'//backslash//'set default')
  !
  ! Debug information
#if defined(FORTRAN2003_PP) /* Fortran 2003 Procedure Pointers */
  call class_message(seve%i,rname,  &
    'Class conversion routines use Fortran 2003 Procedure Pointers')
#else
  call class_message(seve%i,rname,  &
    'Class conversion routines do not use Fortran 2003 Procedure Pointers')
#endif
  !
end subroutine class_pack_init
!
subroutine class_pack_clean(error)
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  logical, intent(inout) :: error
  !
  call exit_class
  !
end subroutine class_pack_clean
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
