!
! Obsolete package for FITS Tape I/O handling
!
subroutine gfits_init(error)
  use gio_interfaces, except_this=>gfits_init
  use gio_fitsio
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !  Initialize current sequential device
  !---------------------------------------------------------------------
  logical, intent(inout) :: error  !
  !
  if (dev_type.eq.tape) then
    call mtinit(unit,error)
    ifile = 1
  else
    call gio_message(seve%e,'FITS','Command INITIALIZE is meaningless for '//  &
    'disk and CDs')
    error = .true.
  endif
end subroutine gfits_init
!
subroutine gfits_skip(nfile,error)
  use gio_interfaces, except_this=>gfits_skip
  use gio_fitsio
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !       Skip a number of files on current sequential device.
  ! Arguments :
  !       NFILE   I       Number of file skipped          Input
  !---------------------------------------------------------------------
  integer                :: nfile  !
  logical, intent(inout) :: error  ! Logical error flag
  ! Local
  character(len=*), parameter :: rname='FITS'
  integer :: ncoun
  !
  if (.not.sequential) then
    call gio_message(seve%w,rname,'Skipping is only meaningful on '//  &
    'sequential media')
  else
    if (dev_type.eq.tape) then
      call mtskip(unit,nfile,ncoun,end_of_tape,error)
      if (.not.error) ifile = ifile+ncoun
    else
      call gio_message(seve%e,rname,'Internal logic error, unknown device '//  &
        'type')
      error=.true.
      return
    endif
  endif
end subroutine gfits_skip
!
subroutine gfits_rewind(error)
  use gio_interfaces, except_this=>gfits_rewind
  use gio_fitsio
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !  Rewind current sequential device
  !---------------------------------------------------------------------
  logical, intent(inout) :: error  ! Logical error flag
  ! Local
  character(len=*), parameter :: rname='FITS'
  integer :: ncoun
  !
  if (.not.sequential) then
    call gio_message(seve%w,rname,'Rewinding is only meaningful on '//  &
    'sequential media')
  else
    if (dev_type.eq.tape) then
      call mtrewi(unit,error)
      if (.not.error) then
        ifile = 1
        call mtskip(unit,0,ncoun,end_of_tape,error)
      endif
    else
      call gio_message(seve%e,rname,'Internal logic error, unknown device '//  &
        'type')
      error=.true.
      return
    endif
  endif
end subroutine gfits_rewind
!
subroutine gfits_eof(error)
  use gio_interfaces, except_this=>gfits_eof
  use gio_fitsio
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public
  !       Goes to end of current FITS file on sequential devices
  !---------------------------------------------------------------------
  logical, intent(inout) :: error  ! Logical error flag
  ! Local
  character(len=message_length) :: mess
  !
  if (.not.sequential) return
  if (dev_type.eq.tape) then
    if (read) then
      if (.not.end_of_tape) then
        call mtend(unit,end_of_tape,error)
        if (.not.error) ifile = ifile+1
      endif
    else
      call mtflus(unit,error)  ! Flush buffer for blocked mode
      call mtmark(unit,error)  ! Write a tape mark
      if (error) then
        write(mess,'(A,I4,A)') 'File ',ifile,' incomplete'
        call gio_message(seve%e,'CLOSE',mess)
        return
      endif
      ifile = ifile + 1
      write(mess,'(A,I4,A)') 'File ',ifile,' written'
      call gio_message(seve%i,'CLOSE',mess)
    endif
  else
    call gio_message(seve%e,'FITS','Internal logic error, unknown device type')
    error=.true.
    return
  endif
  return
end subroutine gfits_eof
!
subroutine gfits_eot(error)
  use gio_interfaces, except_this=>gfits_eot
  use gio_fitsio
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public
  !  Goes to end of current sequential device.
  !---------------------------------------------------------------------
  logical, intent(inout) :: error  ! Logical error flag
  ! Local
  integer :: ncoun
  !
  if (.not.sequential) return
  if (dev_type.eq.tape) then
    call mtskip(unit,32767,ncoun,end_of_tape,error)
    if (.not.error) ifile = ifile+ncoun
  else
    call gio_message(seve%e,'FITS','Internal logic error, unknown device type')
    error=.true.
    return
  endif
  return
end subroutine gfits_eot
!
subroutine gfits_pos(is_sequential,position,eot)
  use gio_interfaces, except_this=>gfits_pos
  use gio_fitsio
  !---------------------------------------------------------------------
  ! @ public
  !     Return position on current sequential device
  ! Arguments :
  !     IS_SEQUENTIAL   L       Current device is sequential            Output
  !     POSITION        I       Current file number                     Output
  !     EOT             L       Position is at end of tape              Output
  !---------------------------------------------------------------------
  logical :: is_sequential          !
  integer :: position               !
  logical :: eot                    !
  !
  is_sequential = sequential
  if (sequential) then
    position = ifile
    eot = end_of_tape
  endif
end subroutine gfits_pos
