subroutine define_var (error)
  use gildas_def
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  use clean_types
  use clean_default
  use clean_support
  use code_names
  !
  logical :: error  ! Logical error flag
  logical :: warning
  ! Local
  real :: wdata
  integer :: ier
  integer(kind=index_length) :: dim(4) = 0
  !
  ! CLEAN program variables
  user_method%m_iter = 0
  call sic_def_inte ('NITER',user_method%m_iter,0,dim,.false.,error)
  call sic_def_inte ('CLEAN_NITER',user_method%m_iter,0,dim,.false.,error)
  user_method%p_iter = 0
  call sic_def_inte ('CLEAN_POSITIVE',user_method%p_iter,0,dim,.false.,error)
  user_method%n_major = 50
  call sic_def_inte ('CLEAN_NCYCLE',user_method%n_major,0,dim,.false.,error)
  user_method%gain = 0.2
  call sic_def_real ('GAIN',user_method%gain,0,dim,.false.,error)
  call sic_def_real ('CLEAN_GAIN',user_method%gain,0,dim,.false.,error)
  user_method%fres = 0.01
  call sic_def_real ('FRES',user_method%fres,0,dim,.false.,error)
  call sic_def_real ('CLEAN_FRES',user_method%fres,0,dim,.false.,error)
  user_method%ares = 0.0
  call sic_def_real ('ARES',user_method%ares,0,dim,.false.,error)
  call sic_def_real ('CLEAN_ARES',user_method%ares,0,dim,.false.,error)
  user_method%converge = 0
  call sic_def_inte ('CLEAN_NKEEP',user_method%converge,0,dim,.false.,error)
  user_method%spexp = 1.0
  call sic_def_real ('CLEAN_SPEEDY',user_method%spexp,0,dim,.false.,error)
  user_method%ngoal = 10000
  call sic_def_inte ('CLEAN_NGOAL',user_method%ngoal,0,dim,.false.,error)
  !
  ! MultiScale
  user_method%nker = (/1,7,11/)
  dim(1) = 3
  call sic_def_inte ('CLEAN_KERNEL',user_method%nker,1,dim,.false.,error)
  user_method%ninflate = 20   ! A decent value, sometimes too short
  call sic_def_inte ('CLEAN_INFLATE',user_method%ninflate,0,0,.false.,error)
  user_method%smooth = sqrt(3.0)
  call sic_def_real ('CLEAN_SMOOTH',user_method%smooth,0,dim,.false.,error)
  user_method%worry = 0.0
  call sic_def_real ('CLEAN_WORRY',user_method%worry,0,dim,.false.,error)
  !
  ! Search area
  dim(1) = 2
  user_method%blc = 0
  call sic_def_inte ('BLC',user_method%blc,1,dim,.false.,error)
  user_method%trc = 0
  call sic_def_inte ('TRC',user_method%trc,1,dim,.false.,error)
  !
  ! Beam fitting
  user_method%thresh = 0.35
  call sic_def_real ('CLEAN_SIDELOBE',user_method%thresh,0,dim,.false.,error)
  major_sec = 0.0
  call sic_def_real ('MAJOR',major_sec,0,dim,.false.,error)
  minor_sec = 0.0
  call sic_def_real ('MINOR',minor_sec,0,dim,.false.,error)
  ! Delete the ANGLE variable defined by define.greg and recreate it
  ! such as it maps 'user_method%angle'
  call sic_delvariable('ANGLE',.true.,warning)
  user_method%angle = 0.0
  call sic_def_real ('ANGLE',user_method%angle,0,dim,.false.,error)  
  !
  ! MRC
  user_method%ratio = 0
  call sic_def_real ('CLEAN_RATIO',user_method%ratio,0,dim,.false.,error)
  !
  ! Mosaic mode
  user_method%search = 0.2
  call sic_def_real ('SEARCH_W',user_method%search,0,dim,.false.,error)
  call sic_def_real ('CLEAN_SEARCH',user_method%search,0,dim,.false.,error)
  user_method%restor = 0.2
  call sic_def_real ('CLEAN_RESTORE',user_method%restor,0,dim,.false.,error)
  call sic_def_real ('RESTORE_W',user_method%restor,0,dim,.false.,error)
  ! Delete the MOSAIC variable defined by define.greg and recreate it
  ! such as it maps 'user_method%mosaic'
  call sic_delvariable('MOSAIC',.true.,warning)
  user_method%mosaic = .false.
  call sic_def_logi ('MOSAIC',user_method%mosaic,.false.,error)
  !
  ! Rather obscure parameters
  dim(1) = 2
  user_method%patch = 0
  call sic_def_inte ('BEAM_PATCH',user_method%patch,1,dim,.false.,error)
  !
  user_method%verbose = .false.
  call sic_def_logi ('VERBOSE',user_method%verbose,.false.,error)
  ! Compact Array parameters
  cuse_method%gain = 0.4
  call sic_def_real ('C_GAIN',cuse_method%gain,0,dim,.false.,error)
  !
  ! UV_MAP variables
  default_map%precis = 0.1       ! Requested precision
  call sic_def_real ('MAP_PRECIS',default_map%precis,0,dim,.false.,error)
  default_map%beam = 0           ! Number of channels per beam
  call sic_def_inte ('MAP_BEAM_STEP',default_map%beam,0,dim,.false.,error)
  dim = [2,0,0,0]
  default_map%field = 0          ! Map field in arcsecond
  call sic_def_real ('MAP_FIELD',default_map%field,1,dim,.false.,error)
  default_map%size = 0           ! Map size in Pixels
  call sic_def_inte ('MAP_SIZE',default_map%size,1,dim,.false.,error)
  default_map%xycell = 0         ! Map cell size in arcsecond
  call sic_def_real ('MAP_CELL',default_map%xycell,1,dim,.false.,error)
  dim = [3,0,0,0]
  default_map%taper = 0          ! UV Taper in m and Degree
  call sic_def_real ('MAP_UVTAPER',default_map%taper,1,dim,.false.,error)
  default_map%taper(4) = 2       ! Taper exponent
  call sic_def_real ('MAP_TAPEREXPO',default_map%taper(4),0,dim,.false.,error)
  !
  default_map%uniform(1) = 0.0      ! UV cell size
  call sic_def_real ('MAP_UVCELL',default_map%uniform(1),0,dim,.false.,error)
  default_map%uniform(2) = 1.0      ! Robustness coefficient
  call sic_def_real ('MAP_ROBUST',default_map%uniform(2),0,dim,.false.,error)
  ! No longer used 
  ! default_map%mode = 'NATURAL'   ! Weighting mode
  ! call sic_def_char ('MAP_WEIGHT',default_map%mode,.false.,error)
  !
  default_map%truncate = 20.0     ! Truncation level (Mosaic or Primary)
  call sic_def_real ('MAP_TRUNCATE',default_map%truncate,0,dim,.false.,error)
  !
  default_map%ctype = 5    ! Convolution code
  call sic_def_inte ('MAP_CONVOLUTION',default_map%ctype,0,dim,.false.,error)
  !
  default_map%shift = .false.
  call sic_def_logi ('MAP_SHIFT',default_map%shift,.false.,error)
  default_map%ra_c = ' '   ! Weighting mode
  call sic_def_char ('MAP_RA',default_map%ra_c,.false.,error)
  default_map%dec_c = ' '   ! Weighting mode
  call sic_def_char ('MAP_DEC',default_map%dec_c,.false.,error)
  default_map%angle = 0.0      ! Robustness coefficient
  call sic_def_real ('MAP_ANGLE',default_map%angle,0,dim,.false.,error)
  !
  ! Old names for compatibility
  !   define logical uv_shift /global
  !   define integer convolution /global
  !   define double uv_cell[2] uv_taper[3] taper_expo /global
  old_map = default_map
  call sic_def_inte ('CONVOLUTION',old_map%ctype,0,dim,.false.,error)
  call sic_def_logi ('UV_SHIFT',old_map%shift,.false.,error)
  call sic_def_char ('WEIGHT_MODE',old_map%mode,.false.,error)
  dim = [2,0,0,0]
  call sic_def_real ('UV_CELL',old_map%uniform(1),1,dim,.false.,error)
  dim = [3,0,0,0]
  call sic_def_real ('UV_TAPER',old_map%taper,1,dim,.false.,error)
  call sic_def_real ('TAPER_EXPO',old_map%taper(4),0,dim,.false.,error)
  ! Initialize status
  save_map = old_map
  !
  ! Dummy definition of the variable & W Header (obsolete)
  !! call sic_def_real('W',wdata,0,dim,.true.,error)
  !
  ! W Header
  !! call sic_def_header('W',w_plot,.false.,error)
  !
  ! Dirty Min/Max
  call sic_def_real('D_MAX',d_max,0,dim,.false.,error)
  call sic_def_real('D_MIN',d_min,0,dim,.false.,error)
  !
  ! CLEAN\SUPPORT polygon, mapped on SUPPORT%  (reserved structure name)
  call sic_defstructure(supportvar,.true.,error)
  !
  ! UV Size
  dim(1) = 2
#if defined(INDEX4) || !defined(BITS64)
  call sic_def_inte('UV_DIM',huv%gil%dim,1,dim,.false.,error)
  call sic_def_inte('UVS_DIM',huvt%gil%dim,1,dim,.false.,error)
#else
  call sic_def_long('UV_DIM',huv%gil%dim,1,dim,.false.,error)
  call sic_def_long('UVS_DIM',huvt%gil%dim,1,dim,.false.,error)
#endif
  call sic_def_inte('UV_NCHAN',huv%gil%nchan,0,dim,.false.,error)
  !
  dim(1) = mtype
  call sic_def_charn('FILE_TYPE',vtype,1,dim,.true.,error)
  call sic_def_charn('FILE_EXT',etype,1,dim,.false.,error)
  !
  ! Delete the TYPE variable defined by define.greg and recreate it
  ! such as it maps 'ctype'
  call sic_delvariable('TYPE',.true.,warning)
  dim(1) = 0
  ctype = ' '  ! Make sure it is initialized
  call sic_def_char('TYPE',ctype,.false.,error)
  !
  call gildas_null(hbeam)
  call gildas_null(hclean)
  call gildas_null(hresid)
  call gildas_null(hdirty)
  !
  call gildas_null(hprim)
  call gildas_null(huv, type = 'UVT')
  call gildas_null(huvi, type = 'UVT')
  call gildas_null(huvt, type = 'UVT')
  call gildas_null(huvm, type = 'UVT')
  call gildas_null(hcct)
  call gildas_null(hmask)
  call gildas_null(hsky)
  !
  call gdf_init_codes(items, stoke)
  !
  ! Read/Write Optimization
  rw_optimize = 0
  ier = sic_getlog('MAPPING_OPTIMIZE',rw_optimize)
  call sic_def_inte('MAPPING_OPTIMIZE',rw_optimize,0,dim,.false.,error)
  !
  ! Debug
  call sic_def_logi('DO_WEIG',do_weig,.false.,error)
  !
end subroutine define_var
