      SUBROUTINE RUN_PAKO(LINE,COMM,ERROR)
C
C     modeled on RUN_ASTRO and RUN_MIRA
C
C------------------------------------------------------------------------
*
      Use modulePakoMessages
      Use modulePakoGlobalVariables
      Use modulePakoDisplayText
      Use modulePakoReceiver
      Use modulePakoBackend
      Use modulePakoSwBeam
      Use modulePakoSwFrequency
      Use modulePakoSwWobbler
      Use modulePakoSwTotalPower
      Use modulePakoSource
      Use modulePakoCalibrate
      Use modulePakoFocus
      Use modulePakoOnOff
      Use modulePakoOtfMap
      Use modulePakoPointing
      Use modulePakoTip
      Use modulePakoTrack
      Use modulePakoVlbi
      Use modulePakoStart
*
      CHARACTER*(*) LINE
      CHARACTER*12 COMM
      LOGICAL ERROR, SIC_PRESENT
*------------------------------------------------------------------------
*
      CHARACTER*12 programName
!
      programName = "pako"
!
      include 'inc/display/displayCommandLine.inc'
!
      If (.False.) Then
      ELSEIF      (COMM.EQ.'BACKEND')  THEN      
         CALL backend(programName,LINE,COMM,ERROR)
      ELSEIF  (COMM.EQ.'CALIBRATE')  THEN
         CALL CALIBRATE(programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'CATALOG')  THEN
         CALL CATALOG(LINE,ERROR)
      ELSEIF (COMM.EQ.'FOCUS')  THEN
         CALL FOCUS    (programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'OFFSETS') THEN
         CALL OFFSETS  (programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'ONOFF')  THEN
         CALL ONOFF    (programName,LINE,COMM,ERROR)
c$$$      ELSEIF (COMM.EQ.'OTFCIRCLE')  THEN
c$$$         CALL OTFCIRCLE(LINE,COMM, ERROR)
c$$$      ELSEIF (COMM.EQ.'OTFLINEAR')  THEN
c$$$         CALL OTFLINEAR(LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'OTFMAP')     THEN
         CALL OTFMAP   (programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'POINTING') THEN
         CALL POINTING (programName,LINE,COMM, ERROR)
c$$$      ELSEIF (COMM.EQ.'SEGMENT') THEN
c$$$         CALL segment(programName,LINE,COMM, ERROR)
c$$$      ELSEIF (COMM.EQ.'SUBSCAN') THEN
c$$$         CALL subscan(programName,LINE,COMM, ERROR)
c$$$      ELSEIF (COMM.EQ.'TRACK') THEN
c$$$         CALL TRACK(LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'RECEIVER')  THEN
         CALL receiver(programName,LINE,COMM,ERROR)
c$$$      ELSEIF (COMM.EQ.'SAVE') THEN
c$$$         CALL pakoSave(programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'SET') THEN
         CALL pakoSet(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'SHOW') THEN
         CALL pakoShow(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'SOURCE')  THEN
         CALL source(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'START') THEN
         CALL pakoStart(programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'SWBEAM') THEN
         CALL swBeam(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'SWFREQUENCY') THEN
         CALL swFrequency(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'SWTOTAL') THEN
         CALL swTotalPower(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'SWWOBBLER') THEN
         CALL swWobbler(programName,LINE,COMM,ERROR)
      ELSEIF (COMM.EQ.'TIP') THEN
         CALL TIP (programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'TRACK') THEN
         CALL TRACK (programName,LINE,COMM, ERROR)
      ELSEIF (COMM.EQ.'VLBI') THEN
         CALL VLBI (programName,LINE,COMM, ERROR)
      ELSE
         CALL GAGOUT('E-RUN_PAKO,  Unimplemented command '//COMM)
         CALL pakoMESSAGE(6,1,'PAKO',COMM//' Not yet implemented')
         ERROR=.True.
      ENDIF
c
      RETURN
      END
