!     $Id: modulePakoVlbi.f90,v 1.1 2005/06/22 14:46:28 ungerech Exp $
!     
!     Family:   OBSERVING MODES
!     Siblings: modulePakoVlbi.f90
!     Siblings: modulePakoTrack.f90
!
!----------------------------------------------------------------------
!     PAKO module for VLBI
!
MODULE modulePakoVlbi
  !
  USE modulePakoMessages
  USE modulePakoTypes
  USE modulePakoGlobalParameters
  USE modulePakoLimits
  USE modulePakoXML
  USE modulePakoUtilities
  USE modulePakoPlots
  USE modulePakoDisplayText
  USE modulePakoGlobalVariables
  USE modulePakoSubscanList
  USE modulePakoReceiver
  USE modulePakoBackend
  USE modulePakoSource
  USE modulePakoSwBeam
  USE modulePakoSwWobbler
  USE modulePakoSwTotalPower
  !
  IMPLICIT NONE
  SAVE
  PRIVATE
!
  PUBLIC :: vlbi
!!$      Public :: saveVlbi
  PUBLIC :: startVlbi
  PUBLIC :: displayVlbi
  PUBLIC :: plotOMVlbi
  !     
  ! *** Variables for Vlbi ***
  INCLUDE 'inc/variables/variablesVlbi.inc'
!!!   
CONTAINS
!!!
!!!
  SUBROUTINE Vlbi(programName, line, command, error)
    !
    ! *** Arguments ***
    INCLUDE 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    INCLUDE 'inc/variables/standardWorkingVariables.inc'
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    INCLUDE 'inc/ranges/rangesVlbi.inc'
    !
    error = .FALSE.
    !    
    WRITE (6,*) " module VLBI ---> SR: VLBI "
    WRITE (6,*) "                          "
    !
    ! *** initialize ***
    IF (.NOT.isInitialized) THEN
       INCLUDE 'inc/variables/setDefaults.inc'
       isInitialized = .TRUE.
    ENDIF
    !
    ! *** set In-values = previous Values ***
    IF (.NOT.ERROR) THEN
       vars(iIn) = vars(iValue)
    END IF
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    !     read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    CALL checkNofParameters(command,                                 &
         &     0, 0,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .OR. errorNumber
    !
    IF (.NOT. ERROR) THEN
       !
       !! Include 'inc/parameters/parameters*.inc'
       !! Include 'inc/options/readOptionsVlbi.inc'
       !
    END IF
    !
    ! *** set defaults ***
    INCLUDE 'inc/options/optionDefaults.inc'
    !
    ! *** read Parameters, Options (again, after defaults!) ***
    !     and check for validity and ranges 
    IF (.NOT. ERROR) THEN
       !
       !! Include 'inc/parameters/parameters*.inc'
       !! Include 'inc/options/readOptionsVlbi.inc'
       !
    END IF
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    IF (.NOT.error) THEN
       !
       errorInconsistent = .FALSE.
       !
    END IF
    !
    ERROR = ERROR .OR. errorInconsistent
    !
    ! *** store from temporary into final variables ***
    IF (.NOT.ERROR) THEN
       vars(iValue) = vars(iTemp)
    END IF
    !
    ! *** display values ***
    !     (Note: this is done independently of the Error status)
    CALL displayVlbi
    !
    ! *** set "selected" observing mode & plot ***
    IF (.NOT.error) THEN
       GV%sessionMode   = om%vlbi
       GV%observingMode = om%vlbi
       VlbiCommand = line(1:lenc(line))
       CALL analyzeVlbi (errorA)
       CALL listSegmentList (errorA)
       !! Call plotOMVlbi (errorP)
    END IF
    !
    RETURN
  END SUBROUTINE Vlbi
!!!
!!!
  SUBROUTINE analyzeVlbi (errorA)
    !
    INCLUDE 'inc/variables/standardWorkingVariables.inc'
    !
    INTEGER                :: nScan 
    CHARACTER (len=lenCh)  :: aUnit, sUnit
    INTEGER                :: iSS           = 0     ! counts subcans/segment
    INTEGER                :: nSS           = 1
    !
    errorA    = .FALSE.
    iSS       = 0
    nScan     = 1111
    aUnit     = GV%angleUnitC                        ! 
    sUnit     = GV%speedUnitC                        ! 
    !
    WRITE (6,*) " module VLBI ---> SR: ananlyze VLBI "
    WRITE (6,*) "                                    "
    !
    segList(:) = segDefault
    !
    CALL countSubscans(value=0)
    CALL countSegments(value=0)
    !
    DO kk = 1, vars(iValue)%nSubscans, 1
       !
       CALL countSubscans(ii)
       CALL countSegments(jj)
       !
       segList(ii)%newSubscan =  .TRUE.
       segList(ii)%scanNumber =  nScan
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  1
       segList(ii)%ssType     =  ss%VLBI
       segList(ii)%segType    =  seg%track
       segList(ii)%angleUnit  =  aUnit
       segList(ii)%speedUnit  =  sUnit
       segList(ii)%flagOn     =  .TRUE.
       segList(ii)%flagRef    =  .FALSE.
       segList(ii)%pStart     =  vars(iValue)%offset
       segList(ii)%pEnd       =  segList(ii)%pStart
       segList(ii)%speedStart =  0.0
       segList(ii)%speedEnd   =  0.0
       segList(ii)%systemName =  vars(iValue)%systemName
       segList(ii)%altOption  =  'tSegment'
       segList(ii)%tSegment   =  vars(iValue)%tSubscan
       segList(ii)%tRecord    =  0.1
       !
    END DO
    !
    CALL getCountSegments(nSegments)
    !
    RETURN 
    !
  END SUBROUTINE analyzeVlbi
!!!
!!!
  SUBROUTINE displayVlbi
    !
    INCLUDE 'inc/variables/standardWorkingVariables.inc'
    !
    CHARACTER(len=24)  :: command
    !
    INCLUDE 'inc/display/commandDisplayVlbi.inc'
    !
  END SUBROUTINE displayVlbi
!!!
!!!
  SUBROUTINE plotOMVlbi (errorP)
    !
    !**   Variables  for Plots   ***
    INCLUDE 'inc/variables/headerForPlotMethods.inc'
    !
    !**   standard working variables   ***
    INCLUDE 'inc/variables/standardWorkingVariables.inc'
    !
    errorP = .FALSE.
    !
    CALL configurePlots
    !
!!$    ! TBD: replace the following by general plot of segList
!!$    !
!!$    jj = 0                     ! jj counts OTF subscans / segments
!!$    !
!!$    Do ii = 1, nSegments, 1
!!$       !
!!$       If (segList(ii)%ssType .Eq.ss%ref.And.                          &
!!$            &       segList(ii)%segType.Eq.seg%track) Then
!!$          Call plotTrackP(segList(ii)%pStart,                          &
!!$               &                    errorP,                                        &
!!$               &                    number=segList(ii)%ssNumber,                   &
!!$               &                    Type=segList(ii)%ssType)
!!$       End If
!!$       !
!!$       If (segList(ii)%ssType .Eq.ss%on.And.                           &
!!$            &       segList(ii)%segType.Eq.seg%track) Then
!!$          Call plotTrackP(segList(ii)%pStart,                          &
!!$               &                    errorP,                                        &
!!$               &                    number=segList(ii)%ssNumber,                   &
!!$               &                    Type=segList(ii)%ssType)
!!$       End If
!!$       !
!!$    End Do
!!$    !
!!$    Call gr_exec(      'set character 0.6' )
!!$    Call gr_exec(      'pen 0'             )
!!$    !
!!$    errorP =  errorP .Or. GR_ERROR()
!!$    !
!!$    If (errorP)                                                    &
!!$         &        Call pakoMessage(priorityE,severityE,                         &
!!$         &        'Vlbi',' could not plot ')
    !
    RETURN
  END SUBROUTINE plotOMVlbi
!!!
!!!
  SUBROUTINE saveVlbi(programName,LINE,commandToSave,                 &
       &        iUnit, ERROR)
    !
    !**   Variables   ***
    INCLUDE 'inc/variables/headerForSaveMethods.inc'
    !      
    !D      Write (6,*) '      ---> SR: saveVlbi '
    !
    contC = contNN
    !
    INCLUDE 'inc/commands/saveCommand.inc'
    !
    contC = contCC
    !
!!$    Include 'inc/parameters/saveOffsets.inc'
!!$    !
!!$    !TBD:      Include 'inc/options/saveBalance.inc'
!!$    !TBD:      Include 'inc/options/saveCalibrate.inc'
!!$    Include 'inc/options/saveNsubscans.inc'
!!$    Include 'inc/options/saveReference.inc'
!!$    Include 'inc/options/saveSystem.inc'
!!$    !
!!$    contC = contCN
!!$    !
!!$    Include 'inc/options/saveTsubscan.inc'
!!$    !
    !
    WRITE (iUnit,*) "!"
    !
    RETURN
  END SUBROUTINE saveVlbi
!!!
!!!
  SUBROUTINE startVlbi(programName,LINE,commandToSave,                &
       &        iUnit, ERROR)
    !
    ! *** Variables ***
    INCLUDE 'inc/variables/headerForSaveMethods.inc'
    !
    ! to format message text
    CHARACTER(len=lenLine)  ::  messageText
    !
    INTEGER                 :: ii
    CHARACTER (len=lenCh)   :: valueC
    CHARACTER (len=lenLine) :: valueComment
    LOGICAL                 :: errorXML
    !
    WRITE (6,*) " module VLBI ---> SR: start VLBI "
    WRITE (6,*) "                                 "
    !
    CALL pakoXMLsetOutputUnit(iunit=iunit)
    CALL pakoXMLsetIndent(iIndent=2)
    !
    INCLUDE 'inc/startXML/generalHead.inc'
    !
    CALL writeXMLset(programName,LINE,commandToSave,                  &
         &        iUnit, ERROR)
    !
    CALL pakoXMLwriteStartElement("RESOURCE","pakoScript",            &
         &                         comment="save from pako",                &
         &                         error=errorXML)
    CALL pakoXMLwriteStartElement("DESCRIPTION",                      &
         &                         doCdata=.TRUE.,                          &
         &                         error=errorXML)
    !
!!$    Call pakoSaveSet(programName,LINE,commandToSave,                  &
!!$         &        OMselected, iUnit, ERROR)                                 
!!$    Call saveReceiver(programName,LINE,commandToSave,                 &
!!$         &        OMselected, iUnit, ERROR)                                 
!!$    Call saveBackend(programName,LINE,commandToSave,                   &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveSwitching(programName,LINE,commandToSave,                 &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveSource(programName,LINE,commandToSave,                    &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveOffsets(programName,LINE,commandToSave,                   &
!!$         &        OMselected, iUnit, ERROR)
!!$    Call saveVlbi(programName,LINE,commandToSave,                      &
!!$         &        OMselected, iUnit, ERROR)                                 
    !                                                                       
    CALL pakoXMLwriteEndElement("DESCRIPTION",                         &
         &                         doCdata=.TRUE.,                           &
         &                         error=errorXML)
    CALL pakoXMLwriteEndElement  ("RESOURCE","pakoScript",             &
         &                         space="after",                            &
         &                         error=errorXML)
    !
    CALL writeXMLreceiver(programName,LINE,commandToSave,             &
         &        iUnit, ERROR)
    !
    CALL writeXMLbackend(programName,LINE,commandToSave,               &
         &        iUnit, ERROR)
    !
    CALL writeXMLswTotalPower(programName,LINE,commandToSave,  &
     &        iUnit, ERROR)
    !
    CALL writeXMLsource(programName,LINE,commandToSave,                &
         &        iUnit, ERROR)
    !
    INCLUDE 'inc/startXML/generalScanHead.inc'
    !
    CALL writeXMLsubscanList(programName,LINE,commandToSave,         &
         &        iUnit, ERROR)
    !   
    INCLUDE 'inc/startXML/generalTail.inc'
    !
    RETURN
  END SUBROUTINE startVlbi
!!!
!!!
END MODULE modulePakoVlbi
